/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.rte.internal;

import com.ibm.rcp.rte.RTEException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class RTEExceptionHelper {
    private static short CURRENT_STATUS = 1;
    private static String pluginID;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.rcp.rte.internal.RTEExceptionHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        pluginID = clazz.getPackage().getName();
        pluginID = pluginID.substring(0, pluginID.lastIndexOf(46));
        logger = Logger.getLogger(pluginID);
    }

    public static void handleRTEFault(Exception fault) throws RTEException {
        RTEExceptionHelper.throwX(CURRENT_STATUS, fault.getMessage(), fault);
    }

    public static void handleRTEFault(String description, Exception fault) throws RTEException {
        RTEExceptionHelper.throwX(CURRENT_STATUS, description, fault);
    }

    public static void handleRTEException(Level level, String msg, Throwable fault) {
        if (logger != null && RTEExceptionHelper.isLoggable(logger, level)) {
            logger.log(level, msg, fault);
        }
    }

    public static void throwX(short errorCode, String t, Exception fault) throws RTEException {
        if (logger != null && RTEExceptionHelper.isLoggable(logger, Level.SEVERE)) {
            logger.log(Level.SEVERE, t, fault);
        }
        RTEException e = new RTEException(errorCode, t, fault);
        throw e;
    }

    public static void throwX(short errorCode, String t) throws RTEException {
        if (logger != null && RTEExceptionHelper.isLoggable(logger, Level.SEVERE)) {
            logger.log(Level.SEVERE, t);
        }
        RTEException e = new RTEException(errorCode, t);
        throw e;
    }

    public static void setStatus(short statusFlag) {
        CURRENT_STATUS = statusFlag;
    }

    public static void showError(String title, Exception e, Shell origShell) {
        Shell shell = origShell;
        if (shell != null) {
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
            if (logger != null && RTEExceptionHelper.isLoggable(logger, Level.SEVERE)) {
                logger.log(Level.SEVERE, w.toString(), e);
            }
            MessageBox msgbox = new MessageBox(shell, 65568);
            msgbox.setMessage(w.toString());
            msgbox.setText(title);
            msgbox.open();
        }
    }

    private static boolean isLoggable(Logger logger, Level level) {
        if (logger != null) {
            return logger.isLoggable(level);
        }
        return false;
    }
}

