/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.rte.internal.spellchecker;

import com.ibm.rcp.rte.internal.RTENLS;
import com.ibm.rcp.rte.internal.RichTextEditor;
import com.ibm.rcp.rte.internal.spellchecker.SpellCheckerDefaultDialog;
import com.ibm.rcp.rte.internal.spellchecker.SpellCheckerUI;
import com.ibm.rcp.rte.internal.spellchecker.SpellCheckerUIControl;
import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.TextAnalyzerFactory;
import com.ibm.rcp.textanalyzer.spellchecker.MisspelledWord;
import com.ibm.rcp.textanalyzer.spellchecker.SpellChecker;
import java.text.Collator;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RTESpellChecker
implements SpellCheckerUIControl {
    private String sLocaleCode;
    private SpellCheckerUI spellCheckerDlg;
    private Shell shell;
    private SpellChecker spellChecker = null;
    private RichTextEditor doc;
    private int currWord = 0;
    private String strMisSpelledWord;
    private MisspelledWord[] misSpellArray;
    private boolean[] misSpellIgnoreList;
    private boolean isFirstSearch = true;
    static /* synthetic */ Class class$0;

    public RTESpellChecker(Shell shell, String locale, RichTextEditor doc) {
        this.shell = shell;
        this.doc = doc;
        this.sLocaleCode = locale;
    }

    public boolean initSpellChecker() {
        this.spellChecker = TextAnalyzerFactory.getSpellCheckerInstance();
        try {
            this.sLocaleCode = this.sLocaleCode.replace('_', '-');
            return this.spellChecker.setLocale(this.sLocaleCode);
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
        catch (TextAnalyzerException exp) {
            if (exp.errorCode == 6) {
                MessageDialog.openInformation((Shell)this.shell, (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_NoEngine);
            }
            if (exp.errorCode == 4) {
                MessageDialog.openInformation((Shell)this.shell, (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_NoNLDirection);
            }
            return false;
        }
    }

    public void invokeSpellChecker() {
        block11: {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.rcp.rte.internal.spellchecker.RTESpellChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String packageName = clazz.getPackage().toString();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.ibm.rcp.rte.internal.spellchecker.RTESpellChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String className = clazz2.toString();
            String methodName = "invokeSpellChecker";
            try {
                this.spellCheckerDlg = this.getSpellCheckerUI();
                if (this.spellCheckerDlg == null) {
                    this.spellCheckerDlg = new SpellCheckerDefaultDialog(this.shell);
                }
                this.start();
            }
            catch (Exception exception) {
                Logger logger = Logger.getLogger(packageName);
                if (logger == null || !logger.isLoggable(Level.SEVERE)) break block11;
                logger.logp(Level.SEVERE, className, methodName, "");
            }
        }
    }

    public boolean setDictionaryLocaleCode(String sLocaleCode) {
        this.sLocaleCode = sLocaleCode;
        return this.initSpellChecker();
    }

    public String getDictionaryLocaleCode() {
        return this.sLocaleCode;
    }

    public SpellCheckerUI getSpellCheckerUI() {
        return this.spellCheckerDlg;
    }

    public void setSpellCheckerUI(SpellCheckerUI dlg) {
        this.spellCheckerDlg = dlg;
    }

    public Shell getShell() {
        return this.shell;
    }

    private void start() {
        this.isFirstSearch = true;
        this.currWord = 0;
        String strTextToCheck = new String();
        strTextToCheck = this.doc.getAllTextString();
        if (this.spellChecker == null && !this.initSpellChecker()) {
            return;
        }
        this.misSpellArray = this.spellChecker.checkSpelling(strTextToCheck, 5, false);
        if (this.misSpellArray != null) {
            this.misSpellIgnoreList = new boolean[this.misSpellArray.length];
            Collator localCollator = Collator.getInstance();
            int i = 0;
            while (i < this.misSpellArray.length) {
                this.misSpellIgnoreList[i] = false;
                ++i;
            }
            i = 0;
            while (i < this.misSpellArray.length) {
                MisspelledWord mWord = this.misSpellArray[i];
                int j = i + 1;
                while (j < this.misSpellArray.length) {
                    if (localCollator.compare(mWord.getWord(), this.misSpellArray[j].getWord()) == 0) {
                        this.misSpellIgnoreList[j] = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.misSpellArray == null || this.misSpellArray.length == 0) {
            this.spellChecker.dispose();
            this.spellChecker = null;
            MessageDialog.openInformation((Shell)this.shell, (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_Message1);
        } else {
            this.spellCheckerDlg.open((SpellCheckerUIControl)this);
        }
    }

    private void setUpUI() {
        MisspelledWord mWord = this.misSpellArray[this.currWord];
        this.strMisSpelledWord = mWord.getWord();
        this.spellCheckerDlg.setWord(this.strMisSpelledWord);
        this.selectMisSpellWord(this.strMisSpelledWord);
        String[] suggestions = mWord.getSuggestions();
        this.spellCheckerDlg.setSuggestions(suggestions);
    }

    private boolean nextWord() {
        boolean hasNextWord = true;
        int i = this.currWord + 1;
        if (i < this.misSpellArray.length) {
            while (i < this.misSpellArray.length && this.misSpellIgnoreList[i]) {
                ++i;
            }
            this.currWord = i;
            this.isFirstSearch = true;
        }
        if (i >= this.misSpellArray.length) {
            MessageDialog.openInformation((Shell)this.shell, (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_Message2);
            this.spellCheckerDlg.stopUI();
            hasNextWord = false;
        }
        return hasNextWord;
    }

    private boolean selectMisSpellWord(String misSpelledWord) {
        boolean result = this.doc.makeSelection(misSpelledWord, this.isFirstSearch);
        if (this.isFirstSearch) {
            this.isFirstSearch = false;
        }
        return result;
    }

    public void startSpellChecker() {
        this.setUpUI();
    }

    public void ignore(String word) {
        if (!this.selectMisSpellWord(this.strMisSpelledWord) && this.nextWord()) {
            this.setUpUI();
        }
    }

    public void ignoreAll(String word) {
        if (this.nextWord()) {
            this.setUpUI();
        }
    }

    public void changeTo(String word, String toWord) {
        this.doc.replace(toWord);
        if (!this.selectMisSpellWord(this.strMisSpelledWord) && this.nextWord()) {
            this.setUpUI();
        }
    }

    public void changeToAll(String word, String toWord) {
        this.doc.replace(toWord);
        while (this.selectMisSpellWord(this.strMisSpelledWord)) {
            this.doc.replace(toWord);
        }
        if (this.nextWord()) {
            this.setUpUI();
        }
    }

    public void stop() {
        this.spellChecker.dispose();
        this.spellChecker = null;
    }
}

