/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.rte.internal;

import com.ibm.rcp.rte.NavigationEvent;
import com.ibm.rcp.rte.NavigationEventListener;
import com.ibm.rcp.rte.RTEEvent;
import com.ibm.rcp.rte.RTEEventListener;
import com.ibm.rcp.rte.RTEException;
import com.ibm.rcp.rte.internal.RTEExceptionHelper;
import com.ibm.rcp.rte.internal.RTENLS;
import com.ibm.rcp.rte.internal.ToolPalette;
import com.ibm.rcp.rte.internal.ToolPaletteCommon;
import com.ibm.rcp.rte.internal.ToolPaletteEX;
import com.ibm.rcp.rte.internal.spellchecker.RTESpellChecker;
import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.TextAnalyzerFactory;
import com.ibm.rcp.textanalyzer.spellchecker.MisspelledWord;
import com.ibm.rcp.textanalyzer.spellchecker.SpellChecker;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.DOMBrowser;
import org.eclipse.swt.browser.IEMSG;
import org.eclipse.swt.browser.IEOS;
import org.eclipse.swt.browser.IESecuritySettings;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.SecuritySettings;
import org.eclipse.swt.browser.TranslateAcceleratorListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.browser.ie.dom.JAttr;
import org.eclipse.swt.browser.ie.dom.JNode;
import org.eclipse.swt.browser.ie.dom.css.JCSSStyleSheet;
import org.eclipse.swt.browser.ie.dom.events.JEvent;
import org.eclipse.swt.browser.ie.dom.html.JHTMLBRElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLBodyElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLControlRange;
import org.eclipse.swt.browser.ie.dom.html.JHTMLDocument;
import org.eclipse.swt.browser.ie.dom.html.JHTMLElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLParagraphElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLScreen;
import org.eclipse.swt.browser.ie.dom.html.JHTMLSelection;
import org.eclipse.swt.browser.ie.dom.html.JHTMLTableCellElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLTableRowElement;
import org.eclipse.swt.browser.ie.dom.html.JHTMLTxtRange;
import org.eclipse.swt.browser.ie.dom.html.JHTMLWindow;
import org.eclipse.swt.browser.ie.dom.stylesheets.JStyleSheetList;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.Variant2;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class RichTextEditor
extends Composite
implements com.ibm.rcp.rte.RichTextEditor {
    public static final int IDM_ATOMICSELECTION = 2399;
    public static final int MSOCMDEXECOPT_DODEFAULT = 0;
    public static final int IDM_PRINTPREVIEW = 2003;
    public static final int IDM_SHOWPAGESETUP = 2004;
    private static final String NOTESTYPE = "Notes Editor Internal";
    private static final String NOTESCELL = "\\cell";
    private static final String CONVERTEDCELL = "\\\\cell";
    private ToolPalette _toolPalette;
    protected DOMBrowser webBrowser;
    protected JHTMLDocument htmlDoc;
    private JHTMLElement docElem;
    private JHTMLWindow htmlWin;
    private String localeCode;
    private String oldLocaleCode;
    private boolean isReadOnly = false;
    private HashMap metadata;
    private boolean dirty = false;
    private boolean isUrlSetting = false;
    private boolean isLoading = false;
    private boolean isLoadCompleted = false;
    private ArrayList dragStartListeners = new ArrayList();
    private ArrayList dragOverListeners = new ArrayList();
    private ArrayList dropListeners = new ArrayList();
    private ArrayList cutListeners = new ArrayList();
    private ArrayList pasteListeners = new ArrayList();
    private HashMap documentEventListeners = new HashMap();
    private HashMap systemDocumentEventListeners = new HashMap();
    private Vector keylisteners = new Vector();
    private EventListener HTMLWindowEventListener = new EventListener(){

        public void handleEvent(Event event) {
            RichTextEditor.this.focus();
        }
    };
    private ArrayList cursorInfoChangedListeners = new ArrayList();
    private ArrayList navigationListeners = new ArrayList();
    private HashMap textAttribute = new HashMap();
    private HashMap completedListener = new HashMap();
    private RTESpellChecker rteSpellChecker;
    private SpellChecker backgroundSpellChecker;
    private boolean enableBackgroundSpellchecking;
    private final int BACKGROUNDSPELLCHECKING_UPDATE = 1;
    private final int BACKGROUNDSPELLCHECKING_CLEAN = 2;
    private final int BACKGROUNDSPELLCHECKING_CLEAN_ALL = 3;
    private final int BACKGROUNDSPELLCHECKING_CORRECT = 4;
    private final int BACKGROUNDSPELLCHECKING_CHECK = 5;
    private ArrayList BackgroundSpellchecking_Ignore_Words = new ArrayList();
    private Map BackgroundSpellchecking_Auto_Correct = new HashMap();
    private final String MISSPELLING_STYLE_RULE = "SPAN.misspelling {border-bottom-style: solid;border-bottom-width: thin;border-bottom-color: red }";
    private final String MISSPELLING_NO_SUGGESTIONS = RTENLS.rteBgSpellChecker_NoSuggestions;
    private DefaultRTEEventListener misspellContextMenuListener = null;
    public static final int MAX_SUGGESTION_NUM = 5;

    public RichTextEditor(Composite parent, int compositeStyle, int toolBarStyle, int rteStyle) throws RTEException {
        super(parent, compositeStyle);
        this.isReadOnly = (rteStyle & 1) == 1;
        this.createControls(compositeStyle, toolBarStyle);
        this.initEvent();
        RTEExceptionHelper.setStatus((short)2);
        this.setUrl("about:blank");
        this.setUrl("about:blank");
        this.localeCode = Platform.getNL();
        this.localeCode = this.localeCode.replace('_', '-');
    }

    private void initEvent() {
        try {
            this.webBrowser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent e) {
                }

                public void completed(ProgressEvent e) {
                    try {
                        RichTextEditor.this.clearListeners();
                        RichTextEditor.this.htmlDoc = (JHTMLDocument)RichTextEditor.this.webBrowser.getDocument();
                        RichTextEditor.this.htmlWin = RichTextEditor.this.webBrowser.getHTMLWindow();
                        RichTextEditor.this.setupListeners();
                        if (!RichTextEditor.this.isReadOnly) {
                            RichTextEditor.this.htmlDoc.setDesignMode("On");
                        }
                        RichTextEditor.this.setReadOnly(RichTextEditor.this.isReadOnly);
                        RichTextEditor.this.isLoadCompleted = true;
                        RichTextEditor.this.isLoading = false;
                    }
                    catch (RTEException rteEx) {
                        RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg01, (Exception)((Object)rteEx));
                    }
                    catch (Exception unknownEx) {
                        RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg01, (Exception)unknownEx);
                    }
                }
            });
            this.webBrowser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    if (RichTextEditor.this.isReadOnly) {
                        DOMBrowser newWebBrowser = new DOMBrowser((Composite)RichTextEditor.this.webBrowser, 0);
                        event.browser = newWebBrowser;
                        newWebBrowser.addLocationListener(new LocationListener(this){
                            final /* synthetic */ 22 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void changing(LocationEvent event) {
                                if (RichTextEditor.access$13(22.access$0(this.this$1))) {
                                    String url = null;
                                    url = event.location;
                                    NavigationEvent navEvent = new NavigationEvent();
                                    navEvent.type = 2;
                                    navEvent.url = url;
                                    RichTextEditor.access$16(22.access$0(this.this$1), navEvent);
                                    event.doit = navEvent.doit;
                                }
                            }

                            public void changed(LocationEvent event) {
                            }
                        });
                    }
                }

                static /* synthetic */ RichTextEditor access$0(22 var0) {
                    return var0.RichTextEditor.this;
                }
            });
            this.webBrowser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    if (RichTextEditor.this.isUrlSetting) {
                        RichTextEditor.this.isUrlSetting = false;
                        RichTextEditor.this.isLoading = true;
                        return;
                    }
                    if (RichTextEditor.this.isReadOnly && !RichTextEditor.this.isLoading) {
                        if (event.location.equalsIgnoreCase("http:///")) {
                            return;
                        }
                        NavigationEvent navEvent = new NavigationEvent();
                        navEvent.type = 1;
                        navEvent.url = event.location;
                        RichTextEditor.this.fireNavigationEvent(navEvent);
                        event.doit = navEvent.doit;
                    }
                }

                public void changed(LocationEvent event) {
                }
            });
        }
        catch (NullPointerException e) {
            String defaultMsg = RTENLS.Err_Msg21;
            if (this.webBrowser == null) {
                RTEExceptionHelper.handleRTEFault((String)(String.valueOf(defaultMsg) + RTENLS.Err_Msg22), (Exception)e);
            } else if (this.htmlDoc == null) {
                RTEExceptionHelper.handleRTEFault((String)(String.valueOf(defaultMsg) + RTENLS.Err_Msg23), (Exception)e);
            } else if (this.htmlWin == null) {
                RTEExceptionHelper.handleRTEFault((String)(String.valueOf(defaultMsg) + RTENLS.Err_Msg24), (Exception)e);
            }
        }
        catch (ClassCastException cce) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg25, (Exception)cce);
        }
        catch (Exception ex) {
            RTEExceptionHelper.handleRTEFault((Exception)ex);
        }
        try {
            RTEEventListener rteInitListener = new RTEEventListener(){

                public void handleEvent(RTEEvent e) throws RTEException {
                    if (e.getType() == 8) {
                        RichTextEditor.this.disableDefaultDropHandler();
                        if ((RichTextEditor.this.getStyle() & 0x4000000) > 0) {
                            RichTextEditor.this.setDirection(-1);
                        }
                        if (RichTextEditor.this._toolPalette != null) {
                            RichTextEditor.this._toolPalette.startUpdateListener();
                        }
                    }
                }
            };
            this.addCompletedListener(rteInitListener);
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.rte_failed_create_rte, (Exception)e);
        }
    }

    private void createControls(int compositeStyle, int toolBarStyle) {
        boolean isSWTExStyle = false;
        if (Platform.getBundle((String)"com.ibm.rcp.swtex") != null) {
            isSWTExStyle = true;
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        layout.marginLeft = 0;
        if (isSWTExStyle) {
            layout.verticalSpacing = 0;
            this.setLayout((Layout)layout);
        } else {
            this.setLayout((Layout)layout);
            this.setBackground(this.getDisplay().getSystemColor(22));
        }
        this.setBackground(this.getDisplay().getSystemColor(22));
        if ((toolBarStyle & 0x1FFF) != 0) {
            this._toolPalette = isSWTExStyle ? new ToolPaletteEX((Composite)this, 0, toolBarStyle) : new ToolPaletteCommon((Composite)this, 0, toolBarStyle);
            GridData toolPaletteGridData = new GridData(784);
            ((Composite)this._toolPalette).setLayoutData((Object)toolPaletteGridData);
            this._toolPalette.setEditAPI((com.ibm.rcp.rte.RichTextEditor)this);
        }
        try {
            this.webBrowser = new DOMBrowser((Composite)this, compositeStyle);
            this.webBrowser.addListener(35, new Listener(){

                public void handleEvent(org.eclipse.swt.widgets.Event event) {
                    event.doit = false;
                }
            });
            SecuritySettings settings = this.webBrowser.getSecuritySettings();
            settings.setAllowScript(false);
            settings.setEnablePopups(false);
            settings.setAllowPlugins(false);
            if (settings instanceof IESecuritySettings) {
                IESecuritySettings iesettings = (IESecuritySettings)settings;
                iesettings.setAllowScriptPaste(true);
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg06, (Exception)e);
        }
        GridData webBrowserGridData = new GridData(1808);
        webBrowserGridData.horizontalIndent = 0;
        this.webBrowser.setLayoutData((Object)webBrowserGridData);
    }

    protected static void runLoopTimer(Shell shell, final int milliSeconds) {
        final boolean[] exit = new boolean[1];
        Thread stupidThreadThing = new Thread(){

            public void run() {
                try {
                    Thread.sleep(milliSeconds);
                }
                catch (Exception exception) {}
                exit[0] = true;
            }
        };
        stupidThreadThing.start();
        Display display = Display.getCurrent();
        while (!exit[0] && !shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEException((Level)Level.FINEST, (String)"", (Throwable)e);
            }
            catch (Throwable t) {
                RTEExceptionHelper.handleRTEException((Level)Level.FINEST, (String)"", (Throwable)t);
            }
        }
    }

    public void addCursorInfoChangedListener(RTEEventListener cursorInfoChangedListener) {
        this.cursorInfoChangedListeners.add(cursorInfoChangedListener);
        if (!this.isReadOnly) {
            this.fireCursorInfoChangedEvent();
        }
    }

    public void removeCursorInfoChangedListener(RTEEventListener cursorInfoChangedListener) {
        this.cursorInfoChangedListeners.remove(cursorInfoChangedListener);
    }

    private void fireCursorInfoChangedEvent() {
        HashMap attributes = this.getTextAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < this.cursorInfoChangedListeners.size()) {
                try {
                    RTEEvent CursorMoveEvent = new RTEEvent();
                    CursorMoveEvent.setTextAttributes(attributes);
                    CursorMoveEvent.setType(9);
                    RTEEventListener lis = (RTEEventListener)this.cursorInfoChangedListeners.get(i);
                    lis.handleEvent(CursorMoveEvent);
                }
                catch (Exception e) {
                    RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg08, (Exception)e);
                }
                ++i;
            }
        }
        attributes.clear();
    }

    private HashMap getTextAttributes() {
        int direction = this.getDirection();
        int i = 0;
        while (i < RTEEvent.TEXT_ATTRIBUTE_COMMANDS.length) {
            if (RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i] == "ltr") {
                this.textAttribute.put(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], direction == 1 ? "TRUE" : "FALSE");
            } else if (RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i] == "rtl") {
                this.textAttribute.put(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], direction == 1 ? "FALSE" : "TRUE");
            } else if (!this.isReadOnly) {
                this.textAttribute.put(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], this.webBrowser.getCommandValue(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i]));
            }
            ++i;
        }
        return this.textAttribute;
    }

    private boolean containNotesTable(Clipboard cb) {
        String[] typeNames = cb.getAvailableTypeNames();
        boolean containNotes = false;
        int i = 0;
        while (i < typeNames.length) {
            if (NOTESTYPE.equals(typeNames[i])) {
                containNotes = true;
                break;
            }
            ++i;
        }
        if (!containNotes) {
            return false;
        }
        String rtfString = (String)cb.getContents((Transfer)RTFTransfer.getInstance());
        if (rtfString == null) {
            return false;
        }
        int notesCellIndex = rtfString.indexOf(NOTESCELL);
        boolean findRTFCellTag = false;
        while (notesCellIndex != -1) {
            if (notesCellIndex > 0 && !rtfString.substring(notesCellIndex - 1).startsWith(CONVERTEDCELL)) {
                findRTFCellTag = true;
                break;
            }
            notesCellIndex = rtfString.indexOf(NOTESCELL, notesCellIndex + 1);
        }
        return findRTFCellTag;
    }

    private void clearListeners() {
        try {
            this.removeAllSystemDocumentEventListener();
            this.removeAllDocEventListenerFromCurrentDoc();
            if (this.htmlWin != null) {
                this.htmlWin.removeEventListener("focus", this.HTMLWindowEventListener, true);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void setupListeners() throws RTEException {
        if (this.htmlDoc == null) {
            RTEExceptionHelper.throwX((short)1, (String)RTENLS.Err_Msg27);
        }
        try {
            HTMLElement htmlDocElem = this.htmlDoc.getBody();
            if (htmlDocElem == null) {
                RTEExceptionHelper.throwX((short)1, (String)RTENLS.Err_Msg27);
            }
            this.docElem = (JHTMLElement)this.htmlDoc.getBody();
        }
        catch (RTEException rteEx) {
            throw rteEx;
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg28, (Exception)e);
        }
        try {
            this.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent ke) {
                    if (ke.keyCode == 8 || ke.keyCode == 46) {
                        RichTextEditor.this.dirty = true;
                    }
                    ke.doit = true;
                }

                public void keyPressed(KeyEvent ke) {
                    RichTextEditor.this.dirty = true;
                    ke.doit = true;
                }
            });
            this.addSystemDocumentEventListener("dragstart", new EventListener(){

                public void handleEvent(Event arg) {
                    RichTextEditor.this.fireDragStart();
                }
            });
            this.addSystemDocumentEventListener("mouseup", new EventListener(){

                public void handleEvent(Event event) {
                    if (!RichTextEditor.this.isReadOnly && RichTextEditor.this.cursorInfoChangedListeners != null && RichTextEditor.this.cursorInfoChangedListeners.size() > 0) {
                        RichTextEditor.this.fireCursorInfoChangedEvent();
                    }
                }
            });
            this.docElem.addEventListener("dragover", new EventListener(){

                public void handleEvent(Event arg) {
                    RichTextEditor.this.fireDragOver();
                }
            }, true);
            this.docElem.addEventListener("drop", new EventListener(){

                public void handleEvent(Event arg) {
                    RichTextEditor.this.fireDrop();
                }
            }, true);
            this.docElem.addEventListener("cut", new EventListener(){

                public void handleEvent(Event arg) {
                    RichTextEditor.this.dirty = true;
                    RichTextEditor.this.fireCut();
                }
            }, true);
            this.docElem.addEventListener("paste", new EventListener(){

                public void handleEvent(Event arg) {
                    RichTextEditor.this.dirty = true;
                    RichTextEditor.this.firePaste(arg);
                    if (RichTextEditor.this.HandleNotesTablePaste()) {
                        arg.stopPropagation();
                    }
                }
            }, true);
            this.initEventTransfer();
            this.addTranslateAcceleratorListener();
            this.htmlWin.addEventListener("focus", this.HTMLWindowEventListener, true);
            this.addAllDocEventListenerToCurrentDoc();
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg33, (Exception)e);
        }
    }

    public HTMLDocument getHtmlDocument() throws RTEException {
        if (this.htmlDoc == null) {
            RTEExceptionHelper.throwX((short)2, (String)RTENLS.Err_Msg18);
        }
        return this.htmlDoc;
    }

    private JHTMLDocument getHtmlDocInstance() throws RTEException {
        if (this.htmlDoc == null) {
            RTEExceptionHelper.throwX((short)2, (String)RTENLS.Err_Msg17);
        }
        return this.htmlDoc;
    }

    public boolean executeCommand(String strCommandName, boolean showUI, String strValue) {
        boolean retVal = this.getHtmlDocInstance().execCommand(strCommandName, showUI, strValue);
        if (!this.isReadOnly && this.cursorInfoChangedListeners != null && this.cursorInfoChangedListeners.size() > 0) {
            this.fireCursorInfoChangedEvent();
        }
        return retVal;
    }

    public void setBackColor(String color) {
        this.executeCommand("backcolor", false, color);
        this.dirty = true;
    }

    public void bold() {
        this.executeCommand("bold", false, null);
        this.dirty = true;
    }

    public void copy() {
        this.executeCommand("Copy", false, null);
    }

    public void createLink() {
        this.executeCommand("createlink", true, null);
        this.dirty = true;
    }

    public void cut() {
        this.executeCommand("Cut", false, null);
    }

    public void delete() {
        this.executeCommand("delete", false, null);
        this.dirty = true;
    }

    public void setFontName(String fontName) {
        this.executeCommand("fontname", false, fontName);
        this.dirty = true;
    }

    public void setFontSize(String fontSize) {
        this.executeCommand("fontsize", false, fontSize);
        this.dirty = true;
    }

    public void setForeColor(String color) {
        this.executeCommand("forecolor", false, color);
        this.dirty = true;
    }

    public void formatBlock(String value) {
        String sFormatValue = value;
        if (value.equalsIgnoreCase("Normal")) {
            sFormatValue = "<p>";
        } else if (value.equalsIgnoreCase("Heading 1")) {
            sFormatValue = "<h1>";
        } else if (value.equalsIgnoreCase("Heading 2")) {
            sFormatValue = "<h2>";
        } else if (value.equalsIgnoreCase("Heading 3")) {
            sFormatValue = "<h3>";
        } else if (value.equalsIgnoreCase("Heading 4")) {
            sFormatValue = "<h4>";
        } else if (value.equalsIgnoreCase("Heading 5")) {
            sFormatValue = "<h5>";
        } else if (value.equalsIgnoreCase("Heading 6")) {
            sFormatValue = "<h6>";
        }
        this.executeCommand("formatblock", false, sFormatValue);
        this.dirty = true;
    }

    public void heading(String value) {
        this.executeCommand("heading", false, value);
        this.dirty = true;
    }

    public void indent() {
        this.executeCommand("indent", false, null);
        this.dirty = true;
    }

    public void insertHorizontalRule() {
        this.executeCommand("inserthorizontalrule", false, null);
        this.dirty = true;
    }

    public void insertOrderedList() {
        this.executeCommand("insertorderedlist", false, null);
        this.dirty = true;
    }

    public void insertBulletList() {
        this.executeCommand("insertunorderedlist", false, null);
        this.dirty = true;
    }

    public void italic() {
        this.executeCommand("italic", false, null);
        this.dirty = true;
    }

    public void setJustifyStyle(int style) {
        switch (style) {
            case 0: {
                this.executeCommand("justifycenter", false, null);
                break;
            }
            case 1: {
                this.executeCommand("justifyfull", false, null);
                break;
            }
            case 2: {
                this.executeCommand("justifyleft", false, null);
                break;
            }
            case 3: {
                this.executeCommand("justifyright", false, null);
            }
        }
        this.dirty = true;
    }

    public void outdent() {
        this.executeCommand("outdent", false, null);
        this.dirty = true;
    }

    public void paste() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        if (this.containNotesTable(cb)) {
            RTEEvent event = new RTEEvent();
            event.setType(7);
            int i = 0;
            while (i < this.pasteListeners.size()) {
                try {
                    RTEEventListener lis = (RTEEventListener)this.pasteListeners.get(i);
                    lis.handleEvent(event);
                    if (!event.doIt) {
                        return;
                    }
                }
                catch (Exception e) {
                    RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg05, (Exception)e);
                }
                ++i;
            }
            String textContent = (String)cb.getContents((Transfer)TextTransfer.getInstance());
            this.insertText(null, textContent);
        } else {
            this.htmlDoc.execCommand("Paste");
        }
        cb.dispose();
        if (this.enableBackgroundSpellchecking) {
            this.insertText(null, " ");
            int style = 5;
            HTMLElement curNode = this.htmlDoc.getBody();
            this.invokeBackgroundSpellchecking(curNode, style, null);
        }
    }

    private boolean HandleNotesTablePaste() {
        boolean result = false;
        Clipboard cb = new Clipboard(Display.getCurrent());
        if (this.containNotesTable(cb)) {
            String textContent = (String)cb.getContents((Transfer)TextTransfer.getInstance());
            this.insertText(null, textContent);
            result = true;
        }
        cb.dispose();
        return result;
    }

    public void print() {
        this.executeCommand("Print", true, null);
    }

    public void printPreview() {
        this.webBrowser.execWB(2003, 1, null, null);
    }

    public void pageSetup() {
        this.webBrowser.execWB(2004, 0, null, null);
    }

    public void redo() {
        this.executeCommand("Redo", false, null);
    }

    public void refresh() {
        this.webBrowser.refresh();
    }

    public void removeFormat() {
        this.executeCommand("removeformat", false, null);
        this.dirty = true;
    }

    public void selectAll() {
        this.executeCommand("selectall", false, null);
    }

    public void strikeThrough() {
        this.executeCommand("strikethrough", false, null);
        this.dirty = true;
    }

    public void underline() {
        this.executeCommand("underline", false, null);
        this.dirty = true;
    }

    public void undo() {
        this.executeCommand("Undo", false, null);
    }

    public void unlink() {
        this.executeCommand("unlink", false, null);
        this.dirty = true;
    }

    public void unselect() {
        this.executeCommand("Unselect", false, null);
    }

    public void insertTable(HTMLElement parent, int rows, int cols) {
        if (parent == null) {
            this.insertTable(rows, cols);
            return;
        }
        HTMLTableElement tableElem = (HTMLTableElement)this.getHtmlDocInstance().createElement("table");
        tableElem.setAttribute("border", "1");
        tableElem.setAttribute("cellpadding", "0");
        tableElem.setAttribute("cellspacing", "0");
        tableElem.setAttribute("bordercolor", "#111111");
        tableElem.setAttribute("width", "100%");
        int width = 100 / cols;
        int remain = width + 100 % cols;
        String s_width = String.valueOf(String.valueOf(width)) + "%";
        String s_remain = String.valueOf(String.valueOf(remain)) + "%";
        int i = 0;
        while (i < rows) {
            HTMLTableRowElement trElem = (HTMLTableRowElement)tableElem.insertRow(i);
            int j = 0;
            while (j < cols) {
                JHTMLElement tdElem = (JHTMLElement)trElem.insertCell(j);
                tdElem.getStyle().setCssText("WORD-BREAK: break-all");
                if (j != cols - 1) {
                    tdElem.setAttribute("width", s_width);
                } else {
                    tdElem.setAttribute("width", s_remain);
                }
                ++j;
            }
            ++i;
        }
        parent.appendChild(tableElem);
        this.dirty = true;
    }

    private void insertTable(int rows, int cols) {
        HTMLTableElement tableElem = (HTMLTableElement)this.getHtmlDocInstance().createElement("table");
        tableElem.setAttribute("border", "1");
        tableElem.setAttribute("cellpadding", "0");
        tableElem.setAttribute("cellspacing", "0");
        tableElem.setAttribute("bordercolor", "#111111");
        tableElem.setAttribute("width", "100%");
        int width = 100 / cols;
        int remain = width + 100 % cols;
        String s_width = String.valueOf(String.valueOf(width)) + "%";
        String s_remain = String.valueOf(String.valueOf(remain)) + "%";
        int i = 0;
        while (i < rows) {
            HTMLTableRowElement trElem = (HTMLTableRowElement)tableElem.insertRow(i);
            int j = 0;
            while (j < cols) {
                JHTMLElement tdElem = (JHTMLElement)trElem.insertCell(j);
                tdElem.getStyle().setCssText("WORD-BREAK: break-all");
                if (j != cols - 1) {
                    tdElem.setAttribute("width", s_width);
                } else {
                    tdElem.setAttribute("width", s_remain);
                }
                ++j;
            }
            ++i;
        }
        this.insertElementAtSelection(tableElem);
        this.dirty = true;
    }

    private void insertTextAtSelection(String text) {
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (rangeResult.isTxtRange()) {
            JHTMLTxtRange currPos = rangeResult.getTxtRange().duplicate();
            currPos.setText(text);
        } else {
            org.w3c.dom.Text textNode = this.getHtmlDocument().createTextNode(text);
            JHTMLControlRange currPos = rangeResult.getControlRange();
            HTMLElement selElem = currPos.item(currPos.getLength() - 1);
            Node nextNode = selElem.getNextSibling();
            selElem.getParentNode().insertBefore(textNode, nextNode);
        }
        this.dirty = true;
    }

    public void insertText(HTMLElement parent, String text) {
        if (parent == null) {
            this.insertTextAtSelection(text);
            return;
        }
        org.w3c.dom.Text textNode = this.getHtmlDocument().createTextNode(text);
        parent.appendChild(textNode);
        this.dirty = true;
    }

    public void find() {
        SearchDialog searchDlg = new SearchDialog(this.webBrowser.getShell());
        searchDlg.open();
    }

    public void replace() {
        SearchReplaceDialog replaceDlg = new SearchReplaceDialog(this.webBrowser.getShell());
        replaceDlg.open();
    }

    public String getSourceContent() throws RTEException {
        String strContent = " ";
        if (this.enableBackgroundSpellchecking) {
            this.removeMisspellingStyle();
        }
        try {
            JHTMLElement docElem = (JHTMLElement)this.getHtmlDocInstance().getDocumentElement();
            if (docElem == null) {
                JHTMLElement bodyElem = (JHTMLElement)this.getHtmlDocInstance().getBody();
                strContent = bodyElem.getOuterHTML();
            } else {
                strContent = docElem.getOuterHTML();
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg20, (Exception)e);
            strContent = "Error";
        }
        if (this.enableBackgroundSpellchecking) {
            this.addMisspellingStyle();
        }
        return strContent;
    }

    public void setSourceContent(String content) throws RTEException {
        try {
            this.htmlWin.removeEventListener("focus", this.HTMLWindowEventListener, true);
            this.htmlDoc.open();
            this.htmlDoc.write(content);
            this.htmlDoc.close();
            this.dirty = true;
            if (this.enableBackgroundSpellchecking) {
                this.addMisspellingStyle();
            }
            this.htmlWin.addEventListener("focus", this.HTMLWindowEventListener, true);
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg35, (Exception)e);
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean flag) throws RTEException {
        try {
            this.isReadOnly = flag;
            JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
            if (body != null) {
                body.setContentEditable(String.valueOf(!flag));
            }
            if (this._toolPalette != null) {
                this._toolPalette.setReadOnly(flag);
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg36, (Exception)e);
        }
    }

    public void setEditorBackColor(String value) {
        if (this.isReadOnly()) {
            return;
        }
        JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
        if (body != null) {
            body.setAttribute("bgColor", value);
            this.dirty = true;
        }
    }

    public String getEditorBackColor() {
        String sColor = "<none>";
        JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
        if (body != null) {
            sColor = body.getAttribute("bgColor");
        }
        return sColor;
    }

    public void setEditorFgColor(String value) {
        if (this.isReadOnly()) {
            return;
        }
        JHTMLElement body = (JHTMLElement)this.getHtmlDocInstance().getBody();
        if (body != null) {
            body.setAttribute("fgColor", value);
            this.dirty = true;
        }
    }

    public String getEditorFgColor() {
        String sColor = "<none>";
        JHTMLElement body = (JHTMLElement)this.getHtmlDocInstance().getBody();
        if (body != null) {
            sColor = body.getAttribute("fgColor");
        }
        return sColor;
    }

    public void scrollTo(int x, int y) {
        JHTMLWindow mywindow = this.getHtmlDocInstance().getParentWindow();
        mywindow.scrollTo(x, y);
    }

    public void scrollToEnd() {
        JHTMLWindow mywindow = this.getHtmlDocInstance().getParentWindow();
        JHTMLScreen myscreen = mywindow.getScreen();
        mywindow.scrollTo(myscreen.getWidth(), 99999999);
    }

    public void scrollToTop() {
        JHTMLWindow mywindow = this.getHtmlDocInstance().getParentWindow();
        mywindow.scrollTo(0, 0);
    }

    public void scrollElementIntoView(HTMLElement elem, boolean top) {
        if (elem != null) {
            JHTMLElement element = (JHTMLElement)elem;
            Variant2 var = new Variant2(top);
            element.scrollIntoView(var);
        }
    }

    public void appendText(String value) {
        if (this.isReadOnly()) {
            return;
        }
        org.w3c.dom.Text myTxt = this.getHtmlDocInstance().createTextNode(value);
        this.htmlDoc.getBody().appendChild(myTxt);
        this.dirty = true;
    }

    public void clear() {
        this.setSourceContent("");
    }

    public HashMap getMetadata() throws RTEException {
        this.metadata.clear();
        Element metaElem = this.getHtmlDocInstance().getElementById("rtedocmeta");
        NamedNodeMap attrs = metaElem.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node attr = attrs.item(i);
            if (attr.getNodeName() != null && attr.getNodeName().indexOf("rte") != -1) {
                this.metadata.put(attr.getNodeName().substring(3), attr.getNodeValue());
            }
            ++i;
        }
        return this.metadata;
    }

    public void setMetadata(HashMap md) {
        this.metadata = md;
        Element metaElem = this.getHtmlDocInstance().getElementById("rtedocmeta");
        if (metaElem == null) {
            metaElem = this.htmlDoc.createElement("meta");
            metaElem.setAttribute("id", "rtedocmeta");
            NodeList elems = this.getHtmlDocInstance().getElementsByTagName("head");
            if (elems == null) {
                return;
            }
            Node head = elems.item(0);
            metaElem = (Element)head.appendChild(metaElem);
        }
        NamedNodeMap attrs = metaElem.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node attr = attrs.item(i);
            if (attr.getNodeName() != null && attr.getNodeName().indexOf("rte") != -1) {
                metaElem.removeAttribute(attr.getNodeName());
            }
            ++i;
        }
        Iterator keys = this.metadata.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)this.metadata.get(key);
            metaElem.setAttribute("rte" + key, value);
        }
    }

    public void insertHTMLElementAtCursor(Element element) {
        try {
            this.insertElementAtSelection(element);
        }
        catch (Exception rteEx) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg37, (Exception)rteEx);
        }
    }

    public void insertHTMLElement(Element parent, Element elem) throws RTEException {
        try {
            parent.appendChild(elem);
            this.dirty = true;
        }
        catch (Exception rteEx) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg38, (Exception)rteEx);
        }
    }

    public void removeHTMLElementByID(String id) {
        Element elem = this.htmlDoc.getElementById(id);
        if (elem == null) {
            return;
        }
        elem.getParentNode().removeChild(elem);
        this.dirty = true;
    }

    public void insertTableColumnLeft() {
        this.InsertColumn(true);
    }

    public void insertTableColumnRight() {
        this.InsertColumn(false);
    }

    public void deleteTableColumn() {
        ColumnInfo colInfo = this.getCellIndex();
        if (colInfo == null) {
            return;
        }
        Node currentRow = colInfo.getCurrentRow();
        HTMLTableElement tableElem = (HTMLTableElement)currentRow.getParentNode().getParentNode();
        int firstSelectionColIndex = this.getCurrentSelectionColIndex(true);
        int lastSelectionColIndex = this.getCurrentSelectionColIndex(false);
        int i = 0;
        while (i < tableElem.getRows().getLength()) {
            HTMLTableRowElement rowElem = (HTMLTableRowElement)tableElem.getRows().item(i);
            int j = firstSelectionColIndex;
            while (j <= lastSelectionColIndex) {
                if (rowElem.getCells().getLength() > firstSelectionColIndex) {
                    rowElem.deleteCell(firstSelectionColIndex);
                    this.dirty = true;
                }
                ++j;
            }
            ++i;
        }
        this.resizeTable();
    }

    private ColumnInfo getCellIndex() {
        JHTMLSelection sel = this.htmlDoc.getSelection();
        JHTMLTxtRange range = sel.createRange().getTxtRange();
        range.collapse(true);
        JNode currentCell = (JNode)range.parentElement();
        String strName = currentCell.getNodeName();
        while (!strName.equalsIgnoreCase("td")) {
            if ((currentCell = (JNode)currentCell.getParentNode()) == null) {
                return null;
            }
            strName = currentCell.getNodeName();
        }
        JHTMLTableCellElement cell = (JHTMLTableCellElement)currentCell;
        JHTMLTableRowElement rowElem = (JHTMLTableRowElement)currentCell.getParentNode();
        return new ColumnInfo((Node)rowElem, cell.getCellIndex());
    }

    private void InsertColumn(boolean isLeft) {
        ColumnInfo colInfo = this.getCellIndex();
        if (colInfo == null) {
            return;
        }
        int currentCellIndex = colInfo.getCurrentCellIndex();
        Node currentRow = colInfo.getCurrentRow();
        HTMLTableElement tableElem = (HTMLTableElement)currentRow.getParentNode().getParentNode();
        int i = 0;
        while (i < tableElem.getRows().getLength()) {
            HTMLTableRowElement rowElem = (HTMLTableRowElement)tableElem.getRows().item(i);
            if (rowElem.getCells().getLength() > currentCellIndex) {
                HTMLTableCellElement cellElem = (HTMLTableCellElement)rowElem.getCells().item(currentCellIndex);
                Element newCell = this.createNewCell(cellElem);
                if (isLeft) {
                    rowElem.insertBefore(newCell, cellElem);
                } else if (rowElem.getCells().getLength() == currentCellIndex + 1) {
                    rowElem.appendChild(newCell);
                } else {
                    cellElem = (HTMLTableCellElement)rowElem.getCells().item(currentCellIndex + 1);
                    rowElem.insertBefore(newCell, cellElem);
                }
            }
            ++i;
        }
        this.resizeTable();
        this.dirty = true;
    }

    public void insertTableRowAbove() {
        HTMLTableRowElement currentRow = this.getCurrentRow();
        if (currentRow == null) {
            return;
        }
        HTMLTableRowElement newRow = (HTMLTableRowElement)this.createNewRow(currentRow);
        JNode container = (JNode)currentRow.getParentNode();
        container.insertBefore((Node)newRow, (Node)currentRow);
        this.dirty = true;
    }

    public void insertTableRowBelow() {
        HTMLTableRowElement currentRow = this.getCurrentRow();
        if (currentRow == null) {
            return;
        }
        Element newRow = this.createNewRow(currentRow);
        Node container = currentRow.getParentNode();
        Node prevRow = currentRow.getNextSibling();
        if (prevRow != null) {
            container.insertBefore(newRow, prevRow);
        } else {
            container.appendChild(newRow);
        }
        this.dirty = true;
    }

    public void deleteTableRow() {
        int firstSelectionRowIndex = this.getCurrentSelectionRowIndex(true);
        if (firstSelectionRowIndex == -1) {
            return;
        }
        int lastSelectionRowIndex = this.getCurrentSelectionRowIndex(false);
        if (lastSelectionRowIndex == -1) {
            return;
        }
        HTMLTableElement currentTable = this.getCurrentTableElement();
        if (currentTable == null) {
            return;
        }
        int i = firstSelectionRowIndex;
        while (i <= lastSelectionRowIndex) {
            currentTable.deleteRow(firstSelectionRowIndex);
            ++i;
        }
        this.dirty = true;
    }

    private void resizeTable() {
        HTMLTableElement currentTable = this.getCurrentTableElement();
        HTMLCollection rows = currentTable.getRows();
        int i = 0;
        while (i < rows.getLength()) {
            HTMLTableRowElement row = (HTMLTableRowElement)rows.item(i);
            HTMLCollection cells = row.getCells();
            int columnCount = cells.getLength();
            int width = 100 / columnCount;
            int remain = width + 100 % columnCount;
            String s_width = String.valueOf(String.valueOf(width)) + "%";
            String s_remain = String.valueOf(String.valueOf(remain)) + "%";
            int j = 0;
            while (j < columnCount) {
                JHTMLElement tdElem = (JHTMLElement)cells.item(j);
                if (j != columnCount - 1) {
                    tdElem.setAttribute("width", s_width);
                } else {
                    tdElem.setAttribute("width", s_remain);
                }
                ++j;
            }
            ++i;
        }
    }

    private HTMLTableElement getCurrentTableElement() {
        JHTMLSelection sel = this.htmlDoc.getSelection();
        JHTMLTxtRange range = sel.createRange().getTxtRange();
        Node node = range.parentElement();
        while (node != null) {
            if (node instanceof HTMLTableElement) {
                return (HTMLTableElement)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    private int getCurrentSelectionColIndex(boolean isStart) {
        JHTMLSelection sel = this.htmlDoc.getSelection();
        JHTMLTxtRange range = sel.createRange().getTxtRange().duplicate();
        range.collapse(isStart);
        Node node = range.parentElement();
        HTMLTableCellElement currentCell = null;
        while (node != null) {
            if (node instanceof HTMLTableCellElement) {
                currentCell = (HTMLTableCellElement)node;
                break;
            }
            node = node.getParentNode();
        }
        return currentCell.getCellIndex();
    }

    private int getCurrentSelectionRowIndex(boolean isStart) {
        JHTMLSelection sel = this.htmlDoc.getSelection();
        JHTMLTxtRange range = sel.createRange().getTxtRange().duplicate();
        range.collapse(isStart);
        Node node = range.parentElement();
        HTMLTableRowElement currentRow = null;
        while (node != null) {
            if (node instanceof HTMLTableRowElement) {
                currentRow = (HTMLTableRowElement)node;
                break;
            }
            node = node.getParentNode();
        }
        if (currentRow == null) {
            return -1;
        }
        return currentRow.getRowIndex();
    }

    private HTMLTableRowElement getCurrentRow() {
        JHTMLSelection sel = this.htmlDoc.getSelection();
        JHTMLTxtRange range = sel.createRange().getTxtRange();
        range.collapse(true);
        Node currentRow = range.parentElement();
        String strName = currentRow.getNodeName();
        while (!strName.equalsIgnoreCase("tr")) {
            if ((currentRow = currentRow.getParentNode()) == null) {
                return null;
            }
            strName = currentRow.getNodeName();
        }
        return (HTMLTableRowElement)currentRow;
    }

    private Element createNewRow(HTMLTableRowElement currentRow) {
        int colNum = currentRow.getCells().getLength();
        JHTMLElement newRow = (JHTMLElement)this.htmlDoc.createElement("tr");
        JHTMLTableRowElement row = (JHTMLTableRowElement)currentRow;
        String stylesValue = row.getStyle().getCssText();
        newRow.getStyle().setCssText(stylesValue);
        int i = 0;
        while (i < currentRow.getAttributes().getLength()) {
            JAttr attr = (JAttr)currentRow.getAttributes().item(i);
            if (attr.getValue().length() > 0 && !attr.getValue().equalsIgnoreCase("null") && !attr.getValue().equalsIgnoreCase("false")) {
                newRow.setAttribute(attr.getName(), attr.getValue());
            }
            ++i;
        }
        i = 0;
        while (i < colNum) {
            HTMLTableCellElement cellElem = (HTMLTableCellElement)currentRow.getCells().item(i);
            Element newCell = this.createNewCell(cellElem);
            newRow.appendChild((Node)newCell);
            ++i;
        }
        return newRow;
    }

    private Element createNewCell(HTMLTableCellElement cellElem) {
        JHTMLElement newCell = (JHTMLElement)this.htmlDoc.createElement("td");
        JHTMLTableCellElement cell = (JHTMLTableCellElement)cellElem;
        String stylesValue = cell.getStyle().getCssText();
        newCell.getStyle().setCssText(stylesValue);
        int j = 0;
        while (j < cellElem.getAttributes().getLength()) {
            Attr attr = (Attr)cellElem.getAttributes().item(j);
            if (attr.getValue().length() > 0 && !attr.getValue().equalsIgnoreCase("null") && !attr.getValue().equalsIgnoreCase("false")) {
                newCell.setAttribute(attr.getName(), attr.getValue());
            }
            ++j;
        }
        return newCell;
    }

    public void bidi() {
        this.setDirection(-this.getDirection());
    }

    public void focus() throws RTEException {
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.focus();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private Node getCursorPositionNode() throws RTEException {
        HTMLElement node = null;
        try {
            JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
            if (rangeResult.isTxtRange()) {
                node = rangeResult.getTxtRange().parentElement();
            } else if (rangeResult.isControlRange()) {
                node = rangeResult.getControlRange().item(rangeResult.getControlRange().getLength() - 1);
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg15, (Exception)e);
        }
        return node;
    }

    private void fireDragStart() {
        RTEEvent event = new RTEEvent();
        event.setType(3);
        int i = 0;
        while (i < this.dragStartListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.dragStartListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg11, (Exception)e);
            }
            ++i;
        }
    }

    private void fireDragOver() {
        RTEEvent event = new RTEEvent();
        event.setType(4);
        int i = 0;
        while (i < this.dragOverListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.dragOverListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg10, (Exception)e);
            }
            ++i;
        }
    }

    private void fireDrop() {
        RTEEvent event = new RTEEvent();
        event.setType(5);
        int i = 0;
        while (i < this.dropListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.dropListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg12, (Exception)e);
            }
            ++i;
        }
    }

    private void fireCut() {
        RTEEvent event = new RTEEvent();
        event.setType(6);
        int i = 0;
        while (i < this.cutListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.cutListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg09, (Exception)e);
            }
            ++i;
        }
    }

    private void firePaste(Event arg) {
        RTEEvent event = new RTEEvent();
        event.setType(7);
        int i = 0;
        while (i < this.pasteListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.pasteListeners.get(i);
                lis.handleEvent(event);
                if (!event.doIt) {
                    arg.stopPropagation();
                    arg.preventDefault();
                    return;
                }
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg13, (Exception)e);
            }
            ++i;
        }
    }

    public void addDragStartListener(RTEEventListener lis) {
        this.dragStartListeners.add(lis);
    }

    public void addDragOverListener(RTEEventListener lis) {
        this.dragOverListeners.add(lis);
    }

    public void addDropListener(RTEEventListener lis) {
        this.dropListeners.add(lis);
    }

    public void addCutListener(RTEEventListener lis) {
        this.cutListeners.add(lis);
    }

    public void addPasteListener(RTEEventListener lis) {
        this.pasteListeners.add(lis);
    }

    public String getSelectedText() {
        String sText = "";
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (rangeResult.isTxtRange()) {
            boolean noneSelected = false;
            if (rangeResult.getTxtRange().getText() == null) {
                this.selectAll();
                noneSelected = true;
            }
            JHTMLTxtRange textRange = this.htmlDoc.getSelection().createRange().getTxtRange();
            if (noneSelected) {
                this.unselect();
            }
            sText = textRange.getText();
        }
        if (sText == null) {
            sText = "";
        }
        return sText;
    }

    public String getDocumentContentInPlainText() {
        JHTMLTxtRange bodyTxtRange = ((JHTMLBodyElement)this.htmlDoc.getBody()).createTextRange();
        String bodyString = bodyTxtRange.getText();
        return bodyString;
    }

    public void setDirection(int value) {
        JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
        if (body == null) {
            return;
        }
        if (value == 1) {
            body.setDir("ltr");
        }
        if (value == -1) {
            body.setDir("rtl");
        }
        this.dirty = true;
        this.fireCursorInfoChangedEvent();
    }

    public int getDirection() {
        String dir;
        JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
        if (body == null) {
            if (0x2000000 == (this.getStyle() & 0x2000000)) {
                return 1;
            }
            if (0x4000000 == (this.getStyle() & 0x4000000)) {
                return -1;
            }
        }
        if ("ltr".equals(dir = body.getDir())) {
            return 1;
        }
        if ("rtl".equals(dir)) {
            return -1;
        }
        return 1;
    }

    public void doCheckSpelling() {
        if (this.initRTESpellChecker()) {
            this.rteSpellChecker.invokeSpellChecker();
        }
    }

    private boolean initRTESpellChecker() {
        if (this.rteSpellChecker == null) {
            this.rteSpellChecker = new RTESpellChecker(this.webBrowser.getShell(), this.localeCode, this);
        }
        return this.rteSpellChecker.setDictionaryLocaleCode(this.localeCode);
    }

    public boolean enableBackgroundSpellchecking(boolean enable) {
        if (this.enableBackgroundSpellchecking == enable) {
            return true;
        }
        this.enableBackgroundSpellchecking = enable;
        this.backgroundSpellChecker = TextAnalyzerFactory.getSpellCheckerInstance();
        try {
            if (enable) {
                this.backgroundSpellChecker.setLocale(this.localeCode);
                this.oldLocaleCode = this.localeCode;
            } else {
                this.backgroundSpellChecker.setLocale(this.oldLocaleCode);
            }
        }
        catch (TextAnalyzerException exp) {
            if (exp.errorCode == 6) {
                MessageDialog.openInformation((Shell)this.webBrowser.getShell(), (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_NoEngine);
            }
            if (exp.errorCode == 4) {
                MessageDialog.openInformation((Shell)this.webBrowser.getShell(), (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_NoNLDirection);
            }
            this.enableBackgroundSpellchecking = false;
            return false;
        }
        if (enable) {
            this.addMisspellingStyle();
            this.misspellContextMenuListener = new DefaultRTEEventListener();
            this.addDocumentEventListener("contextmenu", this.misspellContextMenuListener);
            this.markedMisspelledWordsInWholeDocument();
        } else {
            this.backgroundSpellChecker.dispose();
            this.backgroundSpellChecker = null;
            this.removeMisspellingStyle();
            this.removeMisspellInfo();
            if (this.misspellContextMenuListener != null) {
                this.removeDocumentEventListener("contextmenu", this.misspellContextMenuListener);
                this.misspellContextMenuListener = null;
            }
        }
        return true;
    }

    public void removeMisspellInfo() {
        NodeList spanElements = this.htmlDoc.getElementsByTagName("SPAN");
        int spanElementsNum = spanElements.getLength();
        int i = spanElementsNum - 1;
        while (i >= 0) {
            Node spanElement = spanElements.item(i);
            if (((JHTMLElement)spanElement).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)spanElement).getAttribute("MISSPELLED"))) {
                Node parent = spanElement.getParentNode();
                String NodeValue = this.getNodeContainedText(spanElement).trim();
                org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(NodeValue);
                parent.insertBefore(textNode, spanElement);
                parent.removeChild(spanElement);
            }
            --i;
        }
    }

    private void markedMisspelledWordsInWholeDocument() {
        HTMLElement bodyNode = this.htmlDoc.getBody();
        this.markedMispelledWord(bodyNode);
    }

    private void ignoreAll(String ignoreWord) {
        HTMLElement curNode = this.htmlDoc.getBody();
        if (((JHTMLElement)curNode).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)curNode).getAttribute("MISSPELLED"))) {
            return;
        }
        String NodeValue = this.getDocContent(curNode);
        if ("".equals(NodeValue)) {
            return;
        }
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (rangeResult.isTxtRange()) {
            JHTMLTxtRange range = rangeResult.getTxtRange();
            range.moveToElementText((HTMLElement)((JHTMLElement)curNode));
            String misSpellWord = ignoreWord;
            while (this.findText(range, misSpellWord)) {
                if (((JHTMLElement)range.parentElement()).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)range.parentElement()).getAttribute("MISSPELLED"))) {
                    HTMLElement cNode = range.parentElement();
                    Node pNode = cNode.getParentNode();
                    org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(misSpellWord);
                    pNode.insertBefore(textNode, cNode);
                    pNode.removeChild(cNode);
                    continue;
                }
                range.move("character", 1);
            }
        }
    }

    private void autoCorrect(String misSpellWord, String correctWord) {
        HTMLElement curNode = this.htmlDoc.getBody();
        if (((JHTMLElement)curNode).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)curNode).getAttribute("MISSPELLED"))) {
            return;
        }
        String NodeValue = this.getDocContent(curNode);
        if ("".equals(NodeValue)) {
            return;
        }
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (rangeResult.isTxtRange()) {
            JHTMLTxtRange range = rangeResult.getTxtRange();
            range.moveToElementText((HTMLElement)((JHTMLElement)curNode));
            while (this.findText(range, misSpellWord)) {
                int inum = correctWord.length() - misSpellWord.length();
                if (((JHTMLElement)range.parentElement()).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)range.parentElement()).getAttribute("MISSPELLED"))) {
                    HTMLElement cNode = range.parentElement();
                    Node pNode = cNode.getParentNode();
                    org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(correctWord);
                    pNode.insertBefore(textNode, cNode);
                    pNode.removeChild(cNode);
                    continue;
                }
                range.select();
                range.pasteHTML(correctWord);
                range.move("character", inum + 1);
                return;
            }
        }
    }

    private void addMisspellingStyle() {
        JStyleSheetList list = (JStyleSheetList)this.htmlDoc.getStyleSheets();
        if (list == null || list.getLength() == 0) {
            this.htmlDoc.createStyleSheet("", 0);
        }
        JCSSStyleSheet sheet = (JCSSStyleSheet)list.item(0);
        try {
            sheet.insertRule("SPAN.misspelling {border-bottom-style: solid;border-bottom-width: thin;border-bottom-color: red }", 0);
        }
        catch (DOMException e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg04, (Exception)e);
        }
    }

    private void removeMisspellingStyle() {
        JStyleSheetList list = (JStyleSheetList)this.htmlDoc.getStyleSheets();
        if (list == null || list.getLength() == 0) {
            return;
        }
        JCSSStyleSheet sheet = (JCSSStyleSheet)list.item(0);
        if (sheet == null || sheet.getCssRules() == null || sheet.getCssRules().getLength() == 0) {
            return;
        }
        String strRules = sheet.getCssRules().item(0).getCssText();
        if (strRules.substring(0, 16).equalsIgnoreCase("span.misspelling")) {
            sheet.deleteRule(0);
        }
    }

    private void invokeBackgroundSpellchecking(Node node, int type, String word) {
        if (node == null) {
            return;
        }
        try {
            switch (type) {
                case 1: {
                    if (((JHTMLElement)node).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)node).getAttribute("MISSPELLED"))) {
                        String NodeValue;
                        MisspelledWord[] misSpellWords;
                        String nextNodeValue = "";
                        Node nextSibling = null;
                        if (node.getNextSibling() != null && (nextSibling = node.getNextSibling()) instanceof JHTMLElement && ((JHTMLElement)nextSibling).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)nextSibling).getAttribute("MISSPELLED"))) {
                            nextNodeValue = this.getNodeContainedText(nextSibling).trim();
                        }
                        if ((misSpellWords = this.getMisSpelledWords(NodeValue = String.valueOf(this.getNodeContainedText(node)) + nextNodeValue)) == null) {
                            return;
                        }
                        if (misSpellWords.length == 0) {
                            Node parent = node.getParentNode();
                            int i = node.getChildNodes().getLength() - 1;
                            while (i >= 0) {
                                Node child = node.getChildNodes().item(0);
                                parent.insertBefore(child, node);
                                --i;
                            }
                            parent.removeChild(node);
                            if (nextSibling != null && nextSibling instanceof JHTMLElement && ((JHTMLElement)nextSibling).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)nextSibling).getAttribute("MISSPELLED"))) {
                                parent.removeChild(nextSibling);
                            }
                        } else {
                            Node parent = node.getParentNode();
                            int i = node.getChildNodes().getLength() - 1;
                            while (i >= 0) {
                                Node child = node.getChildNodes().item(0);
                                parent.insertBefore(child, node);
                                --i;
                            }
                            parent.removeChild(node);
                            this.markedMispelledWord(parent);
                        }
                    }
                    return;
                }
                case 2: {
                    if (((JHTMLElement)node).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)node).getAttribute("MISSPELLED"))) {
                        if (word != null && word.equalsIgnoreCase("Ignore")) {
                            ((JHTMLElement)node).setAttribute("IGNORED", "1");
                            String content = ((JHTMLElement)node).getOuterHTML();
                            content = String.valueOf(content.substring(0, 6)) + content.substring(content.indexOf("MISSPELLED"));
                            ((JHTMLElement)node).setOuterHTML(content);
                        } else {
                            Node parent = node.getParentNode();
                            String NodeValue = this.getNodeContainedText(node).trim();
                            org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(NodeValue);
                            parent.insertBefore(textNode, node);
                            parent.removeChild(node);
                        }
                    }
                    return;
                }
                case 3: {
                    this.removeMisspellInfo();
                    return;
                }
                case 4: {
                    Node parent = node.getParentNode();
                    org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(word);
                    parent.insertBefore(textNode, node);
                    parent.removeChild(node);
                    this.dirty = true;
                    return;
                }
                case 5: {
                    this.markedMispelledWord(node);
                    return;
                }
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg29, (Exception)e);
        }
    }

    private void markedMispelledWord(Node node) {
        int numSuggestions = 5;
        Node curNode = node;
        if (node.getNodeType() == 3) {
            return;
        }
        if (curNode instanceof JHTMLElement && ((JHTMLElement)curNode).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)curNode).getAttribute("MISSPELLED"))) {
            return;
        }
        String NodeValue = this.getDocContent(curNode);
        if ("".equals(NodeValue)) {
            return;
        }
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (rangeResult.isTxtRange()) {
            JHTMLTxtRange range = rangeResult.getTxtRange();
            range.moveToElementText((HTMLElement)((JHTMLElement)curNode));
            NodeValue = range.getText();
            MisspelledWord[] misSpellWords = this.getMisSpelledWords(NodeValue);
            if (misSpellWords == null) {
                return;
            }
            int i = 0;
            while (i < misSpellWords.length) {
                MisspelledWord speltWord = misSpellWords[i];
                String misSpellWord = speltWord.getWord();
                if (this.BackgroundSpellchecking_Ignore_Words.contains(misSpellWord)) {
                    range.move("character", 1);
                } else if (this.BackgroundSpellchecking_Auto_Correct.containsKey(misSpellWord)) {
                    boolean findIt = this.findEntiredText(range, misSpellWords[i], NodeValue);
                    if (findIt) {
                        String correctWord = (String)this.BackgroundSpellchecking_Auto_Correct.get(misSpellWord);
                        int inum = correctWord.length() - misSpellWord.length();
                        range.select();
                        range.pasteHTML(correctWord);
                        range.move("character", inum + 1);
                    }
                } else {
                    String[] suggestions = speltWord.getSuggestions();
                    if (suggestions == null) {
                        return;
                    }
                    numSuggestions = suggestions.length < 5 ? suggestions.length : 5;
                    String strSuggestions = "";
                    int j = 0;
                    while (j < numSuggestions) {
                        strSuggestions = String.valueOf(strSuggestions) + suggestions[j] + "/";
                        ++j;
                    }
                    boolean isFind = this.findEntiredText(range, misSpellWords[i], NodeValue);
                    if (isFind) {
                        if (((JHTMLElement)range.parentElement()).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)range.parentElement()).getAttribute("MISSPELLED"))) {
                            ((JHTMLElement)range.parentElement()).setAttribute("SUGGESTIONS", strSuggestions);
                            range.move("character", 1);
                        } else {
                            JHTMLElement markedMisspellWord = (JHTMLElement)this.getHtmlDocInstance().createElement("span");
                            markedMisspellWord.setAttribute("CLASS", "misspelling");
                            markedMisspellWord.setAttribute("MISSPELLED", "1");
                            markedMisspellWord.setAttribute("SUGGESTIONS", strSuggestions);
                            org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(misSpellWord);
                            markedMisspellWord.appendChild((Node)textNode);
                            range.select();
                            range.pasteHTML(markedMisspellWord.getOuterHTML());
                            range.move("character", 1);
                            range.select();
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean findEntiredText(JHTMLTxtRange range, MisspelledWord word, String text) {
        int beginIndex = word.getBeginIndex();
        int endIndex = word.getEndIndex();
        int beginOffset = beginIndex == 0 ? 0 : -1;
        int endOffset = endIndex == text.length() ? 0 : 1;
        String compareStr = text.substring(beginIndex + beginOffset, endIndex + endOffset).trim();
        boolean entired = false;
        boolean isFind = range.findText(word.getWord(), 1, 6);
        if (isFind) {
            while (isFind && !entired) {
                JHTMLTxtRange rangeBak = range.duplicate();
                rangeBak.moveStart("character", beginOffset);
                rangeBak.moveEnd("character", endOffset);
                entired = rangeBak.getText().trim().equalsIgnoreCase(compareStr);
                if (entired) continue;
                range.move("character", 1);
                isFind = range.findText(word.getWord(), 1, 6);
            }
            return entired;
        }
        isFind = range.findText(word.getWord(), 1, -4);
        if (isFind) {
            while (isFind && !entired) {
                JHTMLTxtRange rangeBak = range.duplicate();
                rangeBak.moveStart("character", beginOffset);
                rangeBak.moveEnd("character", endOffset);
                entired = rangeBak.getText().trim().equalsIgnoreCase(compareStr);
                if (entired) continue;
                range.move("character", 1);
                isFind = range.findText(word.getWord(), 1, -4);
            }
        }
        return entired;
    }

    private boolean findText(JHTMLTxtRange range, String misSpellWord) {
        boolean isFind = range.findText(misSpellWord, 1, 6);
        if (!isFind) {
            if (range.findText(misSpellWord, 1, -4)) {
                JHTMLTxtRange rangeBak = range.duplicate();
                rangeBak.moveStart("character", -1);
                isFind = rangeBak.getText().equalsIgnoreCase("'" + misSpellWord);
                if (!isFind) {
                    rangeBak.moveStart("character", 1);
                    rangeBak.moveEnd("character", 1);
                    isFind = rangeBak.getText().equalsIgnoreCase(String.valueOf(misSpellWord) + "'");
                    if (!isFind) {
                        range.move("character", 1);
                    }
                }
            } else {
                range.move("character", 1);
            }
        }
        return isFind;
    }

    private MisspelledWord[] getMisSpelledWords(String text) {
        MisspelledWord[] misspeltWords = this.backgroundSpellChecker.checkSpelling(text, 5, false);
        return misspeltWords;
    }

    public void setSpellCheckerLocale(String sLocaleCode) {
        this.localeCode = sLocaleCode;
    }

    private void addTranslateAcceleratorListener() {
        try {
            this.webBrowser.setTranslateAcceleratorListener(new TranslateAcceleratorListener(){

                public boolean translateAccelerator(IEMSG msg) {
                    short fCtrlKey = IEOS.GetKeyState((int)17);
                    if ((msg.wParam == 86 || msg.wParam == 118) && (fCtrlKey & 0x100) != 0) {
                        if (msg.message == 256) {
                            RichTextEditor.this.paste();
                        }
                        return true;
                    }
                    if (msg.wParam == 9 && msg.message == 256) {
                        fCtrlKey = IEOS.GetKeyState((int)17);
                        if ((fCtrlKey & 0x100) != 0) {
                            return RichTextEditor.this.getShell().traverse(16);
                        }
                        short fShiftKey = IEOS.GetKeyState((int)16);
                        if ((fShiftKey & 0x100) != 0) {
                            return RichTextEditor.this.webBrowser.traverse(8);
                        }
                        boolean fHandled = false;
                        if (!RichTextEditor.this.isReadOnly()) {
                            JHTMLDocument htmlDoc = (JHTMLDocument)RichTextEditor.this.webBrowser.getDocument();
                            JHTMLSelection.CreateRangeResult rangeResult = htmlDoc.getSelection().createRange();
                            if (!rangeResult.isTxtRange()) {
                                return false;
                            }
                            JHTMLTxtRange currPos = rangeResult.getTxtRange();
                            currPos.setText("    ");
                            fHandled = true;
                        }
                        int i = 0;
                        while (i < RichTextEditor.this.keylisteners.size()) {
                            KeyListener kl = (KeyListener)RichTextEditor.this.keylisteners.elementAt(i);
                            org.eclipse.swt.widgets.Event event = new org.eclipse.swt.widgets.Event();
                            int temp = 9;
                            event.character = (char)temp;
                            event.keyCode = temp;
                            event.stateMask = 0;
                            event.widget = RichTextEditor.this.webBrowser;
                            KeyEvent ke = new KeyEvent(event);
                            kl.keyPressed(ke);
                            ++i;
                        }
                        return fHandled;
                    }
                    if (msg.wParam == 9 && msg.message == 257) {
                        int i = 0;
                        while (i < RichTextEditor.this.keylisteners.size()) {
                            KeyListener kl = (KeyListener)RichTextEditor.this.keylisteners.elementAt(i);
                            org.eclipse.swt.widgets.Event event = new org.eclipse.swt.widgets.Event();
                            int temp = 9;
                            event.character = (char)temp;
                            event.keyCode = temp;
                            event.stateMask = 0;
                            event.widget = RichTextEditor.this.webBrowser;
                            KeyEvent ke = new KeyEvent(event);
                            kl.keyReleased(ke);
                            ++i;
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg26, (Exception)e);
        }
    }

    private void initEventTransfer() throws RTEException {
        try {
            this.addSystemDocumentEventListener("keypress", new EventListener(){

                public void handleEvent(Event evt) {
                    int i = 0;
                    while (i < RichTextEditor.this.keylisteners.size()) {
                        KeyListener kl = (KeyListener)RichTextEditor.this.keylisteners.elementAt(i);
                        if ("keypress".equals(evt.getType())) {
                            org.eclipse.swt.widgets.Event event = new org.eclipse.swt.widgets.Event();
                            JEvent jevt = (JEvent)evt;
                            int temp = jevt.getKeyCode();
                            event.character = (char)temp;
                            event.keyCode = ((JEvent)evt).getKeyCode();
                            event.stateMask = 0;
                            event.widget = RichTextEditor.this.webBrowser;
                            KeyEvent ke = new KeyEvent(event);
                            kl.keyPressed(ke);
                            if (!ke.doit) {
                                evt.preventDefault();
                                evt.stopPropagation();
                            }
                        }
                        ++i;
                    }
                }
            });
            this.addSystemDocumentEventListener("keyup", new EventListener(){

                public void handleEvent(Event evt) {
                    int keyCode;
                    if ("keyup".equals(evt.getType())) {
                        int i = 0;
                        while (i < RichTextEditor.this.keylisteners.size()) {
                            KeyListener kl = (KeyListener)RichTextEditor.this.keylisteners.elementAt(i);
                            org.eclipse.swt.widgets.Event event = new org.eclipse.swt.widgets.Event();
                            event.character = (char)((JEvent)evt).getKeyCode();
                            event.keyCode = ((JEvent)evt).getKeyCode();
                            event.stateMask = 0;
                            if (((JEvent)evt).getCtrlKey()) {
                                event.stateMask |= 0x40000;
                            }
                            if (((JEvent)evt).getShiftKey()) {
                                event.stateMask |= 0x20000;
                            }
                            if (((JEvent)evt).getAltKey()) {
                                event.stateMask |= 0x10000;
                            }
                            event.widget = RichTextEditor.this.webBrowser;
                            KeyEvent ke = new KeyEvent(event);
                            kl.keyReleased(ke);
                            ++i;
                        }
                    }
                    if (!RichTextEditor.this.isReadOnly && RichTextEditor.this.cursorInfoChangedListeners != null && RichTextEditor.this.cursorInfoChangedListeners.size() > 0) {
                        keyCode = ((JEvent)evt).getKeyCode();
                        switch (keyCode) {
                            case 8: 
                            case 33: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 46: {
                                RichTextEditor.this.fireCursorInfoChangedEvent();
                            }
                        }
                        if (((JEvent)evt).getCtrlKey()) {
                            char character = (char)((JEvent)evt).getKeyCode();
                            switch (character) {
                                case 'B': 
                                case 'I': 
                                case 'U': 
                                case 'V': 
                                case 'X': 
                                case 'b': 
                                case 'i': 
                                case 'u': 
                                case 'v': 
                                case 'x': {
                                    RichTextEditor.this.fireCursorInfoChangedEvent();
                                }
                            }
                        }
                    }
                    if (!RichTextEditor.this.isReadOnly && RichTextEditor.this.enableBackgroundSpellchecking) {
                        Node curNode;
                        char chars;
                        keyCode = ((JEvent)evt).getKeyCode();
                        if (keyCode == 9 || keyCode == 32 || keyCode == 13 || keyCode >= 186 && keyCode <= 192 || keyCode >= 218 && keyCode <= 222) {
                            int style = 5;
                            Node curNode2 = RichTextEditor.this.getCursorPositionNode();
                            if (curNode2 == null) {
                                return;
                            }
                            RichTextEditor.this.invokeBackgroundSpellchecking(curNode2, style, null);
                            if (keyCode == 13 && (curNode2 = RichTextEditor.this.getcurrentParagraphNode(curNode2)).getPreviousSibling() != null) {
                                curNode2 = curNode2.getPreviousSibling();
                                RichTextEditor.this.invokeBackgroundSpellchecking(curNode2, style, null);
                            }
                        }
                        if ((chars = (char)((JEvent)evt).getKeyCode()) >= 'a' && chars <= 'z' || chars >= 'A' && chars <= 'Z' || keyCode == 46 || keyCode == 32 || keyCode == 13 || keyCode >= 186 && keyCode <= 192 || keyCode >= 218 && keyCode <= 222) {
                            int style = 1;
                            if (keyCode == 13) {
                                Node tmpNode = RichTextEditor.this.getCursorPositionNode();
                                if (((JEvent)evt).getShiftKey()) {
                                    RichTextEditor.this.invokeBackgroundSpellchecking(tmpNode, style, null);
                                    return;
                                }
                                tmpNode = RichTextEditor.this.getcurrentParagraphNode(tmpNode);
                                RichTextEditor.this.recursionUpdateMisspelledWord(tmpNode, style);
                                if (tmpNode.getPreviousSibling() != null) {
                                    tmpNode = tmpNode.getPreviousSibling();
                                    RichTextEditor.this.recursionUpdateMisspelledWord(tmpNode, style);
                                }
                                return;
                            }
                            curNode = RichTextEditor.this.getCursorPositionNode();
                            RichTextEditor.this.invokeBackgroundSpellchecking(curNode, style, null);
                        }
                        if (keyCode == 8) {
                            Node nextSibling;
                            int style = 2;
                            curNode = RichTextEditor.this.getCursorPositionNode();
                            if (curNode != null && curNode.getNextSibling() != null && (nextSibling = curNode.getNextSibling()) instanceof JHTMLElement) {
                                RichTextEditor.this.invokeBackgroundSpellchecking(nextSibling, style, null);
                            }
                            RichTextEditor.this.invokeBackgroundSpellchecking(curNode, style, null);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg26, (Exception)e);
        }
    }

    private Node getcurrentParagraphNode(Node node) {
        Node tmp = node;
        while (node.getParentNode() != null) {
            if ((node = node.getParentNode()) instanceof JHTMLParagraphElement) {
                return node;
            }
            if (!(node instanceof JHTMLBodyElement)) continue;
            return tmp;
        }
        return tmp;
    }

    private void recursionUpdateMisspelledWord(Node parent, int style) {
        if (parent.getChildNodes() != null && parent.getChildNodes().getLength() != 0) {
            int i = 0;
            while (i < parent.getChildNodes().getLength()) {
                Node child = parent.getChildNodes().item(i);
                if (child != null) {
                    if (child.getNodeType() != 3 && ((JHTMLElement)child).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)child).getAttribute("MISSPELLED"))) {
                        this.invokeBackgroundSpellchecking(child, style, null);
                    } else {
                        this.recursionUpdateMisspelledWord(child, style);
                    }
                }
                ++i;
            }
        } else if (parent.getNodeType() != 3 && ((JHTMLElement)parent).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)parent).getAttribute("MISSPELLED"))) {
            this.invokeBackgroundSpellchecking(parent, style, null);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (this.keylisteners == null) {
            this.keylisteners = new Vector();
        }
        if (!this.keylisteners.contains(listener)) {
            this.keylisteners.addElement(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.keylisteners != null && this.keylisteners.contains(listener)) {
            this.keylisteners.removeElement(listener);
        }
    }

    public boolean doesSelectionExists() {
        boolean retVal = false;
        String selType = this.htmlDoc.getSelection().getType();
        if (selType.equalsIgnoreCase("control")) {
            retVal = true;
        } else if (selType.equalsIgnoreCase("text")) {
            JHTMLTxtRange txtRange = this.htmlDoc.getSelection().createRange().getTxtRange().duplicate();
            String strText = txtRange.getHtmlText();
            retVal = strText != null;
        }
        return retVal;
    }

    private void insertElementAtSelection(Element elem) {
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (rangeResult.isTxtRange()) {
            JHTMLTxtRange currPos = rangeResult.getTxtRange().duplicate();
            currPos.pasteHTML(((JHTMLElement)elem).getOuterHTML());
        } else {
            JHTMLControlRange currPos = rangeResult.getControlRange();
            HTMLElement selElem = currPos.item(currPos.getLength() - 1);
            Node nextNode = selElem.getNextSibling();
            selElem.getParentNode().insertBefore(elem, nextNode);
        }
        this.dirty = true;
    }

    public void disableDefaultDropHandler() {
        JHTMLElement body = (JHTMLElement)this.webBrowser.getDocument().getBody();
        if (body == null) {
            return;
        }
        body.addEventListener("dragenter", new EventListener(){

            public void handleEvent(Event arg) {
                RichTextEditor.this.webBrowser.getHTMLWindow().getEvent().preventDefault();
            }
        }, true);
        body.addEventListener("dragover", new EventListener(){

            public void handleEvent(Event arg) {
                RichTextEditor.this.webBrowser.getHTMLWindow().getEvent().preventDefault();
            }
        }, true);
    }

    private String getDocContent(Node parent) {
        String retVal = "";
        if (parent.getChildNodes() != null && parent.getChildNodes().getLength() != 0) {
            int i = 0;
            while (i < parent.getChildNodes().getLength()) {
                if (parent.getChildNodes().item(i) != null) {
                    if (parent.getChildNodes().item(i).getNodeType() == 3) {
                        try {
                            retVal = String.valueOf(retVal) + " " + parent.getChildNodes().item(i).getNodeValue();
                        }
                        catch (DOMException e) {
                            RTEExceptionHelper.handleRTEException((Level)Level.INFO, (String)RTENLS.Err_Msg16, (Throwable)e);
                        }
                    } else {
                        retVal = String.valueOf(retVal) + " " + this.getDocContent(parent.getChildNodes().item(i));
                    }
                }
                ++i;
            }
        } else if (parent.getNodeType() == 3) {
            retVal = String.valueOf(retVal) + " " + parent.getNodeValue();
        }
        return retVal;
    }

    private String getNodeContainedText(Node parent) {
        String retVal = "";
        if (parent.getChildNodes() != null) {
            int i = 0;
            while (i < parent.getChildNodes().getLength()) {
                if (parent.getChildNodes().item(i) != null) {
                    if (parent.getChildNodes().item(i).getNodeType() == 3) {
                        try {
                            retVal = String.valueOf(retVal) + parent.getChildNodes().item(i).getNodeValue();
                        }
                        catch (DOMException e) {
                            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg19, (Exception)e);
                        }
                    } else {
                        retVal = parent.getChildNodes().item(i) instanceof JHTMLBRElement ? String.valueOf(retVal) + " " : String.valueOf(retVal) + this.getNodeContainedText(parent.getChildNodes().item(i));
                    }
                }
                ++i;
            }
        }
        return retVal;
    }

    private String[] split(String target, String regex) {
        if (target == null || regex == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(target, regex);
        Vector<String> strVector = new Vector<String>();
        int i = 0;
        while (st.hasMoreTokens()) {
            strVector.add(i, st.nextToken());
            ++i;
        }
        String[] returnStrs = new String[i];
        int j = 0;
        while (j < i) {
            returnStrs[j] = (String)strVector.get(j);
            ++j;
        }
        return returnStrs;
    }

    public boolean makeSelection(String selText, boolean isFirstSearch) {
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (!rangeResult.isTxtRange()) {
            return false;
        }
        JHTMLTxtRange selObj = rangeResult.getTxtRange();
        if (isFirstSearch) {
            selObj.moveStart("textedit", -1);
        } else {
            selObj.moveStart("character", 1);
        }
        boolean retVal = selObj.findText(selText, 1, 6);
        if (retVal) {
            selObj.select();
        }
        return retVal;
    }

    public void replace(String newWord) {
        JHTMLSelection.CreateRangeResult rangeResult = this.htmlDoc.getSelection().createRange();
        if (!rangeResult.isTxtRange()) {
            return;
        }
        JHTMLTxtRange selObj = rangeResult.getTxtRange();
        selObj.pasteHTML(newWord);
        this.dirty = true;
        if (this.enableBackgroundSpellchecking) {
            Node node = this.getCursorPositionNode();
            int style = 1;
            this.invokeBackgroundSpellchecking(node, style, null);
        }
    }

    public String getAllTextString() {
        HTMLElement parent = this.htmlDoc.getBody();
        return this.getDocContent(parent);
    }

    public Element createHTMLElement(String tag) {
        return this.getHtmlDocInstance().createElement(tag);
    }

    public Element queryHTMLElementByID(String ID) {
        return this.getHtmlDocInstance().getElementById(ID);
    }

    public void removeHTMLElement(Element elem) {
        elem.getParentNode().removeChild(elem);
        this.dirty = true;
    }

    public void setUrl(String url) {
        if (url == null | url.trim().length() == 0) {
            url = "about:blank";
        }
        if (!url.equalsIgnoreCase("about:blank")) {
            try {
                URL u = new URL(url);
                if (u.getProtocol().equalsIgnoreCase("ftp")) {
                    url = "about:blank";
                }
            }
            catch (Exception exception) {
                try {
                    File f = new File(url);
                    if (!f.exists()) {
                        url = "about:blank";
                    }
                }
                catch (Exception exception2) {
                    url = "about:blank";
                }
            }
        }
        this.isLoadCompleted = false;
        this.isUrlSetting = true;
        this.webBrowser.setUrl(url);
        int counter = 0;
        while (!this.isLoadCompleted && counter < 1000) {
            Shell shell;
            try {
                shell = this.getShell();
            }
            catch (Exception exception) {
                ++counter;
                continue;
            }
            RichTextEditor.runLoopTimer(shell, 5);
            ++counter;
        }
    }

    public void addCompletedListener(final RTEEventListener listener) {
        if (this.webBrowser == null || listener == null) {
            return;
        }
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent e) {
            }

            public void completed(ProgressEvent e) {
                try {
                    RTEEvent initDoneEvent = new RTEEvent();
                    initDoneEvent.setType(8);
                    listener.handleEvent(initDoneEvent);
                }
                catch (Exception unknownEx) {
                    RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg31, (Exception)unknownEx);
                }
            }
        };
        this.completedListener.put(listener, progressListener);
        this.webBrowser.addProgressListener(progressListener);
    }

    public void removeCompletedListener(RTEEventListener listener) {
        if (this.webBrowser == null || listener == null) {
            return;
        }
        ProgressListener progressListener = (ProgressListener)this.completedListener.remove(listener);
        if (progressListener != null) {
            this.webBrowser.removeProgressListener(progressListener);
        }
    }

    public void addListener(Element elem, String tag, EventListener lis) {
        JHTMLElement jelem = (JHTMLElement)elem;
        jelem.addEventListener(tag, lis, true);
    }

    public void removeListener(Element elem, String tag, EventListener lis) {
        JHTMLElement jelem = (JHTMLElement)elem;
        jelem.removeEventListener(tag, lis, true);
    }

    public void addDocumentEventListener(String docEvent, EventListener eListen) throws RTEException {
        if (this.htmlDoc == null) {
            return;
        }
        try {
            this.htmlDoc.addEventListener(docEvent, eListen, true);
            ArrayList<EventListener> listeners = (ArrayList<EventListener>)this.documentEventListeners.remove(docEvent);
            if (listeners == null) {
                listeners = new ArrayList<EventListener>();
            }
            listeners.add(eListen);
            this.documentEventListeners.put(docEvent, listeners);
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg03, (Exception)e);
        }
    }

    public void removeDocumentEventListener(String type, EventListener eListen) throws RTEException {
        if (this.htmlDoc == null) {
            return;
        }
        try {
            this.htmlDoc.removeEventListener(type, eListen, true);
            ArrayList listeners = (ArrayList)this.documentEventListeners.remove(type);
            if (listeners == null) {
                listeners = new ArrayList();
            }
            listeners.remove(eListen);
            this.documentEventListeners.put(type, listeners);
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
    }

    private void removeAllDocEventListenerFromCurrentDoc() throws RTEException {
        String type = "removeAllDocEventListenerFromCurrentDoc";
        if (this.htmlDoc == null) {
            return;
        }
        try {
            Iterator it = this.documentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.documentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.removeEventListener(type, listener, true);
                }
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
    }

    private void addAllDocEventListenerToCurrentDoc() throws RTEException {
        String type = "addAllDocEventListenerToCurrentDoc";
        if (this.htmlDoc == null) {
            return;
        }
        try {
            Iterator it = this.documentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.documentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.addEventListener(type, listener, true);
                }
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
    }

    public void removeAllDocumentEventListener() throws RTEException {
        String type = "removeAllDocumentEventListener";
        if (this.htmlDoc == null) {
            return;
        }
        try {
            Iterator it = this.documentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.documentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.removeEventListener(type, listener, true);
                }
            }
            this.documentEventListeners.clear();
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
    }

    private void addSystemDocumentEventListener(String docEvent, EventListener eListen) throws RTEException {
        if (this.htmlDoc == null) {
            return;
        }
        try {
            this.htmlDoc.addEventListener(docEvent, eListen, true);
            ArrayList<EventListener> listeners = (ArrayList<EventListener>)this.systemDocumentEventListeners.remove(docEvent);
            if (listeners == null) {
                listeners = new ArrayList<EventListener>();
            }
            listeners.add(eListen);
            this.systemDocumentEventListeners.put(docEvent, listeners);
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg03, (Exception)e);
        }
    }

    private void removeAllSystemDocumentEventListener() throws RTEException {
        String type = "removeAllSystemDocumentEventListener";
        if (this.htmlDoc == null) {
            return;
        }
        try {
            Iterator it = this.systemDocumentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.systemDocumentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.removeEventListener(type, listener, true);
                }
            }
            this.systemDocumentEventListeners.clear();
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
    }

    public String queryCommandValue(String commandID) {
        return this.getCommandValue(this.getHtmlDocInstance().queryCommandValue(commandID));
    }

    public boolean queryCommandSupported(String commandID) {
        return this.getHtmlDocInstance().queryCommandSupported(commandID);
    }

    public boolean queryCommandState(String commandID) {
        return this.getHtmlDocInstance().queryCommandState(commandID);
    }

    public boolean queryCommandIndeterm(String commandID) {
        return this.getHtmlDocInstance().queryCommandIndeterm(commandID);
    }

    public boolean queryCommandEnabled(String commandID) {
        return this.getHtmlDocInstance().queryCommandEnabled(commandID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCommandValue(Variant2 value) {
        Variant2 v = value;
        try {
            switch (v.getType()) {
                case 11: {
                    if (v.getBoolean()) {
                        return "true";
                    }
                    return "false";
                }
                case 8: {
                    return v.getString();
                }
                case 2: {
                    return String.valueOf(v.getShort());
                }
                case 3: {
                    return String.valueOf(v.getInt());
                }
                case 4: {
                    return String.valueOf(v.getFloat());
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setToolBarBackColor(String color) {
        if (this._toolPalette != null) {
            try {
                if (color.length() != 7) {
                    return;
                }
                color = color.substring(1, 7);
                int icolor = Integer.parseInt(color, 16);
                RGB rgb = new RGB((icolor & 0xFF0000) >> 16, (icolor & 0xFF00) >> 8, icolor & 0xFF);
                Color c = new Color((Device)Display.getCurrent(), rgb);
                this._toolPalette.setBarBackGround(c);
                ((Composite)this._toolPalette).setBackground(c);
                this.dirty = true;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public boolean isBackgroundSpellcheckingEnabled() {
        return this.enableBackgroundSpellchecking;
    }

    public void addNavigationListener(NavigationEventListener navigationListener) {
        this.navigationListeners.add(navigationListener);
    }

    public void removeNavigationListener(NavigationEventListener navigationListener) {
        this.navigationListeners.remove(navigationListener);
    }

    private void fireNavigationEvent(NavigationEvent e) {
        int i = 0;
        while (i < this.navigationListeners.size()) {
            ((NavigationEventListener)this.navigationListeners.get(i)).navigate(e);
            ++i;
        }
    }

    public void lockToolBar(boolean locked) {
        if (this._toolPalette != null) {
            this._toolPalette.setLocked(locked);
        }
    }

    public boolean isToolBarLocked() {
        if (this._toolPalette != null) {
            return this._toolPalette.getLocked();
        }
        return false;
    }

    static /* synthetic */ String access$5(RichTextEditor richTextEditor, Node node) {
        return richTextEditor.getNodeContainedText(node);
    }

    static /* synthetic */ ArrayList access$6(RichTextEditor richTextEditor) {
        return richTextEditor.BackgroundSpellchecking_Ignore_Words;
    }

    static /* synthetic */ void access$7(RichTextEditor richTextEditor, String string) {
        richTextEditor.ignoreAll(string);
    }

    static /* synthetic */ Map access$8(RichTextEditor richTextEditor) {
        return richTextEditor.BackgroundSpellchecking_Auto_Correct;
    }

    static /* synthetic */ void access$9(RichTextEditor richTextEditor, String string, String string2) {
        richTextEditor.autoCorrect(string, string2);
    }

    private class SearchDialog
    extends Dialog {
        private static final int FIND_NONE = 0;
        private static final int FIND_MATCHCASE = -4;
        private static final int FIND_MATCHENTIREWORD = -6;
        private static final int FIND_MATCHCASE_ENTIREWORD = -2;
        private static final int FIND_FORWARD = 1;
        private static final int FIND_BACKWARD = -1;
        private Text textFind;
        private Button chkMatchCase;
        private Button chkEntireWord;
        private Button btFind;
        private String strSearch;
        private boolean isMatchCase;
        private boolean isWrap;
        private boolean isBackwards;
        private boolean isEntireWord;
        private Shell shell;
        private Display display = this.getParent().getDisplay();
        private boolean isFirst = true;
        private JHTMLTxtRange firstRange = null;
        private JHTMLTxtRange currentRange = null;
        private JHTMLTxtRange currPos = null;

        public SearchDialog(Shell parent) {
            super(parent);
            this.shell = new Shell(this.getParent(), 2144);
        }

        public void open() {
            this.shell.setText(RTENLS.rteFindReplace_FindDialog);
            this.shell.setSize(390, 170);
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 390) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 180) / 2);
            Label label = new Label((Composite)this.shell, 0);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 20);
            formData.bottom = new FormAttachment(0, 45);
            formData.right = new FormAttachment(0, 160);
            formData.left = new FormAttachment(0, 20);
            label.setLayoutData((Object)formData);
            label.setText(RTENLS.rteFindReplace_SearchForValue);
            this.textFind = new Text((Composite)this.shell, 2052);
            FormData formData_1 = new FormData();
            formData_1.top = new FormAttachment((Control)label, -5, 128);
            formData_1.bottom = new FormAttachment((Control)label, -5, 1024);
            formData_1.right = new FormAttachment((Control)label, 205, 131072);
            formData_1.left = new FormAttachment((Control)label, 0, 131072);
            this.textFind.setLayoutData((Object)formData_1);
            this.textFind.setToolTipText(RTENLS.rteFindReplace_StrToSearch);
            this.textFind.setFocus();
            this.textFind.addModifyListener(new ModifyListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void modifyText(ModifyEvent e) {
                    if ("".equals(SearchDialog.access$0(this.this$1).getText())) {
                        SearchDialog.access$1(this.this$1).setEnabled(false);
                    } else {
                        SearchDialog.access$1(this.this$1).setEnabled(true);
                    }
                }
            });
            this.textFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    SearchDialog.access$2(this.this$1);
                }
            });
            this.chkMatchCase = new Button((Composite)this.shell, 50);
            FormData formData_2 = new FormData();
            formData_2.top = new FormAttachment((Control)label, 5, 1024);
            formData_2.bottom = new FormAttachment((Control)label, 25, 1024);
            formData_2.right = new FormAttachment((Control)label, 0, 131072);
            formData_2.left = new FormAttachment((Control)label, 0, 16384);
            this.chkMatchCase.setLayoutData((Object)formData_2);
            this.chkMatchCase.setText(RTENLS.rteFindReplace_Matchcase);
            this.chkEntireWord = new Button((Composite)this.shell, 50);
            FormData formData_4 = new FormData();
            formData_4.top = new FormAttachment((Control)label, 30, 1024);
            formData_4.bottom = new FormAttachment((Control)label, 50, 1024);
            formData_4.right = new FormAttachment((Control)label, 0, 131072);
            formData_4.left = new FormAttachment((Control)label, 0, 16384);
            this.chkEntireWord.setLayoutData((Object)formData_4);
            this.chkEntireWord.setText(RTENLS.rteFindReplace_Matchentireword);
            Label lDirection = new Label((Composite)this.shell, 0);
            FormData formData_3 = new FormData();
            formData_3.top = new FormAttachment((Control)label, 8, 1024);
            formData_3.bottom = new FormAttachment((Control)label, 28, 1024);
            formData_3.right = new FormAttachment((Control)label, 140, 131072);
            formData_3.left = new FormAttachment((Control)label, 0, 131072);
            lDirection.setLayoutData((Object)formData_3);
            lDirection.setText(RTENLS.rteFindReplace_Directions);
            Combo cbDirection = new Combo((Composite)this.shell, 2074);
            FormData formData_5 = new FormData();
            formData_5.top = new FormAttachment((Control)label, 30, 1024);
            formData_5.bottom = new FormAttachment((Control)label, 50, 1024);
            formData_5.right = new FormAttachment((Control)label, 100, 131072);
            formData_5.left = new FormAttachment((Control)label, 0, 131072);
            cbDirection.setLayoutData((Object)formData_5);
            String[] itemDirections = new String[]{RTENLS.rteFindReplace_SearchDown, RTENLS.rteFindReplace_SearchUp, RTENLS.rteFindReplace_SearchAll};
            cbDirection.setItems(itemDirections);
            cbDirection.select(0);
            cbDirection.addSelectionListener(new SelectionListener(this, cbDirection){
                final /* synthetic */ SearchDialog this$1;
                private final /* synthetic */ Combo val$cbDirection;
                {
                    this.this$1 = searchDialog;
                    this.val$cbDirection = combo;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.val$cbDirection.getSelectionIndex() == 0) {
                        SearchDialog.access$3(this.this$1, false);
                        SearchDialog.access$4(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 1) {
                        SearchDialog.access$3(this.this$1, true);
                        SearchDialog.access$4(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 2) {
                        SearchDialog.access$4(this.this$1, true);
                        SearchDialog.access$3(this.this$1, false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.btFind = new Button((Composite)this.shell, 0);
            FormData formData_6 = new FormData();
            formData_6.top = new FormAttachment((Control)label, 60, 1024);
            formData_6.bottom = new FormAttachment((Control)label, 80, 1024);
            formData_6.right = new FormAttachment((Control)label, 100, 131072);
            formData_6.left = new FormAttachment((Control)label, 0, 131072);
            this.btFind.setLayoutData((Object)formData_6);
            this.btFind.setText(RTENLS.rteFindReplace_Find);
            this.btFind.setEnabled(false);
            this.btFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    SearchDialog.access$2(this.this$1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button btCancel = new Button((Composite)this.shell, 0);
            FormData formData_7 = new FormData();
            formData_7.top = new FormAttachment((Control)label, 60, 1024);
            formData_7.bottom = new FormAttachment((Control)label, 80, 1024);
            formData_7.right = new FormAttachment((Control)label, 205, 131072);
            formData_7.left = new FormAttachment((Control)label, 120, 131072);
            btCancel.setLayoutData((Object)formData_7);
            btCancel.setText(RTENLS.rteFindReplace_Cancel);
            btCancel.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.close();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.shell.layout();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }

        public void close() {
            this.shell.dispose();
            if (!this.display.readAndDispatch()) {
                this.display.sleep();
            }
        }

        private void beginFind() {
            if (!this.FindNext()) {
                this.WarningDialog();
            }
            this.textFind.setFocus();
        }

        private void WarningDialog() {
            Shell msgShell = new Shell(this.shell, 67680);
            msgShell.setText(RTENLS.rteFindReplace_AlertTitle);
            msgShell.setSize(220, 110);
            msgShell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 220) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 110) / 2);
            msgShell.open();
            Image img = Display.getCurrent().getSystemImage(8);
            img.setBackground(msgShell.getBackground());
            Label msgIcon = new Label((Composite)msgShell, 0);
            msgIcon.setAlignment(0x1000000);
            msgIcon.setImage(img);
            msgIcon.setBounds(10, 10, img.getBounds().width, 10 + img.getBounds().height);
            Label msgString = new Label((Composite)msgShell, 0);
            msgString.setBounds(50, 21, 156, 24);
            msgString.setAlignment(0x1000000);
            msgString.setText(RTENLS.rteFindReplace_StrNotFound);
            Button button = new Button((Composite)msgShell, 0);
            button.setBounds(80, 49, 66, 22);
            button.setText(RTENLS.rteFindReplace_OK);
            button.setFocus();
            button.addSelectionListener(new SelectionListener(this, msgShell){
                final /* synthetic */ SearchDialog this$1;
                private final /* synthetic */ Shell val$msgShell;
                {
                    this.this$1 = searchDialog;
                    this.val$msgShell = shell;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    SearchDialog.access$5(this.this$1).collapse(false);
                    SearchDialog.access$5(this.this$1).select();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    SearchDialog.access$5(this.this$1).collapse(false);
                    SearchDialog.access$5(this.this$1).select();
                }
            });
            msgShell.layout();
        }

        public String getSearchValue() {
            return this.strSearch;
        }

        public boolean isMatchCase() {
            return this.isMatchCase;
        }

        public boolean isWrap() {
            return this.isWrap;
        }

        public boolean isBackwards() {
            return this.isBackwards;
        }

        public boolean isEntireWord() {
            return this.isEntireWord;
        }

        public boolean FindNext() {
            int movTxtLength;
            int movCharLength;
            int direction;
            this.strSearch = this.textFind.getText();
            this.isMatchCase = this.chkMatchCase.getSelection();
            this.isEntireWord = this.chkEntireWord.getSelection();
            this.currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
            int flag = this.isEntireWord ? (this.isMatchCase ? -2 : -6) : (this.isMatchCase ? -4 : 0);
            if (this.isBackwards) {
                direction = -1;
                movCharLength = 0;
                movTxtLength = 1;
            } else {
                direction = 1;
                movCharLength = this.strSearch.length();
                movTxtLength = -1;
            }
            if (this.currPos.getText() != null) {
                this.currPos.move("character", movCharLength);
            }
            if (this.isWrap) {
                if (this.isFirst) {
                    this.currPos.collapse(false);
                    this.currPos.select();
                }
                this.currentRange = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
                this.findFirstRange(flag);
                if (this.firstRange != null && this.currentRange.isEqual(this.firstRange)) {
                    this.isFirst = true;
                    return false;
                }
                if (this.currPos.findText(this.strSearch, 1, flag)) {
                    this.currPos.select();
                    return true;
                }
                this.currPos.move("textedit", movTxtLength);
                if (this.currPos.findText(this.strSearch, 1, flag)) {
                    this.currPos.select();
                    return true;
                }
                return false;
            }
            if (this.currPos.findText(this.strSearch, direction, flag)) {
                this.currPos.select();
                return true;
            }
            return false;
        }

        private void findFirstRange(int flag) {
            JHTMLTxtRange bakRange = this.currPos.duplicate();
            if (this.isFirst) {
                JHTMLTxtRange tempRange = bakRange.duplicate();
                tempRange.moveStart("character", -1);
                String txt = tempRange.getText();
                if (txt != null && !" ".equals(txt)) {
                    tempRange.moveStart("character", 1);
                    tempRange.moveEnd("character", 1);
                    txt = tempRange.getText();
                    if (txt != null && !" ".equals(txt)) {
                        bakRange.move("word", 1);
                    }
                }
                boolean findBefore = false;
                findBefore = bakRange.findText(this.strSearch, -1, flag);
                if (!findBefore) {
                    bakRange.move("textedit", 1);
                    findBefore = bakRange.findText(this.strSearch, -1, flag);
                }
                if (findBefore) {
                    bakRange.select();
                    this.firstRange = bakRange;
                    this.isFirst = false;
                }
            }
        }

        static /* synthetic */ Text access$0(SearchDialog searchDialog) {
            return searchDialog.textFind;
        }

        static /* synthetic */ Button access$1(SearchDialog searchDialog) {
            return searchDialog.btFind;
        }

        static /* synthetic */ void access$2(SearchDialog searchDialog) {
            searchDialog.beginFind();
        }

        static /* synthetic */ void access$3(SearchDialog searchDialog, boolean bl) {
            searchDialog.isBackwards = bl;
        }

        static /* synthetic */ void access$4(SearchDialog searchDialog, boolean bl) {
            searchDialog.isWrap = bl;
        }

        static /* synthetic */ JHTMLTxtRange access$5(SearchDialog searchDialog) {
            return searchDialog.currPos;
        }
    }

    private class SearchReplaceDialog
    extends Dialog {
        private static final int FIND_NONE = 0;
        private static final int FIND_MATCHCASE = -4;
        private static final int FIND_MATCHENTIREWORD = -6;
        private static final int FIND_MATCHCASE_ENTIREWORD = -2;
        private static final int FIND_FORWARD = 1;
        private static final int FIND_BACKWARD = -1;
        private Text textFind;
        private Text textReplace;
        private Button chkMatchCase;
        private Button chkEntireWord;
        private Button btReplaceAll;
        private Button btReplace;
        private Button btFind;
        private String strSearch;
        private String strReplace;
        private boolean isMatchCase;
        private boolean isWrap;
        private boolean isBackwards;
        private boolean isEntireWord;
        private Shell shell;
        private Display display = this.getParent().getDisplay();
        private boolean isFirst = true;
        private JHTMLTxtRange firstRange = null;
        private JHTMLTxtRange currentRange = null;
        private JHTMLTxtRange currPos = null;

        public SearchReplaceDialog(Shell parent) {
            super(parent);
            this.shell = new Shell(this.getParent(), 2144);
        }

        private void setReplaceBtnStatus(Control control) {
            control.addFocusListener(new FocusListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void focusGained(FocusEvent e) {
                    if (SearchReplaceDialog.access$7((SearchReplaceDialog)this.this$1).htmlDoc.getSelection().createRange().getTxtRange().getText() == null) {
                        SearchReplaceDialog.access$0(this.this$1).setEnabled(false);
                        SearchReplaceDialog.access$1(this.this$1).setEnabled(false);
                    } else {
                        SearchReplaceDialog.access$0(this.this$1).setEnabled(true);
                        SearchReplaceDialog.access$1(this.this$1).setEnabled(true);
                    }
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }

        public void open() {
            this.shell.setText(RTENLS.rteFindReplace_FindReplaceDialog);
            this.shell.setSize(410, 210);
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 410) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 200) / 2);
            Label label = new Label((Composite)this.shell, 0);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 20);
            formData.bottom = new FormAttachment(0, 45);
            formData.right = new FormAttachment(0, 180);
            formData.left = new FormAttachment(0, 20);
            label.setLayoutData((Object)formData);
            label.setText(RTENLS.rteFindReplace_SearchForValue);
            this.textFind = new Text((Composite)this.shell, 2052);
            FormData formData_1 = new FormData();
            formData_1.top = new FormAttachment((Control)label, -5, 128);
            formData_1.bottom = new FormAttachment((Control)label, 20, 128);
            formData_1.right = new FormAttachment((Control)label, 205, 131072);
            formData_1.left = new FormAttachment((Control)label, 10, 131072);
            this.textFind.setLayoutData((Object)formData_1);
            this.textFind.setToolTipText(RTENLS.rteFindReplace_StrToSearch);
            this.textFind.setFocus();
            this.setReplaceBtnStatus((Control)this.textFind);
            this.textFind.addModifyListener(new ModifyListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void modifyText(ModifyEvent e) {
                    if ("".equals(SearchReplaceDialog.access$2(this.this$1).getText())) {
                        SearchReplaceDialog.access$3(this.this$1).setEnabled(false);
                    } else {
                        SearchReplaceDialog.access$3(this.this$1).setEnabled(true);
                    }
                }
            });
            this.textFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.beginFind();
                }
            });
            Label label_r = new Label((Composite)this.shell, 0);
            FormData formData_r = new FormData();
            formData_r.top = new FormAttachment((Control)label, 10, 1024);
            formData_r.bottom = new FormAttachment((Control)label, 30, 1024);
            formData_r.right = new FormAttachment((Control)label, 0, 131072);
            formData_r.left = new FormAttachment((Control)label, 0, 16384);
            label_r.setLayoutData((Object)formData_r);
            label_r.setText(RTENLS.rteFindReplace_ReplaceForValue);
            this.textReplace = new Text((Composite)this.shell, 2052);
            FormData formData_R = new FormData();
            formData_R.top = new FormAttachment((Control)label, 5, 1024);
            formData_R.bottom = new FormAttachment((Control)label, 30, 1024);
            formData_R.right = new FormAttachment((Control)label, 205, 131072);
            formData_R.left = new FormAttachment((Control)label, 10, 131072);
            this.textReplace.setLayoutData((Object)formData_R);
            this.textReplace.setToolTipText(RTENLS.rteFindReplace_StrToReplace);
            this.setReplaceBtnStatus((Control)this.textReplace);
            this.chkMatchCase = new Button((Composite)this.shell, 50);
            FormData formData_2 = new FormData();
            formData_2.top = new FormAttachment((Control)label, 40, 1024);
            formData_2.bottom = new FormAttachment((Control)label, 60, 1024);
            formData_2.right = new FormAttachment((Control)label, 0, 131072);
            formData_2.left = new FormAttachment((Control)label, 0, 16384);
            this.chkMatchCase.setLayoutData((Object)formData_2);
            this.chkMatchCase.setText(RTENLS.rteFindReplace_Matchcase);
            this.setReplaceBtnStatus((Control)this.chkMatchCase);
            this.chkEntireWord = new Button((Composite)this.shell, 50);
            FormData formData_4 = new FormData();
            formData_4.top = new FormAttachment((Control)label, 65, 1024);
            formData_4.bottom = new FormAttachment((Control)label, 85, 1024);
            formData_4.right = new FormAttachment((Control)label, 0, 131072);
            formData_4.left = new FormAttachment((Control)label, 0, 16384);
            this.chkEntireWord.setLayoutData((Object)formData_4);
            this.chkEntireWord.setText(RTENLS.rteFindReplace_Matchentireword);
            this.setReplaceBtnStatus((Control)this.chkEntireWord);
            Label lDirection = new Label((Composite)this.shell, 0);
            FormData formData_3 = new FormData();
            formData_3.top = new FormAttachment((Control)label, 43, 1024);
            formData_3.bottom = new FormAttachment((Control)label, 63, 1024);
            formData_3.right = new FormAttachment((Control)label, 100, 131072);
            formData_3.left = new FormAttachment((Control)label, 10, 131072);
            lDirection.setLayoutData((Object)formData_3);
            lDirection.setText(RTENLS.rteFindReplace_Directions);
            Combo cbDirection = new Combo((Composite)this.shell, 2074);
            FormData formData_5 = new FormData();
            formData_5.top = new FormAttachment((Control)label, 65, 1024);
            formData_5.bottom = new FormAttachment((Control)label, 85, 1024);
            formData_5.right = new FormAttachment((Control)label, 100, 131072);
            formData_5.left = new FormAttachment((Control)label, 10, 131072);
            cbDirection.setLayoutData((Object)formData_5);
            String[] itemDirections = new String[]{RTENLS.rteFindReplace_SearchDown, RTENLS.rteFindReplace_SearchUp, RTENLS.rteFindReplace_SearchAll};
            cbDirection.setItems(itemDirections);
            cbDirection.select(0);
            this.setReplaceBtnStatus((Control)cbDirection);
            cbDirection.addSelectionListener(new SelectionListener(this, cbDirection){
                final /* synthetic */ SearchReplaceDialog this$1;
                private final /* synthetic */ Combo val$cbDirection;
                {
                    this.this$1 = searchReplaceDialog;
                    this.val$cbDirection = combo;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.val$cbDirection.getSelectionIndex() == 0) {
                        SearchReplaceDialog.access$4(this.this$1, false);
                        SearchReplaceDialog.access$5(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 1) {
                        SearchReplaceDialog.access$4(this.this$1, true);
                        SearchReplaceDialog.access$5(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 2) {
                        SearchReplaceDialog.access$5(this.this$1, true);
                        SearchReplaceDialog.access$4(this.this$1, false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.btReplace = new Button((Composite)this.shell, 0);
            FormData formData_RB = new FormData();
            formData_RB.top = new FormAttachment((Control)label, 100, 1024);
            formData_RB.bottom = new FormAttachment((Control)label, 120, 1024);
            formData_RB.right = new FormAttachment((Control)label, 75, 16384);
            formData_RB.left = new FormAttachment((Control)label, 0, 16384);
            this.btReplace.setLayoutData((Object)formData_RB);
            this.btReplace.setEnabled(false);
            this.btReplace.setText(RTENLS.rteFindReplace_Replace);
            this.setReplaceBtnStatus((Control)this.btReplace);
            this.btReplace.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.beginReplace();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btReplaceAll = new Button((Composite)this.shell, 0);
            FormData formData_RA = new FormData();
            formData_RA.top = new FormAttachment((Control)label, 100, 1024);
            formData_RA.bottom = new FormAttachment((Control)label, 120, 1024);
            formData_RA.right = new FormAttachment((Control)label, 175, 16384);
            formData_RA.left = new FormAttachment((Control)label, 90, 16384);
            this.btReplaceAll.setLayoutData((Object)formData_RA);
            this.btReplaceAll.setEnabled(false);
            this.btReplaceAll.setText(RTENLS.rteFindReplace_ReplaceAll);
            this.setReplaceBtnStatus((Control)this.btReplaceAll);
            this.btReplaceAll.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.replaceAll();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btFind = new Button((Composite)this.shell, 0);
            FormData formData_6 = new FormData();
            formData_6.top = new FormAttachment((Control)label, 100, 1024);
            formData_6.bottom = new FormAttachment((Control)label, 120, 1024);
            formData_6.right = new FormAttachment((Control)label, 110, 131072);
            formData_6.left = new FormAttachment((Control)label, 35, 131072);
            this.btFind.setLayoutData((Object)formData_6);
            this.btFind.setEnabled(false);
            this.btFind.setText(RTENLS.rteFindReplace_FindNext);
            this.btFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.beginFind();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button btCancel = new Button((Composite)this.shell, 0);
            FormData formData_7 = new FormData();
            formData_7.top = new FormAttachment((Control)label, 100, 1024);
            formData_7.bottom = new FormAttachment((Control)label, 120, 1024);
            formData_7.right = new FormAttachment((Control)label, 200, 131072);
            formData_7.left = new FormAttachment((Control)label, 125, 131072);
            btCancel.setLayoutData((Object)formData_7);
            btCancel.setText(RTENLS.rteFindReplace_Cancel);
            btCancel.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.close();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.shell.layout();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }

        private void WarningDialog(String message) {
            Shell msgShell = new Shell(this.shell, 67680);
            msgShell.setText(RTENLS.rteFindReplace_AlertTitle);
            msgShell.setSize(220, 110);
            msgShell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 220) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 110) / 2);
            msgShell.open();
            Image img = Display.getCurrent().getSystemImage(8);
            img.setBackground(msgShell.getBackground());
            Label msgIcon = new Label((Composite)msgShell, 0);
            msgIcon.setAlignment(0x1000000);
            msgIcon.setImage(img);
            msgIcon.setBounds(10, 10, img.getBounds().width, 10 + img.getBounds().height);
            Label msgString = new Label((Composite)msgShell, 0);
            msgString.setBounds(50, 21, 156, 24);
            msgString.setAlignment(0x1000000);
            msgString.setText(message);
            Button button = new Button((Composite)msgShell, 0);
            button.setBounds(80, 49, 66, 22);
            button.setText(RTENLS.rteFindReplace_OK);
            button.setFocus();
            button.addSelectionListener(new SelectionListener(this, msgShell){
                final /* synthetic */ SearchReplaceDialog this$1;
                private final /* synthetic */ Shell val$msgShell;
                {
                    this.this$1 = searchReplaceDialog;
                    this.val$msgShell = shell;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    SearchReplaceDialog.access$6(this.this$1).collapse(false);
                    SearchReplaceDialog.access$6(this.this$1).select();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    SearchReplaceDialog.access$6(this.this$1).collapse(false);
                    SearchReplaceDialog.access$6(this.this$1).select();
                }
            });
            msgShell.layout();
        }

        public void close() {
            this.shell.dispose();
            if (!this.display.readAndDispatch()) {
                this.display.sleep();
            }
        }

        public void beginFind() {
            if (!this.FindNext()) {
                this.showWarningDialog(RTENLS.rteFindReplace_StrNotFound);
            } else {
                if (!this.btReplace.isEnabled()) {
                    this.btReplace.setEnabled(true);
                }
                if (!this.btReplaceAll.isEnabled()) {
                    this.btReplaceAll.setEnabled(true);
                }
            }
            this.textFind.setFocus();
        }

        public void beginReplace() {
            this.strSearch = this.textFind.getText();
            this.strReplace = this.textReplace.getText();
            this.currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
            if (this.currPos.getText() == null) {
                return;
            }
            this.currPos.pasteHTML(this.strReplace);
            RichTextEditor.this.dirty = true;
            if (this.isBackwards) {
                if (!this.upReplaceFindNext()) {
                    this.showWarningDialog(RTENLS.rteFindReplace_StrNotFound);
                }
            } else if (!this.FindNext()) {
                this.showWarningDialog(RTENLS.rteFindReplace_StrNotFound);
            }
            this.textFind.setFocus();
        }

        /*
         * Unable to fully structure code
         */
        public void replaceAll() {
            block3: {
                this.strSearch = this.textFind.getText();
                this.strReplace = this.textReplace.getText();
                currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
                if (currPos.getText() == null) {
                    return;
                }
                currPos.pasteHTML(this.strReplace);
                if (!this.isBackwards) ** GOTO lbl15
                while (this.upReplaceFindNext()) {
                    currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
                    currPos.pasteHTML(this.strReplace);
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
                    currPos.pasteHTML(this.strReplace);
lbl15:
                    // 2 sources

                    ** while (this.FindNext())
                }
            }
            this.textFind.setFocus();
            RichTextEditor.access$0(RichTextEditor.this, true);
            this.showWarningDialog(RTENLS.rteFindReplace_ReplaceAllFinished);
        }

        private boolean upReplaceFindNext() {
            JHTMLTxtRange currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
            currPos.move("character", -this.strReplace.length());
            if (currPos.findText(this.strSearch, -1, this.getWordMatchFlags())) {
                currPos.select();
                return true;
            }
            return false;
        }

        private void showWarningDialog(String keyMessage) {
            this.WarningDialog(keyMessage);
            if (this.isWrap()) {
                this.isFirst = true;
            }
        }

        public String getSearchValue() {
            return this.strSearch;
        }

        public boolean isMatchCase() {
            return this.isMatchCase;
        }

        public boolean isWrap() {
            return this.isWrap;
        }

        public boolean isBackwards() {
            return this.isBackwards;
        }

        public boolean isEntireWord() {
            return this.isEntireWord;
        }

        private void getParameterFromUI() {
            this.strSearch = this.textFind.getText();
            this.strReplace = this.textReplace.getText();
            this.isMatchCase = this.chkMatchCase.getSelection();
            this.isEntireWord = this.chkEntireWord.getSelection();
        }

        private int getWordMatchFlags() {
            int imatchFlag = this.isEntireWord ? (this.isMatchCase ? -2 : -6) : (this.isMatchCase ? -4 : 0);
            return imatchFlag;
        }

        private void findFirstRange(int flag) {
            JHTMLTxtRange bakRange = this.currPos.duplicate();
            if (this.isFirst) {
                JHTMLTxtRange tempRange = bakRange.duplicate();
                tempRange.moveStart("character", -1);
                String txt = tempRange.getText();
                if (txt != null && !" ".equals(txt)) {
                    tempRange.moveStart("character", 1);
                    tempRange.moveEnd("character", 1);
                    txt = tempRange.getText();
                    if (txt != null && !" ".equals(txt)) {
                        bakRange.move("word", 1);
                    }
                }
                boolean findBefore = false;
                findBefore = bakRange.findText(this.strSearch, -1, flag);
                if (!findBefore) {
                    bakRange.move("textedit", 1);
                    findBefore = bakRange.findText(this.strSearch, -1, flag);
                }
                if (findBefore) {
                    bakRange.select();
                    this.firstRange = bakRange;
                    this.isFirst = false;
                }
            }
        }

        private boolean doWrapSearch(JHTMLTxtRange currPos, int matchFlag) {
            int movTxtLength = -1;
            if (this.isFirst) {
                currPos.collapse(false);
                currPos.select();
            }
            this.currentRange = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
            this.findFirstRange(matchFlag);
            if (this.firstRange != null && this.currentRange.isEqual(this.firstRange)) {
                this.isFirst = true;
                return false;
            }
            if (currPos.findText(this.strSearch, 1, matchFlag)) {
                currPos.select();
                return true;
            }
            currPos.move("textedit", movTxtLength);
            if (currPos.findText(this.strSearch, 1, matchFlag)) {
                currPos.select();
                return true;
            }
            return false;
        }

        public boolean FindNext() {
            int movCharLength;
            int direction;
            this.getParameterFromUI();
            int matchFlag = this.getWordMatchFlags();
            if (this.isBackwards) {
                direction = -1;
                movCharLength = 0;
            } else {
                direction = 1;
                movCharLength = this.strSearch.length();
            }
            this.currPos = RichTextEditor.this.htmlDoc.getSelection().createRange().getTxtRange();
            if (this.currPos.getText() != null) {
                this.currPos.move("character", movCharLength);
            }
            if (this.isWrap) {
                return this.doWrapSearch(this.currPos, matchFlag);
            }
            if (this.currPos.findText(this.strSearch, direction, matchFlag)) {
                this.currPos.select();
                return true;
            }
            return false;
        }

        static /* synthetic */ Button access$0(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.btReplace;
        }

        static /* synthetic */ Button access$1(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.btReplaceAll;
        }

        static /* synthetic */ Text access$2(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.textFind;
        }

        static /* synthetic */ Button access$3(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.btFind;
        }

        static /* synthetic */ void access$4(SearchReplaceDialog searchReplaceDialog, boolean bl) {
            searchReplaceDialog.isBackwards = bl;
        }

        static /* synthetic */ void access$5(SearchReplaceDialog searchReplaceDialog, boolean bl) {
            searchReplaceDialog.isWrap = bl;
        }

        static /* synthetic */ JHTMLTxtRange access$6(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.currPos;
        }

        static /* synthetic */ RichTextEditor access$7(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.RichTextEditor.this;
        }
    }

    private class ColumnInfo {
        private Node currentRow;
        int currentCellIndex;

        public ColumnInfo(Node row, int idx) {
            this.currentRow = row;
            this.currentCellIndex = idx;
        }

        public int getCurrentCellIndex() {
            return this.currentCellIndex;
        }

        public Node getCurrentRow() {
            return this.currentRow;
        }
    }

    private class DefaultRTEEventListener
    implements EventListener {
        private DefaultRTEEventListener() {
        }

        public void handleEvent(Event evt) {
            Node curNode = RichTextEditor.this.getCursorPositionNode();
            if (((JHTMLElement)curNode).getAttribute("IGNORED") != null && "1".equals(((JHTMLElement)curNode).getAttribute("IGNORED"))) {
                return;
            }
            if (((JHTMLElement)curNode).getAttribute("MISSPELLED") != null && "1".equals(((JHTMLElement)curNode).getAttribute("MISSPELLED"))) {
                MenuItem menuItem;
                Menu menu = new Menu((Control)RichTextEditor.this.webBrowser.getShell());
                String allSuggestions = ((JHTMLElement)curNode).getAttribute("SUGGESTIONS");
                String[] suggestions = allSuggestions == null || "".equals(allSuggestions) ? new String[]{RichTextEditor.this.MISSPELLING_NO_SUGGESTIONS} : RichTextEditor.this.split(allSuggestions, "/");
                int i = 0;
                while (i < suggestions.length) {
                    String suggestion = suggestions[i];
                    menuItem = new MenuItem(menu, 0);
                    menuItem.setText(suggestion);
                    if (suggestion.equalsIgnoreCase(RichTextEditor.this.MISSPELLING_NO_SUGGESTIONS)) {
                        menuItem.setEnabled(false);
                    }
                    menuItem.addSelectionListener(new SelectionListener(this, suggestion){
                        final /* synthetic */ DefaultRTEEventListener this$1;
                        private final /* synthetic */ String val$suggestion;
                        {
                            this.this$1 = defaultRTEEventListener;
                            this.val$suggestion = string;
                        }

                        public void widgetSelected(SelectionEvent event) {
                            Node curNode = RichTextEditor.access$1(DefaultRTEEventListener.access$1(this.this$1));
                            RichTextEditor.access$4(DefaultRTEEventListener.access$1(this.this$1), curNode, 4, this.val$suggestion);
                        }

                        public void widgetDefaultSelected(SelectionEvent event) {
                        }
                    });
                    ++i;
                }
                menuItem = new MenuItem(menu, 2);
                menuItem = new MenuItem(menu, 0);
                menuItem.setText(RTENLS.rteBgSpellChecker_Ignore);
                menuItem.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DefaultRTEEventListener this$1;
                    {
                        this.this$1 = defaultRTEEventListener;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        Node curNode = RichTextEditor.access$1(DefaultRTEEventListener.access$1(this.this$1));
                        RichTextEditor.access$4(DefaultRTEEventListener.access$1(this.this$1), curNode, 2, "Ignore");
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                menuItem = new MenuItem(menu, 0);
                menuItem.setText(RTENLS.rteBgSpellChecker_IgnoreAll);
                menuItem.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DefaultRTEEventListener this$1;
                    {
                        this.this$1 = defaultRTEEventListener;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        Node curNode = RichTextEditor.access$1(DefaultRTEEventListener.access$1(this.this$1));
                        String nodeValue = RichTextEditor.access$5(DefaultRTEEventListener.access$1(this.this$1), curNode);
                        RichTextEditor.access$6(DefaultRTEEventListener.access$1(this.this$1)).add(nodeValue);
                        RichTextEditor.access$4(DefaultRTEEventListener.access$1(this.this$1), curNode, 2, null);
                        RichTextEditor.access$7(DefaultRTEEventListener.access$1(this.this$1), nodeValue);
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                menuItem = new MenuItem(menu, 2);
                menuItem = new MenuItem(menu, 64);
                menuItem.setText(RTENLS.rteBgSpellChecker_AutoCorrect);
                Menu autoCorrectMenu = new Menu((Decorations)RichTextEditor.this.webBrowser.getShell(), 4);
                int i2 = 0;
                while (i2 < suggestions.length) {
                    String suggestion = suggestions[i2];
                    MenuItem autoCorectMenuItem = new MenuItem(autoCorrectMenu, 0);
                    autoCorectMenuItem.setText(suggestion);
                    if (suggestion.equalsIgnoreCase(RichTextEditor.this.MISSPELLING_NO_SUGGESTIONS)) {
                        autoCorectMenuItem.setEnabled(false);
                    }
                    autoCorectMenuItem.addSelectionListener(new SelectionListener(this, suggestion){
                        final /* synthetic */ DefaultRTEEventListener this$1;
                        private final /* synthetic */ String val$suggestion;
                        {
                            this.this$1 = defaultRTEEventListener;
                            this.val$suggestion = string;
                        }

                        public void widgetSelected(SelectionEvent event) {
                            Node curNode = RichTextEditor.access$1(DefaultRTEEventListener.access$1(this.this$1));
                            String nodeValue = RichTextEditor.access$5(DefaultRTEEventListener.access$1(this.this$1), curNode);
                            RichTextEditor.access$8(DefaultRTEEventListener.access$1(this.this$1)).put(nodeValue, this.val$suggestion);
                            RichTextEditor.access$4(DefaultRTEEventListener.access$1(this.this$1), curNode, 4, this.val$suggestion);
                            RichTextEditor.access$9(DefaultRTEEventListener.access$1(this.this$1), nodeValue, this.val$suggestion);
                        }

                        public void widgetDefaultSelected(SelectionEvent event) {
                        }
                    });
                    ++i2;
                }
                menuItem.setMenu(autoCorrectMenu);
                menu.setVisible(true);
                evt.stopPropagation();
                evt.preventDefault();
            }
        }

        static /* synthetic */ RichTextEditor access$1(DefaultRTEEventListener defaultRTEEventListener) {
            return defaultRTEEventListener.RichTextEditor.this;
        }
    }
}

