/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.rte.internal;

import com.ibm.rcp.rte.NavigationEvent;
import com.ibm.rcp.rte.NavigationEventListener;
import com.ibm.rcp.rte.RTEEvent;
import com.ibm.rcp.rte.RTEEventListener;
import com.ibm.rcp.rte.RTEException;
import com.ibm.rcp.rte.internal.RTEExceptionHelper;
import com.ibm.rcp.rte.internal.RTENLS;
import com.ibm.rcp.rte.internal.ToolPalette;
import com.ibm.rcp.rte.internal.ToolPaletteCommon;
import com.ibm.rcp.rte.internal.ToolPaletteEX;
import com.ibm.rcp.rte.internal.spellchecker.RTESpellChecker;
import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.TextAnalyzerFactory;
import com.ibm.rcp.textanalyzer.spellchecker.MisspelledWord;
import com.ibm.rcp.textanalyzer.spellchecker.SpellChecker;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.DOMBrowser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.SecuritySettings;
import org.eclipse.swt.browser.WebBrowserFind;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.browser.mozilla.dom.JDOMException;
import org.eclipse.swt.browser.mozilla.dom.JNode;
import org.eclipse.swt.browser.mozilla.dom.JText;
import org.eclipse.swt.browser.mozilla.dom.events.DOMDragEventListener;
import org.eclipse.swt.browser.mozilla.dom.events.JKeyEvent;
import org.eclipse.swt.browser.mozilla.dom.html.JHTMLBRElement;
import org.eclipse.swt.browser.mozilla.dom.html.JHTMLBodyElement;
import org.eclipse.swt.browser.mozilla.dom.html.JHTMLDocument;
import org.eclipse.swt.browser.mozilla.dom.html.JHTMLElement;
import org.eclipse.swt.browser.mozilla.dom.html.JHTMLParagraphElement;
import org.eclipse.swt.browser.mozilla.dom.html.JHTMLWindow;
import org.eclipse.swt.browser.mozilla.dom.html.JSelection;
import org.eclipse.swt.browser.mozilla.dom.range.JRange;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class RichTextEditor
extends Composite
implements com.ibm.rcp.rte.RichTextEditor {
    public static final int IDM_ATOMICSELECTION = 2399;
    public static final int MSOCMDEXECOPT_DODEFAULT = 0;
    private DOMBrowser webBrowser;
    private ToolPalette _toolPalette;
    private JHTMLDocument htmlDoc;
    private JHTMLElement docElem;
    private JHTMLWindow htmlWin;
    private boolean isReadOnly = false;
    private boolean isPrintPreview = false;
    private HashMap metadata;
    private boolean dirty = false;
    private String localeCode;
    private String oldLocaleCode;
    private ArrayList dragStartListeners = new ArrayList();
    private ArrayList dragOverListeners = new ArrayList();
    private ArrayList dropListeners = new ArrayList();
    private ArrayList cutListeners = new ArrayList();
    private ArrayList pasteListeners = new ArrayList();
    private HashMap documentEventListeners = new HashMap();
    private HashMap systemDocumentEventListeners = new HashMap();
    private boolean preReadOnlyValue = false;
    private ArrayList cursorInfoChangedListeners = new ArrayList();
    private ArrayList navigationListeners = new ArrayList();
    private HashMap textAttribute = new HashMap();
    private HashMap completedListener = new HashMap();
    private static final boolean[] textCommandsType;
    private RTESpellChecker rteSpellChecker;
    private SpellChecker backgroundSpellChecker;
    private boolean duringSetSourceContent = false;
    private boolean enableBackgroundSpellchecking;
    private boolean isUrlSetting = false;
    private boolean isLoadCompleted = false;
    private boolean isRefreshing = false;
    private final int BACKGROUNDSPELLCHECKING_UPDATE = 1;
    private final int BACKGROUNDSPELLCHECKING_CLEAN = 2;
    private final int BACKGROUNDSPELLCHECKING_CLEAN_ALL = 3;
    private final int BACKGROUNDSPELLCHECKING_CORRECT = 4;
    private final int BACKGROUNDSPELLCHECKING_CHECK = 5;
    private ArrayList BackgroundSpellchecking_Ignore_Words = new ArrayList();
    private Map BackgroundSpellchecking_Auto_Correct = new HashMap();
    private final String MISSPELLING_STYLE_RULE = "<style>SPAN.misspelling {border-bottom-style: solid;border-bottom-width: thin;border-bottom-color: red }</style>";
    private final String MISSPELLING_NO_SUGGESTIONS = RTENLS.rteBgSpellChecker_NoSuggestions;
    private final String MISSPELLED_TAG = "MISSPELLED";
    DefaultRTEEventListener misspellContextMenuListener = null;
    public static final int MAX_SUGGESTION_NUM = 5;
    private static final int VK_BACK = 8;
    private static final int VK_PRIOR = 33;
    private static final int VK_NEXT = 34;
    private static final int VK_END = 35;
    private static final int VK_HOME = 36;
    private static final int VK_LEFT = 37;
    private static final int VK_UP = 38;
    private static final int VK_RIGHT = 39;
    private static final int VK_DOWN = 40;
    private static final int VK_DELETE = 46;
    private static final int VK_SPACE = 32;
    private static final int VK_RETURN = 13;
    private static final int VK_TAB = 9;
    private static final int KEY_COMMA = 188;
    private static final int KEY_DOT = 192;
    private static final int KEY_PERIOD = 190;
    private static final int KEY_SLASH = 191;
    private static final int KEY_SEMICOLON = 59;
    private static final int KEY_BACKSLASH = 220;
    private static final int KEY_SINGLEQUOTE = 222;
    private static final int KEY_EQUAL = 61;
    private static final int KEY_RULE = 109;
    private static final int KEY_LEFTBRACKET = 219;
    private static final int KEY_RIGHTBRACKET = 221;
    private String PKG_Name;
    private String CLZ_Name;
    private Logger logger;
    private final Level level;
    private final String ENTRY = "ENTRY";
    private final String RETURN = "RETURN";
    private final String THROW = "THROW";
    private Vector keylisteners;
    static /* synthetic */ Class class$0;

    static {
        boolean[] blArray = new boolean[16];
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        textCommandsType = blArray;
    }

    public RichTextEditor(Composite parent, int compositeStyle, int toolBarStyle, int rteStyle) throws RTEException {
        super(parent, compositeStyle);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.rcp.rte.internal.RichTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.PKG_Name = clazz.getPackage().getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ibm.rcp.rte.internal.RichTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.CLZ_Name = clazz2.getName();
        this.logger = Logger.getLogger(this.PKG_Name);
        this.level = Level.FINEST;
        this.ENTRY = "ENTRY";
        this.RETURN = "RETURN";
        this.THROW = "THROW";
        this.keylisteners = new Vector();
        String method_Name = "RichTextEditor";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.isReadOnly = (rteStyle & 1) == 1;
        this.createControls(compositeStyle, toolBarStyle);
        this.initEvent();
        RTEExceptionHelper.setStatus((short)2);
        this.setUrl("about:blank");
        this.setUrl("about:blank");
        this.localeCode = Platform.getNL();
        this.localeCode = this.localeCode.replace('_', '-');
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void initEvent() {
        String method_Name = "initEvent";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        try {
            this.webBrowser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                }

                public void completed(ProgressEvent event) {
                    String method_Name = "ProgressListener::completed";
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
                    RichTextEditor.this.loadcompleted();
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                }
            });
            this.webBrowser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    String method_Name = "OpenWindowListener::open";
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
                    if (RichTextEditor.this.isReadOnly) {
                        DOMBrowser newWebBrowser = new DOMBrowser((Composite)RichTextEditor.this.webBrowser, 0x2000000);
                        event.browser = newWebBrowser;
                        newWebBrowser.addLocationListener(new LocationListener(this){
                            final /* synthetic */ 21 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void changing(LocationEvent event) {
                                if (RichTextEditor.access$19(21.access$0(this.this$1))) {
                                    if (RichTextEditor.access$20(21.access$0(this.this$1))) {
                                        return;
                                    }
                                    String url = null;
                                    url = event.location;
                                    NavigationEvent navEvent = new NavigationEvent();
                                    navEvent.type = 2;
                                    navEvent.url = url;
                                    RichTextEditor.access$21(21.access$0(this.this$1), navEvent);
                                    event.doit = navEvent.doit;
                                }
                            }

                            public void changed(LocationEvent event) {
                            }
                        });
                    }
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                }

                static /* synthetic */ RichTextEditor access$0(21 var0) {
                    return var0.RichTextEditor.this;
                }
            });
            this.webBrowser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    String method_Name = "LocationListener::changing";
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
                    if (RichTextEditor.this.isUrlSetting) {
                        RichTextEditor.this.isUrlSetting = false;
                        return;
                    }
                    if (RichTextEditor.this.isRefreshing) {
                        RichTextEditor.this.isRefreshing = false;
                        return;
                    }
                    if (RichTextEditor.this.isReadOnly) {
                        if (RichTextEditor.this.duringSetSourceContent) {
                            return;
                        }
                        NavigationEvent navEvent = new NavigationEvent();
                        navEvent.type = 1;
                        navEvent.url = event.location;
                        RichTextEditor.this.fireNavigationEvent(navEvent);
                        event.doit = navEvent.doit;
                    }
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                }

                public void changed(LocationEvent event) {
                }
            });
        }
        catch (NullPointerException e) {
            String defaultMsg = RTENLS.Err_Msg21;
            if (this.webBrowser == null) {
                RTEExceptionHelper.handleRTEFault((String)(String.valueOf(defaultMsg) + RTENLS.Err_Msg22), (Exception)e);
            } else if (this.htmlDoc == null) {
                RTEExceptionHelper.handleRTEFault((String)(String.valueOf(defaultMsg) + RTENLS.Err_Msg23), (Exception)e);
            } else if (this.htmlWin == null) {
                RTEExceptionHelper.handleRTEFault((String)(String.valueOf(defaultMsg) + RTENLS.Err_Msg24), (Exception)e);
            }
        }
        catch (ClassCastException cce) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg25, (Exception)cce);
        }
        catch (Exception ex) {
            RTEExceptionHelper.handleRTEFault((Exception)ex);
        }
    }

    private void createControls(int compositeStyle, int toolBarStyle) {
        String method_Name = "createControls";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        boolean isSWTExStyle = false;
        if (Platform.getBundle((String)"com.ibm.rcp.swtex") != null) {
            isSWTExStyle = true;
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        if (isSWTExStyle) {
            layout.verticalSpacing = 0;
            this.setLayout((Layout)layout);
        } else {
            this.setLayout((Layout)layout);
            this.setBackground(this.getDisplay().getSystemColor(22));
        }
        if ((toolBarStyle & 0x1FFF) != 0) {
            this._toolPalette = isSWTExStyle ? new ToolPaletteEX((Composite)this, 16, toolBarStyle) : new ToolPaletteCommon((Composite)this, 16, toolBarStyle);
            GridData toolPaletteGridData = new GridData(784);
            toolPaletteGridData.horizontalIndent = 0;
            ((Composite)this._toolPalette).setLayoutData((Object)toolPaletteGridData);
            this._toolPalette.setEditAPI((com.ibm.rcp.rte.RichTextEditor)this);
        }
        try {
            this.webBrowser = new DOMBrowser((Composite)this, compositeStyle);
            SecuritySettings settings = this.webBrowser.getSecuritySettings();
            settings.setAllowScript(false);
            settings.setEnablePopups(false);
            settings.setAllowPlugins(false);
            this.enableLocalImageLoad();
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg06, (Exception)e);
        }
        GridData webBrowserGridData = new GridData(1808);
        webBrowserGridData.horizontalIndent = 0;
        this.webBrowser.setLayoutData((Object)webBrowserGridData);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private static void runLoopTimer(Shell shell, final int milliSeconds) {
        final boolean[] exit = new boolean[1];
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(milliSeconds);
                }
                catch (Exception exception) {}
                exit[0] = true;
            }
        }.start();
        Display display = Display.getCurrent();
        while (!exit[0] && !shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void loadcompleted() {
        this.clearListeners();
        this.htmlWin = this.webBrowser.getHTMLWindow();
        this.htmlDoc = (JHTMLDocument)this.webBrowser.getDocument();
        this.setupListeners();
        if (!this.isReadOnly) {
            this.htmlDoc.setDesignMode("on");
        }
        if (this._toolPalette != null) {
            this._toolPalette.setReadOnly(this.isReadOnly);
        }
        if (this._toolPalette != null) {
            this._toolPalette.startUpdateListener();
        }
        if (!this.isReadOnly) {
            this.forceFocus();
        }
        this.isLoadCompleted = true;
    }

    private void clearListeners() {
        String method_Name = "clearListeners";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        try {
            this.removeAllSystemDocumentEventListener();
            this.removeAllDocEventListenerFromCurrentDoc();
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            return;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void setupListeners() throws RTEException {
        String method_Name = "setupListeners";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.htmlDoc == null) {
            RTEExceptionHelper.throwX((short)1, (String)RTENLS.Err_Msg27);
        }
        try {
            HTMLElement htmlDocElem = this.htmlDoc.getBody();
            if (htmlDocElem == null) {
                RTEExceptionHelper.throwX((short)1, (String)RTENLS.Err_Msg27);
            }
            this.docElem = (JHTMLElement)this.htmlDoc.getDocumentElement();
        }
        catch (RTEException rteEx) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", rteEx);
            throw rteEx;
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg28, (Exception)e);
        }
        try {
            this.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent ke) {
                    ke.doit = true;
                }

                public void keyPressed(KeyEvent ke) {
                    RichTextEditor.this.dirty = true;
                    ke.doit = true;
                }
            });
            this.addSystemDocumentEventListener("mouseup", new EventListener(){

                public void handleEvent(Event event) {
                    if (!RichTextEditor.this.isReadOnly && RichTextEditor.this.cursorInfoChangedListeners != null && RichTextEditor.this.cursorInfoChangedListeners.size() > 0) {
                        RichTextEditor.this.fireCursorInfoChangedEvent();
                    }
                }
            });
            this.docElem.addDragEventListener(new DOMDragEventListener(){

                public void dragEnter(Event arg) {
                    RichTextEditor.this.fireDragStart();
                }

                public void dragOver(Event arg) {
                    RichTextEditor.this.fireDragOver();
                }

                public void dragExit(Event arg) {
                }

                public void dragDrop(Event arg) {
                    RichTextEditor.this.fireDrop();
                    RichTextEditor.this.dirty = true;
                }

                public void dragGesture(Event arg) {
                }

                public void handleEvent(Event arg) {
                }
            });
            this.initEventTransfer();
            this.addAllDocEventListenerToCurrentDoc();
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg33, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addCursorInfoChangedListener(RTEEventListener cursorInfoChangedListener) {
        String method_Name = "addCursorInfoChangedListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.cursorInfoChangedListeners.add(cursorInfoChangedListener);
        if (!this.isReadOnly) {
            this.fireCursorInfoChangedEvent();
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeCursorInfoChangedListener(RTEEventListener cursorInfoChangedListener) {
        String method_Name = "removeCursorInfoChangedListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.cursorInfoChangedListeners.remove(cursorInfoChangedListener);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void fireCursorInfoChangedEvent() {
        String method_Name = "fireCursorInfoChangedEvent";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        int i = 0;
        while (i < this.cursorInfoChangedListeners.size()) {
            try {
                HashMap attributes = this.getTextAttributes();
                RTEEvent CursorMoveEvent = new RTEEvent();
                CursorMoveEvent.setTextAttributes(attributes);
                CursorMoveEvent.setType(9);
                RTEEventListener lis = (RTEEventListener)this.cursorInfoChangedListeners.get(i);
                lis.handleEvent(CursorMoveEvent);
            }
            catch (Exception exception) {}
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public HashMap getTextAttributes() {
        int direction = this.getDirection();
        int i = 0;
        while (i < RTEEvent.TEXT_ATTRIBUTE_COMMANDS.length) {
            if (RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i] == "ltr") {
                this.textAttribute.put(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], direction == 1 ? "TRUE" : "FALSE");
            } else if (RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i] == "rtl") {
                this.textAttribute.put(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], direction == 1 ? "FALSE" : "TRUE");
            } else if (!this.isReadOnly) {
                this.textAttribute.put(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], this.getCommandValue(RTEEvent.TEXT_ATTRIBUTE_COMMANDS[i], textCommandsType[i]));
            }
            ++i;
        }
        return this.textAttribute;
    }

    private String getCommandValue(String command, boolean type) {
        String method_Name = "getCommandValue";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        String value = null;
        try {
            value = type ? (this.getHtmlDocInstance().queryCommandState(command) ? "true" : "false") : this.getHtmlDocInstance().queryCommandValue(command);
        }
        catch (JDOMException e) {
            this.logger.logp(Level.FINE, this.CLZ_Name, method_Name, RTENLS.Err_Msg39, e);
            return "";
        }
        if (command.equals("formatblock")) {
            value = value.equalsIgnoreCase("h1") ? "Heading 1" : (value.equalsIgnoreCase("h2") ? "Heading 2" : (value.equalsIgnoreCase("h3") ? "Heading 3" : (value.equalsIgnoreCase("h4") ? "Heading 4" : (value.equalsIgnoreCase("h5") ? "Heading 5" : (value.equalsIgnoreCase("h6") ? "Heading 6" : (value.equalsIgnoreCase("address") ? "Address" : (value.equalsIgnoreCase("pre") ? "Preformatted" : "Normal")))))));
        }
        if (value != null && command.equals("backcolor")) {
            try {
                if (!value.equalsIgnoreCase("backcolor") && !value.equals("") && value.length() == 7 && value.charAt(0) == '#') {
                    value = Long.valueOf(value.substring(1), 16).toString();
                }
            }
            catch (Exception e) {
                this.logger.logp(Level.INFO, this.CLZ_Name, method_Name, RTENLS.Err_Msg39, e);
            }
        }
        if (value != null && command.equals("forecolor")) {
            try {
                if (!value.equalsIgnoreCase("forecolor") && !value.equals("")) {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int beginBacket = value.indexOf(40);
                    int endBacket = value.indexOf(41);
                    int beginComma = value.indexOf(44);
                    int endComma = value.lastIndexOf(44);
                    if (beginBacket != -1 && endBacket != -1 && beginComma != -1 && endComma != -1) {
                        r = Integer.parseInt(value.substring(beginBacket + 1, beginComma));
                        g = Integer.parseInt(value.substring(beginComma + 2, endComma));
                        b = Integer.parseInt(value.substring(endComma + 2, endBacket));
                        value = new Long(r * 256 * 256 + g * 256 + b).toString();
                    } else if (value.length() == 7 && value.charAt(0) == '#') {
                        value = Long.valueOf(value.substring(1), 16).toString();
                    }
                }
            }
            catch (Exception e) {
                this.logger.logp(Level.INFO, this.CLZ_Name, method_Name, RTENLS.Err_Msg39, e);
            }
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return value;
    }

    public HTMLDocument getHtmlDocument() throws RTEException {
        if (this.htmlDoc == null) {
            RTEExceptionHelper.throwX((short)2, (String)RTENLS.Err_Msg18);
        }
        return this.htmlDoc;
    }

    private JHTMLDocument getHtmlDocInstance() throws RTEException {
        if (this.htmlDoc == null) {
            RTEExceptionHelper.throwX((short)2, (String)RTENLS.Err_Msg17);
        }
        return this.htmlDoc;
    }

    public boolean executeCommand(String strCommandName, boolean showUI, String strValue) {
        boolean retVal = false;
        if (strCommandName == null || strCommandName.trim().length() == 0) {
            return retVal;
        }
        try {
            retVal = strCommandName.equalsIgnoreCase("cut") || strCommandName.equalsIgnoreCase("copy") || strCommandName.equalsIgnoreCase("paste") ? DOMBrowser.execCutCopyPaste((JHTMLDocument)this.htmlDoc, (DOMBrowser)this.webBrowser, (String)strCommandName) : this.getHtmlDocInstance().execCommand(strCommandName, showUI, strValue);
            if (!this.isReadOnly && this.cursorInfoChangedListeners != null && this.cursorInfoChangedListeners.size() > 0) {
                this.fireCursorInfoChangedEvent();
            }
        }
        catch (Exception e) {
            this.logger.logp(Level.WARNING, this.CLZ_Name, strCommandName, RTENLS.Err_Msg41, e);
        }
        return retVal;
    }

    public void setBackColor(String value) {
        this.executeCommand("hilitecolor", false, value);
        this.dirty = true;
    }

    public void bold() {
        this.executeCommand("bold", false, null);
        this.dirty = true;
    }

    public void copy() {
        this.executeCommand("copy", false, null);
    }

    public void createLink() {
        this.executeCommand("createlink", true, null);
        this.dirty = true;
    }

    public void cut() {
        this.executeCommand("cut", false, null);
        this.fireCut();
    }

    public void delete() {
        this.executeCommand("delete", false, null);
        this.dirty = true;
    }

    public void setFontName(String value) {
        this.executeCommand("fontname", false, value);
        this.dirty = true;
    }

    public void setFontSize(String value) {
        this.executeCommand("fontsize", false, value);
        this.dirty = true;
    }

    public void setForeColor(String value) {
        this.executeCommand("forecolor", false, value);
        this.dirty = true;
    }

    public void formatBlock(String value) {
        String sFormatTag = value;
        if (value.equalsIgnoreCase("Normal")) {
            sFormatTag = "<p>";
        } else if (value.equalsIgnoreCase("Paragraph")) {
            sFormatTag = "<p>";
        } else if (value.equalsIgnoreCase("Heading 1")) {
            sFormatTag = "<h1>";
        } else if (value.equalsIgnoreCase("Heading 2")) {
            sFormatTag = "<h2>";
        } else if (value.equalsIgnoreCase("Heading 3")) {
            sFormatTag = "<h3>";
        } else if (value.equalsIgnoreCase("Heading 4")) {
            sFormatTag = "<h4>";
        } else if (value.equalsIgnoreCase("Heading 5")) {
            sFormatTag = "<h5>";
        } else if (value.equalsIgnoreCase("Heading 6")) {
            sFormatTag = "<h6>";
        } else if (value.equalsIgnoreCase("Address")) {
            sFormatTag = "<address>";
        } else if (value.equalsIgnoreCase("Preformatted")) {
            sFormatTag = "<pre>";
        }
        this.executeCommand("formatblock", false, sFormatTag);
        this.dirty = true;
    }

    public void heading(String value) {
        this.executeCommand("heading", false, value);
        this.dirty = true;
    }

    public void indent() {
        this.executeCommand("indent", false, null);
        this.dirty = true;
    }

    public void insertHorizontalRule() {
        this.executeCommand("inserthorizontalrule", false, null);
        this.dirty = true;
    }

    public void insertOrderedList() {
        this.executeCommand("insertorderedlist", false, null);
        this.dirty = true;
    }

    public void insertBulletList() {
        this.executeCommand("insertunorderedlist", false, null);
        this.dirty = true;
    }

    public void italic() {
        this.executeCommand("italic", false, null);
        this.dirty = true;
    }

    public void setJustifyStyle(int style) {
        switch (style) {
            case 0: {
                this.executeCommand("justifycenter", false, null);
                break;
            }
            case 1: {
                this.executeCommand("justifyfull", false, null);
                break;
            }
            case 2: {
                this.executeCommand("justifyleft", false, null);
                break;
            }
            case 3: {
                this.executeCommand("justifyright", false, null);
            }
        }
        this.dirty = true;
    }

    public void outdent() {
        this.executeCommand("outdent", false, null);
        this.dirty = true;
    }

    public void paste() {
        RTEEvent event = new RTEEvent();
        event.setType(7);
        int i = 0;
        while (i < this.pasteListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.pasteListeners.get(i);
                lis.handleEvent(event);
                if (!event.doIt) {
                    return;
                }
            }
            catch (Exception e) {
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg05, (Exception)e);
            }
            ++i;
        }
        this.executeCommand("Paste", false, null);
        this.dirty = true;
        if (this.enableBackgroundSpellchecking) {
            int style = 5;
            HTMLElement curNode = this.htmlDoc.getBody();
            this.invokeBackgroundSpellchecking(curNode, style, null);
        }
    }

    public void print() {
        this.htmlWin.print();
    }

    public void printPreview() {
        this.isPrintPreview = !this.isPrintPreview;
        this.webBrowser.printPreview();
        if (this.isPrintPreview && !this.isReadOnly) {
            this.setReadOnly(true);
            this.preReadOnlyValue = false;
        } else if (this.isPrintPreview && this.isReadOnly) {
            this.preReadOnlyValue = true;
        }
        if (!this.isPrintPreview) {
            this.setReadOnly(this.preReadOnlyValue);
        }
    }

    public void pageSetup() {
        this.webBrowser.showPageSetupDialog();
    }

    public void redo() {
        this.executeCommand("Redo", false, null);
    }

    public void refresh() {
        this.isRefreshing = true;
        this.webBrowser.refresh();
    }

    public void removeFormat() {
        this.executeCommand("removeformat", false, null);
        this.dirty = true;
    }

    public void selectAll() {
        this.executeCommand("selectall", false, null);
    }

    public void strikeThrough() {
        this.executeCommand("strikethrough", false, null);
        this.dirty = true;
    }

    public void underline() {
        this.executeCommand("underline", false, null);
        this.dirty = true;
    }

    public void undo() {
        this.executeCommand("Undo", false, null);
    }

    public void unlink() {
        this.executeCommand("unlink", false, null);
        this.dirty = true;
    }

    public void unselect() {
        this.htmlWin.getSelection().removeAllRanges();
    }

    public void insertTable(HTMLElement parent, int rows, int cols) {
        if (parent == null) {
            this.insertTable(rows, cols);
            return;
        }
        Element tableElem = this.htmlDoc.createElement("table");
        tableElem.setAttribute("border", "1");
        tableElem.setAttribute("cellpadding", "0");
        tableElem.setAttribute("cellspacing", "0");
        tableElem.setAttribute("bordercolor", "#111111");
        tableElem.setAttribute("width", "100%");
        Element tbodyElem = this.htmlDoc.createElement("tbody");
        int width = 100 / cols;
        int remain = width + 100 % cols;
        String s_width = String.valueOf(String.valueOf(width)) + "%";
        String s_remain = String.valueOf(String.valueOf(remain)) + "%";
        int i = 0;
        while (i < rows) {
            Element trElem = this.htmlDoc.createElement("tr");
            int j = 0;
            while (j < cols) {
                JHTMLElement tdElem = (JHTMLElement)this.htmlDoc.createElement("td");
                if (j != cols - 1) {
                    tdElem.setAttribute("width", s_width);
                } else {
                    tdElem.setAttribute("width", s_remain);
                }
                Element brElem = this.htmlDoc.createElement("br");
                tdElem.appendChild((Node)brElem);
                trElem.appendChild((Node)tdElem);
                ++j;
            }
            tbodyElem.appendChild(trElem);
            ++i;
        }
        tableElem.appendChild(tbodyElem);
        parent.appendChild(tableElem);
        this.dirty = true;
    }

    private void insertTable(int rows, int cols) {
        Element tableElem = this.htmlDoc.createElement("table");
        tableElem.setAttribute("border", "1");
        tableElem.setAttribute("cellpadding", "0");
        tableElem.setAttribute("cellspacing", "0");
        tableElem.setAttribute("bordercolor", "#111111");
        tableElem.setAttribute("width", "100%");
        Element tbodyElem = this.htmlDoc.createElement("tbody");
        int width = 100 / cols;
        int remain = width + 100 % cols;
        String s_width = String.valueOf(String.valueOf(width)) + "%";
        String s_remain = String.valueOf(String.valueOf(remain)) + "%";
        int i = 0;
        while (i < rows) {
            Element trElem = this.htmlDoc.createElement("tr");
            int j = 0;
            while (j < cols) {
                JHTMLElement tdElem = (JHTMLElement)this.htmlDoc.createElement("td");
                if (j != cols - 1) {
                    tdElem.setAttribute("width", s_width);
                } else {
                    tdElem.setAttribute("width", s_remain);
                }
                Element brElem = this.htmlDoc.createElement("br");
                tdElem.appendChild((Node)brElem);
                trElem.appendChild((Node)tdElem);
                ++j;
            }
            tbodyElem.appendChild(trElem);
            ++i;
        }
        tableElem.appendChild(tbodyElem);
        this.insertNodeAtSelection(tableElem);
        this.dirty = true;
    }

    public void insertText(HTMLElement parent, String text) {
        org.w3c.dom.Text textNode = this.htmlDoc.createTextNode(text);
        if (parent == null) {
            this.insertNodeAtSelection(textNode);
        } else {
            parent.appendChild(textNode);
        }
        this.dirty = true;
    }

    public void replace() {
        SearchReplaceDialog replaceDlg = new SearchReplaceDialog(this.webBrowser.getShell());
        replaceDlg.open();
    }

    public void find() {
        SearchDialog searchDlg = new SearchDialog(this.webBrowser.getShell());
        searchDlg.open();
    }

    public String getSourceContent() throws RTEException {
        String strContent = " ";
        if (this.enableBackgroundSpellchecking) {
            this.removeMisspellingStyle();
        }
        try {
            JHTMLElement elem = (JHTMLElement)this.getHtmlDocInstance().getDocumentElement();
            strContent = elem.getInnerHTML();
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg20, (Exception)e);
            strContent = "Error";
        }
        if (this.enableBackgroundSpellchecking) {
            this.addMisspellingStyle();
        }
        return strContent;
    }

    public void setSourceContent(String content) throws RTEException {
        try {
            this.duringSetSourceContent = true;
            this.webBrowser.setText(content);
            this.loadcompleted();
            this.dirty = true;
            if (this.enableBackgroundSpellchecking) {
                this.addMisspellingStyle();
            }
            this.duringSetSourceContent = false;
        }
        catch (Exception e) {
            this.duringSetSourceContent = false;
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg35, (Exception)e);
        }
    }

    private Node insertNodeAtSelection(Node newNode) {
        String method_Name = "insertNodeAtSelection";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        sel.removeAllRanges();
        range.deleteContents();
        Node container = range.getStartContainer();
        int pos = range.getStartOffset();
        JRange newRange = this.htmlDoc.createRange();
        if (newRange == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return null;
        }
        Node afterNode = null;
        if (container.getNodeType() == 3) {
            Node textNode = container;
            container = textNode.getParentNode();
            String text = textNode.getNodeValue();
            String textBefore = text.substring(0, pos);
            String textAfter = text.substring(pos);
            org.w3c.dom.Text beforeNode = this.htmlDoc.createTextNode(textBefore);
            afterNode = this.htmlDoc.createTextNode(textAfter);
            container.insertBefore(beforeNode, textNode);
            container.insertBefore(newNode, textNode);
            afterNode = container.insertBefore(afterNode, textNode);
            container.removeChild(textNode);
        } else {
            afterNode = container.getChildNodes().item(pos);
            newNode = afterNode != null ? container.insertBefore(newNode, afterNode) : (container instanceof JHTMLBRElement ? container.getParentNode().insertBefore(newNode, container) : container.appendChild(newNode));
        }
        if (afterNode != null) {
            newRange.setStart(afterNode, 0);
        } else {
            newRange.setEndAfter(newNode);
        }
        sel.addRange(newRange);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return newNode;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean flag) throws RTEException {
        try {
            if (this.isReadOnly == flag) {
                return;
            }
            this.isReadOnly = flag;
            if (!flag) {
                this.htmlDoc.setDesignMode("on");
                this.executeCommand("readonly", false, String.valueOf(!flag));
            } else {
                this.executeCommand("readonly", false, String.valueOf(!flag));
                this.htmlDoc.setDesignMode("off");
            }
            if (this._toolPalette != null) {
                this._toolPalette.setReadOnly(flag);
            }
        }
        catch (Exception e) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg36, (Exception)e);
        }
    }

    public void setEditorBackColor(String value) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.focus();
            this.htmlDoc.setBgColor(value);
            this.dirty = true;
        }
    }

    public String getEditorBackColor() {
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.focus();
            return this.htmlDoc.getBgColor();
        }
        return null;
    }

    public void setEditorFgColor(String value) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlDoc.setFgColor(value);
            this.dirty = true;
        }
    }

    public String getEditorFgColor() {
        if (this.htmlWin != null && this.htmlDoc != null) {
            return this.htmlDoc.getFgColor();
        }
        return null;
    }

    public void scrollTo(int x, int y) {
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.scrollTo(x, y);
        }
    }

    public void scrollToEnd() {
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.scrollTo(this.htmlWin.getScreen().getWidth(), 99999999);
        }
    }

    public void scrollToTop() {
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.scrollTo(0, 0);
        }
    }

    public void scrollElementIntoView(HTMLElement elem, boolean top) {
        if (elem != null) {
            JHTMLElement element = (JHTMLElement)elem;
            element.scrollIntoView(top);
        }
    }

    public void appendText(String value) {
        if (this.isReadOnly()) {
            return;
        }
        JHTMLDocument hDoc = (JHTMLDocument)this.getHtmlDocument();
        JHTMLElement hBody = (JHTMLElement)hDoc.getBody();
        org.w3c.dom.Text textNode = hDoc.createTextNode(value);
        hBody.appendChild((Node)textNode);
    }

    public void clear() {
        this.setSourceContent("");
    }

    public HashMap getMetadata() {
        String method_Name = "getMetadata";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.metadata.clear();
        Element metaElem = this.webBrowser.getDocument().getElementById("rtedocmeta");
        NamedNodeMap attrs = metaElem.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().indexOf("rte") != -1) {
                this.metadata.put(attr.getNodeName().substring(3), attr.getNodeValue());
            }
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return this.metadata;
    }

    public void setMetadata(HashMap md) {
        String method_Name = "setMetadata";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.metadata = md;
        Element metaElem = this.webBrowser.getDocument().getElementById("rtedocmeta");
        if (metaElem == null) {
            metaElem = this.webBrowser.getDocument().createElement("meta");
            metaElem.setAttribute("id", "rtedocmeta");
            NodeList elems = this.webBrowser.getDocument().getElementsByTagName("head");
            if (elems == null) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                return;
            }
            Node head = elems.item(0);
            metaElem = (Element)head.appendChild(metaElem);
        }
        NamedNodeMap attrs = metaElem.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node attr = attrs.item(i);
            if (attr.getNodeName().indexOf("rte") != -1) {
                metaElem.removeAttribute(attr.getNodeName());
            }
            ++i;
        }
        Iterator keys = this.metadata.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)this.metadata.get(key);
            metaElem.setAttribute("rte" + key, value);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void insertHTMLElementAtCursor(Element element) {
        try {
            this.insertNodeAtSelection(element);
            this.dirty = true;
        }
        catch (Exception rteEx) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg37, (Exception)rteEx);
        }
    }

    public void insertHTMLElement(Element parent, Element elem) throws RTEException {
        try {
            parent.appendChild(elem);
            this.dirty = true;
        }
        catch (Exception rteEx) {
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg38, (Exception)rteEx);
        }
    }

    public void removeHTMLElementByID(String id) {
        Element elem = this.htmlDoc.getElementById(id);
        if (elem == null) {
            return;
        }
        elem.getParentNode().removeChild(elem);
        this.dirty = true;
    }

    public void insertTableColumnLeft() {
        this.InsertColumn(true);
    }

    public void insertTableColumnRight() {
        this.InsertColumn(false);
    }

    public void deleteTableColumn() {
        HTMLTableElement currentTable = this.getCurrentTableElement();
        int firstSelectionColIndex = this.getCurrentSelectionColIndex(true);
        int lastSelectionColIndex = this.getCurrentSelectionColIndex(false);
        int i = 0;
        while (i < currentTable.getRows().getLength()) {
            HTMLTableRowElement rowElem = (HTMLTableRowElement)currentTable.getRows().item(i);
            int j = firstSelectionColIndex;
            while (j <= lastSelectionColIndex) {
                if (rowElem.getCells().getLength() > firstSelectionColIndex) {
                    rowElem.deleteCell(firstSelectionColIndex);
                    this.dirty = true;
                }
                ++j;
            }
            ++i;
        }
        this.resizeTable();
    }

    private int getCurrentSelectionColIndex(boolean isFirst) {
        String method_Name = "getCurrentSelectionColIndex";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        Node node = range.getStartContainer();
        String strName = node.getNodeName();
        int currentColIndex = -1;
        if (strName.equalsIgnoreCase("tr")) {
            HTMLTableRowElement rowElem = (HTMLTableRowElement)node;
            int i = 0;
            while (i < rowElem.getCells().getLength()) {
                if (sel.containsNode(rowElem.getCells().item(i), true)) {
                    currentColIndex = i;
                    if (isFirst) {
                        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                        return currentColIndex;
                    }
                }
                ++i;
            }
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return currentColIndex;
        }
        HTMLTableCellElement currentCell = null;
        while (node != null) {
            if (node instanceof HTMLTableCellElement) {
                currentCell = (HTMLTableCellElement)node;
                break;
            }
            node = node.getParentNode();
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return currentCell.getCellIndex();
    }

    private ColumnInfo getCellIndex() {
        String method_Name = "getCellIndex";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        Object node = (JNode)range.getStartContainer();
        String strName = node.getNodeName();
        int currentCellIndex = 0;
        HTMLTableRowElement rowElem = null;
        if (strName.equalsIgnoreCase("tr")) {
            rowElem = (HTMLTableRowElement)node;
            int i = 0;
            while (i < rowElem.getCells().getLength()) {
                if (sel.containsNode(rowElem.getCells().item(i), true)) {
                    currentCellIndex = i;
                    sel.removeAllRanges();
                    this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                    return new ColumnInfo(rowElem, currentCellIndex);
                }
                ++i;
            }
        } else {
            HTMLTableCellElement currentCell = null;
            while (node != null) {
                if (node instanceof HTMLTableCellElement) {
                    currentCell = (HTMLTableCellElement)node;
                    break;
                }
                node = node.getParentNode();
            }
            currentCellIndex = currentCell.getCellIndex();
            rowElem = (HTMLTableRowElement)currentCell.getParentNode();
        }
        sel.removeAllRanges();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return new ColumnInfo(rowElem, currentCellIndex);
    }

    private void InsertColumn(boolean isLeft) {
        String method_Name = "InsertColumn";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        ColumnInfo colInfo = this.getCellIndex();
        int currentCellIndex = colInfo.getCurrentCellIndex();
        Node currentRow = colInfo.getCurrentRow();
        HTMLTableElement tableElem = (HTMLTableElement)currentRow.getParentNode().getParentNode();
        int i = 0;
        while (i < tableElem.getRows().getLength()) {
            HTMLTableRowElement rowElem = (HTMLTableRowElement)tableElem.getRows().item(i);
            if (rowElem.getCells().getLength() > currentCellIndex) {
                HTMLTableCellElement cellElem = (HTMLTableCellElement)rowElem.getCells().item(currentCellIndex);
                Element newCell = this.createNewCell(cellElem);
                if (isLeft) {
                    rowElem.insertBefore(newCell, cellElem);
                } else if (rowElem.getCells().getLength() == currentCellIndex + 1) {
                    rowElem.appendChild(newCell);
                } else {
                    cellElem = (HTMLTableCellElement)rowElem.getCells().item(currentCellIndex + 1);
                    rowElem.insertBefore(newCell, cellElem);
                }
                this.dirty = true;
            }
            ++i;
        }
        sel.addRange(range);
        sel.collapseToEnd();
        this.resizeTable();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void resizeTable() {
        String method_Name = "resizeTable";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        HTMLTableElement currentTable = this.getCurrentTableElement();
        HTMLCollection rows = currentTable.getRows();
        int i = 0;
        while (i < rows.getLength()) {
            HTMLTableRowElement row = (HTMLTableRowElement)rows.item(i);
            HTMLCollection cells = row.getCells();
            int columnCount = cells.getLength();
            int width = 100 / columnCount;
            int remain = width + 100 % columnCount;
            String s_width = String.valueOf(String.valueOf(width)) + "%";
            String s_remain = String.valueOf(String.valueOf(remain)) + "%";
            int j = 0;
            while (j < columnCount) {
                JHTMLElement tdElem = (JHTMLElement)cells.item(j);
                if (j != columnCount - 1) {
                    tdElem.setAttribute("width", s_width);
                } else {
                    tdElem.setAttribute("width", s_remain);
                }
                ++j;
            }
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void insertTableRowAbove() {
        String method_Name = "insertTableRowAbove";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        HTMLTableRowElement currentRow = this.getCurrentRow();
        Element newRow = this.createNewRow(currentRow);
        Node container = currentRow.getParentNode();
        container.insertBefore(newRow, currentRow);
        this.dirty = true;
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void insertTableRowBelow() {
        String method_Name = "insertTableRowBelow";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        HTMLTableRowElement currentRow = this.getCurrentRow();
        Element newRow = this.createNewRow(currentRow);
        Node container = currentRow.getParentNode();
        Node prevRow = currentRow.getNextSibling();
        if (prevRow != null) {
            container.insertBefore(newRow, prevRow);
        } else {
            container.appendChild(newRow);
        }
        this.dirty = true;
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void deleteTableRow() {
        String method_Name = "deleteTableRow";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        int firstSelectionRowIndex = this.getCurrentSelectionRowIndex(true);
        int lastSelectionRowIndex = this.getCurrentSelectionRowIndex(false);
        HTMLTableElement currentTable = this.getCurrentTableElement();
        if (currentTable == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        int i = firstSelectionRowIndex;
        while (i <= lastSelectionRowIndex) {
            currentTable.deleteRow(firstSelectionRowIndex);
            ++i;
        }
        this.dirty = true;
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private HTMLTableElement getCurrentTableElement() {
        String method_Name = "getCurrentTableElement";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        Node node = range.getStartContainer();
        while (node != null) {
            if (node instanceof HTMLTableElement) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                return (HTMLTableElement)node;
            }
            node = node.getParentNode();
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return null;
    }

    private int getCurrentSelectionRowIndex(boolean isStart) {
        String method_Name = "getCurrentSelectionRowIndex";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = null;
        try {
            range = isStart ? sel.getRangeAt(0) : sel.getRangeAt(sel.getRangeCount() - 1);
        }
        catch (JDOMException ex) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", ex);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg39, (Exception)((Object)ex));
        }
        Node node = range.getStartContainer();
        HTMLTableRowElement currentRow = null;
        while (node != null) {
            if (node instanceof HTMLTableRowElement) {
                currentRow = (HTMLTableRowElement)node;
                break;
            }
            node = node.getParentNode();
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return currentRow.getRowIndex();
    }

    private HTMLTableRowElement getCurrentRow() {
        String method_Name = "getCurrentRow";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        Node currentRow = range.getStartContainer();
        String strName = currentRow.getNodeName();
        while (!strName.equalsIgnoreCase("tr")) {
            currentRow = currentRow.getParentNode();
            strName = currentRow.getNodeName();
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return (HTMLTableRowElement)currentRow;
    }

    private Element createNewRow(HTMLTableRowElement currentRow) {
        String method_Name = "createNewRow";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        int colNum = currentRow.getCells().getLength();
        Element newRow = this.htmlDoc.createElement("tr");
        int i = 0;
        while (i < currentRow.getAttributes().getLength()) {
            Attr attr = (Attr)currentRow.getAttributes().item(i);
            newRow.setAttribute(attr.getName(), attr.getValue());
            ++i;
        }
        i = 0;
        while (i < colNum) {
            HTMLTableCellElement cellElem = (HTMLTableCellElement)currentRow.getCells().item(i);
            Element newCell = this.createNewCell(cellElem);
            newRow.appendChild(newCell);
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return newRow;
    }

    private Element createNewCell(HTMLTableCellElement cellElem) {
        String method_Name = "createNewCell";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        Element newCell = this.htmlDoc.createElement("td");
        Element brElem = this.htmlDoc.createElement("br");
        int j = 0;
        while (j < cellElem.getAttributes().getLength()) {
            Attr attr = (Attr)cellElem.getAttributes().item(j);
            newCell.setAttribute(attr.getName(), attr.getValue());
            ++j;
        }
        newCell.appendChild(brElem);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return newCell;
    }

    public void bidi() {
        this.setDirection(-this.getDirection());
    }

    public void focus() throws RTEException {
        if (this.htmlWin != null && this.htmlDoc != null) {
            this.htmlWin.focus();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private Node getCursorPositionNode() throws RTEException {
        String method_Name = "getCursorPositionNode";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        Node retNode = null;
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        Node container = range.getStartContainer();
        int pos = range.getStartOffset();
        if (container.getNodeType() == 3) {
            Node textNode = container;
            retNode = textNode.getParentNode();
        } else {
            retNode = container.getChildNodes().item(pos);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN", retNode);
        return retNode;
    }

    private void setCursorPosition(Node node, int offset) throws RTEException {
        String method_Name = "setCursorPosition";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        try {
            JSelection sel = this.htmlWin.getSelection();
            JRange newRange = this.htmlDoc.createRange();
            newRange.setStart(node, offset);
            sel.addRange(newRange);
            sel.collapseToEnd();
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg32, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void fireDragStart() {
        String method_Name = "fireDragStart";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        RTEEvent event = new RTEEvent();
        event.setType(3);
        int i = 0;
        while (i < this.dragStartListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.dragStartListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg11, (Exception)e);
            }
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void fireDragOver() {
        String method_Name = "fireDragOver";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        RTEEvent event = new RTEEvent();
        event.setType(4);
        int i = 0;
        while (i < this.dragOverListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.dragOverListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg10, (Exception)e);
            }
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void fireDrop() {
        String method_Name = "fireDrop";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        RTEEvent event = new RTEEvent();
        event.setType(5);
        int i = 0;
        while (i < this.dropListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.dropListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg12, (Exception)e);
            }
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void fireCut() {
        String method_Name = "fireCut";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.dirty = true;
        RTEEvent event = new RTEEvent();
        event.setType(6);
        int i = 0;
        while (i < this.cutListeners.size()) {
            try {
                RTEEventListener lis = (RTEEventListener)this.cutListeners.get(i);
                lis.handleEvent(event);
            }
            catch (Exception e) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
                RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg09, (Exception)e);
            }
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addDragStartListener(RTEEventListener lis) {
        String method_Name = "addDragStartListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", lis);
        this.dragStartListeners.add(lis);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addDragOverListener(RTEEventListener lis) {
        String method_Name = "addDragOverListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", lis);
        this.dragOverListeners.add(lis);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addDropListener(RTEEventListener lis) {
        String method_Name = "addDropListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", lis);
        this.dropListeners.add(lis);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addCutListener(RTEEventListener lis) {
        String method_Name = "addCutListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", lis);
        this.cutListeners.add(lis);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addPasteListener(RTEEventListener lis) {
        String method_Name = "addPasteListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", lis);
        this.pasteListeners.add(lis);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void setDirection(int value) {
        JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
        if (body == null) {
            return;
        }
        if (value == 1) {
            body.setDir("ltr");
        }
        if (value == -1) {
            body.setDir("rtl");
        }
        this.dirty = true;
        this.fireCursorInfoChangedEvent();
    }

    public int getDirection() {
        String dir;
        JHTMLElement body = (JHTMLElement)this.htmlDoc.getBody();
        if (body == null) {
            if (0x2000000 == (this.getStyle() & 0x2000000)) {
                return 1;
            }
            if (0x4000000 == (this.getStyle() & 0x4000000)) {
                return -1;
            }
        }
        if ("ltr".equals(dir = body.getDir())) {
            return 1;
        }
        if ("rtl".equals(dir)) {
            return -1;
        }
        return 1;
    }

    public String getSelectedText() {
        String spellTxt = this.htmlDoc.getSelection();
        if (spellTxt == null || spellTxt.length() < 2) {
            this.selectAll();
            spellTxt = this.htmlDoc.getSelection();
            this.htmlWin.getSelection().removeAllRanges();
            this.unselect();
        }
        return spellTxt;
    }

    public void addKeyListener(KeyListener listener) {
        String method_Name = "addKeyListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.keylisteners == null) {
            this.keylisteners = new Vector();
        }
        if (!this.keylisteners.contains(listener)) {
            this.keylisteners.addElement(listener);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeKeyListener(KeyListener listener) {
        String method_Name = "removeKeyListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.keylisteners != null && this.keylisteners.contains(listener)) {
            this.keylisteners.removeElement(listener);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void initEventTransfer() {
        String method_Name = "initEventTransfer";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        try {
            this.addSystemDocumentEventListener("keypress", new EventListener(){

                public void handleEvent(Event evt) {
                    String method_Name = "initEventTransfer::addSystemDocumentEventListener(keypress)::handleEvent";
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
                    if (evt.getType().equalsIgnoreCase("keypress")) {
                        JKeyEvent keyEvt = (JKeyEvent)evt;
                        if (keyEvt.getCtrlKey()) {
                            if ((char)keyEvt.getCharCode() == 'v' || (char)keyEvt.getCharCode() == 'V') {
                                RichTextEditor.this.paste();
                                evt.preventDefault();
                            }
                            if ((char)keyEvt.getCharCode() == 'x' || (char)keyEvt.getCharCode() == 'X') {
                                RichTextEditor.this.fireCut();
                            }
                            if ((char)keyEvt.getCharCode() == 'b') {
                                RichTextEditor.this.bold();
                                RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                                return;
                            }
                            if ((char)keyEvt.getCharCode() == 'u') {
                                RichTextEditor.this.underline();
                                evt.preventDefault();
                                RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                                return;
                            }
                            if ((char)keyEvt.getCharCode() == 'i') {
                                RichTextEditor.this.italic();
                                RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                                return;
                            }
                        }
                        int i = 0;
                        while (i < RichTextEditor.this.keylisteners.size()) {
                            KeyListener kl = (KeyListener)RichTextEditor.this.keylisteners.elementAt(i);
                            org.eclipse.swt.widgets.Event event = new org.eclipse.swt.widgets.Event();
                            event.character = (char)keyEvt.getCharCode();
                            event.keyCode = keyEvt.getKeyCode();
                            event.stateMask = 0;
                            event.widget = RichTextEditor.this.webBrowser;
                            KeyEvent ke = new KeyEvent(event);
                            kl.keyPressed(ke);
                            if (!ke.doit) {
                                evt.preventDefault();
                                evt.stopPropagation();
                            }
                            ++i;
                        }
                    }
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                }
            });
            this.addSystemDocumentEventListener("keyup", new EventListener(){

                public void handleEvent(Event evt) {
                    String method_Name = "initEventTransfer::addSystemDocumentEventListener(keyup)::handleEvent";
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
                    if (evt.getType().equals("keyup")) {
                        int keyCode;
                        JKeyEvent keyEvt = (JKeyEvent)evt;
                        int i = 0;
                        while (i < RichTextEditor.this.keylisteners.size()) {
                            KeyListener kl = (KeyListener)RichTextEditor.this.keylisteners.elementAt(i);
                            org.eclipse.swt.widgets.Event event = new org.eclipse.swt.widgets.Event();
                            event.character = (char)keyEvt.getKeyCode();
                            event.keyCode = keyEvt.getKeyCode();
                            event.stateMask = 0;
                            if (keyEvt.getCtrlKey()) {
                                event.stateMask |= 0x40000;
                            }
                            if (keyEvt.getShiftKey()) {
                                event.stateMask |= 0x20000;
                            }
                            if (keyEvt.getAltKey()) {
                                event.stateMask |= 0x10000;
                            }
                            event.widget = RichTextEditor.this.webBrowser;
                            KeyEvent ke = new KeyEvent(event);
                            kl.keyReleased(ke);
                            ++i;
                        }
                        if (!RichTextEditor.this.isReadOnly && RichTextEditor.this.cursorInfoChangedListeners != null && RichTextEditor.this.cursorInfoChangedListeners.size() > 0) {
                            keyCode = keyEvt.getKeyCode();
                            switch (keyCode) {
                                case 8: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: 
                                case 40: 
                                case 46: {
                                    RichTextEditor.this.fireCursorInfoChangedEvent();
                                }
                            }
                        }
                        if (!RichTextEditor.this.isReadOnly && RichTextEditor.this.enableBackgroundSpellchecking) {
                            Node curNode;
                            Node curNode2;
                            keyCode = keyEvt.getKeyCode();
                            boolean isReturnKey = false;
                            switch (keyCode) {
                                case 13: {
                                    isReturnKey = true;
                                }
                                case 9: 
                                case 32: {
                                    int style = 5;
                                    curNode2 = RichTextEditor.this.getCursorPositionNode();
                                    if (isReturnKey && curNode2.getParentNode() != null) {
                                        if (RichTextEditor.this.isMisspelledNode(curNode2)) {
                                            Node previousNode = RichTextEditor.this.getPreviousParagraphNode(curNode2);
                                            if ((previousNode = RichTextEditor.this.getMisspeltChildNode(previousNode)) != null) {
                                                RichTextEditor.this.invokeBackgroundSpellchecking(previousNode, 1, null);
                                                RichTextEditor.this.invokeBackgroundSpellchecking(curNode2, 1, null);
                                            }
                                        }
                                        if (RichTextEditor.this.isMisspelledNode(curNode2 = RichTextEditor.this.getRightParentNode(curNode2))) {
                                            this.arrangeNodes(curNode2);
                                        }
                                        if (this.findPreviousNodeBeforeReturn(curNode2) != null) {
                                            RichTextEditor.this.invokeBackgroundSpellchecking(this.findPreviousNodeBeforeReturn(curNode2), style, null);
                                        }
                                    }
                                    RichTextEditor.this.invokeBackgroundSpellchecking(curNode2, style, null);
                                }
                            }
                            switch (keyCode) {
                                case 59: 
                                case 61: 
                                case 109: 
                                case 188: 
                                case 190: 
                                case 191: 
                                case 192: 
                                case 219: 
                                case 220: 
                                case 221: 
                                case 222: {
                                    int style = 5;
                                    curNode2 = RichTextEditor.this.getCursorPositionNode();
                                    RichTextEditor.this.invokeBackgroundSpellchecking(curNode2, style, null);
                                }
                            }
                            char chars = (char)keyEvt.getKeyCode();
                            if (chars >= 'a' && chars <= 'z' || chars >= 'A' && chars <= 'Z' || keyCode == 46 || keyCode == 188 || keyCode == 192 || keyCode == 190 || keyCode == 191 || keyCode == 59 || keyCode == 220 || keyCode == 222 || keyCode == 61 || keyCode == 109 || keyCode == 219 || keyCode == 221 || keyCode == 32) {
                                int style = 1;
                                curNode = RichTextEditor.this.getCursorPositionNode();
                                RichTextEditor.this.invokeBackgroundSpellchecking(curNode, style, null);
                            }
                            if (keyCode == 8) {
                                int style = 2;
                                curNode = RichTextEditor.this.getCursorPositionNode();
                                RichTextEditor.this.invokeBackgroundSpellchecking(curNode, style, null);
                            }
                        }
                    }
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                }

                private void arrangeNodes(Node parentNode) {
                    if (RichTextEditor.this.isMisspelledNode(parentNode) && parentNode.getParentNode() != null) {
                        Node parent = parentNode.getParentNode();
                        NodeList children = parentNode.getChildNodes();
                        int len = children.getLength();
                        int i = 0;
                        while (i < len) {
                            parent.insertBefore(children.item(0), parentNode);
                            ++i;
                        }
                        parent.removeChild(parentNode);
                        RichTextEditor.this.markedMispelledWord(parent);
                    }
                }

                private Node findPreviousNodeBeforeReturn(Node node) {
                    if (node == null || node instanceof JHTMLBodyElement) {
                        return null;
                    }
                    Node previousNode = node.getPreviousSibling();
                    if (!RichTextEditor.this.getDocContent(previousNode).trim().equals("")) {
                        return previousNode;
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg26, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private Node getMisspeltChildNode(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        int i = len - 1;
        while (i >= 0) {
            Node child = children.item(i);
            if (this.isMisspelledNode(child)) {
                return child;
            }
            --i;
        }
        return null;
    }

    private Node getPreviousParagraphNode(Node node) {
        if (node == null) {
            return null;
        }
        Node parent = node;
        while (node.getParentNode() != null) {
            if ((parent = parent.getParentNode()) instanceof JHTMLParagraphElement) {
                return parent.getPreviousSibling();
            }
            if (parent instanceof JHTMLBodyElement) break;
        }
        return null;
    }

    private Node getRightParentNode(Node node) {
        Node parent = node.getParentNode();
        while (parent != null && this.getDocContent(parent).trim().equalsIgnoreCase("")) {
            if (!((parent = parent.getParentNode()) instanceof JHTMLBodyElement)) continue;
            return parent;
        }
        return parent;
    }

    private boolean initRTESpellChecker() {
        if (this.rteSpellChecker == null) {
            this.rteSpellChecker = new RTESpellChecker(this.webBrowser.getShell(), Platform.getNL(), this);
        }
        return this.rteSpellChecker.initSpellChecker();
    }

    public void doCheckSpelling() {
        if (this.initRTESpellChecker()) {
            this.rteSpellChecker.setDictionaryLocaleCode(this.localeCode);
            this.rteSpellChecker.invokeSpellChecker();
        }
    }

    public void setSpellCheckerLocale(String sLocaleCode) {
        this.localeCode = sLocaleCode;
    }

    public boolean doesSelectionExists() {
        try {
            int selLength = this.htmlWin.getSelection().getRangeAt(0).getEndOffset() - this.htmlWin.getSelection().getRangeAt(0).getStartOffset();
            return selLength > 0;
        }
        catch (Exception e) {
            this.logger.logp(Level.FINE, this.CLZ_Name, "doesSelectionExists", "DOMException", e);
            return false;
        }
    }

    public boolean forceFocus() {
        this.webBrowser.forceFocus();
        return true;
    }

    public String getDocumentContentInPlainText() {
        JSelection jselect = this.htmlWin.getSelection();
        int rangeCount = jselect.getRangeCount();
        JRange[] rangeStore = new JRange[rangeCount];
        int i = 0;
        while (i < rangeCount) {
            rangeStore[i] = jselect.getRangeAt(i);
            ++i;
        }
        String spellTxt = null;
        this.htmlWin.getSelection().removeAllRanges();
        this.selectAll();
        spellTxt = this.htmlDoc.getSelection();
        this.htmlWin.getSelection().removeAllRanges();
        this.unselect();
        int i2 = 0;
        while (i2 < rangeCount) {
            jselect.addRange(rangeStore[i2]);
            ++i2;
        }
        return spellTxt;
    }

    public void disableDefaultDropHandler() {
    }

    private String getDocContent(Node parent) {
        String method_Name = "getDocContent";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", parent);
        String retVal = "";
        if (parent != null && parent.getChildNodes() != null) {
            int i = 0;
            while (i < parent.getChildNodes().getLength()) {
                if (parent.getChildNodes().item(i) != null) {
                    retVal = parent.getChildNodes().item(i).getNodeType() == 3 ? String.valueOf(retVal) + parent.getChildNodes().item(i).getNodeValue() : (parent.getChildNodes().item(i) instanceof JHTMLBRElement ? String.valueOf(retVal) + " " : (parent.getChildNodes().item(i) instanceof JHTMLParagraphElement ? String.valueOf(retVal) + " " + this.getDocContent(parent.getChildNodes().item(i)) : String.valueOf(retVal) + this.getDocContent(parent.getChildNodes().item(i))));
                }
                ++i;
            }
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN", retVal);
        return retVal;
    }

    private void resetCursor() {
        String method_Name = "getDocContent";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.setCursorPosition(this.webBrowser.getDocument().getBody().getFirstChild(), 0);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public boolean isBackgroundSpellcheckingEnabled() {
        return this.enableBackgroundSpellchecking;
    }

    public boolean enableBackgroundSpellchecking(boolean enable) {
        String method_Name = "enableBackgroundSpellchecking";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.enableBackgroundSpellchecking == enable) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return true;
        }
        this.enableBackgroundSpellchecking = enable;
        this.backgroundSpellChecker = TextAnalyzerFactory.getSpellCheckerInstance();
        try {
            if (enable) {
                this.backgroundSpellChecker.setLocale(this.localeCode);
                this.oldLocaleCode = this.localeCode;
            } else {
                this.backgroundSpellChecker.setLocale(this.oldLocaleCode);
            }
        }
        catch (TextAnalyzerException exp) {
            if (exp.errorCode == 6) {
                MessageDialog.openInformation((Shell)this.webBrowser.getShell(), (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_NoEngine);
            }
            if (exp.errorCode == 4) {
                MessageDialog.openInformation((Shell)this.webBrowser.getShell(), (String)RTENLS.rteSpellChecker_SpellChecker, (String)RTENLS.rteSpellChecker_NoNLDirection);
            }
            this.enableBackgroundSpellchecking = false;
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return false;
        }
        if (enable) {
            this.addMisspellingStyle();
            this.misspellContextMenuListener = new DefaultRTEEventListener();
            this.addDocumentEventListener("contextmenu", this.misspellContextMenuListener);
            this.markedMisspelledWordsInWholeDocument();
        } else {
            this.backgroundSpellChecker.dispose();
            this.backgroundSpellChecker = null;
            this.removeMisspellingStyle();
            this.removeMisspellInfo();
            if (this.misspellContextMenuListener != null) {
                this.removeDocumentEventListener("contextmenu", this.misspellContextMenuListener);
                this.misspellContextMenuListener = null;
            }
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return true;
    }

    public void removeMisspellInfo() {
        String method_Name = "removeMisspellInfo";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        NodeList spanElements = this.htmlDoc.getElementsByTagName("SPAN");
        int spanElementsNum = spanElements.getLength();
        int i = spanElementsNum - 1;
        while (i >= 0) {
            Node spanElement = spanElements.item(i);
            if (((JHTMLElement)spanElement).hasAttribute("MISSPELLED")) {
                Node parent = spanElement.getParentNode();
                String NodeValue = this.getDocContent(spanElement).trim();
                org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(NodeValue);
                parent.insertBefore(textNode, spanElement);
                parent.removeChild(spanElement);
            }
            --i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private boolean enableLocalImageLoad() {
        return DOMBrowser.enableLocalImageLoad();
    }

    private void markedMisspelledWordsInWholeDocument() {
        HTMLElement bodyNode = this.htmlDoc.getBody();
        this.markedMispelledWord(bodyNode);
    }

    private void addMisspellingStyle() {
        String method_Name = "addMisspellingStyle";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JHTMLElement elem = (JHTMLElement)this.htmlDoc.getElementsByTagName("head").item(0);
        String headContent = elem.getInnerHTML();
        headContent = String.valueOf(headContent) + "<style>SPAN.misspelling {border-bottom-style: solid;border-bottom-width: thin;border-bottom-color: red }</style>";
        elem.setInnerHTML(headContent);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void removeMisspellingStyle() {
        String method_Name = "removeMisspellingStyle";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JHTMLElement elem = (JHTMLElement)this.htmlDoc.getElementsByTagName("head").item(0);
        String headContent = elem.getInnerHTML();
        int index = headContent.indexOf("<style>SPAN.misspelling {border-bottom-style: solid;border-bottom-width: thin;border-bottom-color: red }</style>");
        if (index != -1) {
            headContent = String.valueOf(headContent.substring(0, index)) + headContent.substring(index + "<style>SPAN.misspelling {border-bottom-style: solid;border-bottom-width: thin;border-bottom-color: red }</style>".length());
            elem.setInnerHTML(headContent);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void invokeBackgroundSpellchecking(Node node, int type, String word) {
        String method_Name = "invokeBackgroundSpellchecking";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (node == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            switch (type) {
                case 1: {
                    if (this.isMisspelledNode(node)) {
                        HTMLElement previousSibling = this.getPreviousMisspelledWordNode(node);
                        String previousNodeValue = this.getDocContent(previousSibling).trim();
                        String NodeValue = this.getDocContent(node);
                        NodeValue = String.valueOf(previousNodeValue) + NodeValue;
                        MisspelledWord[] misSpellWords = this.getMisSpelledWords(NodeValue);
                        if (misSpellWords == null) {
                            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                            return;
                        }
                        Node parent = node.getParentNode();
                        org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(NodeValue);
                        if (misSpellWords.length == 0) {
                            if (previousSibling != null && this.isMisspelledNode(previousSibling)) {
                                parent.insertBefore(textNode, previousSibling);
                                parent.removeChild(previousSibling);
                                parent.removeChild(node);
                            } else {
                                parent.insertBefore(textNode, node);
                                parent.removeChild(node);
                            }
                        } else if (misSpellWords.length == 1 && !misSpellWords[0].getWord().equals(NodeValue)) {
                            parent.insertBefore(textNode, node);
                            parent.removeChild(node);
                            this.markedMispelledWord(parent);
                        }
                    }
                    this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                    return;
                }
                case 2: {
                    if (this.isMisspelledNode(node)) {
                        if (word != null && word.equalsIgnoreCase("Ignore")) {
                            ((JHTMLElement)node).setAttribute("IGNORED", "1");
                            ((JHTMLElement)node).removeAttribute("class");
                        } else {
                            HTMLElement previousSibling = this.getPreviousMisspelledWordNode(node);
                            if (previousSibling != null && previousSibling instanceof JHTMLElement) {
                                Node parent = node.getParentNode();
                                String NodeValue = this.getDocContent(node).trim();
                                NodeValue = String.valueOf(this.getDocContent(previousSibling).trim()) + NodeValue;
                                org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(NodeValue);
                                parent.insertBefore(textNode, previousSibling);
                                parent.removeChild(node);
                                parent.removeChild(previousSibling);
                            } else {
                                Node parent = node.getParentNode();
                                String NodeValue = this.getDocContent(node).trim();
                                org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(NodeValue);
                                parent.insertBefore(textNode, node);
                                parent.removeChild(node);
                            }
                        }
                    }
                    this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                    return;
                }
                case 3: {
                    this.removeMisspellInfo();
                    this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                    return;
                }
                case 4: {
                    Node parent = node.getParentNode();
                    org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(word);
                    parent.insertBefore(textNode, node);
                    parent.removeChild(node);
                    this.dirty = true;
                    this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                    return;
                }
                case 5: {
                    this.markedMispelledWord(node);
                    this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg29, (Exception)e);
        }
    }

    private boolean isMisspelledNode(Node node) {
        return node instanceof JHTMLElement && ((JHTMLElement)node).hasAttribute("MISSPELLED");
    }

    private HTMLElement getPreviousMisspelledWordNode(Node node) {
        String method_Name = "getPreviousMisspelledWordNode";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (node.getPreviousSibling() != null) {
            Node previousSibling = null;
            previousSibling = node.getPreviousSibling();
            Node parentNode = previousSibling.getParentNode();
            while (previousSibling instanceof JText && previousSibling.getNodeValue().equals("")) {
                parentNode.removeChild(previousSibling);
                previousSibling = node.getPreviousSibling();
            }
            if (this.isMisspelledNode(previousSibling)) {
                this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                return (JHTMLElement)previousSibling;
            }
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return null;
    }

    private void ignoreAll(String ignoreWord) {
        JRange range;
        String method_Name = "ignoreAll";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        HTMLElement curNode = this.htmlDoc.getBody();
        if (((JHTMLElement)curNode).hasAttribute("MISSPELLED")) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        String NodeValue = this.getDocContent(curNode);
        if (NodeValue.equals("")) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        JSelection sel = this.htmlWin.getSelection();
        JRange cursorBakRange = range = sel.getRangeAt(0);
        this.setCursorPosition(curNode, 0);
        String misSpellWord = ignoreWord;
        while (this.FindNextEntiredWord(misSpellWord, (Node)curNode, NodeValue, "IgnoreAll")) {
            range = this.htmlWin.getSelection().getRangeAt(0);
            if (!((JHTMLElement)range.getStartContainer().getParentNode()).hasAttribute("MISSPELLED")) continue;
            Node cNode = range.getStartContainer().getParentNode();
            Node pNode = cNode.getParentNode();
            org.w3c.dom.Text textNode = this.htmlDoc.createTextNode(misSpellWord);
            pNode.insertBefore(textNode, cNode);
            pNode.removeChild(cNode);
        }
        sel.addRange(cursorBakRange);
        sel.collapseToEnd();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void autoCorrect(String misSpellWord, String correctWord) {
        JRange range;
        String method_Name = "autoCorrect";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        HTMLElement curNode = this.htmlDoc.getBody();
        if (((JHTMLElement)curNode).hasAttribute("MISSPELLED")) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        String NodeValue = this.getDocContent(curNode);
        if (NodeValue.equals("")) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        JSelection sel = this.htmlWin.getSelection();
        JRange cursorBakRange = range = sel.getRangeAt(0);
        this.setCursorPosition(curNode, 0);
        while (this.FindNextEntiredWord(misSpellWord, (Node)curNode, NodeValue, "AutoCorrect")) {
            range = this.htmlWin.getSelection().getRangeAt(0);
            if (((JHTMLElement)range.getStartContainer().getParentNode()).hasAttribute("MISSPELLED")) {
                Node cNode = range.getStartContainer().getParentNode();
                Node pNode = cNode.getParentNode();
                org.w3c.dom.Text textNode = this.htmlDoc.createTextNode(correctWord);
                pNode.insertBefore(textNode, cNode);
                pNode.removeChild(cNode);
                continue;
            }
            org.w3c.dom.Text insertTextNode = this.htmlDoc.createTextNode(correctWord);
            this.insertMisspelledNodeAtSelection(insertTextNode);
        }
        sel.addRange(cursorBakRange);
        sel.collapseToEnd();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void markedMispelledWord(Node node) {
        JRange range;
        String method_Name = "markedMispelledWord";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY", node);
        int numSuggestions = 5;
        Node curNode = node;
        if (((JHTMLElement)curNode).hasAttribute("MISSPELLED")) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        String NodeValue = this.getDocContent(curNode);
        if (NodeValue.equals("")) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        JSelection sel = this.htmlWin.getSelection();
        JRange cursorBakRange = range = sel.getRangeAt(0);
        MisspelledWord[] misSpellWords = this.getMisSpelledWords(NodeValue);
        if (misSpellWords == null || misSpellWords.length == 0) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        this.setCursorPosition(curNode, 0);
        int i = 0;
        while (i < misSpellWords.length) {
            MisspelledWord speltWord = misSpellWords[i];
            String misSpellWord = speltWord.getWord();
            if (this.FindNextEntiredWord(speltWord, curNode, NodeValue, null) && !this.BackgroundSpellchecking_Ignore_Words.contains(misSpellWord)) {
                if (this.BackgroundSpellchecking_Auto_Correct.containsKey(misSpellWord)) {
                    String correctWord = (String)this.BackgroundSpellchecking_Auto_Correct.get(misSpellWord);
                    org.w3c.dom.Text insertTextNode = this.htmlDoc.createTextNode(correctWord);
                    this.insertMisspelledNodeAtSelection(insertTextNode);
                } else {
                    range = this.htmlWin.getSelection().getRangeAt(0);
                    if (!((JHTMLElement)range.getStartContainer().getParentNode()).hasAttribute("MISSPELLED")) {
                        String[] suggestions = speltWord.getSuggestions();
                        if (suggestions == null) {
                            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
                            return;
                        }
                        numSuggestions = suggestions.length < 5 ? suggestions.length : 5;
                        String strSuggestions = "";
                        int j = 0;
                        while (j < numSuggestions) {
                            strSuggestions = String.valueOf(strSuggestions) + suggestions[j] + "/";
                            ++j;
                        }
                        JHTMLElement markedMisspellWord = (JHTMLElement)this.getHtmlDocInstance().createElement("span");
                        markedMisspellWord.setAttribute("CLASS", "misspelling");
                        markedMisspellWord.setAttribute("MISSPELLED", "1");
                        markedMisspellWord.setAttribute("SUGGESTIONS", strSuggestions);
                        org.w3c.dom.Text textNode = this.getHtmlDocInstance().createTextNode(misSpellWord);
                        markedMisspellWord.appendChild((Node)textNode);
                        this.insertMisspelledNodeAtSelection((Node)markedMisspellWord);
                    }
                }
            }
            ++i;
        }
        sel.addRange(cursorBakRange);
        sel.collapseToEnd();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private MisspelledWord[] getMisSpelledWords(String text) {
        return this.backgroundSpellChecker.checkSpelling(text, 5, false);
    }

    private boolean FindNextEntiredWord(MisspelledWord speltWord, Node curNode, String nodeValue, String tag) {
        String method_Name = "FindNextEntiredWord";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        String misSpellWord = speltWord.getWord();
        if (tag == null) {
            tag = "";
        }
        boolean[] retVal = new boolean[1];
        boolean entired = false;
        this.setCursorPosition(curNode, 0);
        WebBrowserFind findObj = this.webBrowser.getFindObject();
        findObj.SetEntireWord(true);
        findObj.SetFindBackwards(false);
        findObj.SetMatchCase(true);
        char[] charArray = new char[misSpellWord.length() + 1];
        misSpellWord.getChars(0, misSpellWord.length(), charArray, 0);
        charArray[charArray.length - 1] = '\u0000';
        findObj.SetSearchString(charArray);
        findObj.FindNext(retVal);
        if (!retVal[0]) {
            entired = false;
        } else {
            String NodeValue = nodeValue;
            int length = misSpellWord.length();
            int occurance = NodeValue.indexOf(misSpellWord);
            while (occurance > -1) {
                if (occurance == speltWord.getBeginIndex()) {
                    entired = true;
                    break;
                }
                findObj.FindNext(retVal);
                if (!retVal[0]) {
                    entired = false;
                    break;
                }
                occurance = NodeValue.indexOf(misSpellWord, occurance + length);
            }
        }
        findObj.Release();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return entired;
    }

    private boolean FindNextEntiredWord(String misSpellWord, Node curNode, String nodeValue, String tag) {
        String method_Name = "FindNextEntiredWord2";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (tag == null) {
            tag = "";
        }
        boolean[] retVal = new boolean[1];
        boolean entired = false;
        this.setCursorPosition(curNode, 0);
        WebBrowserFind findObj = this.webBrowser.getFindObject();
        findObj.SetEntireWord(true);
        findObj.SetFindBackwards(false);
        findObj.SetMatchCase(true);
        char[] charArray = new char[misSpellWord.length() + 1];
        misSpellWord.getChars(0, misSpellWord.length(), charArray, 0);
        charArray[charArray.length - 1] = '\u0000';
        findObj.SetSearchString(charArray);
        findObj.FindNext(retVal);
        if (!retVal[0]) {
            entired = false;
        } else {
            String NodeValue = nodeValue;
            int length = misSpellWord.length();
            int occurance = NodeValue.indexOf(misSpellWord);
            while (occurance > -1) {
                char startChar;
                String extendWord;
                char endChar;
                if (NodeValue.indexOf(misSpellWord) == NodeValue.lastIndexOf(misSpellWord)) {
                    entired = true;
                }
                if (occurance == 0) {
                    entired = NodeValue.equals(misSpellWord) ? true : !((endChar = (extendWord = NodeValue.substring(0, length + 1)).charAt(extendWord.length() - 1)) >= 'a' && endChar <= 'z' || endChar >= 'A' && endChar <= 'Z');
                } else if (occurance == NodeValue.length() - length) {
                    extendWord = NodeValue.substring(occurance - 1);
                    startChar = extendWord.charAt(0);
                    entired = !(startChar >= 'a' && startChar <= 'z' || startChar >= 'A' && startChar <= 'Z');
                } else {
                    extendWord = NodeValue.substring(occurance - 1, occurance + length + 1);
                    startChar = extendWord.charAt(0);
                    endChar = extendWord.charAt(extendWord.length() - 1);
                    boolean bl = entired = !(startChar >= 'a' && startChar <= 'z' || startChar >= 'A' && startChar <= 'Z' || endChar >= 'a' && endChar <= 'z' || endChar >= 'A' && endChar <= 'Z');
                }
                if (entired) {
                    JRange range = this.htmlWin.getSelection().getRangeAt(0);
                    if (((JHTMLElement)range.getStartContainer().getParentNode()).hasAttribute("MISSPELLED")) {
                        if (!tag.equalsIgnoreCase("")) break;
                        findObj.FindNext(retVal);
                        entired = false;
                    } else {
                        if (tag.equalsIgnoreCase("")) break;
                        findObj.FindNext(retVal);
                        entired = false;
                    }
                } else {
                    findObj.FindNext(retVal);
                }
                occurance = NodeValue.indexOf(misSpellWord, occurance + length);
            }
        }
        findObj.Release();
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return entired;
    }

    private Node insertMisspelledNodeAtSelection(Node newNode) {
        String method_Name = "insertMisspelledNodeAtSelection";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JSelection sel = this.htmlWin.getSelection();
        JRange range = sel.getRangeAt(0);
        sel.removeAllRanges();
        range.deleteContents();
        Node container = range.getStartContainer();
        int pos = range.getStartOffset();
        JRange newRange = this.htmlDoc.createRange();
        if (newRange == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return null;
        }
        Node afterNode = null;
        if (container.getNodeType() == 3) {
            Node textNode = container;
            container = textNode.getParentNode();
            String text = textNode.getNodeValue();
            String textBefore = text.substring(0, pos);
            String textAfter = text.substring(pos);
            org.w3c.dom.Text beforeNode = this.htmlDoc.createTextNode(textBefore);
            afterNode = this.htmlDoc.createTextNode(textAfter);
            container.insertBefore(beforeNode, textNode);
            container.insertBefore(newNode, textNode);
            afterNode = container.insertBefore(afterNode, textNode);
            container.removeChild(textNode);
        } else {
            afterNode = container.getChildNodes().item(pos);
            newNode = afterNode != null ? container.insertBefore(newNode, afterNode) : (container instanceof JHTMLBRElement ? container.getParentNode().insertBefore(newNode, container) : container.appendChild(newNode));
        }
        if (afterNode != null) {
            newRange.setEndAfter(afterNode);
        } else {
            newRange.setEndAfter(newNode);
        }
        sel.addRange(newRange);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
        return newNode;
    }

    private String[] split(String target, String regex) {
        if (target == null || regex == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(target, regex);
        Vector<String> strVector = new Vector<String>();
        int i = 0;
        while (st.hasMoreTokens()) {
            strVector.add(i, st.nextToken());
            ++i;
        }
        String[] returnStrs = new String[i];
        int j = 0;
        while (j < i) {
            returnStrs[j] = (String)strVector.get(j);
            ++j;
        }
        return returnStrs;
    }

    public String getAllTextString() {
        HTMLElement parent = this.htmlDoc.getBody();
        return this.getDocContent(parent);
    }

    public boolean makeSelection(String selText, boolean isFirstSearch) {
        if (isFirstSearch) {
            this.resetCursor();
        }
        WebBrowserFind findObj = this.webBrowser.getFindObject();
        char[] strselText = selText.toCharArray();
        char[] buff = new char[strselText.length + 1];
        System.arraycopy(strselText, 0, buff, 0, strselText.length);
        findObj.SetSearchString(buff);
        findObj.SetEntireWord(true);
        findObj.SetFindBackwards(false);
        findObj.SetMatchCase(false);
        findObj.SetWrapFind(false);
        boolean[] retVal = new boolean[1];
        findObj.FindNext(retVal);
        findObj.Release();
        return retVal[0];
    }

    public void replace(String newWord) {
        org.w3c.dom.Text newStr = this.htmlDoc.createTextNode(newWord);
        this.insertNodeAtSelection(newStr);
        this.dirty = true;
        if (this.enableBackgroundSpellchecking) {
            Node node = this.getCursorPositionNode();
            int style = 1;
            this.invokeBackgroundSpellchecking(node, style, null);
        }
    }

    public Element createHTMLElement(String tag) {
        return this.getHtmlDocInstance().createElement(tag);
    }

    public Element queryHTMLElementByID(String ID) {
        return this.getHtmlDocInstance().getElementById(ID);
    }

    public void removeHTMLElement(Element elem) {
        elem.getParentNode().removeChild(elem);
        this.dirty = true;
    }

    public void setUrl(String url) {
        String method_Name = "setUrl";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (url == null | url.trim().length() == 0) {
            url = "about:blank";
        }
        if (!url.equalsIgnoreCase("about:blank")) {
            try {
                URL u = new URL(url);
                if (u.getProtocol().equalsIgnoreCase("ftp")) {
                    url = "about:blank";
                }
            }
            catch (Exception exception) {
                try {
                    File f = new File(url);
                    if (!f.exists()) {
                        url = "about:blank";
                    }
                }
                catch (Exception exception2) {
                    url = "about:blank";
                }
            }
        }
        this.isLoadCompleted = false;
        this.isUrlSetting = true;
        this.webBrowser.setUrl(url);
        int counter = 0;
        while (!this.isLoadCompleted && counter < 1000) {
            Shell shell;
            try {
                shell = this.getShell();
            }
            catch (Exception exception) {
                ++counter;
                continue;
            }
            RichTextEditor.runLoopTimer(shell, 5);
            ++counter;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addCompletedListener(final RTEEventListener listener) {
        String method_Name = "addCompletedListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.webBrowser == null || listener == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent e) {
            }

            public void completed(ProgressEvent e) {
                String method_Name = "addCompletedListener::ProgressListener::completed";
                RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
                try {
                    RTEEvent initDoneEvent = new RTEEvent();
                    initDoneEvent.setType(8);
                    listener.handleEvent(initDoneEvent);
                }
                catch (RTEException rteEx) {
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "THROW", rteEx);
                    RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg01, (Exception)((Object)rteEx));
                }
                catch (Exception unknownEx) {
                    RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "THROW", unknownEx);
                    RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg31, (Exception)unknownEx);
                }
                RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
            }
        };
        this.completedListener.put(listener, progressListener);
        this.webBrowser.addProgressListener(progressListener);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeCompletedListener(RTEEventListener listener) {
        String method_Name = "removeCompletedListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.webBrowser == null || listener == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        ProgressListener progressListener = (ProgressListener)this.completedListener.remove(listener);
        if (progressListener != null) {
            this.webBrowser.removeProgressListener(progressListener);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addListener(Element elem, String tag, EventListener lis) {
        String method_Name = "addListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JHTMLElement jelem = (JHTMLElement)elem;
        jelem.addEventListener(tag, lis, true);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeListener(Element elem, String tag, EventListener lis) {
        String method_Name = "removeListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        JHTMLElement jelem = (JHTMLElement)elem;
        jelem.removeEventListener(tag, lis, true);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void addSystemDocumentEventListener(String docEvent, EventListener eListen) throws RTEException {
        String method_Name = "addSystemDocumentEventListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            this.htmlDoc.addEventListener(docEvent, eListen, true);
            ArrayList<EventListener> listeners = (ArrayList<EventListener>)this.systemDocumentEventListeners.remove(docEvent);
            if (listeners == null) {
                listeners = new ArrayList<EventListener>();
            }
            listeners.add(eListen);
            this.systemDocumentEventListeners.put(docEvent, listeners);
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg03, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void removeAllSystemDocumentEventListener() throws RTEException {
        String method_Name = "removeAllSystemDocumentEventListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        String type = "removeAllSystemDocumentEventListener";
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            Iterator it = this.systemDocumentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.systemDocumentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.removeEventListener(type, listener, true);
                }
            }
            this.systemDocumentEventListeners.clear();
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void addDocumentEventListener(String docEvent, EventListener eListen) throws RTEException {
        String method_Name = "addDocumentEventListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            this.htmlDoc.addEventListener(docEvent, eListen, true);
            ArrayList<EventListener> listeners = (ArrayList<EventListener>)this.documentEventListeners.remove(docEvent);
            if (listeners == null) {
                listeners = new ArrayList<EventListener>();
            }
            listeners.add(eListen);
            this.documentEventListeners.put(docEvent, listeners);
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg03, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeDocumentEventListener(String type, EventListener eListen) throws RTEException {
        String method_Name = "removeDocumentEventListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            this.htmlDoc.removeEventListener(type, eListen, true);
            ArrayList listeners = (ArrayList)this.documentEventListeners.remove(type);
            if (listeners == null) {
                listeners = new ArrayList();
            }
            listeners.remove(eListen);
            this.documentEventListeners.put(type, listeners);
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeAllDocumentEventListener() throws RTEException {
        String method_Name = "removeAllDocumentEventListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        String type = "removeAllDocumentEventListener";
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            Iterator it = this.documentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.documentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.removeEventListener(type, listener, true);
                }
            }
            this.documentEventListeners.clear();
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void removeAllDocEventListenerFromCurrentDoc() throws RTEException {
        String method_Name = "removeAllDocEventListenerFromCurrentDoc";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        String type = "removeAllDocEventListenerFromCurrentDoc";
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            Iterator it = this.documentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.documentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.removeEventListener(type, listener, true);
                }
            }
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void addAllDocEventListenerToCurrentDoc() throws RTEException {
        String method_Name = "addAllDocEventListenerToCurrentDoc";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        String type = "addAllDocEventListenerFromCurrentDoc";
        if (this.htmlDoc == null) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
            return;
        }
        try {
            Iterator it = this.documentEventListeners.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                ArrayList listeners = (ArrayList)this.documentEventListeners.get(type);
                ListIterator itArray = listeners.listIterator();
                while (itArray.hasNext()) {
                    EventListener listener = (EventListener)itArray.next();
                    this.htmlDoc.addEventListener(type, listener, true);
                }
            }
        }
        catch (Exception e) {
            this.logger.logp(this.level, this.CLZ_Name, method_Name, "THROW", e);
            RTEExceptionHelper.handleRTEFault((String)RTENLS.Err_Msg30, (Exception)e);
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public String queryCommandValue(String commandID) {
        try {
            String retV = this.getHtmlDocInstance().queryCommandValue(commandID);
            return retV;
        }
        catch (JDOMException jDOMException) {
            return null;
        }
    }

    public boolean queryCommandSupported(String commandID) {
        try {
            boolean retV = this.getHtmlDocInstance().queryCommandSupported(commandID);
            return retV;
        }
        catch (JDOMException jDOMException) {
            return false;
        }
    }

    public boolean queryCommandState(String commandID) {
        try {
            boolean retV = this.getHtmlDocInstance().queryCommandState(commandID);
            return retV;
        }
        catch (JDOMException jDOMException) {
            return false;
        }
    }

    public boolean queryCommandIndeterm(String commandID) {
        try {
            boolean retV = this.getHtmlDocInstance().queryCommandIndeterm(commandID);
            return retV;
        }
        catch (JDOMException jDOMException) {
            return false;
        }
    }

    public boolean queryCommandEnabled(String commandID) {
        try {
            boolean retV = this.getHtmlDocInstance().queryCommandEnabled(commandID);
            return retV;
        }
        catch (JDOMException jDOMException) {
            return false;
        }
    }

    public void setToolBarBackColor(String color) {
        if (this._toolPalette != null) {
            try {
                if (color.length() != 7) {
                    return;
                }
                color = color.substring(1, 7);
                int icolor = Integer.parseInt(color, 16);
                RGB rgb = new RGB((icolor & 0xFF0000) >> 16, (icolor & 0xFF00) >> 8, icolor & 0xFF);
                Color c = new Color((Device)Display.getCurrent(), rgb);
                this._toolPalette.setBarBackGround(c);
                ((Composite)this._toolPalette).setBackground(c);
                this.dirty = true;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void addNavigationListener(NavigationEventListener navigationListener) {
        String method_Name = "addNavigationListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.navigationListeners.add(navigationListener);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public void removeNavigationListener(NavigationEventListener navigationListener) {
        String method_Name = "removeNavigationListener";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        this.navigationListeners.remove(navigationListener);
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    private void fireNavigationEvent(NavigationEvent e) {
        String method_Name = "fireNavigationEvent";
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "ENTRY");
        int i = 0;
        while (i < this.navigationListeners.size()) {
            ((NavigationEventListener)this.navigationListeners.get(i)).navigate(e);
            ++i;
        }
        this.logger.logp(this.level, this.CLZ_Name, method_Name, "RETURN");
    }

    public boolean isToolBarLocked() {
        if (this._toolPalette != null) {
            return this._toolPalette.getLocked();
        }
        return false;
    }

    public void lockToolBar(boolean locked) {
        if (this._toolPalette != null) {
            this._toolPalette.setLocked(locked);
        }
    }

    static /* synthetic */ ArrayList access$14(RichTextEditor richTextEditor) {
        return richTextEditor.BackgroundSpellchecking_Ignore_Words;
    }

    static /* synthetic */ void access$15(RichTextEditor richTextEditor, String string) {
        richTextEditor.ignoreAll(string);
    }

    static /* synthetic */ Map access$16(RichTextEditor richTextEditor) {
        return richTextEditor.BackgroundSpellchecking_Auto_Correct;
    }

    static /* synthetic */ void access$17(RichTextEditor richTextEditor, String string, String string2) {
        richTextEditor.autoCorrect(string, string2);
    }

    private class SearchReplaceDialog
    extends Dialog {
        private Text textFind;
        private Text textReplace;
        private Button chkMatchCase;
        private Button chkEntireWord;
        private Button btReplaceAll;
        private Button btReplace;
        private Button btFind;
        private Button btCancel;
        private String strSearch;
        private String strReplace;
        private boolean isMatchCase;
        private boolean isWrap;
        private boolean isBackwards;
        private boolean isEntireWord;
        private Shell shell;
        private Display display = this.getParent().getDisplay();
        private JRange currentRange = null;
        private JRange firstRange = null;
        private JRange firstReplaceRange = null;
        private boolean isFirst = true;
        private boolean isFirstReplace = true;
        private final int START_TO_START = 0;
        private final int END_TO_END = 2;

        public SearchReplaceDialog(Shell parent) {
            super(parent);
            this.shell = new Shell(this.getParent(), 2144);
        }

        private void setReplaceBtnStatus(Control control) {
            control.addFocusListener(new FocusListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void focusGained(FocusEvent e) {
                    if (RichTextEditor.access$0(SearchReplaceDialog.access$6(this.this$1)).getSelection() == null || RichTextEditor.access$0(SearchReplaceDialog.access$6(this.this$1)).getSelection().length() < 1) {
                        SearchReplaceDialog.access$0(this.this$1).setEnabled(false);
                        SearchReplaceDialog.access$1(this.this$1).setEnabled(false);
                    } else {
                        SearchReplaceDialog.access$0(this.this$1).setEnabled(true);
                        SearchReplaceDialog.access$1(this.this$1).setEnabled(true);
                    }
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }

        public void open() {
            this.shell.setText(RTENLS.rteFindReplace_FindReplaceDialog);
            this.shell.setSize(410, 190);
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 410) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 180) / 2);
            Label label = new Label((Composite)this.shell, 0);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 20);
            formData.bottom = new FormAttachment(0, 45);
            formData.right = new FormAttachment(0, 180);
            formData.left = new FormAttachment(0, 20);
            label.setLayoutData((Object)formData);
            label.setText(RTENLS.rteFindReplace_SearchForValue);
            this.textFind = new Text((Composite)this.shell, 2052);
            FormData formData_1 = new FormData();
            formData_1.top = new FormAttachment((Control)label, -5, 128);
            formData_1.bottom = new FormAttachment((Control)label, 20, 128);
            formData_1.right = new FormAttachment((Control)label, 205, 131072);
            formData_1.left = new FormAttachment((Control)label, 10, 131072);
            this.textFind.setLayoutData((Object)formData_1);
            this.textFind.setToolTipText(RTENLS.rteFindReplace_StrToSearch);
            this.textFind.setFocus();
            this.setReplaceBtnStatus((Control)this.textFind);
            this.textFind.addModifyListener(new ModifyListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void modifyText(ModifyEvent e) {
                    if (SearchReplaceDialog.access$2(this.this$1).getText().equals("")) {
                        SearchReplaceDialog.access$3(this.this$1).setEnabled(false);
                    } else {
                        SearchReplaceDialog.access$3(this.this$1).setEnabled(true);
                    }
                }
            });
            this.textFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.beginFind();
                }
            });
            Label label_r = new Label((Composite)this.shell, 0);
            FormData formData_r = new FormData();
            formData_r.top = new FormAttachment((Control)label, 10, 1024);
            formData_r.bottom = new FormAttachment((Control)label, 30, 1024);
            formData_r.right = new FormAttachment((Control)label, 0, 131072);
            formData_r.left = new FormAttachment((Control)label, 0, 16384);
            label_r.setLayoutData((Object)formData_r);
            label_r.setText(RTENLS.rteFindReplace_ReplaceForValue);
            this.textReplace = new Text((Composite)this.shell, 2052);
            FormData formData_R = new FormData();
            formData_R.top = new FormAttachment((Control)label, 5, 1024);
            formData_R.bottom = new FormAttachment((Control)label, 30, 1024);
            formData_R.right = new FormAttachment((Control)label, 205, 131072);
            formData_R.left = new FormAttachment((Control)label, 10, 131072);
            this.textReplace.setLayoutData((Object)formData_R);
            this.textReplace.setToolTipText(RTENLS.rteFindReplace_StrToReplace);
            this.setReplaceBtnStatus((Control)this.textReplace);
            this.chkMatchCase = new Button((Composite)this.shell, 50);
            FormData formData_2 = new FormData();
            formData_2.top = new FormAttachment((Control)label, 40, 1024);
            formData_2.bottom = new FormAttachment((Control)label, 60, 1024);
            formData_2.right = new FormAttachment((Control)label, 0, 131072);
            formData_2.left = new FormAttachment((Control)label, 0, 16384);
            this.chkMatchCase.setLayoutData((Object)formData_2);
            this.chkMatchCase.setText(RTENLS.rteFindReplace_Matchcase);
            this.setReplaceBtnStatus((Control)this.chkMatchCase);
            Label lDirection = new Label((Composite)this.shell, 0);
            FormData formData_3 = new FormData();
            formData_3.top = new FormAttachment((Control)label, 42, 1024);
            formData_3.bottom = new FormAttachment((Control)label, 62, 1024);
            formData_3.right = new FormAttachment((Control)label, 80, 131072);
            formData_3.left = new FormAttachment((Control)label, 10, 131072);
            lDirection.setLayoutData((Object)formData_3);
            lDirection.setText(RTENLS.rteFindReplace_Directions);
            Combo cbDirection = new Combo((Composite)this.shell, 2074);
            FormData formData_c = new FormData();
            formData_c.top = new FormAttachment((Control)label, 38, 1024);
            formData_c.bottom = new FormAttachment((Control)label, 58, 1024);
            formData_c.right = new FormAttachment((Control)label, 205, 131072);
            formData_c.left = new FormAttachment((Control)label, 90, 131072);
            cbDirection.setLayoutData((Object)formData_c);
            String[] itemDirections = new String[]{RTENLS.rteFindReplace_SearchDown, RTENLS.rteFindReplace_SearchUp, RTENLS.rteFindReplace_SearchAll};
            cbDirection.setItems(itemDirections);
            cbDirection.select(0);
            this.setReplaceBtnStatus((Control)cbDirection);
            cbDirection.addSelectionListener(new SelectionListener(this, cbDirection){
                final /* synthetic */ SearchReplaceDialog this$1;
                private final /* synthetic */ Combo val$cbDirection;
                {
                    this.this$1 = searchReplaceDialog;
                    this.val$cbDirection = combo;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.val$cbDirection.getSelectionIndex() == 0) {
                        SearchReplaceDialog.access$4(this.this$1, false);
                        SearchReplaceDialog.access$5(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 1) {
                        SearchReplaceDialog.access$4(this.this$1, true);
                        SearchReplaceDialog.access$5(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 2) {
                        SearchReplaceDialog.access$5(this.this$1, true);
                        SearchReplaceDialog.access$4(this.this$1, false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.chkEntireWord = new Button((Composite)this.shell, 50);
            FormData formData_5 = new FormData();
            formData_5.top = new FormAttachment((Control)label, 80, 1024);
            formData_5.bottom = new FormAttachment((Control)label, 100, 1024);
            formData_5.right = new FormAttachment((Control)label, 190, 131072);
            formData_5.left = new FormAttachment((Control)label, 100, 131072);
            this.chkEntireWord.setLayoutData((Object)formData_5);
            this.chkEntireWord.setText(RTENLS.rteFindReplace_Matchentireword);
            this.chkEntireWord.setVisible(false);
            this.btReplace = new Button((Composite)this.shell, 0);
            FormData formData_RB = new FormData();
            formData_RB.top = new FormAttachment((Control)label, 80, 1024);
            formData_RB.bottom = new FormAttachment((Control)label, 106, 1024);
            formData_RB.right = new FormAttachment((Control)label, 75, 16384);
            formData_RB.left = new FormAttachment((Control)label, 0, 16384);
            this.btReplace.setLayoutData((Object)formData_RB);
            this.btReplace.setEnabled(false);
            this.btReplace.setText(RTENLS.rteFindReplace_Replace);
            this.setReplaceBtnStatus((Control)this.btReplace);
            this.btReplace.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.beginReplace();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btReplaceAll = new Button((Composite)this.shell, 0);
            FormData formData_RA = new FormData();
            formData_RA.top = new FormAttachment((Control)label, 80, 1024);
            formData_RA.bottom = new FormAttachment((Control)label, 106, 1024);
            formData_RA.right = new FormAttachment((Control)label, 175, 16384);
            formData_RA.left = new FormAttachment((Control)label, 90, 16384);
            this.btReplaceAll.setLayoutData((Object)formData_RA);
            this.btReplaceAll.setEnabled(false);
            this.btReplaceAll.setText(RTENLS.rteFindReplace_ReplaceAll);
            this.setReplaceBtnStatus((Control)this.btReplaceAll);
            this.btReplaceAll.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.replaceAll();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btFind = new Button((Composite)this.shell, 0);
            FormData formData_6 = new FormData();
            formData_6.top = new FormAttachment((Control)label, 80, 1024);
            formData_6.bottom = new FormAttachment((Control)label, 106, 1024);
            formData_6.right = new FormAttachment((Control)label, 110, 131072);
            formData_6.left = new FormAttachment((Control)label, 35, 131072);
            this.btFind.setLayoutData((Object)formData_6);
            this.btFind.setText(RTENLS.rteFindReplace_FindNext);
            this.btFind.setEnabled(false);
            this.btFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.beginFind();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.btCancel = new Button((Composite)this.shell, 0);
            FormData formData_7 = new FormData();
            formData_7.top = new FormAttachment((Control)label, 80, 1024);
            formData_7.bottom = new FormAttachment((Control)label, 106, 1024);
            formData_7.right = new FormAttachment((Control)label, 200, 131072);
            formData_7.left = new FormAttachment((Control)label, 125, 131072);
            this.btCancel.setLayoutData((Object)formData_7);
            this.btCancel.setText(RTENLS.rteFindReplace_Cancel);
            this.btCancel.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchReplaceDialog this$1;
                {
                    this.this$1 = searchReplaceDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.close();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.shell.layout();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }

        public void close() {
            this.shell.dispose();
            if (!this.display.readAndDispatch()) {
                this.display.sleep();
            }
        }

        public void beginFind() {
            if (!this.FindNext()) {
                this.showWarningDialog(RTENLS.rteFindReplace_StrNotFound);
            } else {
                if (!this.btReplace.isEnabled()) {
                    this.btReplace.setEnabled(true);
                }
                if (!this.btReplaceAll.isEnabled()) {
                    this.btReplaceAll.setEnabled(true);
                }
            }
            this.textFind.setFocus();
        }

        private void showWarningDialog(String keyMessage) {
            this.WarningDialog(keyMessage);
            if (this.isWrap()) {
                this.isFirst = true;
                this.isFirstReplace = true;
            }
        }

        private boolean isReplaced(JRange range, int offset) {
            JRange currPosBak = range.cloneRange();
            currPosBak.setStart(currPosBak.getStartContainer(), currPosBak.getStartOffset() - offset);
            currPosBak.setEnd(currPosBak.getStartContainer(), currPosBak.getEndOffset() + this.strReplace.length() - this.strSearch.length() - offset);
            return currPosBak.compareBoundaryPoints(0, this.firstReplaceRange) == 0 && currPosBak.compareBoundaryPoints(2, this.firstReplaceRange) == 0;
        }

        private JRange getFirstReplacedRange(Node node) {
            JRange currSelect = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
            JRange currBak = currSelect.cloneRange();
            currBak.setStart(node, 0);
            currBak.setEnd(node, this.strReplace.length());
            return currBak;
        }

        public void beginReplace() {
            JRange currPos;
            this.strSearch = this.textFind.getText();
            this.strReplace = this.textReplace.getText();
            int index = this.strReplace.indexOf(this.strSearch);
            if (this.isWrap() && index != -1 && !this.isFirstReplace && this.isReplaced(currPos = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0), index)) {
                this.showWarningDialog(RTENLS.rteFindReplace_StrNotFound);
                return;
            }
            org.w3c.dom.Text newStr = RichTextEditor.this.htmlDoc.createTextNode(this.strReplace);
            Node node = RichTextEditor.this.insertNodeAtSelection(newStr);
            RichTextEditor.this.dirty = true;
            if (this.isWrap && this.isFirstReplace) {
                this.isFirstReplace = false;
                this.firstReplaceRange = this.getFirstReplacedRange(node);
            }
            if (this.isBackwards) {
                RichTextEditor.this.setCursorPosition(node, 0);
            }
            if (!this.FindNext()) {
                this.showWarningDialog(RTENLS.rteFindReplace_StrNotFound);
            }
            this.textFind.setFocus();
        }

        public void replaceAll() {
            this.strSearch = this.textFind.getText();
            this.strReplace = this.textReplace.getText();
            int index = this.strReplace.indexOf(this.strSearch);
            if (RichTextEditor.this.htmlDoc.getSelection() == null || RichTextEditor.this.htmlDoc.getSelection().length() < 1) {
                return;
            }
            org.w3c.dom.Text newStr = RichTextEditor.this.htmlDoc.createTextNode(this.strReplace);
            Node node = RichTextEditor.this.insertNodeAtSelection(newStr);
            RichTextEditor.this.dirty = true;
            if (this.isWrap && this.isFirstReplace && index != -1) {
                this.isFirstReplace = false;
                this.firstReplaceRange = this.getFirstReplacedRange(node);
            }
            if (this.isBackwards) {
                RichTextEditor.this.setCursorPosition(node, 0);
            }
            while (this.FindNext()) {
                JRange currPos;
                if (this.isWrap() && index != -1 && !this.isFirstReplace && this.isReplaced(currPos = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0), index)) {
                    this.showWarningDialog(RTENLS.rteFindReplace_ReplaceAllFinished);
                    return;
                }
                newStr = RichTextEditor.this.htmlDoc.createTextNode(this.strReplace);
                node = RichTextEditor.this.insertNodeAtSelection(newStr);
                if (!this.isBackwards) continue;
                RichTextEditor.this.setCursorPosition(node, 0);
            }
            this.textFind.setFocus();
            this.showWarningDialog(RTENLS.rteFindReplace_ReplaceAllFinished);
        }

        private void WarningDialog(String message) {
            Shell msgShell = new Shell(this.shell, 67696);
            msgShell.setText(RTENLS.rteFindReplace_AlertTitle);
            msgShell.setSize(310, 110);
            msgShell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 310) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 110) / 2);
            msgShell.open();
            Image img = Display.getCurrent().getSystemImage(8);
            Label msgIcon = new Label((Composite)msgShell, 0);
            msgIcon.setAlignment(0x1000000);
            img.setBackground(msgShell.getBackground());
            msgIcon.setImage(img);
            msgIcon.setBounds(10, 10, img.getBounds().width, 10 + img.getBounds().height);
            Label msgString = new Label((Composite)msgShell, 0);
            msgString.setAlignment(0x1000000);
            msgString.setText(message);
            Point lbSize = msgString.computeSize(-1, -1);
            msgString.setBounds(img.getBounds().width + 15, 21, lbSize.x + 5, lbSize.y);
            Button button = new Button((Composite)msgShell, 0);
            button.setBounds(125, 49, 66, 25);
            button.setText(RTENLS.rteFindReplace_OK);
            button.setFocus();
            button.addSelectionListener(new SelectionListener(this, msgShell){
                final /* synthetic */ SearchReplaceDialog this$1;
                private final /* synthetic */ Shell val$msgShell;
                {
                    this.this$1 = searchReplaceDialog;
                    this.val$msgShell = shell;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    RichTextEditor.access$1(SearchReplaceDialog.access$6(this.this$1)).getSelection().collapseToEnd();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    RichTextEditor.access$1(SearchReplaceDialog.access$6(this.this$1)).getSelection().collapseToEnd();
                }
            });
            msgShell.layout();
        }

        public String getSearchValue() {
            return this.strSearch;
        }

        public boolean isMatchCase() {
            return this.isMatchCase;
        }

        public boolean isWrap() {
            return this.isWrap;
        }

        public boolean isBackwards() {
            return this.isBackwards;
        }

        public boolean isEntireWord() {
            return this.isEntireWord;
        }

        public boolean FindNext() {
            this.strSearch = this.textFind.getText();
            this.isMatchCase = this.chkMatchCase.getSelection();
            this.isEntireWord = this.chkEntireWord.getSelection();
            WebBrowserFind findObj = RichTextEditor.this.webBrowser.getFindObject();
            char[] charArray = new char[this.strSearch.length() + 1];
            this.strSearch.getChars(0, this.strSearch.length(), charArray, 0);
            charArray[charArray.length - 1] = '\u0000';
            findObj.SetSearchString(charArray);
            findObj.SetEntireWord(this.isEntireWord);
            findObj.SetFindBackwards(this.isBackwards);
            findObj.SetMatchCase(this.isMatchCase);
            findObj.SetWrapFind(this.isWrap);
            boolean[] retVal = new boolean[1];
            if (this.isWrap) {
                if (this.isFirst) {
                    this.isFirst = false;
                    JRange bakRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                    findObj.FindNext(retVal);
                    if (retVal[0]) {
                        findObj.SetWrapFind(false);
                        findObj.SetFindBackwards(true);
                        findObj.FindNext(retVal);
                        if (retVal[0]) {
                            this.firstRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                        } else {
                            RichTextEditor.this.selectAll();
                            RichTextEditor.this.htmlWin.getSelection().collapseToEnd();
                            findObj.FindNext(retVal);
                            if (retVal[0]) {
                                this.firstRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                            }
                        }
                        findObj.SetWrapFind(true);
                        findObj.SetFindBackwards(false);
                        RichTextEditor.this.htmlWin.getSelection().addRange(bakRange);
                        RichTextEditor.this.htmlWin.getSelection().collapseToEnd();
                    } else {
                        return false;
                    }
                }
                this.currentRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                if (this.firstRange != null && this.currentRange.compareBoundaryPoints(0, this.firstRange) == 0 && this.currentRange.compareBoundaryPoints(2, this.firstRange) == 0) {
                    this.isFirst = true;
                    return false;
                }
                findObj.FindNext(retVal);
            } else {
                findObj.FindNext(retVal);
            }
            findObj.Release();
            return retVal[0];
        }

        static /* synthetic */ Button access$0(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.btReplace;
        }

        static /* synthetic */ Button access$1(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.btReplaceAll;
        }

        static /* synthetic */ Text access$2(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.textFind;
        }

        static /* synthetic */ Button access$3(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.btFind;
        }

        static /* synthetic */ void access$4(SearchReplaceDialog searchReplaceDialog, boolean bl) {
            searchReplaceDialog.isBackwards = bl;
        }

        static /* synthetic */ void access$5(SearchReplaceDialog searchReplaceDialog, boolean bl) {
            searchReplaceDialog.isWrap = bl;
        }

        static /* synthetic */ RichTextEditor access$6(SearchReplaceDialog searchReplaceDialog) {
            return searchReplaceDialog.RichTextEditor.this;
        }
    }

    private class SearchDialog
    extends Dialog {
        private Text textFind;
        private Button chkMatchCase;
        private Button chkEntireWord;
        private Button btFind;
        private String strSearch;
        private boolean isMatchCase;
        private boolean isWrap;
        private boolean isBackwards;
        private boolean isEntireWord;
        private Shell shell;
        private Display display = this.getParent().getDisplay();
        private JRange currentRange = null;
        private JRange firstRange = null;
        private boolean isFirst = true;
        private final int START_TO_START = 0;
        private final int END_TO_END = 2;

        public SearchDialog(Shell parent) {
            super(parent);
            this.shell = new Shell(this.getParent(), 2144);
        }

        public void open() {
            this.shell.setText(RTENLS.rteFindReplace_FindDialog);
            this.shell.setSize(400, 170);
            this.shell.setLayout((Layout)new FormLayout());
            this.shell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 400) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 180) / 2);
            Label label = new Label((Composite)this.shell, 0);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, 20);
            formData.bottom = new FormAttachment(0, 45);
            formData.right = new FormAttachment(0, 170);
            formData.left = new FormAttachment(0, 20);
            label.setLayoutData((Object)formData);
            label.setText(RTENLS.rteFindReplace_SearchForValue);
            this.textFind = new Text((Composite)this.shell, 2052);
            FormData formData_1 = new FormData();
            formData_1.top = new FormAttachment((Control)label, -5, 128);
            formData_1.bottom = new FormAttachment((Control)label, -5, 1024);
            formData_1.right = new FormAttachment((Control)label, 205, 131072);
            formData_1.left = new FormAttachment((Control)label, 10, 131072);
            this.textFind.setLayoutData((Object)formData_1);
            this.textFind.setToolTipText(RTENLS.rteFindReplace_StrToSearch);
            this.textFind.setFocus();
            this.textFind.addModifyListener(new ModifyListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void modifyText(ModifyEvent e) {
                    if (SearchDialog.access$0(this.this$1).getText().equals("")) {
                        SearchDialog.access$1(this.this$1).setEnabled(false);
                    } else {
                        SearchDialog.access$1(this.this$1).setEnabled(true);
                    }
                }
            });
            this.textFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.this$1.beginFind();
                }
            });
            this.chkMatchCase = new Button((Composite)this.shell, 50);
            FormData formData_2 = new FormData();
            formData_2.top = new FormAttachment((Control)label, 5, 1024);
            formData_2.bottom = new FormAttachment((Control)label, 25, 1024);
            formData_2.right = new FormAttachment((Control)label, 0, 131072);
            formData_2.left = new FormAttachment((Control)label, 0, 16384);
            this.chkMatchCase.setLayoutData((Object)formData_2);
            this.chkMatchCase.setText(RTENLS.rteFindReplace_Matchcase);
            Label lDirection = new Label((Composite)this.shell, 0);
            FormData formData_3 = new FormData();
            formData_3.top = new FormAttachment((Control)label, 8, 1024);
            formData_3.bottom = new FormAttachment((Control)label, 28, 1024);
            formData_3.right = new FormAttachment((Control)label, 140, 131072);
            formData_3.left = new FormAttachment((Control)label, 10, 131072);
            lDirection.setLayoutData((Object)formData_3);
            lDirection.setText(RTENLS.rteFindReplace_Directions);
            Combo cbDirection = new Combo((Composite)this.shell, 2074);
            FormData formData_c = new FormData();
            formData_c.top = new FormAttachment((Control)label, 30, 1024);
            formData_c.bottom = new FormAttachment((Control)label, 50, 1024);
            formData_c.right = new FormAttachment((Control)label, 100, 131072);
            formData_c.left = new FormAttachment((Control)label, 10, 131072);
            cbDirection.setLayoutData((Object)formData_c);
            String[] itemDirections = new String[]{RTENLS.rteFindReplace_SearchDown, RTENLS.rteFindReplace_SearchUp, RTENLS.rteFindReplace_SearchAll};
            cbDirection.setItems(itemDirections);
            cbDirection.select(0);
            cbDirection.addSelectionListener(new SelectionListener(this, cbDirection){
                final /* synthetic */ SearchDialog this$1;
                private final /* synthetic */ Combo val$cbDirection;
                {
                    this.this$1 = searchDialog;
                    this.val$cbDirection = combo;
                }

                public void widgetSelected(SelectionEvent event) {
                    if (this.val$cbDirection.getSelectionIndex() == 0) {
                        SearchDialog.access$2(this.this$1, false);
                        SearchDialog.access$3(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 1) {
                        SearchDialog.access$2(this.this$1, true);
                        SearchDialog.access$3(this.this$1, false);
                    } else if (this.val$cbDirection.getSelectionIndex() == 2) {
                        SearchDialog.access$3(this.this$1, true);
                        SearchDialog.access$2(this.this$1, false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
            this.chkEntireWord = new Button((Composite)this.shell, 50);
            FormData formData_5 = new FormData();
            formData_5.top = new FormAttachment((Control)label, 30, 1024);
            formData_5.bottom = new FormAttachment((Control)label, 50, 1024);
            formData_5.right = new FormAttachment((Control)label, 0, 131072);
            formData_5.left = new FormAttachment((Control)label, 0, 16384);
            this.chkEntireWord.setLayoutData((Object)formData_5);
            this.chkEntireWord.setText(RTENLS.rteFindReplace_Matchentireword);
            this.chkEntireWord.setVisible(false);
            this.btFind = new Button((Composite)this.shell, 0);
            FormData formData_6 = new FormData();
            formData_6.top = new FormAttachment((Control)label, 60, 1024);
            formData_6.bottom = new FormAttachment((Control)label, 86, 1024);
            formData_6.right = new FormAttachment((Control)label, 100, 131072);
            formData_6.left = new FormAttachment((Control)label, 10, 131072);
            this.btFind.setLayoutData((Object)formData_6);
            this.btFind.setText(RTENLS.rteFindReplace_Find);
            this.btFind.setEnabled(false);
            this.btFind.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.beginFind();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button btCancel = new Button((Composite)this.shell, 0);
            FormData formData_7 = new FormData();
            formData_7.top = new FormAttachment((Control)label, 60, 1024);
            formData_7.bottom = new FormAttachment((Control)label, 86, 1024);
            formData_7.right = new FormAttachment((Control)label, 205, 131072);
            formData_7.left = new FormAttachment((Control)label, 120, 131072);
            btCancel.setLayoutData((Object)formData_7);
            btCancel.setText(RTENLS.rteFindReplace_Cancel);
            btCancel.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SearchDialog this$1;
                {
                    this.this$1 = searchDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.close();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.shell.layout();
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }

        public void close() {
            this.shell.dispose();
            if (!this.display.readAndDispatch()) {
                this.display.sleep();
            }
        }

        public void beginFind() {
            if (!this.FindNext()) {
                this.WarningDialog();
            }
            this.textFind.setFocus();
        }

        private void WarningDialog() {
            Shell msgShell = new Shell(this.shell, 67680);
            msgShell.setText(RTENLS.rteFindReplace_AlertTitle);
            msgShell.setSize(300, 110);
            msgShell.setLocation((Display.getDefault().getPrimaryMonitor().getBounds().width - 300) / 2, (Display.getDefault().getPrimaryMonitor().getBounds().height - 110) / 2);
            msgShell.open();
            Image img = Display.getCurrent().getSystemImage(8);
            Label msgIcon = new Label((Composite)msgShell, 0);
            msgIcon.setAlignment(0x1000000);
            img.setBackground(msgShell.getBackground());
            msgIcon.setImage(img);
            msgIcon.setBounds(10, 10, img.getBounds().width, 10 + img.getBounds().height);
            Label msgString = new Label((Composite)msgShell, 0);
            msgString.setAlignment(0x1000000);
            msgString.setText(RTENLS.rteFindReplace_StrNotFound);
            Point lbSize = msgString.computeSize(-1, -1);
            msgString.setBounds(img.getBounds().width + 15, 21, lbSize.x + 5, lbSize.y);
            Button button = new Button((Composite)msgShell, 0);
            button.setBounds(125, 49, 66, 25);
            button.setText(RTENLS.rteFindReplace_OK);
            button.setFocus();
            button.addSelectionListener(new SelectionListener(this, msgShell){
                final /* synthetic */ SearchDialog this$1;
                private final /* synthetic */ Shell val$msgShell;
                {
                    this.this$1 = searchDialog;
                    this.val$msgShell = shell;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    RichTextEditor.access$1(SearchDialog.access$4(this.this$1)).getSelection().collapseToEnd();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.val$msgShell.dispose();
                    RichTextEditor.access$1(SearchDialog.access$4(this.this$1)).getSelection().collapseToEnd();
                }
            });
            msgShell.layout();
        }

        public String getSearchValue() {
            return this.strSearch;
        }

        public boolean isMatchCase() {
            return this.isMatchCase;
        }

        public boolean isWrap() {
            return this.isWrap;
        }

        public boolean isBackwards() {
            return this.isBackwards;
        }

        public boolean isEntireWord() {
            return this.isEntireWord;
        }

        public boolean FindNext() {
            this.strSearch = this.textFind.getText();
            this.isMatchCase = this.chkMatchCase.getSelection();
            this.isEntireWord = this.chkEntireWord.getSelection();
            WebBrowserFind findObj = RichTextEditor.this.webBrowser.getFindObject();
            char[] charArray = new char[this.strSearch.length() + 1];
            this.strSearch.getChars(0, this.strSearch.length(), charArray, 0);
            charArray[charArray.length - 1] = '\u0000';
            findObj.SetSearchString(charArray);
            findObj.SetEntireWord(this.isEntireWord);
            findObj.SetFindBackwards(this.isBackwards);
            findObj.SetMatchCase(this.isMatchCase);
            findObj.SetWrapFind(this.isWrap);
            boolean[] retVal = new boolean[1];
            if (this.isWrap) {
                if (this.isFirst) {
                    this.isFirst = false;
                    JRange bakRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                    findObj.FindNext(retVal);
                    if (retVal[0]) {
                        findObj.SetWrapFind(false);
                        findObj.SetFindBackwards(true);
                        findObj.FindNext(retVal);
                        if (retVal[0]) {
                            this.firstRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                        } else {
                            RichTextEditor.this.selectAll();
                            RichTextEditor.this.htmlWin.getSelection().collapseToEnd();
                            findObj.FindNext(retVal);
                            if (retVal[0]) {
                                this.firstRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                            }
                        }
                        findObj.SetWrapFind(true);
                        findObj.SetFindBackwards(false);
                        RichTextEditor.this.htmlWin.getSelection().addRange(bakRange);
                        RichTextEditor.this.htmlWin.getSelection().collapseToEnd();
                    } else {
                        return false;
                    }
                }
                this.currentRange = RichTextEditor.this.htmlWin.getSelection().getRangeAt(0);
                if (this.firstRange != null && this.currentRange.compareBoundaryPoints(0, this.firstRange) == 0 && this.currentRange.compareBoundaryPoints(2, this.firstRange) == 0) {
                    this.isFirst = true;
                    return false;
                }
                findObj.FindNext(retVal);
            } else {
                findObj.FindNext(retVal);
            }
            findObj.Release();
            return retVal[0];
        }

        static /* synthetic */ Text access$0(SearchDialog searchDialog) {
            return searchDialog.textFind;
        }

        static /* synthetic */ Button access$1(SearchDialog searchDialog) {
            return searchDialog.btFind;
        }

        static /* synthetic */ void access$2(SearchDialog searchDialog, boolean bl) {
            searchDialog.isBackwards = bl;
        }

        static /* synthetic */ void access$3(SearchDialog searchDialog, boolean bl) {
            searchDialog.isWrap = bl;
        }

        static /* synthetic */ RichTextEditor access$4(SearchDialog searchDialog) {
            return searchDialog.RichTextEditor.this;
        }
    }

    private class ColumnInfo {
        private Node currentRow;
        int currentCellIndex;

        public ColumnInfo(Node row, int idx) {
            this.currentRow = row;
            this.currentCellIndex = idx;
        }

        public int getCurrentCellIndex() {
            return this.currentCellIndex;
        }

        public Node getCurrentRow() {
            return this.currentRow;
        }
    }

    private class DefaultRTEEventListener
    implements EventListener {
        private DefaultRTEEventListener() {
        }

        public void handleEvent(Event evt) {
            String method_Name = "DefaultRTEEventListener::handleEvent";
            RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "ENTRY");
            Node curNode = RichTextEditor.this.getCursorPositionNode();
            if (((JHTMLElement)curNode).hasAttribute("IGNORED")) {
                RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
                return;
            }
            if (((JHTMLElement)curNode).hasAttribute("MISSPELLED")) {
                MenuItem menuItem;
                Menu menu = new Menu((Control)RichTextEditor.this.webBrowser.getShell());
                String allSuggestions = ((JHTMLElement)curNode).getAttribute("SUGGESTIONS");
                String[] suggestions = allSuggestions == null || allSuggestions.equals("") ? new String[]{RichTextEditor.this.MISSPELLING_NO_SUGGESTIONS} : RichTextEditor.this.split(allSuggestions, "/");
                int i = 0;
                while (i < suggestions.length) {
                    String suggestion = suggestions[i];
                    menuItem = new MenuItem(menu, 0);
                    menuItem.setText(suggestion);
                    if (suggestion.equalsIgnoreCase(RichTextEditor.this.MISSPELLING_NO_SUGGESTIONS)) {
                        menuItem.setEnabled(false);
                    }
                    menuItem.addSelectionListener(new SelectionListener(this, suggestion){
                        final /* synthetic */ DefaultRTEEventListener this$1;
                        private final /* synthetic */ String val$suggestion;
                        {
                            this.this$1 = defaultRTEEventListener;
                            this.val$suggestion = string;
                        }

                        public void widgetSelected(SelectionEvent event) {
                            Node curNode = RichTextEditor.access$9(DefaultRTEEventListener.access$1(this.this$1));
                            RichTextEditor.access$12(DefaultRTEEventListener.access$1(this.this$1), curNode, 4, this.val$suggestion);
                        }

                        public void widgetDefaultSelected(SelectionEvent event) {
                        }
                    });
                    ++i;
                }
                menuItem = new MenuItem(menu, 2);
                menuItem = new MenuItem(menu, 0);
                menuItem.setText(RTENLS.rteBgSpellChecker_Ignore);
                menuItem.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DefaultRTEEventListener this$1;
                    {
                        this.this$1 = defaultRTEEventListener;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        Node curNode = RichTextEditor.access$9(DefaultRTEEventListener.access$1(this.this$1));
                        RichTextEditor.access$12(DefaultRTEEventListener.access$1(this.this$1), curNode, 2, "Ignore");
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                menuItem = new MenuItem(menu, 0);
                menuItem.setText(RTENLS.rteBgSpellChecker_IgnoreAll);
                menuItem.addSelectionListener(new SelectionListener(this){
                    final /* synthetic */ DefaultRTEEventListener this$1;
                    {
                        this.this$1 = defaultRTEEventListener;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        Node curNode = RichTextEditor.access$9(DefaultRTEEventListener.access$1(this.this$1));
                        String nodeValue = RichTextEditor.access$13(DefaultRTEEventListener.access$1(this.this$1), curNode);
                        RichTextEditor.access$14(DefaultRTEEventListener.access$1(this.this$1)).add(nodeValue);
                        RichTextEditor.access$12(DefaultRTEEventListener.access$1(this.this$1), curNode, 2, null);
                        RichTextEditor.access$15(DefaultRTEEventListener.access$1(this.this$1), nodeValue);
                    }

                    public void widgetDefaultSelected(SelectionEvent event) {
                    }
                });
                menuItem = new MenuItem(menu, 2);
                menuItem = new MenuItem(menu, 64);
                menuItem.setText(RTENLS.rteBgSpellChecker_AutoCorrect);
                Menu autoCorrectMenu = new Menu((Decorations)RichTextEditor.this.webBrowser.getShell(), 4);
                int i2 = 0;
                while (i2 < suggestions.length) {
                    String suggestion = suggestions[i2];
                    MenuItem autoCorectMenuItem = new MenuItem(autoCorrectMenu, 0);
                    autoCorectMenuItem.setText(suggestion);
                    if (suggestion.equalsIgnoreCase(RichTextEditor.this.MISSPELLING_NO_SUGGESTIONS)) {
                        autoCorectMenuItem.setEnabled(false);
                    }
                    autoCorectMenuItem.addSelectionListener(new SelectionListener(this, suggestion){
                        final /* synthetic */ DefaultRTEEventListener this$1;
                        private final /* synthetic */ String val$suggestion;
                        {
                            this.this$1 = defaultRTEEventListener;
                            this.val$suggestion = string;
                        }

                        public void widgetSelected(SelectionEvent event) {
                            Node curNode = RichTextEditor.access$9(DefaultRTEEventListener.access$1(this.this$1));
                            String nodeValue = RichTextEditor.access$13(DefaultRTEEventListener.access$1(this.this$1), curNode);
                            RichTextEditor.access$16(DefaultRTEEventListener.access$1(this.this$1)).put(nodeValue, this.val$suggestion);
                            RichTextEditor.access$12(DefaultRTEEventListener.access$1(this.this$1), curNode, 4, this.val$suggestion);
                            RichTextEditor.access$17(DefaultRTEEventListener.access$1(this.this$1), nodeValue, this.val$suggestion);
                        }

                        public void widgetDefaultSelected(SelectionEvent event) {
                        }
                    });
                    ++i2;
                }
                menuItem.setMenu(autoCorrectMenu);
                menu.setVisible(true);
                evt.stopPropagation();
                evt.preventDefault();
            }
            RichTextEditor.this.logger.logp(RichTextEditor.this.level, RichTextEditor.this.CLZ_Name, method_Name, "RETURN");
        }

        static /* synthetic */ RichTextEditor access$1(DefaultRTEEventListener defaultRTEEventListener) {
            return defaultRTEEventListener.RichTextEditor.this;
        }
    }
}

