/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.srvc;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.wvcm.Baseline;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WvcmService {
    private SrvcProvider _provider;
    private static ILogger _logger;
    private static Map<String, callInfo> _stats;
    private static boolean _loggingActive;
    private Stack<String> _methodNames = new Stack();
    private PropertyRequestItem.PropertyRequest _lastPropertyRequest = null;
    private Map<PropertyNameList.PropertyName<?>, PropValue> _lastUpdates = null;
    private long _startTime = 0L;
    private long _writeDuration;
    private long _readDuration;
    private static Map<String, Integer> _propStats;

    static {
        _loggingActive = false;
        _propStats = new HashMap<String, Integer>();
    }

    public WvcmService(SrvcProvider provider) {
        this._provider = provider;
    }

    private static SrvcFeedback sfb(Feedback fb) throws WvcmException {
        if (fb != null && fb.isAbortRequested()) {
            fb.abortRequested(false);
            throw new WvcmException("Aborted", WvcmException.ReasonCode.ABORTED);
        }
        if (fb instanceof SrvcFeedback) {
            return (SrvcFeedback)fb;
        }
        return new SrvcFeedback(fb);
    }

    protected void processFeedback(SrvcFeedback feedback) {
        PropertyRequestItem.PropertyRequest mpr = feedback.getPropertyRequestForModified();
        if (mpr != null) {
            for (SrvcResource resource : feedback.get_modifiedResources()) {
                try {
                    feedback.notifyIsModified(resource.buildProxy(mpr, feedback));
                }
                catch (WvcmException wvcmException) {}
            }
        }
    }

    private void validateProxy(Object object, PropertyRequestItem.PropertyRequest propertyRequest) throws WvcmException {
        block6: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    if (propertyRequest == null) break block6;
                                    if (!(object instanceof List)) break block7;
                                    List list = (List)object;
                                    int i = 0;
                                    while (i < list.size()) {
                                        this.validateProxy(list.get(i), propertyRequest);
                                        ++i;
                                    }
                                    break block6;
                                }
                                if (!(object instanceof Map)) break block8;
                                Iterator values = ((Map)object).values().iterator();
                                while (values.hasNext()) {
                                    this.validateProxy(values.next(), propertyRequest);
                                }
                                break block6;
                            }
                            if (!(object instanceof Baseline.AddedVersion)) break block9;
                            this.validateProxy(((Baseline.AddedVersion)object).getVersion(), propertyRequest);
                            break block6;
                        }
                        if (!(object instanceof Baseline.ChangedVersion)) break block10;
                        this.validateProxy(((Baseline.ChangedVersion)object).getOldVersion(), propertyRequest);
                        this.validateProxy(((Baseline.ChangedVersion)object).getNewVersion(), propertyRequest);
                        break block6;
                    }
                    if (!(object instanceof Baseline.DeletedVersion)) break block11;
                    this.validateProxy(((Baseline.DeletedVersion)object).getVersion(), propertyRequest);
                    break block6;
                }
                if (!(object instanceof Workspace.MergePreviewReport)) break block12;
                this.validateProxy(((Workspace.MergePreviewReport)object).getCommonAncestor(), propertyRequest);
                this.validateProxy(((Workspace.MergePreviewReport)object).getTarget(), propertyRequest);
                this.validateProxy(((Workspace.MergePreviewReport)object).getVersionList(), propertyRequest);
                break block6;
            }
            if (!(object instanceof ResourceImpl)) break block6;
            ResourceImpl resource = (ResourceImpl)object;
            HashMap<PropertyNameList.PropertyName<?>, PropValue> propMap = resource.getPropMap();
            PropertyRequestItem.NestedPropertyName[] items = propertyRequest.toArray();
            int i = 0;
            while (i < items.length) {
                PropertyNameList.PropertyName name = items[i].getRoot();
                if (!name.equals((Object)Resource.ALL_CUSTOM_PROPERTIES)) {
                    PropValue value = (PropValue)propMap.get(name);
                    if (value == null) {
                        throw new WvcmException("SERVER ERROR: Requested property " + name + " not retrieved for resource: " + resource.location().string(), WvcmException.ReasonCode.FORBIDDEN);
                    }
                    if (value.get_exception() == null) {
                        this.validateProxy(value.get_value(), items[i].getNested());
                    }
                }
                ++i;
            }
        }
    }

    public static void setLogger(ILogger logger) {
        _logger = logger;
    }

    public static void beginStatistics() {
        _stats = new HashMap<String, callInfo>();
    }

    public static Map<String, callInfo> endStatistics() {
        Map<String, callInfo> results = _stats;
        _stats = null;
        return results;
    }

    public static boolean activateLogging(boolean activate) {
        boolean oldState = _loggingActive;
        _loggingActive = activate;
        return oldState;
    }

    private static boolean durationLoggingEnabled() {
        return _stats != null && _loggingActive;
    }

    private void logWritePropertiesCompletion(long durationMillis) {
        if (WvcmService.durationLoggingEnabled()) {
            this._writeDuration += durationMillis;
        }
    }

    private void logReadPropertiesCompletion(long durationMillis) {
        if (WvcmService.durationLoggingEnabled()) {
            this._readDuration += durationMillis;
        }
    }

    private void logStart(String methodName, PropertyRequestItem.PropertyRequest pr, Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        if (methodName == null) {
            throw new IllegalArgumentException("methodName must not be null");
        }
        if (this._methodNames.empty()) {
            this._lastPropertyRequest = pr;
            this._lastUpdates = updates;
            this._startTime = System.currentTimeMillis();
            this._writeDuration = 0L;
            this._readDuration = 0L;
            if (_logger != null) {
                _logger.starting(this._provider.getClass().getName(), methodName, updates, pr);
            }
        }
        this._methodNames.push(methodName);
    }

    private void logCompletion(SrvcFeedback feedback) {
        String methodName = this._methodNames.pop();
        if (this._methodNames.empty()) {
            long minDuration;
            String providerName = this._provider.getClass().getSimpleName();
            long duration = System.currentTimeMillis() - this._startTime;
            String minDurationVal = this._provider._initArgs.get("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION");
            if (minDurationVal != null && duration >= (minDuration = (long)Integer.parseInt(minDurationVal))) {
                String msg = String.valueOf(providerName) + "." + methodName + ": " + duration;
                feedback.notifyNestedActive(msg);
            }
            if (WvcmService.durationLoggingEnabled()) {
                String updatesString = this._lastUpdates == null || this._lastUpdates.size() == 0 ? "" : ".updates:" + this._lastUpdates.keySet().toString();
                String prString = this._lastPropertyRequest == null ? "" : ".pr:" + this._lastPropertyRequest.toString();
                String key = String.valueOf(methodName) + "(" + providerName + ")" + updatesString + prString;
                callInfo current = _stats.get(key);
                if (current == null) {
                    try {
                        _stats.put(key, new callInfo(duration));
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        System.out.println("stats collision");
                    }
                } else {
                    current.addCall(duration, this._writeDuration, this._readDuration);
                }
            }
            if (_logger != null) {
                _logger.completed(duration);
            }
        }
    }

    public static Map<String, Integer> getPropStats() {
        return _propStats;
    }

    public void logProperty(String className, String propName) {
        if (WvcmService.durationLoggingEnabled()) {
            String providerClassName = this._provider.getClass().getSimpleName();
            String key = String.valueOf(providerClassName) + "." + className + "." + propName;
            Integer current = _propStats.get(key);
            if (current == null) {
                current = 0;
            }
            _propStats.put(key, current + 1);
        }
    }

    private void writeProps(SrvcResource srvcResource, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        long durationMillis;
        boolean logThis;
        boolean bl = logThis = _logger != null && updates.size() > 0;
        if (logThis) {
            _logger.starting("", "writeProperties", updates, null);
        }
        long writeStartTime = WvcmService.durationLoggingEnabled() ? System.currentTimeMillis() : 0L;
        try {
            srvcResource.doWriteProperties(updates, updated, feedback);
        }
        catch (Throwable throwable) {
            long durationMillis2;
            long l = durationMillis2 = WvcmService.durationLoggingEnabled() ? System.currentTimeMillis() - writeStartTime : 0L;
            if (logThis) {
                _logger.completed(durationMillis2);
            }
            this.logWritePropertiesCompletion(durationMillis2);
            throw throwable;
        }
        long l = durationMillis = WvcmService.durationLoggingEnabled() ? System.currentTimeMillis() - writeStartTime : 0L;
        if (logThis) {
            _logger.completed(durationMillis);
        }
        this.logWritePropertiesCompletion(durationMillis);
    }

    private Resource readProperties(SrvcResource srvcResource, Location location, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        boolean logThis;
        ResourceImpl result = null;
        boolean bl = logThis = _logger != null && propertyRequest != null;
        if (logThis) {
            _logger.starting("", "readProperties", null, propertyRequest);
        }
        long readStartTime = WvcmService.durationLoggingEnabled() ? System.currentTimeMillis() : 0L;
        try {
            result = srvcResource.buildProxy(location, propertyRequest, srvcResource, feedback);
        }
        catch (Throwable throwable) {
            long durationMillis = WvcmService.durationLoggingEnabled() ? System.currentTimeMillis() - readStartTime : 0L;
            this.logReadPropertiesCompletion(durationMillis);
            if (logThis) {
                _logger.completed(durationMillis);
            }
            throw throwable;
        }
        long durationMillis = WvcmService.durationLoggingEnabled() ? System.currentTimeMillis() - readStartTime : 0L;
        this.logReadPropertiesCompletion(durationMillis);
        if (logThis) {
            _logger.completed(durationMillis);
        }
        return result;
    }

    protected static PropertyRequestItem.PropertyRequest getPR(Feedback feedback) {
        if (feedback == null) {
            return null;
        }
        return feedback.getPropertyRequestForResult();
    }

    public Resource doCreateControllableResource(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateControllableResource", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateControllableResource(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateVersionControlledResource", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateVersionControlledResource(location, versionLoc, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateControllableSymbolicLink", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateControllableSymbolicLink(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateControllableFolder", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateControllableFolder(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateBaselineControlledFolder(Location location, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateBaselineControlledFolder", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateBaselineControlledFolder(location, baselineLoc, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateWorkspace", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateWorkspace(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateGeneratedWorkspace", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateGeneratedWorkspace(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, srvcResource.calculateLocation(), WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateActivity", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateActivity(location, isStream, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateGeneratedResource", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateGeneratedActivity(location, isStream, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, srvcResource.calculateLocation(), WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCreateGeneratedTask", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doCreateGeneratedTask(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, srvcResource.calculateLocation(), WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doFind(Resource query, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doFind", WvcmService.getPR(fb), updates);
        try {
            List<Object> results = this._provider.doFind(query, WvcmService.getPR(fb), false, feedback);
            if (results == null || results.size() == 0) {
                return null;
            }
            Resource result = (Resource)results.get(0);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doFindAll(Resource query, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doFindAll", WvcmService.getPR(fb), updates);
        try {
            List<Object> results = this._provider.doFind(query, WvcmService.getPR(fb), true, feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            if (results == null) {
                results = Collections.emptyList();
            }
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public PropertyNameList doGetPropertyNameList(Location location, String namespace, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doGetPropertyNameList", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            PropertyNameList result = srvcResource.doGetPropertyNameList(namespace);
            this.processFeedback(feedback);
            PropertyNameList propertyNameList = result;
            return propertyNameList;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doUpdateProperties(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUpdateProperties", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doUpdateProperties(List<Location> locations, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUpdateProperties ResourceList", WvcmService.getPR(fb), null);
        try {
            List<Object> results = this._provider.doUpdateProperties(locations, WvcmService.getPR(fb), updatesList, updatedList, feedback);
            this.processFeedback(feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doUpdateContextProperties(List<Location> locations, Location contextLocation, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUpdateContextProperties  ResourceList", WvcmService.getPR(fb), null);
        try {
            SrvcResource context = this._provider.getSrvcRes(contextLocation, feedback);
            List<Object> results = this._provider.doUpdateContextProperties(locations, context, WvcmService.getPR(fb), updatesList, updatedList, feedback);
            this.processFeedback(feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doReadContent(Location location, OutputStream content, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doReadContent", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            this.processFeedback(feedback);
            srvcResource.doReadContent(content, feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doWriteContent", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doWriteContent(location, content, contentIdentifier, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCopy(Location location, Location destination, Resource.CopyFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCopy", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doCopy(destination, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public void doUnbindAll(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUnbindAll", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doUnbindAll(feedback);
            this.processFeedback(feedback);
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doBindChild(Location location, String bindingName, Location childLocation, Folder.BindFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doBindChild", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doBindChild(bindingName, childLocation, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doRebindChild(Location location, String bindingName, Location sourceFolderLocation, String sourceBindingName, Folder.RebindFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doRebindChild", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doRebindChild(bindingName, sourceFolderLocation, sourceBindingName, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doRebindAll(Location location, String bindingName, Location sourceLocation, Folder.RebindFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doRebindAll", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doRebindAll(bindingName, sourceLocation, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doUnbindChild(Location location, String bindingName, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUnbindChild", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doUnbindChild(bindingName, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doReadMemberList(Location location, boolean deep, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doReadMemberList", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            this.processFeedback(feedback);
            List<Object> results = srvcResource.doReadMemberList(location, WvcmService.getPR(fb), deep, feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doVersionControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doVersionControl", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doVersionControl(feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCheckin(Location location, ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCheckin", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doCheckin(flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCheckout(Location location, ControllableResource.CheckoutFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCheckout", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doCheckout(flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doUncheckout(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUncheckout", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doUncheckout(feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doSetLabel(Location location, String label, boolean overwrite, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doSetLabel", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doSetLabel(label, overwrite, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doRemoveLabel(Location location, String label, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUncheckout", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doRemoveLabel(label, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doReadLabelledVersionProperties(Location location, String label, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doReadLabelledVersionProperties", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            this.processFeedback(feedback);
            SrvcResource srvcResult = srvcResource.doReadLabelledVersionProperties(label);
            if (srvcResult == null) {
                return null;
            }
            ResourceImpl result = srvcResult.buildProxy(WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            ResourceImpl resourceImpl = result;
            return resourceImpl;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doBaselineControl", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.doBaselineControl(location, updates, updated, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doCompareReport(Location location, Location otherLocation, Baseline.CompareFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCompareReport", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            this.processFeedback(feedback);
            List<Object> results = srvcResource.doCompareReport(otherLocation, flags, WvcmService.getPR(fb), feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doMergePreviewReport(Location location, List<Location> sourceLocations, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doMergePreviewReport", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            ArrayList<SrvcResource> sources = new ArrayList<SrvcResource>(sourceLocations.size());
            int i = 0;
            while (i < sourceLocations.size()) {
                sources.add(this._provider.getSrvcRes(sourceLocations.get(i), feedback));
                ++i;
            }
            this.processFeedback(feedback);
            List<Object> results = srvcResource.doMergePreviewReport(sources, WvcmService.getPR(fb), feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doMerge(Location location, List<Location> sourceLocations, Workspace.MergeFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doMerge", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            ArrayList<SrvcResource> sources = new ArrayList<SrvcResource>(sourceLocations.size());
            int i = 0;
            while (i < sourceLocations.size()) {
                sources.add(this._provider.getSrvcRes(sourceLocations.get(i), feedback));
                ++i;
            }
            srvcResource.doMerge(sources, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doUpdate(Location location, List<Location> sourceLocations, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doUpdate", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            ArrayList<SrvcResource> sources = new ArrayList<SrvcResource>(sourceLocations.size());
            int i = 0;
            while (i < sourceLocations.size()) {
                sources.add(this._provider.getSrvcRes(sourceLocations.get(i), feedback));
                ++i;
            }
            srvcResource.doUpdate(sources, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doLatestActivityVersionReport(Location location, Location activityLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doLatestActivityVersionReport", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            SrvcResource srvcResult = srvcResource.doLatestActivityVersionReport(activityLoc);
            this.processFeedback(feedback);
            if (srvcResult == null) {
                return null;
            }
            ResourceImpl result = srvcResult.buildProxy(WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            ResourceImpl resourceImpl = result;
            return resourceImpl;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doVersionControl(Location location, List<Location> locations, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doVersionControl", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doVersionControl(locations, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCheckinAll(Location location, String comment, ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCheckinAll", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            srvcResource.doCheckinAll(comment, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public Resource doCheckin(Location location, List<Location> locations, String comment, ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doCheckin", WvcmService.getPR(fb), updates);
        try {
            SrvcResource srvcResource = this._provider.getSrvcRes(location, feedback);
            this.writeProps(srvcResource, updates, updated, feedback);
            ArrayList<SrvcResource> resources = new ArrayList<SrvcResource>(locations.size());
            int i = 0;
            while (i < locations.size()) {
                resources.add(this._provider.getSrvcRes(locations.get(i), feedback));
                ++i;
            }
            srvcResource.doCheckin(resources, comment, flags, feedback);
            this.processFeedback(feedback);
            Resource result = this.readProperties(srvcResource, location, WvcmService.getPR(fb), feedback);
            this.validateProxy(result, WvcmService.getPR(fb));
            Resource resource = result;
            return resource;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    public List<Object> doFind(ResourceList<?> queries, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, Feedback fb) throws WvcmException {
        SrvcFeedback feedback = WvcmService.sfb(fb);
        this.logStart("doFind ResourceList", WvcmService.getPR(fb), null);
        try {
            List<Object> results = this._provider.doFind(queries, WvcmService.getPR(fb), feedback);
            this.processFeedback(feedback);
            this.validateProxy(results, WvcmService.getPR(fb));
            List<Object> list = results;
            return list;
        }
        finally {
            this.logCompletion(feedback);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ILogger {
        public void starting(String var1, String var2, Map<PropertyNameList.PropertyName<?>, PropValue> var3, PropertyRequestItem.PropertyRequest var4);

        public void completed(long var1);
    }

    public class callInfo {
        private long _totalCalls = 1L;
        private long _totalDuration;
        private long _writePropertiesDuration;
        private long _readPropertiesDuration;

        public callInfo(long duration) {
            this._totalDuration = duration;
            this._writePropertiesDuration = 0L;
            this._readPropertiesDuration = 0L;
        }

        public void addCall(long totalDuration, long writeDuration, long readDuration) {
            ++this._totalCalls;
            this._totalDuration += totalDuration;
            this._writePropertiesDuration += writeDuration;
            this._readPropertiesDuration += readDuration;
        }

        public long getTotalDuration() {
            return this._totalDuration;
        }

        public long getTotalCalls() {
            return this._totalCalls;
        }

        public long getWritePropsDuration() {
            return this._writePropertiesDuration;
        }

        public long getReadPropsDuration() {
            return this._readPropertiesDuration;
        }
    }
}

