/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.repo.RiLocation;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolderVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoIFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiRepo {
    public static int TraceLevel = 0;
    public static Map<String, RiRepo> _repoMap = new HashMap<String, RiRepo>();
    public static RiLocation rootLocation = new RiLocation("/", null);
    private RiLocation repoLocation;
    public RiRepoFolder rootFolder;
    public RiLocation rootFolderLocation;
    public RiLocation relativeRootLocation;
    private RiRepoControllableFolder workspaceFolder;
    private RiLocation workspaceFolderLocation;
    private List<RiRepoIFolder> workspaceFolderList;
    private RiRepoFolder activityFolder;
    private RiLocation activityFolderLocation;
    private List<RiRepoIFolder> activityFolderList;
    private RiRepoFolder taskFolder;
    private RiLocation taskFolderLocation;
    private RiRepoFolder versionHistoryFolder;
    private RiRepoVersionHistory workspaceVersionHistory;
    private RiRepoVersion workspaceInitialVersion;
    private List<RiRepoIFolder> versionHistoryFolderList;
    private RiRepoFolder configurationFolder;
    private RiRepoFolder baselineHistoryFolder;
    private int uniqueVersionHistoryLocation = 0;
    private int uniqueComponentLocation = 0;
    private int uniqueConfigurationLocation = 0;
    private int uniqueResourceIdentifer = 0;
    private RiLocation uuidRootLocation;
    public Map<String, RiRepoResource> stableResourceMap = new HashMap<String, RiRepoResource>();
    private Map<String, Integer> _resourceSuffix = new HashMap<String, Integer>();

    public static RiRepo get_Repo(SrvcProvider thisProvider) {
        RiRepo repo = _repoMap.get("default");
        if (repo == null) {
            repo = new RiRepo("default", thisProvider);
            _repoMap.put("default", repo);
        }
        return repo;
    }

    public static RiRepo get_Repo(String repoName, SrvcProvider thisProvider) {
        RiRepo repo = _repoMap.get(repoName);
        if (repo == null) {
            repo = new RiRepo(repoName, thisProvider);
            _repoMap.put(repoName, repo);
        }
        return repo;
    }

    public static RiRepo get_Repo(Location location, SrvcProvider thisProvider) {
        String[] segments = location.string().split("/");
        if (segments.length < 2) {
            return RiRepo.get_Repo(thisProvider);
        }
        return RiRepo.get_Repo(segments[1], thisProvider);
    }

    private RiRepo(String repoName, SrvcProvider provider) {
        if (repoName.length() == 0) {
            throw new RuntimeException("repo name cannot be null");
        }
        this.repoLocation = new RiLocation(String.valueOf(rootLocation.string()) + repoName, null);
        this.uuidRootLocation = new RiLocation(String.valueOf(this.repoLocation.string()) + "/uuid", null);
        this.rootFolderLocation = new RiLocation(String.valueOf(this.repoLocation.string()) + "/path/.", null);
        this.workspaceFolderLocation = new RiLocation(String.valueOf(this.rootFolderLocation.string()) + "/ws", null);
        this.activityFolderLocation = new RiLocation(String.valueOf(this.rootFolderLocation.string()) + "/act", null);
        this.taskFolderLocation = new RiLocation(String.valueOf(this.rootFolderLocation.string()) + "/task", null);
        this.relativeRootLocation = new RiLocation(String.valueOf(this.repoLocation.string()) + "/relative/.", null);
        this.rootFolder = new RiRepoFolder(null, repoName, provider, this);
        this.workspaceFolder = new RiRepoControllableFolder(this.rootFolder, "ws", provider, this);
        this.activityFolder = new RiRepoFolder(this.rootFolder, "act", provider, this);
        this.taskFolder = new RiRepoFolder(this.rootFolder, "task", provider, this);
        this.versionHistoryFolder = new RiRepoFolder(this.rootFolder, "vh", provider, this);
        this.configurationFolder = new RiRepoFolder(this.rootFolder, "cfg", provider, this);
        this.baselineHistoryFolder = new RiRepoFolder(this.rootFolder, "bh", provider, this);
        this.workspaceFolderList = new ArrayList<RiRepoIFolder>();
        this.workspaceFolderList.add(this.workspaceFolder);
        this.activityFolderList = new ArrayList<RiRepoIFolder>();
        this.activityFolderList.add(this.getActivityFolder());
        this.versionHistoryFolderList = new ArrayList<RiRepoIFolder>();
        this.versionHistoryFolderList.add(this.getVersionHistoryFolder());
        this.versionHistoryFolderList.add(this.getBaselineHistoryFolder());
        String versionHistoryName = this.createUniqueVersionHistoryLocation();
        this.workspaceVersionHistory = new RiRepoVersionHistory(this.getVersionHistoryFolder(), versionHistoryName, provider, this);
        String versionName = this.workspaceVersionHistory.createUniqueVersionLocation(true);
        this.workspaceInitialVersion = new RiRepoFolderVersion(this.workspaceVersionHistory, versionName, provider, this);
    }

    public RiRepoFolder getRootFolder() {
        return this.rootFolder;
    }

    public RiLocation getRootFolderLocation() {
        return this.rootFolderLocation;
    }

    public RiLocation getRelativeRootLocation() {
        return this.relativeRootLocation;
    }

    public RiRepoControllableFolder getWorkspaceFolder() {
        return this.workspaceFolder;
    }

    public RiLocation getWorkspaceFolderLocation() {
        return this.workspaceFolderLocation;
    }

    List<RiRepoIFolder> getWorkspaceFolderList() {
        return this.workspaceFolderList;
    }

    List<RiRepoIFolder> getVersionHistoryFolderList() {
        return this.versionHistoryFolderList;
    }

    RiRepoVersionHistory getWorkspaceVersionHistory() {
        return this.workspaceVersionHistory;
    }

    RiRepoVersion getWorkspaceInitialVersion() {
        return this.workspaceInitialVersion;
    }

    public RiRepoFolder getActivityFolder() {
        return this.activityFolder;
    }

    public RiLocation getActivityFolderLocation() {
        return this.activityFolderLocation;
    }

    List<RiRepoIFolder> getActivityFolderList() {
        return this.activityFolderList;
    }

    public RiRepoFolder getTaskFolder() {
        return this.taskFolder;
    }

    public RiLocation getTaskFolderLocation() {
        return this.taskFolderLocation;
    }

    public RiRepoFolder getConfigurationFolder() {
        return this.configurationFolder;
    }

    public RiRepoFolder getBaselineHistoryFolder() {
        return this.baselineHistoryFolder;
    }

    public RiRepoFolder getVersionHistoryFolder() {
        return this.versionHistoryFolder;
    }

    String createUniqueVersionHistoryLocation() {
        ++this.uniqueVersionHistoryLocation;
        return "vh" + String.valueOf(this.uniqueVersionHistoryLocation);
    }

    String createUniqueComponentLocation(String name) {
        ++this.uniqueComponentLocation;
        String s = String.valueOf(this.uniqueComponentLocation);
        return String.valueOf(name) + "_comp" + s;
    }

    String createUniqueConfigurationLocation() {
        ++this.uniqueConfigurationLocation;
        String s = String.valueOf(this.uniqueConfigurationLocation);
        return "cfg" + s;
    }

    String getNextResourceIdentifier() {
        ++this.uniqueResourceIdentifer;
        String s = String.valueOf(this.uniqueResourceIdentifer);
        return "id_" + s;
    }

    public Location createUniqueGeneratedLocation(SrvcProvider provider, Location originalLocation) throws WvcmException {
        Location newLoc;
        SrvcResource existingResource;
        String nameBase = originalLocation.lastSegment();
        int suffix = 0;
        if (this._resourceSuffix.containsKey(nameBase)) {
            suffix = this._resourceSuffix.get(nameBase);
        }
        while ((existingResource = provider.lookup(newLoc = originalLocation.parent().child(String.valueOf(nameBase) + ++suffix), null)) != null) {
        }
        this._resourceSuffix.put(nameBase, suffix);
        return newLoc;
    }

    public RiRepoResource getResourceFromId(String id) {
        return this.stableResourceMap.get(id);
    }

    public RiLocation uuidLoc(String uuid) {
        return new RiLocation(String.valueOf(this.uuidRootLocation.string()) + "/" + uuid, null);
    }

    public RiLocation get_uuidRootLoc() {
        return this.uuidRootLocation;
    }
}

