/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import javax.wvcm.WvcmException;

public class DiffBLInfo {
    private CTVersion oldBaselineVersion;
    private CTVersion newBaselineVersion;
    private CTProvider wvcmProvider;
    private boolean lookedUpOldBaselineVersion = false;
    private boolean lookedUpNewBaselineVersion = false;

    public DiffBLInfo(CTVersion oldBaselineVersion, CTVersion newBaselineVersion, CTProvider wvcmProvider) throws WvcmException {
        this.oldBaselineVersion = oldBaselineVersion;
        this.newBaselineVersion = newBaselineVersion;
        this.wvcmProvider = wvcmProvider;
    }

    public CTVersion getNewBaselineVersion() {
        return this.newBaselineVersion;
    }

    public CTVersion getOldBaselineVersion() {
        return this.oldBaselineVersion;
    }

    public void setNewBaselineVersion(CTVersion newBaselineVersion) {
        this.newBaselineVersion = newBaselineVersion;
    }

    public void setOldBaselineVersion(CTVersion oldBaselineVersion) {
        this.oldBaselineVersion = oldBaselineVersion;
    }

    public CTVersion lookupNewBaselineVersion(String baselineSelectorNew, CCaseObjInfo elemInfo, SrvcFeedback feedback) throws WvcmException {
        if (!this.lookedUpNewBaselineVersion) {
            this.newBaselineVersion = this.lookupVersionInBaseline(baselineSelectorNew, elemInfo, feedback);
            this.lookedUpNewBaselineVersion = true;
        }
        return this.newBaselineVersion;
    }

    public CTVersion lookupOldBaselineVersion(String baselineSelectorOld, CCaseObjInfo elemInfo, SrvcFeedback feedback) throws WvcmException {
        if (!this.lookedUpOldBaselineVersion) {
            this.oldBaselineVersion = this.lookupVersionInBaseline(baselineSelectorOld, elemInfo, feedback);
            this.lookedUpOldBaselineVersion = true;
        }
        return this.oldBaselineVersion;
    }

    private CTVersion lookupVersionInBaseline(String baselineSelector, CCaseObjInfo elemInfo, SrvcFeedback feedback) throws WvcmException {
        if (baselineSelector == null) {
            throw new IllegalArgumentException("GetVersionInfoInBaseline: Need a non null BaselineSelector");
        }
        CCaseLib cc = this.wvcmProvider.getCCaseLib();
        String label = cc.getLabelTypeName(baselineSelector, feedback);
        if (label == null) {
            return null;
        }
        String baselineExtendedPathName = String.valueOf(elemInfo.getPathName()) + '/' + label;
        CCaseObjInfo ccaseObjInfoVersionInBaseline = CCaseObjInfo.lookupObjInfo(cc, baselineExtendedPathName, feedback);
        if (ccaseObjInfoVersionInBaseline == null) {
            return null;
        }
        return CTVersion.valueOf(this.wvcmProvider, ccaseObjInfoVersionInBaseline, feedback);
    }
}

