/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.wvcm.PropertyNameList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtils {
    public static final String FWDSLASH = String.valueOf('/');
    public static final String BACKSLASH = String.valueOf('\\');

    private CommonUtils() {
    }

    public static String getPropertyNameKey(PropertyNameList.PropertyName<?> propertyName) {
        String name = propertyName.getName();
        String ns = propertyName.getNamespace();
        String key = String.valueOf(ns == null ? new String() : String.valueOf(ns) + ':') + name;
        return key;
    }

    public static PropertyNameList.PropertyName<?> getPropertyNameFromKey(String key) {
        String ns = null;
        String name = key;
        int sep = key.indexOf(58);
        if (sep != -1) {
            ns = key.substring(0, sep - 1);
            name = key.substring(sep + 1);
        }
        return new PropertyNameList.PropertyName(ns, name);
    }

    public static PropertyNameList convertList2PropertyNameList(List<PropertyNameList.PropertyName<?>> propNames) {
        PropertyNameList.PropertyName[] propNameArray = new PropertyNameList.PropertyName[propNames.size()];
        int i = 0;
        while (i < propNames.size()) {
            propNameArray[i] = propNames.get(i);
            ++i;
        }
        return new PropertyNameList(propNameArray);
    }

    public static String myToString(char c, List<String> err, boolean b) {
        return CommonUtils.myToString(String.valueOf(c), err, b);
    }

    public static String myToString(String sep, boolean quoteIfSpaces, String ... items) {
        return CommonUtils.myToString(sep, Arrays.asList(items), quoteIfSpaces);
    }

    public static String myToString(String separator, List<String> sourceAsList, boolean quoteIfSpaces, int maxLength) {
        if (sourceAsList == null) {
            return new String();
        }
        StringBuffer result = new StringBuffer();
        int length = 0;
        int separatorLength = separator.length();
        int i = 0;
        while (i < sourceAsList.size()) {
            String item = sourceAsList.get(i);
            if (quoteIfSpaces) {
                item = CommonUtils.quoteIfSpaces(item);
            }
            if (length + separatorLength + item.length() + 4 >= maxLength) {
                result.append(" ...");
                return result.toString();
            }
            if (i != 0) {
                result.append(separator);
            }
            result.append(item);
            ++i;
        }
        return result.toString();
    }

    public static String myToString(String separator, List<String> sourceAsList, boolean quoteIfSpaces) {
        if (sourceAsList == null) {
            return new String();
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < sourceAsList.size()) {
            if (i != 0) {
                result.append(separator);
            }
            String item = sourceAsList.get(i);
            if (quoteIfSpaces) {
                item = CommonUtils.quoteIfSpaces(item);
            }
            result.append(item);
            ++i;
        }
        return result.toString();
    }

    public static String quoteIfSpaces(String source) {
        return source.contains(String.valueOf(' ')) ? String.valueOf('\"') + source + '\"' : source;
    }

    public static final String uniquifier() {
        return "_" + UUID.randomUUID().toString();
    }

    public static final String canonicalizePathname(String pathname) {
        return pathname.replace(BACKSLASH, FWDSLASH);
    }
}

