/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTWvcmConfiguration
extends CTControllableResource {
    public static final String VOBCOMP_ATTR_NAMESPACE = "com.ibm.team.interop";
    public static final String VOBCOMP_ATTR_NAME = "VobComponent";
    public static final String VOBCOMP_ATTR = "com.ibm.team.interop_VobComponent";
    private static final String DATETIME_FMT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private String _latestBaselineSelector = null;

    CTWvcmConfiguration(Location loc, CTProvider provider) throws WvcmException {
        super(loc, provider);
        if (!ObjSelUtils.isUniversalSelector(this.getComponentLocation().getDisplayName())) {
            throw new IllegalArgumentException("Component location must be universal selector");
        }
    }

    @Override
    public Class<?> get_proxyClass() {
        return ConfigurationImpl.class;
    }

    @Override
    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.createBaseline(feedback);
    }

    @Override
    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Configuration.RESOURCE_IDENTIFIER)) {
            return this.getLocation().string();
        }
        if (propertyName.equals((Object)Configuration.CHECKED_IN)) {
            return this.getLatestBaseline(feedback);
        }
        if (propertyName.equals((Object)Configuration.IS_CHECKED_OUT)) {
            return false;
        }
        if (propertyName.equals((Object)Configuration.VERSION_HISTORY)) {
            CTLocation compLoc = this.getComponentLocation();
            if (compLoc.hasKind(CTLocation.Kind.VOBCOMPONENT)) {
                return new CTVOB(compLoc, this.getProvider());
            }
            return new CTComponent(compLoc, this.getProvider());
        }
        if (propertyName.equals((Object)Configuration.ROOT_FOLDER)) {
            CTProvider p = this.getProvider();
            CTLocation myLoc = this.getLocation();
            CTLocation viewLoc = myLoc.lookupContextLocation(CTLocation.Kind.WORKSPACE);
            String compPathname = null;
            if (viewLoc != null) {
                CTUcmView view = (CTUcmView)p.lookup(viewLoc, feedback);
                compPathname = view.getComponentPathname(myLoc.getContextLocation(CTLocation.Kind.COMPONENT), feedback);
                if (ObjSelUtils.isUniversalSelector(compPathname)) {
                    throw new IllegalStateException("Need component pathname, not universal selector: " + compPathname);
                }
            } else {
                viewLoc = myLoc.lookupContextLocation(CTLocation.Kind.BASE_CC_VIEW);
                if (viewLoc == null) {
                    throw new IllegalArgumentException("Configuration location for Base CC has no view context");
                }
                CTLocation vobLocation = myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT);
                if (vobLocation == null) {
                    throw new IllegalArgumentException("Configuration location for Base CC has no VOB context");
                }
                CCaseObjInfo info = CCaseObjInfo.getObjInfo(p.getCCaseLib(), vobLocation.getDisplayName(), feedback);
                String mtype = info.getMtype();
                if (mtype.equals("versioned object base")) {
                    String vobTag = p.getCCaseLib().computeVobTagFromVobSelector(info.getPathName(), feedback);
                    String pathIntoView = String.valueOf(CCaseLib.getPathIntoView(viewLoc.getViewTag())) + vobTag;
                    compPathname = CommonUtils.canonicalizePathname(pathIntoView);
                } else if (mtype.equals("component")) {
                    String componentRootDirPathname = p.getCCaseLib().getComponentRootDirPathname(info.getUniversalSelector(), viewLoc.getViewTag(), feedback);
                    compPathname = CommonUtils.canonicalizePathname(componentRootDirPathname);
                }
            }
            CTLocation location = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, compPathname);
            return new CTControllableFolder(location, this.getProvider());
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    protected String computePathname(SrvcFeedback feedback) throws WvcmException {
        return this.getLocation().string();
    }

    private CTLocation getComponentLocation() throws WvcmException {
        CTLocation compLoc = this.getLocation().lookupContextLocation(CTLocation.Kind.COMPONENT);
        if (compLoc != null) {
            return compLoc;
        }
        return this.getLocation().getContextLocation(CTLocation.Kind.VOBCOMPONENT);
    }

    @Override
    public CTLocation getViewLocation(SrvcFeedback feedback) throws WvcmException {
        CTLocation wsLoc = this.getLocation().lookupContextLocation(CTLocation.Kind.WORKSPACE);
        if (wsLoc != null) {
            return wsLoc;
        }
        return this.getLocation().getContextLocation(CTLocation.Kind.BASE_CC_VIEW);
    }

    @Override
    public CTLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        return CTLocation.valueOf(CTLocation.Kind.CONFIGURATION, cc.getComponentRootDirPathname(this.getLocation().getContextLocation(CTLocation.Kind.COMPONENT).getDisplayName(), this.getLocation().getContextLocation(CTLocation.Kind.WORKSPACE).getViewTag(), feedback));
    }

    public synchronized void createBaseline(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.getProvider();
        CTLocation wsLoc = this.getViewLocation(feedback);
        String viewTag = wsLoc.getViewTag();
        String compName = this.getComponentLocation().getDisplayName();
        CCaseLib cc = p.getCCaseLib();
        String baselineBasename = null;
        if (!wsLoc.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            baselineBasename = cc.makeBaseline(viewTag, compName, feedback);
            if (baselineBasename != null) {
                String pVobSelector = ObjSelUtils.getObjSelVobSel(cc.getStreamUniversalSelector(viewTag, feedback));
                this._latestBaselineSelector = ObjSelUtils.formatSelector("baseline", baselineBasename, pVobSelector);
            }
        } else {
            CTLocation brtypeLoc = wsLoc.getContextLocation(CTLocation.Kind.BRTYPE);
            String vobComps = cc.getAttr(VOBCOMP_ATTR, brtypeLoc.getDisplayName(), feedback);
            if (vobComps != null) {
                if (!vobComps.contains(compName)) {
                    vobComps = String.valueOf(vobComps) + "|" + compName;
                    cc.setAttr(VOBCOMP_ATTR, brtypeLoc.getDisplayName(), vobComps, true, feedback);
                }
            } else {
                vobComps = compName;
                cc.setAttr(VOBCOMP_ATTR, brtypeLoc.getDisplayName(), vobComps, false, feedback);
            }
        }
    }

    private synchronized CTBaseline getLatestBaseline(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.getProvider();
        CTLocation myLoc = this.getLocation();
        CTLocation viewLocation = myLoc.lookupContextLocation(CTLocation.Kind.WORKSPACE);
        if (viewLocation == null) {
            viewLocation = myLoc.getContextLocation(CTLocation.Kind.BASE_CC_VIEW);
        }
        CTBaseline result = null;
        if (viewLocation.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            if (this._latestBaselineSelector == null) {
                this._latestBaselineSelector = CTWvcmConfiguration.timeNow();
            }
            CTLocation timeStampLoc = CTLocation.valueOf(CTLocation.Kind.TIMESTAMP, this._latestBaselineSelector);
            CTLocation vobCompLoc = myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT);
            CTLocation brtypeLoc = viewLocation.getContextLocation(CTLocation.Kind.BRTYPE);
            CTLocation lbtypeLoc = viewLocation.lookupContextLocation(CTLocation.Kind.LBTYPE);
            CTLocation baselineLoc = CTLocation.createBaseCCBaselineLocation(brtypeLoc, lbtypeLoc, vobCompLoc, timeStampLoc);
            result = (CTBaseline)p.lookup(baselineLoc, feedback);
        } else {
            CCaseLib cc = p.getCCaseLib();
            if (this._latestBaselineSelector == null) {
                CTView view = (CTView)p.lookup(viewLocation, feedback);
                String compPath = myLoc.getContextLocation(CTLocation.Kind.COMPONENT).getDisplayName();
                if (!ObjSelUtils.isUniversalSelector(compPath)) {
                    throw new IllegalStateException("Component location must be universal selector");
                }
                this._latestBaselineSelector = cc.getLatestBaselineInStreamOfComponent(view.getStreamSelector(feedback), compPath, feedback);
                if (this._latestBaselineSelector == null) {
                    this._latestBaselineSelector = cc.getInitialBaseline(compPath, feedback);
                }
            }
            result = (CTBaseline)p.lookup(p.location(this._latestBaselineSelector), feedback);
        }
        return result;
    }

    public static String timeNow() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FMT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = dateFormat.format(calendar.getTime());
        return date;
    }
}

