/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ri.impl.WorkspaceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTView
extends CTControllableFolder {
    CTView(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return WorkspaceImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            return true;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    protected Map<String, SrvcResource> getChildMap(SrvcFeedback feedback) throws WvcmException {
        HashMap<String, SrvcResource> childBindings = new HashMap<String, SrvcResource>();
        CTProvider provider = this.getProvider();
        CCaseLib cc = provider.getCCaseLib();
        String pathName = this.getPathname(feedback);
        pathName = pathName.startsWith("vob:") ? pathName.substring("vob:".length()) : pathName;
        Map<String, Boolean> dir = cc.getFSDirectory(pathName, feedback);
        for (String leafname : dir.keySet()) {
            Location loc = this.getLocation().child(leafname);
            Boolean isDirectory = dir.get(leafname);
            CTControllableResource cr = isDirectory != false ? new CTControllableFolder(loc, provider) : new CTControllableResource(loc, provider);
            childBindings.put(leafname, cr);
        }
        return childBindings;
    }

    public synchronized String getStreamSelector(SrvcFeedback feedback) throws WvcmException {
        throw new IllegalStateException("getStreamSelector() must be implemented in subclasses");
    }

    public String getViewTag() throws WvcmException {
        return this.getLocation().getViewTag();
    }

    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
    }

    @Override
    public CTLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        return this.getLocation();
    }

    @Override
    protected String computePathname(SrvcFeedback feedback) throws WvcmException {
        return CCaseLib.getPathIntoView(this.getLocation().getDisplayName());
    }

    public CTActivity lookupCurrentActivity(SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException(Messages.CTView_UNSUPPORTED_LOOKUP_ACTIVITY_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        CCaseLib cc = provider.getCCaseLib();
        cc.removeView(this.getViewTag(), feedback);
        this.flush(feedback);
    }

    public void prepareToWrite(String pathname, SrvcFeedback feedback) throws WvcmException {
        throw new IllegalStateException("prepareToWrite() must be implemented in subclasses");
    }

    public String getConfigSpec(SrvcFeedback feedback) throws WvcmException {
        return this.getProvider().getCCaseLib().getViewConfigSpec(this.getViewTag(), feedback);
    }

    public void setConfigSpec(String[] configSpec, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.getProvider();
        CCaseLib cc = p.getCCaseLib();
        cc.setViewConfigSpec(this.getViewTag(), configSpec, feedback);
    }
}

