/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.OutputStream;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTVersion
extends CTResource {
    private String _pathname = null;
    private Location _versionHistoryLocation = null;

    CTVersion(Location location, CTProvider provider) {
        super(location, provider);
    }

    public static CTVersion valueOf(CTProvider p, CCaseObjInfo versInfo, SrvcFeedback feedback) throws WvcmException {
        CTLocation versLoc = CTVersion.lookupVersionLocation(versInfo);
        CTResource result = p.createAndCacheCTResource(versLoc, versInfo, feedback);
        if (result == null) {
            throw new IllegalArgumentException("lookup of version selector \"" + versInfo.getUniversalSelector() + "\" returned null");
        }
        if (!(result instanceof CTVersion)) {
            throw new IllegalStateException(" lookup of versionSelector returned an instance of class: " + ((Object)((Object)result)).getClass().getName() + "for location: " + versLoc.toString());
        }
        return (CTVersion)result;
    }

    public static CTLocation lookupVersionLocation(CCaseObjInfo versInfo) {
        String mtype = versInfo.getMtype();
        CTLocation versLoc = null;
        if (mtype.equals("symbolic link")) {
            versLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, versInfo.getUniversalSelector());
        } else {
            if (mtype.equals("view private object")) {
                return null;
            }
            versLoc = CTLocation.valueOf(CTLocation.Kind.VERSION, versInfo.getUniversalSelector());
        }
        return versLoc;
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public void doReadContent(OutputStream content, SrvcFeedback feedback) throws WvcmException {
        String pathName = this.getPathname(feedback);
        this.readContentInternalUsingPathname(pathName, content);
    }

    protected synchronized String getPathname(SrvcFeedback feedback) throws WvcmException {
        boolean retried = false;
        if (this._pathname == null) {
            CCaseLib cc = this.getProvider().getCCaseLib();
            this._pathname = this.getObjInfo(feedback).getPathName();
            if (this._pathname == null || this._pathname.length() == 0) {
                this._pathname = cc.getPathname(this.getLocation().getDisplayName(), feedback);
            }
            if (this._pathname == null || this._pathname.length() == 0) {
                this._pathname = cc.getPathname(this.getLocation().getDisplayName(), feedback);
            }
        }
        if (this._pathname == null || this._pathname.length() == 0) {
            throw new RuntimeException("pathname is null or nullstring for location: " + this.getLocation());
        }
        if (retried) {
            Log log = LogFactory.getLog((String)CCaseLib.class.getName());
            log.debug((Object)"CTVersion getPathname retry worked.");
        }
        return this._pathname;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getPathname(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(feedback);
        }
        if (this.VERSION_HISTORY_PROPERTIES.contains(propertyName)) {
            return this.getVersionHistory(feedback).getThisProperty(propertyName, configuration, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public synchronized CTElement getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        if (this._versionHistoryLocation == null) {
            CCaseLib cc = provider.getCCaseLib();
            String myLocString = this.getLocation().getDisplayName();
            String myVobSel = null;
            myVobSel = ObjSelUtils.isUniversalSelector(myLocString) ? ObjSelUtils.getObjSelVobSel(myLocString) : cc.getVobuuid(myLocString, feedback);
            String elemUsel = cc.getElementUsel(myLocString, myVobSel, feedback);
            if (elemUsel == null) {
                throw new IllegalStateException("Unexpected null value for element selector of version");
            }
            this._versionHistoryLocation = provider.location(elemUsel);
        }
        CTElement vh = (CTElement)provider.lookup(this._versionHistoryLocation, feedback);
        return vh;
    }

    public void setElemUSel(String elemUSel) {
        this._versionHistoryLocation = CTLocation.valueOf(elemUSel);
    }
}

