/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.wvcm.Location;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CTLocation
implements Location {
    public static final String INFO_SEPARATOR_STRING = "|";
    private static final String GEN_SEPARATOR_STRING = ">";
    private static final String PATHNAME_SEPARATOR_STRING = "/";
    public static final String INFO_SEPARATOR_REGEX = "\\|";
    private static final String PARTS_SEPARATOR_STRING = "||";
    private static final String PARTS_SEPARATOR_REGEX = "\\|\\|";
    private static final String CTLOCATION_PREFIX = "(CTLocation: ";
    private static final String CONTEXT_PARTS = "(contextParts ";
    private static final String MYKIND = "myKind: ";
    private static final String MYINFO = ".  myInfo: ";
    private static final String CONTEXT_PREFIX = ".  ";
    private static final String NULL = "<null>";
    private String _string;
    private Parts _parts;
    public static CTLocation _rootLoc = CTLocation.valueOf(Kind.ROOT_LOCATION, "||");
    public static CTLocation _relativeRootLoc = CTLocation.valueOf(Kind.SYMBOLIC_LINK_TARGET, new String());

    private CTLocation(Parts parts) {
        this._string = parts.string();
        this._parts = parts;
    }

    public CTLocation(CTLocation src) {
        this._string = src._string;
        this._parts = src._parts;
    }

    public static CTLocation valueOf(Kind kind, String displayName) {
        if (kind == null) {
            throw new IllegalArgumentException("Null kind for location");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("The displayname of a location cannot be null");
        }
        Parts myParts = new Parts(kind, displayName);
        CTLocation result = new CTLocation(myParts);
        return result;
    }

    public static CTLocation valueOf(String string) {
        return new CTLocation(new Parts(string));
    }

    public String string() {
        return this._string;
    }

    public String toString() {
        return CTLOCATION_PREFIX + this.string() + ')';
    }

    public CTLocation parent() {
        int lastIndexOf;
        Parts myParts = this.getParts();
        if (this.hasKind(Kind.CONFIGURATION)) {
            return this.lookupContextLocation(Kind.WORKSPACE);
        }
        if (this.hasKind(Kind.WORKSPACE) || this.hasKind(Kind.BASE_CC_VIEW)) {
            return _rootLoc;
        }
        String pathname = myParts.get_myInfo();
        String separator = GEN_SEPARATOR_STRING;
        Kind myKind = myParts.get_myKind();
        if (myKind == Kind.CONTROLLABLE_RESOURCE || myKind == Kind.SYMBOLIC_LINK_TARGET) {
            separator = PATHNAME_SEPARATOR_STRING;
        }
        if ((lastIndexOf = pathname.lastIndexOf(separator)) >= 0) {
            Kind kind = this.getKind();
            String parentPN = pathname.substring(0, lastIndexOf);
            if (kind == Kind.SYMBOLIC_LINK_TARGET) {
                if (parentPN.length() == 0) {
                    return _relativeRootLoc;
                }
                return CTLocation.valueOf(kind, parentPN);
            }
            String viewTag = ObjSelUtils.getViewTag(CCaseLib.getMvfsRoot(), this.getDisplayName());
            String info = parentPN;
            if (viewTag != null) {
                String viewPrefix = CCaseLib.getPathIntoView(viewTag).replace(File.separator, PATHNAME_SEPARATOR_STRING);
                if (parentPN.replace(File.separator, PATHNAME_SEPARATOR_STRING).equals(viewPrefix)) {
                    info = viewTag;
                    kind = Kind.WORKSPACE;
                }
            }
            Parts parentParts = new Parts(kind, info, myParts.get_contextMap());
            return new CTLocation(parentParts);
        }
        return null;
    }

    private synchronized Parts getParts() {
        if (this._parts == null) {
            this._parts = new Parts(this._string);
        }
        return this._parts;
    }

    public final boolean hasKind(Kind kind) {
        if (kind == null) {
            return this.getKind() == null;
        }
        return kind.equals((Object)this.getKind());
    }

    public Location child(String bindingName) throws WvcmException {
        if (bindingName.indexOf(PARTS_SEPARATOR_STRING) != -1) {
            throw new WvcmException(NLS.bind((String)Messages.CTLocation_INVALID_CHILD_NAME_ERROR, (Object)PARTS_SEPARATOR_STRING), WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (this.equals(_rootLoc)) {
            return CTLocation.valueOf(Kind.WORKSPACE, bindingName);
        }
        Kind myKind = this._parts.get_myKind();
        if (myKind != null) {
            switch (myKind) {
                case SYMBOLIC_LINK_TARGET: {
                    String name = bindingName;
                    if (this.getDisplayName().length() > 0 || bindingName.length() == 0) {
                        name = String.valueOf(this.getDisplayName()) + PATHNAME_SEPARATOR_STRING + name;
                    }
                    return CTLocation.valueOf(myKind, name);
                }
                case CONTROLLABLE_RESOURCE: {
                    CTLocation viewLoc = this.getViewLocation();
                    Parts resultParts = new Parts(Kind.CONTROLLABLE_RESOURCE, String.valueOf(this.getDisplayName()) + PATHNAME_SEPARATOR_STRING + bindingName);
                    if (viewLoc != null) {
                        resultParts.addContext(viewLoc);
                    }
                    CTLocation result = new CTLocation(resultParts);
                    return result;
                }
                case WORKSPACE: 
                case BASE_CC_VIEW: {
                    String viewTag = this.getViewTag();
                    String path = String.valueOf(CCaseLib.getPathIntoView(viewTag)) + PATHNAME_SEPARATOR_STRING + bindingName;
                    Parts resultParts = new Parts(Kind.CONTROLLABLE_RESOURCE, path);
                    resultParts.addContext(this);
                    return new CTLocation(resultParts);
                }
                case CONFIGURATION: {
                    throw new WvcmException(Messages.CTLocation_INVALID_CHILD_REQUEST_ERROR, WvcmException.ReasonCode.FORBIDDEN);
                }
            }
        }
        String path = String.valueOf(this.getDisplayName()) + GEN_SEPARATOR_STRING + bindingName;
        return CTLocation.valueOf(path);
    }

    public String lastSegment() {
        int finalSep;
        Parts myParts = this.getParts();
        String myInfo = myParts.get_myInfo();
        Kind myKind = myParts.get_myKind();
        String separator = GEN_SEPARATOR_STRING;
        if (myKind == Kind.CONTROLLABLE_RESOURCE || myKind == Kind.WORKSPACE || myKind == Kind.SYMBOLIC_LINK_TARGET) {
            separator = PATHNAME_SEPARATOR_STRING;
        }
        if ((finalSep = myInfo.lastIndexOf(separator)) == -1) {
            return myInfo;
        }
        return myInfo.substring(finalSep + separator.length());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CTLocation)) {
            return false;
        }
        CTLocation other = (CTLocation)o;
        Kind myKind = this.getKind();
        Kind otherKind = other.getKind();
        if (myKind != null && otherKind != null && (myKind.equals((Object)Kind.BASE_CC_VIEW) && otherKind.equals((Object)Kind.WORKSPACE) || myKind.equals((Object)Kind.WORKSPACE) && otherKind.equals((Object)Kind.BASE_CC_VIEW))) {
            String myViewTag = this.getDisplayName();
            String otherViewTag = other.getDisplayName();
            return myViewTag.equals(otherViewTag);
        }
        return this._string.equals(other._string);
    }

    public int hashCode() {
        return this._string.hashCode();
    }

    public static Kind parseKind(String kindString) {
        Kind kind = CTLocation.computeKind(kindString);
        if (kind == null) {
            kind = CTLocation.computeKind(kindString.toUpperCase());
        }
        return kind;
    }

    private static Kind computeKind(String kindString) {
        Kind result;
        try {
            result = Kind.valueOf(kindString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = null;
        }
        return result;
    }

    public String getViewTag() {
        Parts myParts = this.getParts();
        String myInfo = myParts.get_myInfo();
        if (this.hasKind(Kind.WORKSPACE) || this.hasKind(Kind.BASE_CC_VIEW)) {
            return myInfo;
        }
        if (myParts._myContext != null) {
            return ((CTLocation)myParts._myContext.get((Object)Kind.WORKSPACE)).getViewTag();
        }
        throw new IllegalArgumentException("CTLocation.getViewTag() could not get view tag from `" + this._string + '\'');
    }

    public Kind getKind() {
        Parts myParts = this.getParts();
        Kind myKind = myParts.get_myKind();
        return myKind;
    }

    public static CTLocation createConfigurationLoc(CTLocation workspaceLocation, CTLocation componentLocation) {
        workspaceLocation.requireKind(Kind.WORKSPACE);
        componentLocation.requireKind(Kind.COMPONENT);
        return CTLocation.createJoinedLocation(Kind.CONFIGURATION, workspaceLocation, componentLocation);
    }

    public static CTLocation createBaseConfigurationLoc(CTLocation viewLocation, CTLocation vobLocation) {
        viewLocation.requireKind(Kind.BASE_CC_VIEW);
        vobLocation.requireKind(Kind.VOBCOMPONENT);
        return CTLocation.createJoinedLocation(Kind.CONFIGURATION, viewLocation, vobLocation);
    }

    public static CTLocation createJoinedLocation(Kind kind, CTLocation ... locations) {
        return CTLocation.createJoinedLocation(kind, null, locations);
    }

    public static CTLocation createJoinedLocation(Kind kind, String info, CTLocation ... locations) {
        Parts newParts = new Parts(kind, info);
        CTLocation[] cTLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            CTLocation loc = cTLocationArray[n2];
            newParts.addContext(loc);
            ++n2;
        }
        return new CTLocation(newParts);
    }

    public String getDisplayName() {
        return this.getParts().get_myInfo();
    }

    public void requireKind(Kind kind) {
        this.getParts().requireKind(kind);
    }

    public CTLocation lookupContextLocation(Kind kind) {
        Parts myParts = this.getParts();
        if (myParts == null) {
            return null;
        }
        if (myParts.get_myKind().equals((Object)kind)) {
            return this;
        }
        HashMap<Kind, CTLocation> c = myParts.get_contextMap();
        return c == null ? null : c.get((Object)kind);
    }

    public CTLocation getContextLocation(Kind kind) throws WvcmException {
        CTLocation result = this.lookupContextLocation(kind);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTLocation_MISSING_LOCATION_FOR_KIND_ERROR, (Object)kind.toString(), (Object)this.string()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static String getBrtypeFromInfo(String info) {
        String result = null;
        if (info != null) {
            result = info.contains(INFO_SEPARATOR_STRING) ? info.substring(0, info.indexOf(INFO_SEPARATOR_STRING)) : info;
        }
        return result;
    }

    public static String getLbtypeFromInfo(String info) {
        String result = null;
        if (info != null && info.contains(INFO_SEPARATOR_STRING)) {
            result = info.substring(info.indexOf(INFO_SEPARATOR_STRING) + 1);
        }
        return result;
    }

    public static CTLocation createBranchLocation(CTLocation brtypeLocation, CTLocation lbtypeLocation) {
        CTLocation location = null;
        brtypeLocation.requireKind(Kind.BRTYPE);
        if (lbtypeLocation != null) {
            lbtypeLocation.requireKind(Kind.LBTYPE);
            String info = String.valueOf(brtypeLocation.getDisplayName()) + '_' + lbtypeLocation.getDisplayName();
            location = CTLocation.createJoinedLocation(Kind.BRANCH, info, brtypeLocation, lbtypeLocation);
        } else {
            String info = brtypeLocation.getDisplayName();
            location = CTLocation.createJoinedLocation(Kind.BRANCH, info, brtypeLocation);
        }
        return location;
    }

    public static CTLocation createBaseCCBaselineLocation(CTLocation brtypeLocation, CTLocation lbtypeLocation, CTLocation vobComponentLocation, CTLocation timeStampLocation) {
        CTLocation location = null;
        brtypeLocation.requireKind(Kind.BRTYPE);
        vobComponentLocation.requireKind(Kind.VOBCOMPONENT);
        timeStampLocation.requireKind(Kind.TIMESTAMP);
        String info = "BASECCBL" + timeStampLocation.getDisplayName();
        if (lbtypeLocation != null) {
            lbtypeLocation.requireKind(Kind.LBTYPE);
            location = CTLocation.createJoinedLocation(Kind.BASE_CC_BASELINE, info, brtypeLocation, lbtypeLocation, vobComponentLocation, timeStampLocation);
        } else {
            location = CTLocation.createJoinedLocation(Kind.BASE_CC_BASELINE, info, brtypeLocation, vobComponentLocation, timeStampLocation);
        }
        return location;
    }

    public static CTLocation createBaseViewLocation(String viewTag, CTLocation brtypeLoc, CTLocation lbtypeLoc) {
        Parts newParts = new Parts(Kind.BASE_CC_VIEW, viewTag);
        brtypeLoc.requireKind(Kind.BRTYPE);
        newParts.addContext(brtypeLoc);
        if (lbtypeLoc != null) {
            lbtypeLoc.requireKind(Kind.LBTYPE);
            newParts.addContext(lbtypeLoc);
        }
        CTLocation location = new CTLocation(newParts);
        return location;
    }

    private CTLocation getViewLocation() throws WvcmException {
        CTLocation viewLoc = this.lookupContextLocation(Kind.WORKSPACE);
        if (viewLoc == null) {
            viewLoc = this.lookupContextLocation(Kind.BASE_CC_VIEW);
        }
        return viewLoc;
    }

    /* synthetic */ CTLocation(Parts parts, CTLocation cTLocation) {
        this(parts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ACTIVITY,
        BASELINE,
        COMPONENT,
        CONFIGURATION,
        CONTROLLABLE_RESOURCE,
        FOLDER,
        ROOT_LOCATION,
        SYMBOLIC_LINK_TARGET,
        STREAM,
        TASK,
        VERSION,
        SYMBOLIC_LINK_VERSION,
        WORKSPACE,
        BRTYPE,
        LBTYPE,
        BRANCH,
        VOBCOMPONENT,
        TIMESTAMP,
        BASE_CC_BASELINE,
        BASE_CC_VIEW,
        CQTASK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parts {
        private Kind _myKind;
        private String _myInfo;
        private HashMap<Kind, CTLocation> _myContext;

        public Parts(Kind kind, String info) {
            this(kind, info, new HashMap<Kind, CTLocation>());
        }

        public Parts(Kind kind, String info, HashMap<Kind, CTLocation> context) {
            this._myKind = kind;
            this._myInfo = info;
            this._myContext = context != null ? context : new HashMap();
        }

        public Parts(Parts parts) {
            this(parts._myKind, parts._myInfo, parts._myContext);
        }

        public Parts(Kind kind, String info, CTLocation context) {
            this(kind, info);
            this.addContext(context);
        }

        public Parts(String locationString) {
            if (locationString == null) {
                throw new IllegalArgumentException("Location string must not be null");
            }
            String[] segments = this.getSegments(locationString);
            String[] myInfo = this.getInfoStrings(segments[0]);
            String kindString = myInfo[0];
            Kind myKind = CTLocation.parseKind(kindString);
            if (myKind == null) {
                this._myKind = null;
                this._myInfo = myInfo[0];
                this._myContext = null;
                return;
            }
            String details = myInfo.length > 1 ? myInfo[1] : new String();
            this._myKind = myKind;
            this._myInfo = details;
            this._myContext = new HashMap();
            int i = 1;
            while (i < segments.length) {
                String segment = segments[i];
                String[] infoSegments = this.getSegments(segment);
                String[] segmentInfo = this.getInfoStrings(infoSegments[0]);
                Kind segmentKind = CTLocation.parseKind(segmentInfo[0]);
                String info = segmentInfo.length > 1 ? segmentInfo[1] : new String();
                Parts segmentParts = new Parts(segmentKind, info);
                CTLocation segmentLocation = new CTLocation(segmentParts, null);
                this.addContext(segmentLocation);
                ++i;
            }
        }

        public String[] getInfoStrings(String segment) throws IllegalArgumentException {
            String[] myInfo = segment.split(CTLocation.INFO_SEPARATOR_REGEX);
            if (myInfo.length < 1) {
                throw new IllegalArgumentException("Could not interpret location string (could not find kind): " + segment);
            }
            return myInfo;
        }

        public String[] getSegments(String locationString) throws IllegalArgumentException {
            String[] segments = locationString.split(CTLocation.PARTS_SEPARATOR_REGEX);
            if (segments.length < 1) {
                throw new IllegalArgumentException("Could not interpret location string: " + locationString);
            }
            return segments;
        }

        public Kind get_myKind() {
            return this._myKind;
        }

        public String get_myInfo() {
            return this._myInfo;
        }

        public boolean equiv(Parts other) {
            boolean kindsEquiv = this._myKind.equals((Object)other._myKind);
            boolean detailsEquiv = this._myInfo.equals(other._myInfo);
            boolean contextEquiv = false;
            contextEquiv = this._myContext == null ? other._myContext == null : (other._myContext == null ? false : this._myContext.equals(other._myContext));
            return kindsEquiv && detailsEquiv && contextEquiv;
        }

        public void requireKind(Kind expectedKind) {
            if (!this._myKind.equals((Object)expectedKind)) {
                throw new IllegalArgumentException("Expected kind: " + expectedKind.toString() + " actual kind: " + this._myKind.toString());
            }
        }

        public void requireNoContext() {
            if (this._myContext != null) {
                throw new IllegalArgumentException("Expected no context parts.  actual contextParts: " + this._myContext.toString());
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer(CTLocation.CONTEXT_PARTS);
            result.append(CTLocation.MYKIND);
            result.append(this._myKind.toString());
            result.append(CTLocation.MYINFO);
            result.append(this._myInfo);
            result.append(CTLocation.CONTEXT_PREFIX);
            if (this._myContext == null) {
                result.append(CTLocation.NULL);
            } else {
                result.append(this._myContext.toString());
            }
            result.append(')');
            return result.toString();
        }

        private String string() {
            StringBuffer result = new StringBuffer();
            if (this._myKind != null) {
                result.append(this._myKind.toString());
                if (this.get_myInfo() != null) {
                    result.append(CTLocation.INFO_SEPARATOR_STRING);
                }
            }
            if (this.get_myInfo() != null) {
                result.append(this.get_myInfo());
            }
            if (this._myContext != null) {
                Set<Kind> keySet = this._myContext.keySet();
                ArrayList<Kind> keyList = new ArrayList<Kind>(keySet.size());
                keyList.addAll(keySet);
                Collections.sort(keyList);
                for (Kind contextKind : keyList) {
                    result.append(CTLocation.PARTS_SEPARATOR_STRING);
                    result.append(this._myContext.get((Object)contextKind).string());
                }
            }
            return result.toString();
        }

        public void requireContext() {
            if (this._myContext == null) {
                throw new IllegalArgumentException("Expected context parts.  actual contextParts is null");
            }
        }

        public void addContext(CTLocation context) {
            Parts contextParts = context.getParts();
            this._myContext.put(contextParts.get_myKind(), context);
        }

        public HashMap<Kind, CTLocation> get_contextMap() {
            return this._myContext;
        }
    }
}

