/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.DiffBLInfo;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wvcm.Baseline;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTBaseline
extends CTVersion {
    private static final String SPACES = " +";
    private static final String TWO_LEFT_ARROWS = "<<";
    private static final String TWO_RIGHT_ARROWS = ">>";
    private static final String LEFT_ARROW = "<-";
    private static final String RIGHT_ARROW = "->";

    CTBaseline(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return BaselineImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getLocation();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return new CTComponent(this.getComponentLocation(feedback), this.getProvider());
        }
        if (propertyName.equals((Object)Version.VERSION_NAME)) {
            return this.getPathname(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private Location getComponentLocation(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(cc, this.getComponentSelector(feedback), feedback);
        String compUsel = compObjInfo.getUniversalSelector();
        CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compUsel);
        return compLoc;
    }

    private final List<DiffBLInfo> getDiffBLInfosFromVersions(String baselineSelectorOld, String baselineSelectorNew, VersionDiffs versionDiffs, boolean newOnly, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        ArrayList<DiffBLInfo> result = new ArrayList<DiffBLInfo>();
        List<String> versionStrings = versionDiffs.getVersions();
        if (versionStrings.isEmpty()) {
            return result;
        }
        List<CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(cc, versionStrings, feedback);
        ArrayList<String> elemStrings = new ArrayList<String>(verInfos.size());
        for (CCaseVerInfo verInfo : verInfos) {
            elemStrings.add(verInfo.getElemPathName());
        }
        if (elemStrings == null || elemStrings.size() == 0) {
            throw new IllegalArgumentException("elemStrings must not be null or empty");
        }
        List<CCaseObjInfo> elemInfos = CCaseObjInfo.getObjInfos(cc, elemStrings, feedback);
        int expectedSize = elemInfos.size();
        if (verInfos.size() != expectedSize || versionStrings.size() != expectedSize || versionDiffs.getInNewList().size() != expectedSize) {
            throw new IllegalStateException("Unexpected size mismatch in info computed from diffBL output");
        }
        HashMap<String, DiffBLInfo> elems = new HashMap<String, DiffBLInfo>(elemInfos.size());
        Iterator<CCaseVerInfo> verIt = verInfos.iterator();
        Iterator<Boolean> boolIt = versionDiffs.getInNewList().iterator();
        for (CCaseObjInfo elemInfo : elemInfos) {
            boolean inNew = boolIt.next();
            CCaseVerInfo verInfo = verIt.next();
            String elemUSel = elemInfo.getUniversalSelector();
            this.getProvider().createAndCacheCTResource(CTLocation.valueOf(elemUSel), elemInfo, feedback);
            CTVersion ver = inNew || !newOnly ? CTVersion.valueOf(this.getProvider(), verInfo, feedback) : null;
            String elemPathName = elemInfo.getPathName();
            DiffBLInfo diffBLInfo = (DiffBLInfo)elems.get(elemPathName);
            if (diffBLInfo == null) {
                diffBLInfo = new DiffBLInfo(inNew ? null : ver, inNew ? ver : null, this.getProvider());
                result.add(diffBLInfo);
                elems.put(elemPathName, diffBLInfo);
            } else if (inNew) {
                if (diffBLInfo.getNewBaselineVersion() == null) {
                    diffBLInfo.setNewBaselineVersion(ver);
                } else {
                    ver = diffBLInfo.lookupNewBaselineVersion(baselineSelectorNew, elemInfo, feedback);
                }
            } else if (diffBLInfo.getOldBaselineVersion() == null) {
                diffBLInfo.setOldBaselineVersion(ver);
            } else {
                ver = diffBLInfo.lookupOldBaselineVersion(baselineSelectorOld, elemInfo, feedback);
            }
            if (ver == null) continue;
            ver.setElemUSel(elemUSel);
        }
        return result;
    }

    private VersionDiffs getVersionDiffs(List<String> versionLines) {
        ArrayList<String> versionStrings = new ArrayList<String>(versionLines.size());
        ArrayList<Boolean> baselines = new ArrayList<Boolean>(versionLines.size());
        for (String line : versionLines) {
            String[] items = line.split(SPACES, 2);
            if (items[0].equals(TWO_LEFT_ARROWS)) {
                baselines.add(false);
                versionStrings.add(items[1].trim());
                continue;
            }
            if (!items[0].equals(TWO_RIGHT_ARROWS)) continue;
            baselines.add(true);
            versionStrings.add(items[1].trim());
        }
        return new VersionDiffs(versionStrings, baselines);
    }

    protected SrvcResource.SrvcCompareReport computeBlReport(DiffBLInfo diffBLInfo) throws WvcmException {
        CTVersion vOld = diffBLInfo.getOldBaselineVersion();
        CTVersion vNew = diffBLInfo.getNewBaselineVersion();
        if (vOld == null && vNew == null) {
            throw new IllegalArgumentException("Old and new versions are both null");
        }
        if (vOld == null) {
            return new SrvcResource.SrvcAddedVersion((SrvcResource)vNew);
        }
        if (vNew == null) {
            return new SrvcResource.SrvcDeletedVersion((SrvcResource)vOld);
        }
        return new SrvcResource.SrvcChangedVersion((SrvcResource)vOld, (SrvcResource)vNew);
    }

    private SrvcResource.SrvcCompareReport computeBlReport(String actLine, SrvcFeedback feedback) throws WvcmException {
        String[] items = actLine.split(SPACES, 3);
        CTLocation activityLoc = CTLocation.valueOf(CTLocation.Kind.ACTIVITY, ObjSelUtils.formatSelector("activity", items[1].trim()));
        String prefix = items[0];
        CTActivity ctAct = (CTActivity)this.getProvider().lookup(activityLoc, feedback);
        if (prefix.equals(TWO_RIGHT_ARROWS)) {
            return new SrvcResource.SrvcAddedActivity((SrvcResource)ctAct);
        }
        if (prefix.equals(TWO_LEFT_ARROWS)) {
            return new SrvcResource.SrvcDeletedActivity((SrvcResource)ctAct);
        }
        if (prefix.equals(RIGHT_ARROW)) {
            return new SrvcResource.SrvcPartiallyAddedActivity((SrvcResource)ctAct);
        }
        if (prefix.equals(LEFT_ARROW)) {
            return new SrvcResource.SrvcPartiallyDeletedActivity((SrvcResource)ctAct);
        }
        throw new IllegalArgumentException("Activity line has unrecognized prefix: " + actLine);
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource resource, Baseline.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        if (!(resource instanceof CTBaseline)) {
            throw new IllegalArgumentException("Compare report should be for baseline");
        }
        CTBaseline newBaseline = (CTBaseline)resource;
        if (newBaseline.equals((Object)this)) {
            return new ArrayList<SrvcResource.SrvcCompareReport>();
        }
        boolean getActs = false;
        boolean newOnly = false;
        Baseline.CompareFlag[] compareFlagArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            Baseline.CompareFlag flag = compareFlagArray[n2];
            if (flag.equals(Baseline.CompareFlag.ACTIVITIES)) {
                getActs = true;
            } else if (flag.equals(Baseline.CompareFlag.NEW_ONLY)) {
                newOnly = true;
            }
            ++n2;
        }
        CTProvider p = this.getProvider();
        String baselineSelectorOld = this.getUniversalSelector(feedback);
        String baselineSelectorNew = newBaseline.getUniversalSelector(feedback);
        List<String> versionLines = p.getCCaseLib().diffBl(false, baselineSelectorOld, baselineSelectorNew, feedback);
        VersionDiffs versionDiffs = this.getVersionDiffs(versionLines);
        List<DiffBLInfo> elems = this.getDiffBLInfosFromVersions(baselineSelectorOld, baselineSelectorNew, versionDiffs, newOnly, feedback);
        ArrayList<SrvcResource.SrvcCompareReport> blReports = new ArrayList<SrvcResource.SrvcCompareReport>(elems.size());
        for (DiffBLInfo e : elems) {
            if (e.getOldBaselineVersion() == null && e.getNewBaselineVersion() == null) continue;
            blReports.add(this.computeBlReport(e));
        }
        if (getActs) {
            List<String> actLines = p.getCCaseLib().diffBl(true, baselineSelectorOld, baselineSelectorNew, feedback);
            for (String actLine : actLines) {
                blReports.add(this.computeBlReport(actLine, feedback));
            }
        }
        return blReports;
    }

    private String getComponentSelector(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        String componentSelector = cc.getComponent(this.getLocation().getDisplayName(), feedback);
        return componentSelector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionDiffs {
        private List<String> versionStrings;
        private List<Boolean> inNewList;

        VersionDiffs(List<String> versionStrings, List<Boolean> inNewList) {
            this.versionStrings = versionStrings;
            this.inNewList = inNewList;
        }

        public List<String> getVersions() {
            return this.versionStrings;
        }

        public List<Boolean> getInNewList() {
            return this.inNewList;
        }
    }
}

