/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCaseObjInfo {
    private CCaseLib _cc;
    private boolean _isDirectory;
    private String _pathname;
    private String _universalSelector;
    private String _mtype;
    public static final Collection<String> FILE_SYSTEM_METATYPES = Arrays.asList("directory version", "directory element", "file element", "symbolic link", "version");

    public static CCaseObjInfo getObjInfo(CCaseLib cc, String pathName, SrvcFeedback feedback) throws WvcmException {
        List<CCaseObjInfo> objInfos = CCaseObjInfo.getObjInfos(cc, Collections.singletonList(pathName), feedback);
        if (objInfos.isEmpty()) {
            return null;
        }
        return objInfos.get(0);
    }

    public static List<CCaseObjInfo> getObjInfos(CCaseLib cc, List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        CommandResult.IgnoreFlags flags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        List<CCaseObjInfo> objInfos = CCaseObjInfo.getObjInfos(cc, pathNames, flags, feedback);
        if (objInfos == null) {
            throw new IllegalStateException(pathNames + " not found, but no exception thrown");
        }
        return objInfos;
    }

    public static CCaseObjInfo lookupObjInfo(CCaseLib cc, String pathName, SrvcFeedback feedback) throws WvcmException {
        List<CCaseObjInfo> objInfos = CCaseObjInfo.lookupObjInfos(cc, Collections.singletonList(pathName), feedback);
        if (objInfos.isEmpty()) {
            return null;
        }
        return objInfos.get(0);
    }

    public static List<CCaseObjInfo> lookupObjInfos(CCaseLib cc, List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        return CCaseObjInfo.getObjInfos(cc, pathNames, ignoreFlags, feedback);
    }

    private static List<CCaseObjInfo> getObjInfos(CCaseLib cc, List<String> pathNames, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CCaseObjInfo> results = new ArrayList<CCaseObjInfo>();
        if (pathNames.size() > 0) {
            List<String[]> tokensList = cc.describeForObjInfo(pathNames, flags, feedback);
            for (String[] tokens : tokensList) {
                if (tokens == null || tokens.length == 0) {
                    results.add(null);
                    continue;
                }
                results.add(new CCaseObjInfo(cc, tokens[1], tokens[0].startsWith("directory"), tokens[2], tokens[0]));
            }
        }
        return results;
    }

    public CCaseObjInfo(CCaseLib cc, String universalSelector, boolean isDirectory, String pathName, String mtype) {
        this._cc = cc;
        this._universalSelector = universalSelector;
        this._isDirectory = isDirectory;
        this._pathname = CommonUtils.canonicalizePathname(pathName);
        this._mtype = mtype;
    }

    public String getPathName() throws WvcmException {
        if (this._pathname == null) {
            this._pathname = CommonUtils.canonicalizePathname(this._cc.getPathname(this._universalSelector, null));
        }
        return this._pathname;
    }

    public String getUniversalSelector() {
        return this._universalSelector;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public String getMtype() {
        return this._mtype;
    }

    public String lookupVobUuid() {
        if (this._universalSelector != null) {
            String result = ObjSelUtils.vobUuidSubstring(this._universalSelector);
            return result;
        }
        return null;
    }

    public void clearPathname() {
        if (CCaseObjInfo.isFileSystemMetatype(this._mtype)) {
            this._pathname = null;
        }
    }

    public static boolean isFileSystemMetatype(String mtype) {
        return FILE_SYSTEM_METATYPES.contains(mtype);
    }
}

