/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.remotehelp.panel;

import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.ui.api.IAgentUI;
import com.ibm.cic.agent.ui.extensions.CustomPanel;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.rational.cdi.remotehelp.panel.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class InstallHelpPanel
extends CustomPanel {
    private static final String CSHELP_ID = "com.ibm.rational.cdi.remotehelp.panel.cshelp.remotehelp";
    private static final String REMOTEHELP_IU_ID = "com.ibm.rational.cdi.remotehelp.panel";
    public final int HELP_NONE = 0;
    public final int HELP_LOCAL = 1;
    public final int HELP_REMOTE = 2;
    public final int HELP_CUSTOM = 3;
    public final String HELP_LOCAL_NAME = "local";
    public final String HELP_REMOTE_NAME = "remote";
    public final String HELP_CUSTOM_NAME = "custom";
    public final String KEY_HELP_OPTION = "user.help.option";
    public final String KEY_HELP_URL = "user.help.url";
    private int helpOption = 0;
    private Button bRemote = null;
    private Button bLocal = null;
    private Button bCustom = null;
    private Text tHost = null;
    private Text tPort = null;
    private Text tPath = null;
    private Composite containerOptions;
    private Composite containerCustom;
    StyledText mainDescription;
    Composite mainContainer;
    private FormToolkit toolkit;

    public InstallHelpPanel() {
        super(Messages.Panel_Header);
        super.setDescription(Messages.Panel_Header_Desc);
        super.setHelpRef(CSHELP_ID);
    }

    public InstallHelpPanel(String pageName) {
        super(pageName);
    }

    public boolean canAddPanelToWizardPage() {
        return true;
    }

    public void createControl(Composite parent) {
        IAdaptable adaptable = this.getInitializationData();
        IAgentUI agentUI = (IAgentUI)adaptable.getAdapter(IAgentUI.class);
        this.toolkit = agentUI.getFormToolkit();
        this.mainContainer = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 5;
        this.mainContainer.setLayout((Layout)gridLayout);
        ScrolledForm form = this.toolkit.createScrolledForm(this.mainContainer);
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mainContainer.setLayoutData((Object)gridData);
        this.createCoreControls(form.getBody());
        this.setControl((Control)this.mainContainer);
    }

    private void createCoreControls(Composite parent) {
        GridLayout gridLayout = null;
        GridData containerGridData = null;
        GridData gridData = null;
        Label label = null;
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 5;
        gridLayout.numColumns = 1;
        containerGridData = new GridData(1040);
        Composite messageContainer = this.toolkit.createComposite(parent);
        messageContainer.setLayout((Layout)gridLayout);
        messageContainer.setLayoutData((Object)containerGridData);
        this.mainDescription = new StyledText(parent, 74);
        this.mainDescription.setText(Messages.Help_Desc1);
        this.mainDescription.setBlockSelection(true);
        gridData = new GridData(1808);
        gridData.widthHint = 600;
        this.mainDescription.setLayoutData((Object)gridData);
        label = new Label(parent, 64);
        label.setText(Messages.Help_Desc2);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.containerOptions = new Composite(parent, 0);
        GridLayout gridLayout0 = new GridLayout(2, false);
        gridLayout0.horizontalSpacing = 0;
        this.containerOptions.setLayout((Layout)gridLayout0);
        gridData = new GridData(768);
        this.containerOptions.setLayoutData((Object)gridData);
        this.bRemote = new Button(this.containerOptions, 16);
        gridData = new GridData(770);
        this.bRemote.setLayoutData((Object)gridData);
        this.bRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                InstallHelpPanel.this.helpOption = 2;
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }
        });
        StyledText labelRemote = new StyledText(this.containerOptions, 74);
        labelRemote.setText(Messages.Button_Remote);
        gridData = new GridData(1808);
        gridData.widthHint = 570;
        labelRemote.setLayoutData((Object)gridData);
        labelRemote.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                InstallHelpPanel.this.helpOption = 2;
                InstallHelpPanel.this.bRemote.setSelection(true);
                InstallHelpPanel.this.bLocal.setSelection(false);
                InstallHelpPanel.this.bCustom.setSelection(false);
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.bLocal = new Button(this.containerOptions, 16);
        gridData = new GridData(770);
        this.bLocal.setLayoutData((Object)gridData);
        this.bLocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                InstallHelpPanel.this.helpOption = 1;
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }
        });
        StyledText labelLocal = new StyledText(this.containerOptions, 74);
        labelLocal.setText(Messages.Button_Local);
        gridData = new GridData(1808);
        gridData.widthHint = 570;
        labelLocal.setLayoutData((Object)gridData);
        labelLocal.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                InstallHelpPanel.this.helpOption = 1;
                InstallHelpPanel.this.bRemote.setSelection(false);
                InstallHelpPanel.this.bLocal.setSelection(true);
                InstallHelpPanel.this.bCustom.setSelection(false);
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.bCustom = new Button(this.containerOptions, 16);
        gridData = new GridData(770);
        this.bCustom.setLayoutData((Object)gridData);
        this.bCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                InstallHelpPanel.this.helpOption = 3;
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }
        });
        StyledText labelCustom = new StyledText(this.containerOptions, 74);
        labelCustom.setText(Messages.Button_Custom);
        gridData = new GridData(32);
        labelCustom.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.widthHint = 570;
        labelCustom.setLayoutData((Object)gridData);
        labelCustom.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                InstallHelpPanel.this.helpOption = 3;
                InstallHelpPanel.this.bRemote.setSelection(false);
                InstallHelpPanel.this.bLocal.setSelection(false);
                InstallHelpPanel.this.bCustom.setSelection(true);
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        label = new Label(this.containerOptions, 0);
        gridData = new GridData(770);
        label.setLayoutData((Object)gridData);
        this.containerCustom = new Composite(this.containerOptions, 0);
        GridLayout gridLayout1 = new GridLayout(2, false);
        gridLayout1.horizontalSpacing = 5;
        this.containerCustom.setLayout((Layout)gridLayout1);
        gridData = new GridData(768);
        this.containerCustom.setLayoutData((Object)gridData);
        label = new Label(this.containerCustom, 64);
        label.setText(Messages.Label_Host);
        gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        this.tHost = new Text(this.containerCustom, 2052);
        gridData = new GridData(1808);
        this.tHost.setLayoutData((Object)gridData);
        this.tHost.setTextLimit(50);
        this.tHost.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }
        });
        label = new Label(this.containerCustom, 64);
        label.setText(Messages.Label_Port);
        gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        this.tPort = new Text(this.containerCustom, 2052);
        gridData = new GridData(1808);
        this.tPort.setLayoutData((Object)gridData);
        this.tPort.setTextLimit(5);
        this.tPort.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }
        });
        label = new Label(this.containerCustom, 64);
        label.setText(Messages.Label_Path);
        gridData = new GridData(32);
        label.setLayoutData((Object)gridData);
        this.tPath = new Text(this.containerCustom, 2052);
        gridData = new GridData(1808);
        this.tPath.setLayoutData((Object)gridData);
        this.tPath.setTextLimit(255);
        this.tPath.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                InstallHelpPanel.this.setControlStates();
                InstallHelpPanel.this.verifyComplete();
            }
        });
    }

    private void readFromResponseFile() {
        IProfile profile = this.getProductProfile();
        if (profile == null) {
            this.helpOption = 0;
            return;
        }
        String savedHelpOption = profile.getUserData("user.help.option");
        if (savedHelpOption != null) {
            if (savedHelpOption.equals("remote")) {
                this.bRemote.setSelection(true);
                this.helpOption = 2;
            } else if (savedHelpOption.equals("local")) {
                this.bLocal.setSelection(true);
                this.helpOption = 1;
            } else if (savedHelpOption.equals("custom")) {
                this.bCustom.setSelection(true);
                this.helpOption = 3;
            } else {
                this.helpOption = 0;
            }
        } else {
            this.helpOption = 0;
        }
        String savedURL = profile.getUserData("user.help.url");
        if (savedURL != null) {
            try {
                URL url = new URL(savedURL);
                this.tHost.setText(url.getHost());
                this.tPath.setText(url.getPath());
                int port = url.getPort();
                if (port == -1) {
                    this.tPort.setText("");
                } else {
                    this.tPort.setText(Integer.toString(port));
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public void setInitialData() {
        this.readFromResponseFile();
        String[] offeringList = this.getOfferingsWithLocalHelp();
        String packagesName = this.getPackagesName(offeringList);
        String newDescription = MessageFormat.format(Messages.Help_Desc1, "\"" + packagesName + "\"");
        this.mainDescription.setText(newDescription);
        this.setControlStates();
        this.mainContainer.pack();
        this.verifyComplete();
    }

    private void setControlStates() {
        if (this.helpOption == 0) {
            this.helpOption = 2;
            this.bRemote.setSelection(true);
        }
        switch (this.helpOption) {
            case 2: {
                this.tHost.setEnabled(false);
                this.tPort.setEnabled(false);
                this.tPath.setEnabled(false);
                break;
            }
            case 1: {
                this.tHost.setEnabled(false);
                this.tPort.setEnabled(false);
                this.tPath.setEnabled(false);
                break;
            }
            case 3: {
                this.tHost.setEnabled(true);
                this.tPort.setEnabled(true);
                this.tPath.setEnabled(true);
                break;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void verifyComplete() {
        IProfile profile = this.getProductProfile();
        if (profile == null) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (this.bRemote.getSelection()) {
            profile.setUserData("user.help.option", "remote");
            profile.setUserData("user.help.url", "");
        } else if (this.bLocal.getSelection()) {
            profile.setUserData("user.help.option", "local");
            profile.setUserData("user.help.url", "");
        } else if (this.bCustom.getSelection()) {
            profile.setUserData("user.help.option", "custom");
            URL url = this.getURL();
            if (url == null) {
                this.setErrorMessage(Messages.ERROR_URL);
                this.setPageComplete(false);
                return;
            }
            profile.setUserData("user.help.url", url.toString());
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private URL getURL() {
        int portNum;
        URL url = null;
        String host = this.tHost.getText().trim();
        String port = this.tPort.getText().trim();
        String path = this.tPath.getText().trim();
        if (port.length() == 0) {
            portNum = 80;
        } else {
            try {
                portNum = Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (host.length() == 0) {
            return null;
        }
        try {
            url = new URL("http", host, portNum, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return url;
    }

    public boolean shouldSkip() {
        return false;
    }

    public IStatus performFinish(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    private IProfile getProductProfile() {
        IAgentJob[] jobs = (IAgentJob[])this.getInitializationData().getAdapter(IAgentJob[].class);
        if (jobs == null) {
            return null;
        }
        int i = 0;
        while (i < jobs.length) {
            IProfile profile = jobs[i].getAssociatedProfile();
            if (profile != null && !profile.getProfileKind().equals("self") && !profile.getProfileKind().equals("license")) {
                return profile;
            }
            ++i;
        }
        return null;
    }

    private String[] getOfferingsWithLocalHelp() {
        Vector<String> offeringVector = new Vector<String>();
        IAgentJob[] jobs = (IAgentJob[])this.getInitializationData().getAdapter(IAgentJob[].class);
        if (jobs == null) {
            return null;
        }
        int i = 0;
        while (i < jobs.length) {
            IProfile profile = jobs[i].getAssociatedProfile();
            if (profile != null && !profile.getProfileKind().equals("self") && !profile.getProfileKind().equals("license")) {
                IOffering currOffering = jobs[i].getOffering();
                List list = currOffering.getInstallableUnits();
                int j = 0;
                while (j < list.size()) {
                    IInstallableUnit iu = (IInstallableUnit)list.get(j);
                    if (iu.getName().equals(REMOTEHELP_IU_ID)) {
                        offeringVector.add(currOffering.getName());
                    }
                    ++j;
                }
            }
            ++i;
        }
        String[] offeringArray = offeringVector.toArray(new String[0]);
        return offeringArray;
    }

    private String getPackagesName(String[] list) {
        if (list.length == 0) {
            return "";
        }
        if (list.length == 1) {
            return list[0];
        }
        StringBuffer buf = new StringBuffer(list[0]);
        int i = 1;
        while (i < list.length) {
            buf.append(", ");
            buf.append(list[i]);
            ++i;
        }
        return buf.toString();
    }
}

