/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.net.URI;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class MultiSchemaTypeProperty
extends BaseMultiValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = "/:.{}";
    protected int customPropertyFlag = 68;
    protected URI[] relativeURILocations = new URI[0];

    public MultiSchemaTypeProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, QName.class, parentGroup);
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiSchemaTypeProperty property = (MultiSchemaTypeProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public String[] getValuesAsStrings() {
        return super.getValuesAsStrings();
    }

    @Override
    protected Object convertStringValue(String newValue) throws CoreException {
        if (newValue != null) {
            int openCurly_index = newValue.indexOf("{");
            int closeCurly_index = newValue.indexOf("}");
            if (openCurly_index < 0 && closeCurly_index < 0) {
                return new QName(newValue);
            }
            if (openCurly_index >= 0 && closeCurly_index >= 0 && openCurly_index < closeCurly_index && newValue.indexOf("{", openCurly_index + 1) < 0 && newValue.indexOf("}", closeCurly_index + 1) < 0) {
                return new QName(newValue.substring(openCurly_index + 1, closeCurly_index), newValue.substring(closeCurly_index + 1));
            }
        }
        Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_LONG_STRING, (Object)newValue), null);
        throw new CoreException((IStatus)status);
    }

    public URI[] getLocations() {
        return this.relativeURILocations;
    }

    public void setLocations(URI[] uri) throws CoreException {
        if (uri == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_INVALID_OBJECT_TYPE, null);
            throw new CoreException((IStatus)status);
        }
        int i = 0;
        while (i < uri.length) {
            if (uri[i] == null) {
                Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_URI_NOT_FILE, null);
                throw new CoreException((IStatus)status);
            }
            if (uri[i].isAbsolute()) {
                Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_URI_NOT_RELATIVE, (Object)uri[i]), null);
                throw new CoreException((IStatus)status);
            }
            ++i;
        }
        this.relativeURILocations = uri;
    }
}

