/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;

public class MultiJavaTypeProperty
extends BaseMultiValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = ".";
    protected int customPropertyFlag = 36;
    String[] implementationTypes;

    public MultiJavaTypeProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validImplementationTypes) throws CoreException {
        super(propertyName, displayName, propertyDescription, String.class, parentGroup);
        this.implementationTypes = validImplementationTypes;
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    public String[] getImplementationTypes() {
        return this.implementationTypes;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiJavaTypeProperty property = (MultiJavaTypeProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        block22: {
            if (evt.getNewValue() == null || "".equals(evt.getNewValue().toString())) {
                return;
            }
            String className = evt.getNewValue().toString();
            int index = className.lastIndexOf(BIDI_DELIMITERS);
            String pkg = index > 0 ? className.substring(0, index) : null;
            String name = index > 0 ? className.substring(index + 1) : className;
            IStatus status = JavaConventions.validateJavaTypeName((String)name);
            if (!status.isOK()) {
                throw new PropertyVetoException(status.getMessage(), evt);
            }
            status = JavaConventions.validatePackageName((String)pkg);
            if (!status.isOK()) {
                throw new PropertyVetoException(status.getMessage(), evt);
            }
            try {
                final ArrayList javaTypes = new ArrayList();
                SearchEngine searchEngine = new SearchEngine();
                TypeNameRequestor requestor = new TypeNameRequestor(){

                    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                        class TypeInfo {
                            String className;
                            String path;

                            TypeInfo(char[] packageName, char[] simpleTypeName, String path) {
                                if (simpleTypeName != null) {
                                    this.className = packageName != null ? String.valueOf(new String(packageName)) + MultiJavaTypeProperty.BIDI_DELIMITERS + new String(simpleTypeName) : new String(simpleTypeName);
                                }
                                this.path = path;
                            }

                            public String getClassName() {
                                return this.className;
                            }

                            public String getPath() {
                                return this.path;
                            }
                        }
                        TypeInfo type = new TypeInfo(packageName, simpleTypeName, path);
                        javaTypes.add(type);
                    }
                };
                IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();
                searchEngine.searchAllTypeNames(pkg.toCharArray(), name.toCharArray(), 64, 10, workspaceScope, requestor, 3, (IProgressMonitor)new NullProgressMonitor());
                if (javaTypes.isEmpty()) {
                    throw new PropertyVetoException(MessageResource.bind((String)MessageResource.ERR_CAN_NOT_FIND_CLASS, (Object)className), evt);
                }
                String[] implementationTypes = this.getImplementationTypes();
                if (implementationTypes == null || implementationTypes.length <= 0) break block22;
                TypeInfo typeInfo = (TypeInfo)javaTypes.get(0);
                Path path = new Path(typeInfo.getPath());
                IType resolvedType = null;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segments()[0]);
                if (project == null || !project.exists()) {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    if (projects != null) {
                        int i = 0;
                        while (i < projects.length) {
                            IType t;
                            IJavaProject javaProj = JavaCore.create((IProject)projects[i]);
                            if (javaProj != null && javaProj.exists() && (t = javaProj.findType(className)) != null) {
                                resolvedType = t;
                                break;
                            }
                            ++i;
                        }
                    }
                } else {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    resolvedType = javaProject.findType(className);
                }
                if (resolvedType == null) {
                    throw new PropertyVetoException(MessageResource.bind((String)MessageResource.ERR_CAN_NOT_FIND_CLASS, (Object)className), evt);
                }
                String[] superInterfaceNames = resolvedType.getSuperInterfaceNames();
                boolean found = false;
                if (superInterfaceNames != null) {
                    int i = 0;
                    while (i < implementationTypes.length) {
                        found = false;
                        int j = 0;
                        while (j < superInterfaceNames.length) {
                            if (superInterfaceNames[j].equals(implementationTypes[i])) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                if (!found) {
                    ITypeHierarchy hierarchy = resolvedType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    IType[] superInterfaces = hierarchy.getAllTypes();
                    if (superInterfaces == null || superInterfaces.length < implementationTypes.length) {
                        throw new PropertyVetoException(MessageResource.bind((String)MessageResource.ERR_CLASS_DOES_NOT_IMPLEMENT_INTERFACE, (Object)className, (Object)implementationTypes[0]), evt);
                    }
                    int i = 0;
                    while (i < implementationTypes.length) {
                        found = false;
                        int j = 0;
                        while (j < superInterfaces.length) {
                            if (superInterfaces[j].getFullyQualifiedName().equals(implementationTypes[i])) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            throw new PropertyVetoException(MessageResource.bind((String)MessageResource.ERR_CLASS_DOES_NOT_IMPLEMENT_INTERFACE, (Object)className, (Object)implementationTypes[i]), evt);
                        }
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                throw new PropertyVetoException(e.getLocalizedMessage(), evt);
            }
        }
    }
}

