/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BaseMultiValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class MultiFileProperty
extends BaseMultiValuedProperty
implements ICustomProperty {
    public static final String BIDI_DELIMITERS = "/\\:.";
    protected int customPropertyFlag = 20;
    String[] fileExtensions;
    protected boolean mustExist = true;

    public MultiFileProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validFileExtensions) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.fileExtensions = validFileExtensions;
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    public MultiFileProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validFileExtensions, boolean mustExist) throws CoreException {
        super(propertyName, displayName, propertyDescription, URI.class, parentGroup);
        this.fileExtensions = validFileExtensions;
        this.addVetoablePropertyChangeListener(this);
        this.propertyFlag |= 0x104;
        this.mustExist = mustExist;
        this.propertyType.setBidiDelimiters(BIDI_DELIMITERS);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiFileProperty property = (MultiFileProperty)super.clone();
        property.addVetoablePropertyChangeListener(property);
        return property;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() != this) return;
        if (evt.getNewValue() == null) {
            if (!this.getPropertyType().isRequired()) return;
            throw new PropertyVetoException(MessageResource.ERR_URI_NOT_NULL, evt);
        }
        URI uri = (URI)evt.getNewValue();
        if ("platform".equals(uri.scheme())) {
            if (uri.segmentCount() <= 1 || !"resource".equals(uri.segment(0))) throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = uri.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)uri.segment(i)));
                ++i;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(platformResourcePath.toString(), 1);
            if (status.getCode() != 4) return;
            throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
        }
        if (!uri.isFile()) {
            throw new PropertyVetoException(MessageResource.ERR_URI_NOT_FILE, evt);
        }
        if (this.fileExtensions == null || this.fileExtensions.length <= 0) return;
        String fileExt = uri.fileExtension();
        if (fileExt == null) throw new PropertyVetoException(MessageResource.ERR_NO_FILE_EXT, evt);
        int i = this.fileExtensions.length;
        while (--i >= 0) {
            if (!this.fileExtensions[i].equalsIgnoreCase(fileExt)) continue;
            return;
        }
        throw new PropertyVetoException(MessageResource.ERR_INVALID_FILE_EXT, evt);
    }

    @Override
    protected Object convertStringValue(String newValue) throws CoreException {
        try {
            if (newValue.startsWith("file:") || newValue.startsWith("platform:")) {
                return URI.createURI((String)newValue);
            }
            return URI.createFileURI((String)newValue);
        }
        catch (RuntimeException e) {
            Status eclipseStatus = e.getLocalizedMessage() != null ? new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage(), (Throwable)e) : new Status(4, "com.ibm.propertygroup", 4, "", (Throwable)e);
            throw new CoreException((IStatus)eclipseStatus);
        }
    }

    @Override
    public String[] getValuesAsStrings() {
        Object[] currentValues = this.getValues();
        String[] stringValues = new String[currentValues.length];
        int i = 0;
        while (i < currentValues.length) {
            if (currentValues[i] != null) {
                URI uri = (URI)currentValues[i];
                if (uri.isFile()) {
                    stringValues[i] = uri.toFileString();
                } else if ("platform".equals(uri.scheme())) {
                    String value;
                    String decodedURI = URI.decode((String)uri.toString());
                    String path = "platform:/resource";
                    int index = decodedURI.indexOf(path);
                    String wsPath = decodedURI.substring(index += path.length());
                    String wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                    stringValues[i] = value = String.valueOf(wsRoot) + wsPath;
                }
            }
            ++i;
        }
        return stringValues;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }
}

