/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi.common;

import com.ibm.propertygroup.ICustomProperty;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;

public class JavaClassNameProperty
extends BaseSingleValuedProperty
implements ICustomProperty {
    protected int customPropertyFlag = 256;

    public JavaClassNameProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, String.class, parentGroup);
        this.propertyFlag |= 0x104;
    }

    @Override
    public int getCustomPropertyFlag() {
        return this.customPropertyFlag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(Object newValue) throws CoreException {
        if (newValue == null) {
            super.setValue(newValue);
            return;
        }
        if (String.class.isAssignableFrom(newValue.getClass())) {
            String typeName = (String)newValue;
            if (typeName.indexOf(46) != -1) {
                Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_CLASSNAME_QUALIFIED, null);
                LogFacility.logErrorMessage((IStatus)status);
                throw new CoreException((IStatus)status);
            }
            IStatus status = JavaConventions.validateJavaTypeName((String)typeName);
            if (status.isOK() || status.getSeverity() == 2) {
                super.setValue(newValue);
                if (status.getSeverity() != 2) return;
                throw new CoreException(status);
            }
            LogFacility.logErrorMessage(status);
            throw new CoreException(status);
        }
        Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_INVALID_PROPERTY_TYPE, null);
        LogFacility.logErrorMessage((IStatus)status);
        throw new CoreException((IStatus)status);
    }
}

