/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ITableCellProperty;
import com.ibm.propertygroup.ITableProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BaseProperty;
import com.ibm.propertygroup.spi.BasePropertyDescriptor;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.TableCellProperty;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TableProperty
extends BaseProperty
implements ITableProperty {
    protected ArrayList rows = new ArrayList();
    protected ArrayList columnDescriptors = new ArrayList();
    protected boolean rowCreated = false;

    public TableProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, parentGroup);
        this.propertyFlag |= 0x102;
    }

    public void addColumn(ITableProperty.ColumnDescriptor column) throws CoreException {
        if (this.rowCreated) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_CAN_NOT_ADD_COLUMN, null);
            throw new CoreException((IStatus)status);
        }
        this.columnDescriptors.add(column);
        column.setParent(this);
    }

    public void removeColumn(int index) throws CoreException {
        if (this.rowCreated) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_CAN_NOT_REMOVE_COLUMN, null);
            throw new CoreException((IStatus)status);
        }
        ITableProperty.ColumnDescriptor desc = (ITableProperty.ColumnDescriptor)this.columnDescriptors.remove(index);
        desc.setParent(null);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public ITableCellProperty[] createNewRow() throws CoreException {
        return this.createNewRow(this.rows.size() - 1);
    }

    @Override
    public ITableCellProperty[] createNewRow(int index) throws CoreException {
        ++index;
        ITableCellProperty[] newRow = new TableCellProperty[this.columnDescriptors.size()];
        try {
            int i = this.columnDescriptors.size();
            while (--i >= 0) {
                ITableProperty.ColumnDescriptor column = (ITableProperty.ColumnDescriptor)this.columnDescriptors.get(i);
                TableCellProperty property = new TableCellProperty(column.getName(), column.getDisplayName(), column.getDescription(), column.getType().getType(), null);
                property.setParent(this);
                property.setDefaultValue(column.getType().getDefaultValue());
                property.setValidValues(column.getType().getValidValues());
                property.setDefaultValueDerived(column.getType().isDefaultValueDerived());
                property.setExpert(column.getType().isExpert());
                property.setReadOnly(column.getType().isReadOnly());
                property.setRequired(column.getType().isRequired());
                property.setHidden(column.getType().isHidden());
                property.setSensitive(column.getType().isSensitive());
                property.setValidValuesEditable(column.getType().isValidValuesEditable());
                property.setEnabled(true);
                property.setColumn(i);
                property.setRow(index);
                newRow[i] = property;
                property.addPropertyChangeListener(this);
            }
            this.rows.add(index, newRow);
            this.propertyChanges.fireTableRowAdd(newRow);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage(e.getStatus());
            throw e;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        if (!this.rowCreated) {
            this.rowCreated = true;
        }
        return newRow;
    }

    @Override
    public void deleteRow(int index) throws CoreException {
        try {
            ITableCellProperty[] deletedRow = (TableCellProperty[])this.rows.remove(index);
            int i = 0;
            while (i < deletedRow.length) {
                deletedRow[i].setParent(null);
                ((BasePropertyDescriptor)((Object)deletedRow[i])).removePropertyChangeListener(this);
                ++i;
            }
            this.propertyChanges.fireTableRowRemove(deletedRow);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public ITableCellProperty getCellProperty(int row, int column) throws CoreException {
        try {
            return this.getRowProperties(row)[column];
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public ITableProperty.ColumnDescriptor[] getColumns() throws CoreException {
        try {
            return this.columnDescriptors.toArray(new ITableProperty.ColumnDescriptor[this.columnDescriptors.size()]);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public ITableCellProperty[] getRowProperties(int index) throws CoreException {
        try {
            ITableCellProperty[] row = (TableCellProperty[])this.rows.get(index);
            int i = row.length;
            while (--i >= 0) {
                if (((TableCellProperty)row[i]).getRow() == index) continue;
                ((TableCellProperty)row[i]).setRow(index);
            }
            return row;
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public void unSet() {
        for (TableCellProperty[] row : this.rows) {
            int i = 0;
            while (i < row.length) {
                row[i].setParent(null);
                ++i;
            }
        }
        this.rows.clear();
        this.rowCreated = false;
        this.propertyChanges.fireTableCleared();
    }

    @Override
    public boolean isSet() {
        return this.rowCreated;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof TableCellProperty && evt.getPropertyChangeType() == 0 && evt.getSource() instanceof ISingleTypedProperty) {
            this.propertyChanges.firePropertyChange(new PropertyChangeEvent((ISingleTypedProperty)evt.getSource(), evt.getOldValue(), evt.getNewValue(), 0));
        }
    }

    @Override
    public void moveRow(int to, int from) throws CoreException {
        try {
            Object oldRow = this.rows.remove(from);
            this.rows.add(to, oldRow);
            this.propertyChanges.fireTableRowMove(to, from);
        }
        catch (RuntimeException e) {
            LogFacility.logErrorMessage(e.getLocalizedMessage(), e);
            Status status = new Status(4, "com.ibm.propertygroup", 4, e.getLocalizedMessage() != null ? e.getLocalizedMessage() : "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TableProperty clone = (TableProperty)super.clone();
        clone.rows = (ArrayList)this.rows.clone();
        int i = 0;
        while (i < clone.rows.size()) {
            ITableCellProperty[] pd = (ITableCellProperty[])clone.rows.get(i);
            ITableCellProperty[] clonedPD = (ITableCellProperty[])pd.clone();
            int j = 0;
            while (j < clonedPD.length) {
                clonedPD[j] = (ITableCellProperty)clonedPD[j].clone();
                clonedPD[j].addPropertyChangeListener(clone);
                ++j;
            }
            clone.rows.set(i, clonedPD);
            ++i;
        }
        clone.columnDescriptors = (ArrayList)this.columnDescriptors.clone();
        i = 0;
        while (i < clone.columnDescriptors.size()) {
            ITableProperty.ColumnDescriptor cd = (ITableProperty.ColumnDescriptor)clone.columnDescriptors.get(i);
            clone.columnDescriptors.set(i, cd.clone());
            ++i;
        }
        return clone;
    }
}

