/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.spi;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.internal.LogFacility;
import com.ibm.propertygroup.internal.messages.MessageResource;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleTypedProperty;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class BaseMultiValuedProperty
extends BaseSingleTypedProperty
implements IMultiValuedProperty {
    protected List<Object> values = new ArrayList<Object>();
    protected boolean allowDuplicates = false;
    protected int[] selection = new int[0];
    protected int selectionStyle = 1;

    public BaseMultiValuedProperty(String propertyName, String displayName, String propertyDescription, Class<?> propertyType, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, propertyType, parentGroup);
        this.propertyFlag |= 0x2101;
    }

    @Override
    public void addValue(Object value) throws CoreException {
        this.addValue(value, this.values.size());
    }

    @Override
    public void addValue(Object value, int index) throws CoreException, IndexOutOfBoundsException {
        if (index > this.values.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_PG_IS_DISABLED, null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        if (this.propertyType.getType().isAssignableFrom(value.getClass())) {
            block6: {
                try {
                    this.vetoableChanges.fireVetoableChange(null, value);
                }
                catch (PropertyVetoException ex) {
                    if (ex.getErrorCode() == 0) {
                        Status status = new Status(4, "com.ibm.propertygroup", 4, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                        throw new CoreException((IStatus)status);
                    }
                    if (ex.getErrorCode() != 1) break block6;
                    Status status = new Status(2, "com.ibm.propertygroup", 2, ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "", (Throwable)ex);
                    this.values.add(value);
                    this.setSet(true);
                    this.propertyChanges.firePropertyValueChange(null, value);
                    throw new CoreException((IStatus)status);
                }
            }
            this.values.add(index, value);
            this.setSet(true);
            this.propertyChanges.firePropertyValueChange(null, value);
            return;
        }
        Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_INVALID_PROPERTY_TYPE, null);
        LogFacility.logErrorMessage((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    @Override
    public void addValueAsString(String value) throws CoreException {
        Object obj = this.convertStringValue(value);
        this.addValue(obj);
    }

    @Override
    public void addValueAsString(String value, int index) throws CoreException, IndexOutOfBoundsException {
        Object obj = this.convertStringValue(value);
        this.addValue(obj, index);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object get(int index) throws IndexOutOfBoundsException {
        return this.values.get(index);
    }

    @Override
    public Object[] getValues() {
        return this.values.toArray();
    }

    @Override
    public String[] getValuesAsStrings() {
        Object[] currentValues = this.getValues();
        String[] stringValues = new String[currentValues.length];
        int i = currentValues.length;
        while (--i >= 0) {
            if (currentValues[i] == null) continue;
            stringValues[i] = currentValues[i].toString();
        }
        return stringValues;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public Object removeValue(int index) {
        Object value = this.values.remove(index);
        this.propertyChanges.firePropertyValueChange(value, null);
        return value;
    }

    @Override
    public boolean removeValue(Object value) {
        if (!this.isEnabled()) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_CANNOT_REMOVE, null);
            LogFacility.logErrorMessage((IStatus)status);
        }
        boolean returnValue = this.values.remove(value);
        if (this.values.isEmpty()) {
            this.setSet(false);
        } else {
            this.setSet(true);
        }
        if (returnValue) {
            this.propertyChanges.firePropertyValueChange(value, null);
        }
        return returnValue;
    }

    @Override
    public boolean removeValueAsString(String value) throws CoreException {
        try {
            Object obj = this.convertStringValue(value);
            return this.removeValue(obj);
        }
        catch (CoreException e) {
            LogFacility.logErrorMessage(e.getStatus());
            return false;
        }
    }

    @Override
    public void unSet() {
        this.values.clear();
        this.setSet(false);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    protected Object convertStringValue(String newValue) throws CoreException {
        if (this.propertyType.isPrimitive() && newValue == null) {
            Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.bind((String)MessageResource.ERR_PRIMITIVE_TYPE_CANNOT_BE_NULL, (Object)this.getDisplayName()), null);
            LogFacility.logErrorMessage((IStatus)status);
            throw new CoreException((IStatus)status);
        }
        switch (this.propertyType.getPropertyTypeIdentifier()) {
            case 1: {
                return new Boolean(newValue);
            }
            case 2: {
                try {
                    return new Byte(newValue);
                }
                catch (NumberFormatException e1) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_BYTE_STRING, (Object)newValue), (Throwable)e1);
                    throw new CoreException((IStatus)status);
                }
            }
            case 3: {
                if (newValue != null && newValue.length() == 1) {
                    int char32 = UTF16.charAt((String)newValue, (int)0);
                    return new Character(UCharacter.toChars((int)char32)[0]);
                }
                Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_CHAR_STRING, (Object)newValue), null);
                throw new CoreException((IStatus)status);
            }
            case 4: {
                try {
                    return new Double(newValue);
                }
                catch (NumberFormatException e2) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_DOUBLE_STRING, (Object)newValue), (Throwable)e2);
                    throw new CoreException((IStatus)status);
                }
            }
            case 5: {
                try {
                    return new Float(newValue);
                }
                catch (NumberFormatException e3) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_FLOAT_STRING, (Object)newValue), (Throwable)e3);
                    throw new CoreException((IStatus)status);
                }
            }
            case 6: {
                try {
                    return new Integer(newValue);
                }
                catch (NumberFormatException e4) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_INT_STRING, (Object)newValue), (Throwable)e4);
                    throw new CoreException((IStatus)status);
                }
            }
            case 7: {
                try {
                    return new Long(newValue);
                }
                catch (NumberFormatException e5) {
                    Status status = new Status(4, "com.ibm.propertygroup", 4, NLS.bind((String)MessageResource.ERR_INVALID_LONG_STRING, (Object)newValue), (Throwable)e5);
                    throw new CoreException((IStatus)status);
                }
            }
            case 0: {
                return newValue;
            }
        }
        Status status = new Status(4, "com.ibm.propertygroup", 4, MessageResource.ERR_SET_AS_STRING_NOT_SUPPORTED, null);
        LogFacility.logErrorMessage((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    @Override
    public boolean allowDuplicateValues() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicateValues(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public void setSelection(int[] indices) {
        if (indices == null) {
            indices = new int[]{};
        }
        int[] oldSelection = this.selection;
        this.selection = indices;
        this.propertyChanges.fireMultiValuePropertySelection(oldSelection, this.selection);
    }

    public int[] getSelection() {
        return this.selection;
    }

    @Override
    public int getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setSelectionStyle(int selectionStyle) {
        this.selectionStyle = selectionStyle;
    }
}

