/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.utilities;

import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.IPropertyType;
import com.ibm.propertygroup.ISingleTypedProperty;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PropertyUtil {
    public static Object getValue(IPropertyDescriptor property) {
        if (property == null) {
            return null;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            return ((ISingleValuedProperty)property).getValue();
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            return ((IMultiValuedProperty)property).getValues();
        }
        return null;
    }

    public static String getValueAsString(IPropertyDescriptor property) {
        ISingleValuedProperty prop;
        if (property == null) {
            return null;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property) && (prop = (ISingleValuedProperty)property).getValue() != null) {
            return prop.getValueAsString();
        }
        return null;
    }

    public static Object[] getValues(IPropertyDescriptor property) {
        if (property == null) {
            return null;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            return new Object[]{((ISingleValuedProperty)property).getValue()};
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            return ((IMultiValuedProperty)property).getValues();
        }
        return null;
    }

    public static void setValue(IPropertyDescriptor property, Object newValue) throws CoreException {
        if (property == null) {
            return;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            ((ISingleValuedProperty)property).setValue(newValue);
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            ((IMultiValuedProperty)property).addValue(newValue);
        }
    }

    public static void setValueAsString(IPropertyDescriptor property, String newValue) throws CoreException {
        if (property == null) {
            return;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            ((ISingleValuedProperty)property).setValueAsString(newValue);
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            ((IMultiValuedProperty)property).addValueAsString(newValue);
        }
    }

    public static void setValues(IPropertyDescriptor property, List<Object> newValues) throws CoreException {
        if (property == null) {
            return;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            ((ISingleValuedProperty)property).setValue(newValues.get(0));
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            int i = 0;
            while (i < newValues.size()) {
                ((IMultiValuedProperty)property).addValue(newValues.get(i));
                ++i;
            }
        }
    }

    public static void setValuesAsStrings(IPropertyDescriptor property, String[] newValues) throws CoreException {
        if (property == null) {
            return;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)property)) {
            ((ISingleValuedProperty)property).setValueAsString(newValues[0]);
        } else if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)property)) {
            int i = 0;
            while (i < newValues.length) {
                ((IMultiValuedProperty)property).addValueAsString(newValues[i]);
                ++i;
            }
        }
    }

    public static IPropertyType getPropertyType(IPropertyDescriptor property) {
        if (property != null && PropertyHelper.isSingleTypedProperty((IPropertyDescriptor)property)) {
            return ((ISingleTypedProperty)property).getPropertyType();
        }
        return null;
    }

    public static Object getDefaultValue(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.getDefaultValue();
        }
        return null;
    }

    public static Object[] getValidValues(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.getValidValues();
        }
        return null;
    }

    public static String[] getValidValuesAsStrings(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.getValidValuesAsStrings();
        }
        return null;
    }

    public static boolean isEnabled(IPropertyDescriptor property) {
        return property.isEnabled();
    }

    public static Class getClassType(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.getClass();
        }
        return null;
    }

    public static boolean isHidden(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isHidden();
        }
        return false;
    }

    public static boolean isReadOnly(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isReadOnly();
        }
        return false;
    }

    public static boolean isExpert(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isExpert();
        }
        return false;
    }

    public static boolean isPrimitive(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isPrimitive();
        }
        return false;
    }

    public static boolean isSensitive(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isSensitive();
        }
        return false;
    }

    public static boolean isRequired(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isRequired();
        }
        return false;
    }

    public static boolean isValidValuesEditable(IPropertyDescriptor property) {
        IPropertyType propertyType = PropertyUtil.getPropertyType(property);
        if (propertyType != null) {
            return propertyType.isValidValuesEditable();
        }
        return false;
    }

    public static String getPropertyNameForHelp(IPropertyDescriptor property) {
        StringBuffer name = new StringBuffer(property.getName());
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == ' ' || c == '.') {
                name.setCharAt(i, '_');
            }
            ++i;
        }
        return name.toString();
    }

    public static String getPropertyNameForHelp(String propertyName) {
        StringBuffer name = new StringBuffer(propertyName);
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == ' ' || c == '.') {
                name.setCharAt(i, '_');
            }
            ++i;
        }
        return name.toString();
    }

    public static IPropertyDescriptor getProperty(IPropertyGroup propertyGroup, String name) {
        IPropertyDescriptor property = propertyGroup.getProperty(name);
        if (property != null && !PropertyHelper.isPropertyGroup((IPropertyDescriptor)property)) {
            return property;
        }
        IPropertyDescriptor[] properties = propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            IPropertyDescriptor ipd = properties[i];
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd) && (property = PropertyUtil.getProperty((IPropertyGroup)ipd, name)) != null) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public static boolean isAdvancedPropertyDescriptor(IPropertyDescriptor ipd) {
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
            return PropertyUtil.isAdvancedPropertyGroup((IPropertyGroup)ipd);
        }
        return PropertyUtil.isExpert(ipd);
    }

    public static boolean isHiddenPropertyDescriptor(IPropertyDescriptor ipd) {
        if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipd)) {
            IPropertyDescriptor[] properties = ((IPropertyGroup)ipd).getProperties();
            int i = 0;
            while (i < properties.length) {
                if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]) ? !PropertyUtil.isHiddenPropertyDescriptor(properties[i]) : !PropertyUtil.isHidden(properties[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return PropertyUtil.isHidden(ipd);
    }

    public static boolean isAdvancedPropertyGroup(IPropertyGroup pg) {
        IPropertyDescriptor[] properties = pg.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)properties[i]) ? !PropertyUtil.isAdvancedPropertyGroup((IPropertyGroup)properties[i]) : !PropertyUtil.isExpert(properties[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IPath getPropertyPath(IPropertyDescriptor ipd) {
        ArrayList<String> names = new ArrayList<String>(6);
        while (ipd != null) {
            names.add(0, ipd.getName());
            ipd = ipd.getParent();
        }
        if (!names.isEmpty()) {
            Path path = new Path((String)names.get(0));
            int i = 1;
            while (i < names.size()) {
                path = path.append((String)names.get(i));
                ++i;
            }
            return path;
        }
        return null;
    }
}

