/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.utilities;

import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIHelpContext;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PropertyUIHelpRegistry {
    public static final String HELP_CONTEXT = "com.ibm.propertygroup.ui.utilities.PropertyUIHelpRegistry.HELP_CONTEXT";
    private static PropertyUIHelpRegistry instance_ = null;
    private static HelpListener helpListener_ = null;
    private IHelpResource[] activeTopics_ = null;
    private String componentName_ = null;
    private boolean generateDynamicF1IDs_ = true;

    private PropertyUIHelpRegistry() {
    }

    public static PropertyUIHelpRegistry instance() {
        if (instance_ == null) {
            instance_ = new PropertyUIHelpRegistry();
        }
        return instance_;
    }

    public void addF1HelpToWidget(PropertyUIWidget widget, IPropertyDescriptor property, PropertyUIFactory factory) {
        IPropertyDescriptor parent;
        Control[] controls = widget.getHelpControls();
        if (controls == null || controls.length == 0) {
            return;
        }
        ArrayList<String> contextIDs = new ArrayList<String>(3);
        String dynamicDesc = null;
        String contextIDPrefix = factory.getHelpContextIdPrefix();
        if (contextIDPrefix != null && contextIDPrefix.length() > 0) {
            StringBuffer helpid = new StringBuffer(contextIDPrefix);
            if (factory.getHelpContextType() == 0) {
                helpid.append("_");
                helpid.append(PropertyUtil.getPropertyNameForHelp(property));
            }
            contextIDs.add(helpid.toString());
        }
        if (this.generateDynamicF1IDs_ && (parent = property.getParent()) != null && parent.getName() != null && property.getName() != null && property.getName() != null) {
            StringBuffer helpID = new StringBuffer(parent.getName());
            helpID.append(".");
            helpID.append(PropertyUtil.getPropertyNameForHelp(property));
            String id = helpID.toString();
            if (this.componentName_ != null && !"".equals(this.componentName_)) {
                helpID.insert(0, ".");
                helpID.insert(0, this.componentName_);
                contextIDs.add(helpID.toString());
            }
            contextIDs.add(id);
            String desc = property.getDescription();
            if (desc != null && !desc.isEmpty()) {
                dynamicDesc = desc;
            }
        }
        if (!contextIDs.isEmpty() || dynamicDesc != null) {
            PropertyUIHelpContext context = new PropertyUIHelpContext(contextIDs.toArray(new String[contextIDs.size()]), dynamicDesc, this.getActiveTopics());
            int i = 0;
            while (i < controls.length) {
                controls[i].setData(HELP_CONTEXT, (Object)context);
                controls[i].addHelpListener(this.getHelpListener());
                ++i;
            }
        }
    }

    public HelpListener getHelpListener() {
        if (helpListener_ == null) {
            helpListener_ = new HelpListener(){

                public void helpRequested(HelpEvent event) {
                    IContext context = (IContext)event.widget.getData(PropertyUIHelpRegistry.HELP_CONTEXT);
                    if (context != null && context.getText() == null) {
                        Control control = (Control)event.widget;
                        context = PropertyUIHelpRegistry.this.getParentContextHelp(control);
                        control.setData(PropertyUIHelpRegistry.HELP_CONTEXT, null);
                        control.removeHelpListener((HelpListener)this);
                    }
                    if (context != null) {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
                    }
                }
            };
        }
        return helpListener_;
    }

    protected IContext getParentContextHelp(Control control) {
        Composite parent = control.getParent();
        IContext context = null;
        while (parent != null) {
            Object object = parent.getData("org.eclipse.ui.help");
            if (object != null) {
                if (object instanceof String) {
                    context = HelpSystem.getContext((String)((String)object));
                    break;
                }
                if (!(object instanceof IContext)) break;
                context = (IContext)object;
                break;
            }
            parent = parent.getParent();
        }
        return context;
    }

    public IHelpResource[] getActiveTopics() {
        return this.activeTopics_;
    }

    public void setActiveTopics(IHelpResource[] activeTopics) {
        this.activeTopics_ = activeTopics;
    }

    public String getComponentName() {
        return this.componentName_;
    }

    public void setComponentName(String componentName) {
        this.componentName_ = componentName;
    }

    public void reset() {
        this.activeTopics_ = null;
        this.componentName_ = null;
        this.generateDynamicF1IDs_ = true;
    }

    public boolean isGenerateDynamicF1IDs() {
        return this.generateDynamicF1IDs_;
    }

    public void setGenerateDynamicF1IDs(boolean generateDynamicF1IDs) {
        this.generateDynamicF1IDs_ = generateDynamicF1IDs;
    }
}

