/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.utilities;

import com.ibm.icu.text.BreakIterator;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.ui.dialogs.PropertyUIErrorDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PropertyGroupUIHelper {
    private static PropertyGroupUIHelper helper_;

    public static PropertyGroupUIHelper getDefault() {
        if (helper_ == null) {
            helper_ = new PropertyGroupUIHelper();
        }
        return helper_;
    }

    public void showExceptionMessage(AbstractUIPlugin plugin, Throwable e, Shell shell, String title, String msg) {
        String message = msg;
        if (msg == null) {
            message = e.toString();
            PropertyUIErrorDialog.openError(shell, title, message, null, e);
        } else {
            PropertyUIErrorDialog.openError(shell, title, e.getClass().getName(), msg, null);
        }
        String pluginName = plugin.getBundle().getSymbolicName();
        if (pluginName == null || pluginName.length() < 1) {
            pluginName = " ";
        }
        plugin.getLog().log((IStatus)new Status(4, pluginName, 4, message, e));
    }

    public StringBuffer getMessageFromStatus(IStatus status, StringBuffer message, boolean isSubStatus) {
        if (status != null) {
            if (!status.isMultiStatus()) {
                Throwable ta;
                String msg = status.getMessage();
                if (!(msg != null && msg.length() >= 1 || (ta = status.getException()) == null || (msg = ta.getMessage()) != null && msg.length() >= 1)) {
                    msg = ta.toString();
                }
                if (msg != null && msg.length() > 0) {
                    if (isSubStatus) {
                        message.append("--- ").append(msg).append("\n");
                    } else {
                        message.append(msg);
                    }
                }
            } else {
                IStatus[] subStatus = status.getChildren();
                int i = 0;
                while (i < subStatus.length) {
                    this.getMessageFromStatus(subStatus[i], message, true);
                    ++i;
                }
            }
        }
        return message;
    }

    public String getMessageFromCoreException(CoreException ie) {
        StringBuffer message = new StringBuffer("");
        this.getMessageFromStatus(ie.getStatus(), message, false);
        if (message.length() < 1) {
            String msg = ie.getMessage();
            if (msg == null || msg.length() < 1) {
                msg = ie.toString();
            }
            return msg;
        }
        return message.toString();
    }

    public String[] getDisplayString(String msg) {
        String[] rv = new String[1];
        StringBuffer str = new StringBuffer(msg.trim());
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '&') {
                str.deleteCharAt(i);
                break;
            }
            ++i;
        }
        if (str.charAt(str.length() - 1) == ':') {
            str.deleteCharAt(str.length() - 1);
        }
        StringBuffer str1 = new StringBuffer("'");
        str1.append(str);
        str1.append("'");
        rv[0] = str1.toString();
        return rv;
    }

    public void getTextFromPropertyGroup(IPropertyGroup pg, StringBuffer sb, String indent) {
        IPropertyDescriptor[] props = pg.getProperties();
        sb.append(pg.getDisplayName());
        int i = 0;
        while (i < props.length) {
            sb.append("\n");
            if (props[i] instanceof IPropertyGroup) {
                this.getTextFromPropertyGroup((IPropertyGroup)props[i], sb, String.valueOf(indent) + "\t");
            } else if (props[i] instanceof ISingleValuedProperty) {
                ISingleValuedProperty svp = (ISingleValuedProperty)props[i];
                sb.append(indent);
                sb.append(svp.getDisplayName());
                sb.append(":");
                sb.append("\t");
                sb.append(svp.getValueAsString());
            } else if (props[i] instanceof IMultiValuedProperty) {
                IMultiValuedProperty mvp = (IMultiValuedProperty)props[i];
                String[] values = mvp.getValuesAsStrings();
                int j = 0;
                while (j < values.length) {
                    sb.append(indent);
                    sb.append(mvp.getDisplayName());
                    sb.append(":");
                    sb.append("\t");
                    sb.append(values[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public String getStringRepresentationFromPropertyGroup(IPropertyGroup pg) {
        if (pg == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        IPropertyDescriptor[] props = pg.getProperties();
        int i = 0;
        while (i < props.length) {
            IMultiValuedProperty mvp;
            int index;
            String name = props[i].getDisplayName();
            if (name == null || "".equals(name)) {
                name = props[i].getName();
            }
            if ((index = name.indexOf(38)) != -1) {
                StringBuffer nameBuf = new StringBuffer(name);
                nameBuf.deleteCharAt(index);
                name = nameBuf.toString();
            }
            if (props[i] instanceof IPropertyGroup) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(name);
                sb.append("(");
                sb.append(this.getStringRepresentationFromPropertyGroup((IPropertyGroup)props[i]));
                sb.append(")");
            } else if (props[i] instanceof ISingleValuedProperty) {
                ISingleValuedProperty svp = (ISingleValuedProperty)props[i];
                if (!svp.getPropertyType().isExpert()) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(name);
                    sb.append("=");
                    sb.append(svp.getValueAsString());
                }
            } else if (props[i] instanceof IMultiValuedProperty && !(mvp = (IMultiValuedProperty)props[i]).getPropertyType().isExpert()) {
                if (i != 0) {
                    sb.append(",");
                }
                String[] values = mvp.getValuesAsStrings();
                int j = 0;
                while (j < values.length) {
                    sb.append(name);
                    sb.append("=");
                    sb.append(values[j]);
                    if (j < props.length - 1) {
                        sb.append(",");
                    }
                    ++j;
                }
            }
            ++i;
        }
        int index = sb.length() - 1;
        if (sb.charAt(index) == ',') {
            sb.deleteCharAt(index);
        }
        return sb.toString();
    }

    public String wrapMessage(String message, int maxLineLength) {
        if (message.length() <= maxLineLength) {
            return message;
        }
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(message);
        StringBuffer result = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            if (sb.length() + end - start + 1 > maxLineLength) {
                result.append(sb);
                result.append("\n");
                sb = new StringBuffer();
            }
            sb.append(message.substring(start, end));
            start = end;
            end = boundary.next();
        }
        result.append(sb);
        return result.toString().trim();
    }

    public void addToolTipToControl(Control control, String tooltip) {
        if (tooltip != null && tooltip.length() > 0) {
            BreakIterator iter = BreakIterator.getLineInstance();
            iter.setText(tooltip);
            int start = iter.first();
            StringBuffer buf = new StringBuffer();
            int end = iter.next();
            while (end != -1) {
                if (end - start > 68) {
                    buf.append(tooltip.substring(start, end));
                    buf.append("\n");
                    start = end;
                }
                end = iter.next();
            }
            buf.append(tooltip.substring(start));
            control.setToolTipText(buf.toString());
        }
    }
}

