/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.wizards;

import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.plugin.PropertyUIPlugin;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewPlatformFileWizard
extends Wizard
implements INewWizard {
    protected WizardNewFileCreationPage newFilePage_;
    protected String filePath_;
    protected String[] exts_;
    protected IFile file_;

    public NewPlatformFileWizard(String path, String[] exts) {
        this.filePath_ = path;
        this.exts_ = exts;
    }

    public void addPages() {
        this.newFilePage_ = new WizardNewFileCreationPage("com.ibm.propertygroup.ui.internal.wizards.NewPlatformFileWizard", (IStructuredSelection)new StructuredSelection()){

            protected boolean validatePage() {
                String fileName = this.getFileName();
                IPath fullPath = this.getContainerFullPath();
                if (fullPath != null && !fullPath.isEmpty() && fileName != null && fileName.length() > 0) {
                    if (fileName.lastIndexOf(46) != -1) {
                        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
                        if (NewPlatformFileWizard.this.exts_ != null && NewPlatformFileWizard.this.exts_.length > 0) {
                            int i = 0;
                            while (i < NewPlatformFileWizard.this.exts_.length) {
                                if (ext.equalsIgnoreCase(NewPlatformFileWizard.this.exts_[i])) {
                                    ext = null;
                                    break;
                                }
                                ++i;
                            }
                        } else {
                            ext = null;
                        }
                        if (ext != null) {
                            this.setErrorMessage(NLS.bind((String)PropertyUIMessages.ERROR_WIZARDS_INVALID_FILE_EXTENSIONS, (Object[])PropertyUIHelper.instance().getDisplayString(new ArrayList<String>(Arrays.asList(NewPlatformFileWizard.this.exts_)).toString())));
                            return false;
                        }
                    } else {
                        fileName = NewPlatformFileWizard.this.addDefaultExtension(fileName);
                    }
                    fullPath = fullPath.append(fileName);
                    if (ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath).exists()) {
                        this.setErrorMessage(NLS.bind((String)PropertyUIMessages.ERROR_WIZARDS_FILE_EXISTS, (Object[])PropertyUIHelper.instance().getDisplayString(fullPath.toString())));
                        return false;
                    }
                    URI uri = URI.createPlatformResourceURI((String)fullPath.toString());
                    if (uri != null) {
                        try {
                            Path path;
                            URL resolvedURL = FileLocator.resolve((URL)new URL(uri.toString()));
                            if (resolvedURL != null && (path = new Path(resolvedURL.getFile())).toFile().exists()) {
                                this.setErrorMessage(NLS.bind((String)PropertyUIMessages.ERROR_WIZARDS_FILE_EXISTS, (Object[])PropertyUIHelper.instance().getDisplayString(fullPath.toString())));
                                return false;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                this.setErrorMessage(null);
                return super.validatePage();
            }
        };
        this.newFilePage_.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_NEW_FILE);
        this.newFilePage_.setDescription(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_NEW_FILE_DESC);
        if (this.filePath_ != null && this.filePath_.length() > 0) {
            Path path = new Path(this.filePath_);
            IFile file = this.filePath_.startsWith("/") || this.filePath_.startsWith("\\") ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (file != null) {
                String fileName = file.getName();
                if (fileName.lastIndexOf(46) == -1) {
                    fileName = this.addDefaultExtension(fileName);
                }
                this.newFilePage_.setFileName(fileName);
                this.newFilePage_.setContainerFullPath(file.getParent().getFullPath());
            }
        } else {
            Iterator it;
            IStructuredSelection selection = this.getCurrentSelection();
            if (selection != null && !selection.isEmpty() && (it = selection.iterator()).hasNext()) {
                Object object = it.next();
                IResource selectedResource = null;
                if (object instanceof IResource) {
                    selectedResource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                }
                if (selectedResource != null) {
                    if (selectedResource.getType() == 1) {
                        selectedResource = selectedResource.getParent();
                    }
                    if (selectedResource.isAccessible()) {
                        this.newFilePage_.setContainerFullPath(selectedResource.getFullPath());
                    }
                }
            }
        }
        this.addPage((IWizardPage)this.newFilePage_);
    }

    public boolean performFinish() {
        boolean performedOK = false;
        String fileName = this.newFilePage_.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            this.newFilePage_.setFileName(this.addDefaultExtension(fileName));
        }
        this.file_ = this.newFilePage_.createNewFile();
        if (this.file_ != null) {
            performedOK = true;
        }
        return performedOK;
    }

    public void init(IWorkbench desktop, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(PropertyUIPlugin.getImageDescriptor("icons/newfile_wiz.gif"));
        this.setWindowTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_WIN_TITLE_NEW_TITLE);
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = PropertyUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected String addDefaultExtension(String fileName) {
        if (this.exts_ != null && this.exts_.length > 0) {
            StringBuffer name = new StringBuffer(fileName);
            name.append(".").append(this.exts_[0]);
            return name.toString();
        }
        return fileName;
    }

    public IFile getFile() {
        return this.file_;
    }
}

