/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTextContentAssist;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class PropertyUIWidgetText_Base
extends PropertyUIWidgetProperty
implements PaintListener {
    protected Control label_;
    protected PropertyUIWidgetTextContentAssist textContentAssist_;
    protected Text text_;
    protected int columnNo_ = 1;
    protected boolean editingProperty_ = false;

    public PropertyUIWidgetText_Base(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetText_Base(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetText_Base(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.columnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        this.createUIControls(parent);
        this.initUIControls(parent);
    }

    protected void createUIControls(Composite parent) {
        this.createLabel(parent);
        this.createText(parent);
    }

    protected void initUIControls(Composite parent) {
        int colNo;
        if (this.isRequired()) {
            this.addPaintListener(this);
        }
        if ((colNo = this.getTextHorizontalSpan()) > 1) {
            this.addFillers(parent, colNo - 1);
        }
        this.initDefaultValue();
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void createLabel(Composite parent) {
        this.label_ = this.createWidgetLabel(parent);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        this.label_.setLayoutData((Object)gd);
        if (this.isRequired()) {
            GC gc = new GC((Drawable)this.label_);
            gd.widthHint = this.label_ instanceof Label ? gc.stringExtent((String)((Label)this.label_).getText()).x + gc.stringExtent((String)"*").x : gc.stringExtent((String)((Hyperlink)this.label_).getText()).x + gc.stringExtent((String)"*").x;
            gc.dispose();
        }
    }

    protected void createText(Composite parent) {
        this.textContentAssist_ = this.widgetStyle_ == -1 ? this.factory_.createTextWithContentAssist(parent, this.factory_.getBorderStyle(), null) : this.factory_.createTextWithContentAssist(parent, this.widgetStyle_, null);
        this.text_ = this.textContentAssist_.getTextField();
        GridData gd = new GridData(768);
        gd.widthHint = 10;
        this.text_.setLayoutData((Object)gd);
        this.addHoverManager((Control)this.text_, this.property_.getDescription());
        if (this.isSensitive()) {
            this.text_.setEchoChar('*');
        }
    }

    @Override
    public void initDefaultValue() {
        this.removeModificationListner((Control)this.text_, 24);
        this.text_.setText("");
        Object defaultValue = this.getDefaultValue();
        Object value = this.getValue();
        if (value != null) {
            this.setStringToSWTControl(this.getValueAsString());
        } else if (defaultValue != null) {
            if (this.isRequired()) {
                this.setValue(defaultValue.toString());
                value = this.getValue();
                if (value != null) {
                    this.setStringToSWTControl(this.getValueAsString());
                } else if (this.status_ != 0) {
                    this.errorMessage_ = null;
                    this.status_ = 0;
                }
            } else {
                this.setStringToSWTControl(defaultValue.toString());
            }
        }
        this.addModificationListner();
    }

    protected void addModificationListner() {
        this.addModificationListner((Control)this.text_, 24);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.editingProperty_) {
            return;
        }
        if (!e.widget.equals(this.text_) && this.text_.isFocusControl()) {
            return;
        }
        super.focusLost(e);
    }

    @Override
    public void handleEvent(Event event) {
        this.editingProperty_ = true;
        if (event.widget == this.text_) {
            super.handleEvent(event);
        }
        this.editingProperty_ = false;
    }

    @Override
    public String getWidgetValue() {
        return this.text_.getText();
    }

    @Override
    public void setWidgetValue(String newValue) {
        this.setStringToSWTControl(newValue);
    }

    @Override
    public void setWidgetValue(String newValue, boolean applyToProperty) {
        if (!applyToProperty) {
            this.removeModificationListner((Control)this.text_, 24);
        }
        this.setStringToSWTControl(newValue);
        if (!applyToProperty) {
            this.addModificationListner();
        }
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                if (this.isValueSyn()) break;
                this.handlePropertyValueChanged();
                break;
            }
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label_.getParent().redraw();
    }

    protected void handlePropertyValueChanged() {
        String newValue = this.getValueAsString();
        this.removeModificationListner((Control)this.text_, 24);
        if (newValue == null) {
            this.text_.setText("");
        } else {
            this.setStringToSWTControl(newValue);
        }
        if (this.text_.isFocusControl()) {
            int stringLength = this.text_.getText().length();
            this.text_.setSelection(stringLength, stringLength);
        }
        this.addModificationListner((Control)this.text_, 24);
    }

    public Text getText() {
        return this.text_;
    }

    public void setColumnNo(int newValue) {
        this.columnNo_ = newValue;
    }

    @Override
    public void setValue(String newValue) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            if (newValue == null || newValue.length() < 1) {
                if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
                    ((ISingleValuedProperty)this.property_).setValue(null);
                } else {
                    ((IProperty)this.property_).unSet();
                }
            } else {
                ((ISingleValuedProperty)this.property_).setValueAsString(newValue);
            }
            this.errorMessage_ = null;
            this.status_ = 0;
        }
        catch (CoreException ie) {
            IStatus status = ie.getStatus();
            this.errorMessage_ = status.getMessage();
            this.status_ = status.getSeverity();
        }
        catch (Exception e) {
            this.errorMessage_ = e.getMessage();
            if (this.errorMessage_ == null || this.errorMessage_.length() < 1) {
                this.errorMessage_ = e.toString();
            }
            this.status_ = 4;
        }
    }

    public void addSuggestion(String suggestion) {
        if (suggestion != null && suggestion.length() > 0) {
            this.textContentAssist_.addSuggestion(suggestion);
        }
    }

    public void setSuggestions(List<String> suggestions) {
        this.textContentAssist_.setSuggestions(suggestions);
    }

    public void sortSuggestions() {
        this.textContentAssist_.sortSuggestions();
    }

    protected ArrayList<Control> getUIControlList() {
        ArrayList<Control> controls = new ArrayList<Control>(3);
        controls.add(this.label_);
        controls.add((Control)this.text_);
        if (this.filler_ != null) {
            controls.add((Control)this.filler_);
        }
        return controls;
    }

    @Override
    public Control[] getUIControls() {
        ArrayList<Control> controls = this.getUIControlList();
        Control[] newArray = new Control[controls.size()];
        controls.toArray(newArray);
        return newArray;
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.text_;
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber - 1 != this.columnNo_) {
            this.columnNo_ = newNumber - 1;
            int colNo = this.getTextHorizontalSpan();
            if (colNo > 1) {
                if (this.filler_ != null) {
                    GridData gd = (GridData)this.filler_.getLayoutData();
                    gd.horizontalSpan = this.columnNo_ - 1;
                } else {
                    this.addFillers(this.text_.getParent(), colNo - 1);
                    Text control = this.text_;
                    this.filler_.moveBelow((Control)control);
                }
            } else if (this.filler_ != null) {
                this.filler_.dispose();
                this.filler_ = null;
            }
        }
    }

    protected int getTextHorizontalSpan() {
        return this.columnNo_;
    }

    public void addPaintListener(PaintListener listener) {
        this.label_.addPaintListener((PaintListener)this);
        this.label_.getParent().addPaintListener((PaintListener)this);
    }

    public void paintControl(PaintEvent e) {
        if (this.isRequired() && this.isEnabled() && this.label_ != null && !this.label_.isDisposed() && !e.widget.isDisposed()) {
            String requiredLabel = "*";
            Rectangle lBounds = this.label_.getBounds();
            Point tLoc = this.text_.getLocation();
            GridLayout layout = (GridLayout)this.label_.getParent().getLayout();
            int hSpace = 5;
            if (layout != null) {
                hSpace = layout.horizontalSpacing;
            }
            Point global = this.label_.toDisplay(tLoc.x - lBounds.x - hSpace - e.gc.stringExtent((String)requiredLabel).x, 2);
            Point local = ((Control)e.widget).toControl(global);
            e.gc.drawString(requiredLabel, local.x, local.y, true);
        }
    }

    protected void setStringToSWTControl(String str) {
        this.text_.setText(this.processText(str));
    }
}

