/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetDecorator;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PropertyUIWidgetRadioButton
extends PropertyUIWidgetProperty {
    protected Composite group_;
    protected Control label_;
    protected ArrayList<Button> buttons_ = new ArrayList(this.getValidValues().length);
    protected int columnNo_ = 1;
    protected int groupColumnNo_ = 1;
    protected boolean isEqualWidth_ = true;

    public PropertyUIWidgetRadioButton(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetRadioButton(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, int gcNo, boolean isEqualWidth) {
        this(property, factory, columnNo, gcNo, isEqualWidth, null);
    }

    public PropertyUIWidgetRadioButton(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, int gcNo, boolean isEqualWidth, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.columnNo_ = columnNo;
        this.groupColumnNo_ = gcNo;
        this.isEqualWidth_ = isEqualWidth;
    }

    @Override
    public void createControl(Composite parent) {
        this.createGroup(parent);
        Composite composite = this.createContainer(parent);
        this.createLabel(composite);
        this.createButtons(this.group_);
        if (this.isReadOnly() || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void createGroup(Composite parent) {
        this.group_ = this.factory_.createComposite(parent, 0);
        this.group_.setData("com.ibm.propertygroup.ui.inner_composite", (Object)"PropertyUIWidgetRadioButton");
        GridLayout layout = new GridLayout();
        if (this.groupColumnNo_ > 1) {
            layout.numColumns = this.groupColumnNo_;
            layout.makeColumnsEqualWidth = this.isEqualWidth_;
        }
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.group_.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        int columnNo = this.columnNo_;
        if (this.columnNo_ > 2) {
            columnNo = 2;
            this.addFillers(parent, this.columnNo_ - 2);
        }
        gd.horizontalSpan = columnNo;
        this.group_.setLayoutData((Object)gd);
        this.addHoverManager((Control)this.group_, this.property_.getDescription());
    }

    protected Composite createContainer(Composite parent) {
        Composite composite = this.factory_.createComposite(this.group_, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.groupColumnNo_;
        composite.setLayoutData((Object)gd);
        composite.setData("com.ibm.propertygroup.ui.inner_composite", (Object)"PropertyUIWidgetRadioButton");
        return composite;
    }

    protected void createLabel(Composite parent) {
        this.label_ = this.createWidgetLabel(parent);
    }

    protected void createButtons(Composite parent) {
        int indent = this.widgetIndent_;
        if (indent < 1) {
            indent = 20;
        }
        Object defaultValue = this.getDefaultValue();
        Object value = this.getValue();
        Object[] values = this.getValidValues();
        String[] values_str = this.getValidValuesAsStrings();
        int i = 0;
        while (i < values.length) {
            Button btn = this.widgetStyle_ == -1 ? this.factory_.createButton(this.group_, 16) : this.factory_.createButton(this.group_, this.widgetStyle_);
            if (values_str != null && values_str.length > i) {
                btn.setText(values_str[i]);
            } else {
                btn.setText(values[i].toString());
            }
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalIndent = indent;
            btn.setLayoutData((Object)gd);
            this.buttons_.add(btn);
            if (value != null) {
                if (value.equals(values[i])) {
                    btn.setSelection(true);
                }
            } else if (defaultValue != null && defaultValue.equals(values[i])) {
                btn.setSelection(true);
                if (this.isRequired()) {
                    this.setValue(defaultValue);
                }
            }
            btn.addListener(13, (Listener)this);
            ++i;
        }
    }

    @Override
    public void initDefaultValue() {
        Object defaultValue = this.getDefaultValue();
        Object value = this.getValue();
        Object[] values = this.getValidValues();
        int i = 0;
        while (i < this.buttons_.size()) {
            Button btn = this.buttons_.get(i);
            btn.removeListener(24, (Listener)this);
            if (value != null) {
                if (value.equals(values[i])) {
                    btn.setSelection(true);
                }
            } else if (defaultValue != null && defaultValue.equals(values[i])) {
                btn.setSelection(true);
                if (this.isRequired()) {
                    this.setValue(defaultValue);
                }
            }
            btn.addListener(24, (Listener)this);
            ++i;
        }
    }

    @Override
    public String getWidgetValue() {
        int i = 0;
        while (i < this.buttons_.size()) {
            Button btn = this.buttons_.get(i);
            if (btn.getSelection()) {
                return btn.getText();
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setWidgetValue(String newValue) {
        this.setWidgetValue(newValue, true);
    }

    @Override
    public void setWidgetValue(String newValue, boolean applyToProperty) {
        if (newValue == null) {
            return;
        }
        int i = 0;
        while (i < this.buttons_.size()) {
            Button btn = this.buttons_.get(i);
            if (newValue.equals(btn.getText())) {
                if (!applyToProperty) {
                    btn.removeListener(24, (Listener)this);
                }
                btn.setSelection(true);
                if (!applyToProperty) {
                    btn.addListener(24, (Listener)this);
                }
            }
            ++i;
        }
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                if (this.isValueSyn()) break;
                this.handlePropertyValueChanged();
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                if (this.isReadOnly() || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    protected void handlePropertyValueChanged() {
        String value = this.getValueAsString();
        int i = 0;
        while (i < this.buttons_.size()) {
            Button btn = this.buttons_.get(i);
            btn.removeListener(24, (Listener)this);
            btn.setSelection(false);
            if (value != null && value.equalsIgnoreCase(btn.getText())) {
                btn.setSelection(true);
            }
            btn.addListener(24, (Listener)this);
            ++i;
        }
    }

    public ArrayList<Button> getButtons() {
        return this.buttons_;
    }

    public void setColumnNo(int newValue) {
        this.columnNo_ = newValue;
    }

    public void setGroupColumnNo(int newValue) {
        this.groupColumnNo_ = newValue;
    }

    public void setIsEqualWidth(boolean newValue) {
        this.isEqualWidth_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        Control[] controls = this.filler_ != null ? new Control[this.buttons_.size() + 2] : new Control[this.buttons_.size() + 1];
        controls[0] = this.label_;
        int k = 1;
        int i = 0;
        while (i < this.buttons_.size()) {
            controls[k++] = this.buttons_.get(i);
            ++i;
        }
        if (this.filler_ != null) {
            controls[k] = this.filler_;
        }
        return controls;
    }

    @Override
    public Control getDefaultFocusControl() {
        return this.buttons_.get(0);
    }

    @Override
    public Control[] getHelpControls() {
        Control[] controls = new Control[this.buttons_.size()];
        this.buttons_.toArray(controls);
        return controls;
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber != this.columnNo_) {
            GridData gd;
            this.columnNo_ = newNumber;
            if (this.filler_ != null) {
                if (this.columnNo_ > 2) {
                    gd = (GridData)this.filler_.getLayoutData();
                    gd.horizontalSpan = this.columnNo_ - 2;
                } else {
                    this.filler_.dispose();
                    this.filler_ = null;
                }
            } else if (this.columnNo_ > 2) {
                this.addFillers(this.group_.getParent(), this.columnNo_ - 2);
                this.filler_.moveBelow((Control)this.group_);
            }
            gd = (GridData)this.group_.getLayoutData();
            int columnNo = this.columnNo_;
            if (this.columnNo_ > 2) {
                columnNo = 2;
            }
            gd.horizontalSpan = columnNo;
            this.group_.layout();
        }
    }

    @Override
    public Control[] getWidgetLabelControls() {
        return this.getUIControls();
    }

    @Override
    public void decorateUIWidget(Image image, int position, String hoverHelp, Runnable action) {
        if (this.decorator_ == null) {
            this.decorator_ = new PropertyUIWidgetDecorator(this.label_);
        }
        this.decorator_.decorateUIWidget(image, position, hoverHelp, true, action);
    }
}

