/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.widgets;

import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIWidgetInfo;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PropertyUIWidgetLabel
extends PropertyUIWidgetProperty {
    protected Control label_;
    protected Text labelText_;
    protected int columnNo_ = 1;

    public PropertyUIWidgetLabel(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public PropertyUIWidgetLabel(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        this(property, factory, columnNo, null);
    }

    public PropertyUIWidgetLabel(IProperty property, IPropertyUIWidgetFactory factory, int columnNo, PropertyUIWidgetInfo info) {
        super(property, factory, info);
        this.columnNo_ = columnNo;
    }

    @Override
    public void createControl(Composite parent) {
        this.createLabel(parent);
        this.createLabelText(parent);
        if (this.columnNo_ > 1) {
            this.addFillers(parent, this.columnNo_ - 1);
        }
        this.initDefaultValue();
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected void createLabel(Composite parent) {
        this.label_ = this.createWidgetLabel(parent);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        gd.verticalAlignment = 1;
        this.label_.setLayoutData((Object)gd);
    }

    protected void createLabelText(Composite parent) {
        this.labelText_ = this.widgetStyle_ == -1 ? this.factory_.createText(parent, 66) : this.factory_.createText(parent, this.widgetStyle_);
        this.labelText_.setEditable(false);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.labelText_.setLayoutData((Object)gd);
        this.addHoverManager((Control)this.labelText_, this.property_.getDescription());
    }

    @Override
    public void initDefaultValue() {
        Object defaultValue = this.getDefaultValue();
        Object value = this.getValue();
        if (value != null) {
            this.setStringToSWTControl(this.value2String());
        } else if (defaultValue != null) {
            if (this.isRequired()) {
                this.setValue(defaultValue);
                value = this.getValue();
                if (value != null) {
                    this.setStringToSWTControl(this.value2String());
                } else if (this.status_ != 0) {
                    this.errorMessage_ = null;
                    this.status_ = 0;
                }
            } else {
                this.setStringToSWTControl(this.value2String(defaultValue));
            }
        }
    }

    @Override
    public String getWidgetValue() {
        return this.labelText_.getText();
    }

    @Override
    public void setWidgetValue(String newValue) {
        this.setStringToSWTControl(newValue);
    }

    @Override
    public void update() {
        this.update(0);
    }

    @Override
    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                if (this.isValueSyn()) break;
                String newValue = this.getValueAsString();
                if (newValue == null) {
                    this.labelText_.setText("");
                    break;
                }
                this.setStringToSWTControl(newValue);
                break;
            }
            case 1: 
            case 2: {
                if (!this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    public Text getText() {
        return this.labelText_;
    }

    public void setColumnNo(int newValue) {
        this.columnNo_ = newValue;
    }

    @Override
    public Control[] getUIControls() {
        if (this.filler_ != null) {
            return new Control[]{this.label_, this.labelText_, this.filler_};
        }
        return new Control[]{this.label_, this.labelText_};
    }

    @Override
    public Control getDefaultFocusControl() {
        return null;
    }

    @Override
    public Control[] getHelpControls() {
        return new Control[]{this.labelText_};
    }

    @Override
    public void changeColumnNumber(int newNumber) {
        if (newNumber - 1 != this.columnNo_) {
            this.columnNo_ = newNumber - 1;
            if (this.filler_ != null) {
                if (this.columnNo_ > 1) {
                    GridData gd = (GridData)this.filler_.getLayoutData();
                    gd.horizontalSpan = this.columnNo_ - 1;
                } else {
                    this.filler_.dispose();
                    this.filler_ = null;
                }
            } else if (this.columnNo_ > 1) {
                this.addFillers(this.labelText_.getParent(), this.columnNo_ - 1);
                this.filler_.moveBelow((Control)this.labelText_);
            }
        }
    }

    protected String value2String(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() < 1) {
                return "";
            }
            return list.get(0).toString();
        }
        return value.toString();
    }

    protected String value2String() {
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() < 1) {
                return "";
            }
            return list.get(0).toString();
        }
        return this.getValueAsString();
    }

    protected void setStringToSWTControl(String str) {
        this.labelText_.setText(this.processText(str));
    }
}

