/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.internal.utilities;

import com.ibm.propertygroup.ui.internal.utilities.PropertyUIListenerWrapper;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIListener;
import com.ibm.propertygroup.ui.listener.IPropertyUIStatusChangedListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIComplexChangedEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIEvent;
import com.ibm.propertygroup.ui.listener.PropertyUIStatusChangedEvent;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;

public class PropertyUIChangeEventSender
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Hashtable listenerTable_ = new Hashtable(3);
    private PropertyUIWidget source_ = null;

    public PropertyUIChangeEventSender(PropertyUIWidget source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.source_ = source;
    }

    public synchronized void addPropertyUIListener(String type, EventListener listener) {
        if (type.equals("PROPERTY_UI_CHANGE_LISTENER") && listener instanceof IPropertyUIChangeListener) {
            this.addPropertyUIChangeListener((IPropertyUIChangeListener)listener);
        } else if (type.equals("PROPERTY_UI_STATUS_CHANGE_LISTENER") && listener instanceof IPropertyUIStatusChangedListener) {
            this.addPropertyUIStatusChangedListener((IPropertyUIStatusChangedListener)listener);
        } else if (listener instanceof IPropertyUIListener) {
            this.addPropertyUIListener(type, (IPropertyUIListener)listener);
        }
    }

    public synchronized void removePropertyUIListener(String type, EventListener listener) {
        if (listener instanceof IPropertyUIListener) {
            this.removePropertyUIListener(type, (IPropertyUIListener)listener);
        } else if (type.equals("PROPERTY_UI_CHANGE_LISTENER") && listener instanceof IPropertyUIChangeListener) {
            this.removePropertyUIChangeListener((IPropertyUIChangeListener)listener);
        } else if (type.equals("PROPERTY_UI_STATUS_CHANGE_LISTENER") && listener instanceof IPropertyUIStatusChangedListener) {
            this.removePropertyUIStatusChangedListener((IPropertyUIStatusChangedListener)listener);
        }
    }

    public synchronized void addPropertyUIListener(String type, IPropertyUIListener listener) {
        ArrayList<IPropertyUIListener> list = (ArrayList<IPropertyUIListener>)this.listenerTable_.get(type);
        if (list == null) {
            list = new ArrayList<IPropertyUIListener>(6);
            this.listenerTable_.put(type, list);
        }
        if (list.indexOf(listener) == -1) {
            list.add(listener);
        }
    }

    public synchronized void removePropertyUIListener(String type, IPropertyUIListener listener) {
        ArrayList list = (ArrayList)this.listenerTable_.get(type);
        if (list != null) {
            list.remove(listener);
        }
    }

    public synchronized void addPropertyUIChangeListener(IPropertyUIChangeListener listener) {
        PropertyUIListenerWrapper wrapper = new PropertyUIListenerWrapper(listener);
        this.addPropertyUIListener("PROPERTY_UI_CHANGE_LISTENER", wrapper);
    }

    public synchronized void removePropertyUIChangeListener(IPropertyUIChangeListener listener) {
        ArrayList list = (ArrayList)this.listenerTable_.get("PROPERTY_UI_CHANGE_LISTENER");
        if (list != null) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                PropertyUIListenerWrapper wrapper = (PropertyUIListenerWrapper)list.get(i);
                if (wrapper.getEventListener().equals(listener)) {
                    list.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public synchronized void addPropertyUIStatusChangedListener(IPropertyUIStatusChangedListener listener) {
        PropertyUIListenerWrapper wrapper = new PropertyUIListenerWrapper(listener);
        this.addPropertyUIListener("PROPERTY_UI_STATUS_CHANGE_LISTENER", wrapper);
    }

    public synchronized void removePropertyUIStatusChangedListener(IPropertyUIStatusChangedListener listener) {
        ArrayList list = (ArrayList)this.listenerTable_.get("PROPERTY_UI_STATUS_CHANGE_LISTENER");
        if (list != null) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                PropertyUIListenerWrapper wrapper = (PropertyUIListenerWrapper)list.get(i);
                if (wrapper.getEventListener().equals(listener)) {
                    list.remove(i);
                    return;
                }
                ++i;
            }
        }
    }

    public void firePropertyUIChange(Object oldValue, Object newValue) {
        this.firePropertyUIChange(oldValue, newValue, 0);
    }

    public void firePropertyUIChange(Object oldValue, Object newValue, int type) {
        this.firePropertyUIEvent(new PropertyUIChangeEvent(this.source_, this.source_.getProperty().getName(), oldValue, newValue, type));
    }

    public void firePropertyUIStatusChanged(IStatus status) {
        this.firePropertyUIEvent(new PropertyUIStatusChangedEvent((Object)this.source_, status));
    }

    public void firePropertyUIComplexChanged(int type, int complexType) {
        this.firePropertyUIEvent(new PropertyUIComplexChangedEvent((Object)this.source_, type, complexType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyUIEvent(PropertyUIEvent event) {
        ArrayList targets = (ArrayList)this.listenerTable_.get(event.getPropertyUIListenerType());
        if (targets != null) {
            PropertyUIChangeEventSender propertyUIChangeEventSender = this;
            synchronized (propertyUIChangeEventSender) {
                targets = (ArrayList)targets.clone();
            }
        }
        if (targets != null) {
            int size = targets.size();
            int i = 0;
            while (i < size) {
                IPropertyUIListener target = (IPropertyUIListener)targets.get(i);
                target.handlePropertyUIEvent(event);
                ++i;
            }
        }
    }
}

