/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.dialogs;

import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PropertyUIValueSelectionDialog
extends SelectionDialog {
    protected Text text_;
    protected Label label_;
    protected String labelText_;
    protected Button okButton_;
    protected FilteredList filteredList_;
    private String[] elements_;
    private String[] resultStrings_;
    private boolean validValuesEditable_ = false;
    protected boolean multiSelectable_ = true;

    public PropertyUIValueSelectionDialog(Shell shell, String[] elements, String labelText) {
        this(shell, elements, labelText, true);
    }

    public PropertyUIValueSelectionDialog(Shell shell, String[] elements, String labelText, boolean multiSelectable) {
        super(shell);
        this.elements_ = elements;
        this.labelText_ = labelText;
        this.multiSelectable_ = multiSelectable;
        if (this.elements_ != null && this.elements_.length > 1) {
            this.quickSort(this.elements_, 0, this.elements_.length - 1);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton_ = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.handleSelectionChanged();
    }

    public Control createDialogArea(Composite parent) {
        IPropertyUIWidgetFactory factory = PropertyUIFactory.newInstance(true).getUIFactory();
        Composite main = (Composite)super.createDialogArea(parent);
        this.createLabel(factory, main);
        this.createTextField(factory, main);
        if (this.elements_ != null && this.elements_.length > 0) {
            this.createFilteredList(factory, main);
        }
        this.resultStrings_ = null;
        this.text_.setFocus();
        return main;
    }

    protected void createLabel(IPropertyUIWidgetFactory factory, Composite parent) {
        this.label_ = factory.createLabel(parent, 0);
        GridData gd = new GridData(768);
        this.label_.setLayoutData((Object)gd);
        this.label_.setText(this.labelText_);
    }

    protected void createTextField(IPropertyUIWidgetFactory factory, Composite parent) {
        this.text_ = factory.createText(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 280;
        this.text_.setLayoutData((Object)gd);
        this.text_.addListener(24, new Listener(){

            public void handleEvent(Event evt) {
                if (PropertyUIValueSelectionDialog.this.filteredList_ != null) {
                    PropertyUIValueSelectionDialog.this.filteredList_.setFilter(PropertyUIValueSelectionDialog.this.getTextValue());
                } else {
                    PropertyUIValueSelectionDialog.this.handleSelectionChanged();
                }
            }
        });
    }

    protected void createFilteredList(IPropertyUIWidgetFactory factory, Composite parent) {
        int style = 2;
        if (!this.multiSelectable_) {
            style = 4;
        }
        this.filteredList_ = factory.createFilteredList(parent, 0xB00 | style, new LabelProvider(), false, true, true);
        GridData gd = new GridData(1808);
        gd.widthHint = 280;
        gd.heightHint = 200;
        this.filteredList_.setLayoutData((Object)gd);
        String str = this.getTextValue();
        this.filteredList_.setFilter(str == null ? "" : str);
        this.filteredList_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (PropertyUIValueSelectionDialog.this.getSelected().length > 0) {
                    PropertyUIValueSelectionDialog.this.buttonPressed(0);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                PropertyUIValueSelectionDialog.this.handleSelectionChanged();
            }
        });
        this.filteredList_.setElements((Object[])this.elements_);
    }

    public String[] getResultsAsStrings() {
        return this.resultStrings_;
    }

    public void setValidValuesEditable(boolean editable) {
        this.validValuesEditable_ = editable;
    }

    public String getTextValue() {
        return this.text_.getText().trim();
    }

    private String[] getSelected() {
        if (this.text_ == null || this.text_.isDisposed()) {
            return null;
        }
        String textValue = this.getTextValue();
        Object[] selected = null;
        if (this.filteredList_ != null && !this.filteredList_.isDisposed()) {
            selected = this.filteredList_.getSelection();
        }
        if (!(selected != null && selected.length >= 1 || textValue.length() <= 0 || !this.validValuesEditable_ && this.elements_ != null)) {
            selected = new Object[]{textValue};
        }
        String[] result = null;
        if (selected != null) {
            result = new String[selected.length];
            int i = 0;
            while (i < selected.length) {
                result[i] = selected[i].toString();
                ++i;
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    protected void okPressed() {
        this.resultStrings_ = this.getSelected();
        super.okPressed();
    }

    private void quickSort(String[] values, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = values[(left + right) / 2];
        while (true) {
            if (this.smaller(values[left], mid)) {
                ++left;
                continue;
            }
            while (this.smaller(mid, values[right])) {
                --right;
            }
            if (left <= right) {
                String tmp = values[left];
                values[left] = values[right];
                values[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            this.quickSort(values, original_left, right);
        }
        if (left < original_right) {
            this.quickSort(values, left, original_right);
        }
    }

    private boolean smaller(String left, String right) {
        return left.toLowerCase().compareTo(right.toLowerCase()) < 0;
    }

    private void handleSelectionChanged() {
        if (this.okButton_ != null) {
            this.okButton_.setEnabled(this.getSelected().length > 0);
        }
    }
}

