/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.propertygroup.ui.dialogs;

import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyUIErrorDialog
extends MessageDialog {
    protected static final String[] LABELS_OK = new String[]{IDialogConstants.OK_LABEL};
    protected static final String[] LABELS_OK_DETAILS = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
    private Throwable detail_;
    private int detailButtonID_ = -1;
    private Text text_;
    private String detailMessage_;
    private String reason_;
    private int defaultButtonIndex_ = 0;
    private static final int TEXT_LINE_COUNT = 15;

    public PropertyUIErrorDialog(Shell shell, String title, String message, Throwable detail, String[] labels, int defaultIndex) {
        super(shell, title, null, message, 1, labels, defaultIndex);
        this.defaultButtonIndex_ = defaultIndex;
        this.detail_ = detail;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    public int open() {
        this.create();
        Button b = this.getButton(this.defaultButtonIndex_);
        b.setFocus();
        b.getShell().setDefaultButton(b);
        return super.open();
    }

    public void setDetailButton(int index) {
        this.detailButtonID_ = index;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.detailButtonID_) {
            this.toggleDetailsArea();
        } else {
            this.setReturnCode(buttonId);
            this.close();
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.text_ != null) {
            this.text_.dispose();
            this.text_ = null;
            this.getButton(this.detailButtonID_).setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownText((Composite)this.getContents());
            this.getButton(this.detailButtonID_).setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected void createDropDownText(Composite parent) {
        this.text_ = new Text(parent, 2816);
        if (this.detailMessage_ != null) {
            this.text_.setText(this.detailMessage_);
        } else {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(baos);
                this.detail_.printStackTrace(ps);
                if (this.detail_ instanceof SWTError && ((SWTError)this.detail_).throwable != null) {
                    ps.println("\n*** Stack trace of contained exception ***");
                    ((SWTError)this.detail_).throwable.printStackTrace(ps);
                } else if (this.detail_ instanceof SWTException && ((SWTException)this.detail_).throwable != null) {
                    ps.println("\n*** Stack trace of contained exception ***");
                    ((SWTException)this.detail_).throwable.printStackTrace(ps);
                }
                ps.flush();
                baos.flush();
                this.text_.setText(baos.toString());
            }
            catch (IOException iOException) {}
        }
        GridData data = new GridData(1808);
        data.heightHint = this.text_.getLineHeight() * 15;
        this.text_.setLayoutData((Object)data);
    }

    public static boolean openError(Shell parent, String title, String message, String reason, Throwable detail) {
        PropertyUIErrorDialog dialog;
        String[] labels;
        String detailMsg = null;
        String msg = reason;
        if (detail == null) {
            if (reason.length() > 268) {
                labels = LABELS_OK_DETAILS;
                detailMsg = reason;
                StringBuffer msgBuffer = new StringBuffer(reason);
                msgBuffer.setLength(268);
                msgBuffer.append(" ...");
                msg = msgBuffer.toString();
            } else {
                labels = LABELS_OK;
            }
        } else {
            labels = LABELS_OK_DETAILS;
        }
        if (detail != null || detailMsg != null) {
            dialog = new PropertyUIErrorDialog(parent, title, message, detail, labels, 1);
            dialog.setDetailButton(1);
        } else {
            dialog = new PropertyUIErrorDialog(parent, title, message, detail, labels, 0);
        }
        dialog.reason_ = msg;
        dialog.detailMessage_ = detailMsg;
        return dialog.open() == 0;
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Label label;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Image image = parent.getDisplay().getSystemImage(1);
        if (image != null) {
            label = new Label(composite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            data = new GridData(66);
            data.verticalSpan = 3;
            label.setLayoutData((Object)data);
        }
        if (this.message != null) {
            label = new Label(composite, 64);
            label.setText(this.message);
            data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        if (this.reason_ != null) {
            label = new Label(composite, 0);
            label.setText(PropertyUIMessages.PROPERTY_UI_DIALOG_LABEL_REASON);
            GridData gd = new GridData(768);
            label.setLayoutData((Object)gd);
            label = new Label(composite, 64);
            label.setText(this.reason_);
            GridData data2 = new GridData(1796);
            data2.horizontalIndent = 20;
            data2.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data2);
            label.setFont(parent.getFont());
        }
        return composite;
    }
}

