/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.common.writer;

import com.ibm.adapter.j2ca.spi.util.ConnectorProjectHelper;
import com.ibm.adapter.j2ca.spi.util.InMemoryClassLoader;
import com.ibm.lang.common.writer.CodegenUtil;
import com.ibm.lang.common.writer.LogFacility;
import java.io.ObjectStreamClass;
import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;

public class SerialVersionUIDAdder {
    public static void addSerialVersionToClasses(List<ICompilationUnit> units, boolean waitForBuild, IProgressMonitor monitor) {
        if (waitForBuild) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            }
            catch (InterruptedException interruptedException) {}
        }
        IProject project = null;
        InMemoryClassLoader loader = null;
        for (ICompilationUnit cu : units) {
            IProject currentProject = cu.getJavaProject().getProject();
            if (project == null || project != currentProject) {
                URL[] projectURLs = null;
                try {
                    projectURLs = ConnectorProjectHelper.getURLsFromProject((IProject)currentProject);
                }
                catch (Exception exception) {
                    continue;
                }
                loader = new InMemoryClassLoader(projectURLs);
                project = currentProject;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(CodegenUtil.getPackageName(cu));
            sb.append(".");
            sb.append(CodegenUtil.getClassName(cu));
            String qualifiedClassName = sb.toString();
            Class<?> cls = null;
            try {
                cls = loader.loadClass(qualifiedClassName);
            }
            catch (Throwable throwable) {
                try {
                    currentProject.build(10, monitor);
                }
                catch (CoreException coreException) {}
                try {
                    cls = loader.loadClass(qualifiedClassName);
                }
                catch (Throwable cnfExc) {
                    String message = cnfExc.getLocalizedMessage() == null ? "" : cnfExc.getLocalizedMessage();
                    LogFacility.logErrorMessage((String)message, (Throwable)cnfExc);
                    continue;
                }
            }
            ObjectStreamClass osCls = ObjectStreamClass.lookup(cls);
            if (osCls == null) continue;
            long serialVerionUIDLong = osCls.getSerialVersionUID();
            sb = new StringBuffer();
            sb.append("private static final long serialVersionUID = ");
            sb.append(Long.toString(serialVerionUIDLong));
            sb.append("L;");
            try {
                cu = cu.getWorkingCopy(monitor);
                cu.getTypes()[0].createField(sb.toString(), cu.getTypes()[0].getChildren()[0], false, monitor);
                cu.commitWorkingCopy(true, monitor);
                cu.discardWorkingCopy();
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

