/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.common.writer;

import com.ibm.etools.marshall.MarshallParms;
import com.ibm.etools.marshall.codegen.CodeGenStringUtils;
import com.ibm.etools.marshall.codegen.CodeGenUtils;
import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.BinaryTD;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import com.ibm.etools.typedescriptor.StringTD;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.lang.common.writer.CodegenUtil;
import com.ibm.lang.common.writer.Level88;
import com.ibm.lang.common.writer.PropertyInfo;
import java.beans.Introspector;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;

public abstract class BaseGenerationAdapter {
    protected StringBuffer initialValueBuffer_ = new StringBuffer();
    protected StringBuffer matchMethodBuffer_ = new StringBuffer();
    protected String initializeRecordSize_ = "0";
    protected String contentSize_ = "0";
    protected String recordBaseOffset_ = "0";
    protected boolean generatingSubrecord_ = false;
    protected Map<String, String> ODODependentMap_ = new HashMap<String, String>();
    protected Map<String, String> valFormulaMaxSizeMap_ = new HashMap<String, String>();
    protected Map<String, String> builtInJavaTypeToDefaultValueMap_ = new HashMap<String, String>();
    protected Map<String, String> builtInJavaTypeToJavaClassMap_ = new HashMap<String, String>();
    protected List<Level88> level88List_ = new ArrayList<Level88>();
    protected Map<String, String> getterBodyMap_ = new HashMap<String, String>();
    protected Map<String, String> setterBodyMap_ = new HashMap<String, String>();
    protected Map<String, String> isBodyMap_ = new HashMap<String, String>();
    protected ICompilationUnit compilationUnit_ = null;
    protected boolean isCICSChannel_ = false;
    protected boolean isCICSCharContainer_ = false;
    protected int charSize_ = 1;
    protected String recordName_ = null;
    private static String[] defaultBuiltInJavaTypeToDefaultValueMap = new String[]{"boolean", "false", "float", "0.0F", "double", "0.0D", "long", "0", "int", "0", "short", "0", "byte", "0", "byte[]", "null"};
    private static String[] defaultBuiltInJavaTypeToJavaClassMap = new String[]{"boolean", "java.lang.Boolean", "float", "java.lang.Float", "double", "java.lang.Double", "long", "java.lang.Long", "int", "java.lang.Integer", "short", "java.lang.Short", "byte", "java.lang.Byte"};

    public BaseGenerationAdapter() {
        int i = 0;
        while (i < defaultBuiltInJavaTypeToDefaultValueMap.length) {
            this.builtInJavaTypeToDefaultValueMap_.put(defaultBuiltInJavaTypeToDefaultValueMap[i], defaultBuiltInJavaTypeToDefaultValueMap[i + 1]);
            i += 2;
        }
        i = 0;
        while (i < defaultBuiltInJavaTypeToJavaClassMap.length) {
            this.builtInJavaTypeToJavaClassMap_.put(defaultBuiltInJavaTypeToJavaClassMap[i], defaultBuiltInJavaTypeToJavaClassMap[i + 1]);
            i += 2;
        }
    }

    protected void populateValFormulaMaxSizeMap() {
        if (this.ODODependentMap_.size() != 0) {
            Collection<String> values = this.ODODependentMap_.values();
            for (String aVal : values) {
                int index = aVal.indexOf(58);
                if (index == -1) continue;
                String maxOccurs = aVal.substring(0, index);
                String valFormula = aVal.substring(index + 1);
                this.valFormulaMaxSizeMap_.put(valFormula, maxOccurs);
            }
        }
    }

    public String getPackageName() {
        return CodegenUtil.getPackageName(this.compilationUnit_);
    }

    public String getClassName() {
        return CodegenUtil.getClassName(this.compilationUnit_);
    }

    public String getGetSizeMethodBody() {
        String initialSize = Integer.toString(this.evaluateFormula(this.contentSize_));
        String sizeStr = "return (" + initialSize + ");\n";
        String indent = "\t\t";
        if (!CodeGenUtils.isFormula((String)this.contentSize_)) {
            return String.valueOf(indent) + sizeStr;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append("if ((buffer_ == null) || (valFieldNameMap_ == null))\n");
        sb.append(indent);
        sb.append("\t" + sizeStr + "\n\n");
        sb.append(indent);
        sb.append("String formula = \"" + this.contentSize_ + "\";\n");
        sb.append(indent);
        sb.append("int size = evaluateFormula (formula, valFieldNameMap_);\n");
        sb.append(indent);
        sb.append("return (size);\n");
        return sb.toString();
    }

    protected int evaluateFormula(String formula) {
        int result = 0;
        int index = formula.indexOf("(");
        if (index == -1) {
            return Integer.parseInt(formula);
        }
        String function = formula.substring(0, index);
        if (function.equalsIgnoreCase("val")) {
            String strResult = this.valFormulaMaxSizeMap_.get(formula);
            if (strResult == null) {
                return 0;
            }
            result = Integer.parseInt(strResult);
        } else if (function.equalsIgnoreCase("neg")) {
            formula = formula.substring(index + 1, formula.length() - 1);
            result = -1 * this.evaluateFormula(formula);
        } else {
            formula = formula.substring(index + 1, formula.length() - 1);
            char[] formulaChars = formula.toCharArray();
            int brackets = 0;
            int i = 0;
            while (i < formulaChars.length) {
                if (formulaChars[i] == '(') {
                    ++brackets;
                } else if (formulaChars[i] == ')') {
                    --brackets;
                } else if (formulaChars[i] == ',' && brackets == 0) break;
                ++i;
            }
            String leftSide = "0";
            String rightSide = "0";
            leftSide = formula.substring(0, i);
            rightSide = formula.substring(i + 1);
            if (function.equalsIgnoreCase("add")) {
                result = this.evaluateFormula(leftSide) + this.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("mpy")) {
                result = this.evaluateFormula(leftSide) * this.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("sub")) {
                result = this.evaluateFormula(leftSide) - this.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("div")) {
                result = this.evaluateFormula(leftSide) / this.evaluateFormula(rightSide);
            } else if (function.equalsIgnoreCase("max")) {
                result = Math.max(this.evaluateFormula(leftSide), this.evaluateFormula(rightSide));
            } else if (function.equalsIgnoreCase("min")) {
                result = Math.min(this.evaluateFormula(leftSide), this.evaluateFormula(rightSide));
            } else if (function.equalsIgnoreCase("mod")) {
                result = this.evaluateFormula(leftSide) % this.evaluateFormula(rightSide);
            }
        }
        return result;
    }

    public String getInitialRecordSize() {
        return this.initializeRecordSize_;
    }

    public String getUppercaseName(String name) {
        return CodegenUtil.getUppercaseName(name);
    }

    public String getLowercaseName(String name) {
        return CodegenUtil.getLowercaseName(name);
    }

    public String getInitializeMethodBody() {
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        if (this.isCICSCharContainer_) {
            String padCharString = " ";
            String initializeRecordSize = this.initializeRecordSize_;
            if (this.charSize_ > 1) {
                padCharString = "\\u3000";
                int recSize = Integer.parseInt(initializeRecordSize) / this.charSize_;
                initializeRecordSize = Integer.toString(recSize);
            }
            sb.append("padCharacter_ = '");
            sb.append(padCharString);
            sb.append("';\n");
            sb.append(indent);
            sb.append("StringBuffer sb = new StringBuffer(");
            sb.append(initializeRecordSize);
            sb.append(");\n");
            sb.append(indent);
            sb.append("sb.setLength (");
            sb.append(initializeRecordSize);
            sb.append(");\n");
            sb.append(indent);
            sb.append("String str = sb.toString().replace ('\\u0000', padCharacter_);\n");
            sb.append(indent);
            sb.append("buffer_ = str.toCharArray();");
            if (this.initialValueBuffer_.length() != 0) {
                sb.append("\n");
                sb.append(this.initialValueBuffer_.toString());
            }
            return sb.toString();
        }
        sb.append("buffer_ = new byte[bufferSize_];\n\n");
        if (this.ODODependentMap_.size() != 0) {
            sb.append(indent);
            sb.append("if (valFieldNameMap_ == null)\n");
            sb.append(indent);
            sb.append("{\n");
            sb.append(indent);
            sb.append("\tjava.util.HashMap valFieldNameMap = new java.util.HashMap();\n");
            for (Map.Entry<String, String> entry : this.ODODependentMap_.entrySet()) {
                String valFormula;
                String fieldName = entry.getKey();
                String value = entry.getValue();
                int index = value.indexOf(58);
                if (index == -1) continue;
                if (this.generatingSubrecord_) {
                    valFormula = value.substring(index + 1);
                    String maxValue = value.substring(0, index);
                    sb.append(indent);
                    sb.append("\tvalFieldNameMap.put (\"" + valFormula + "\", new Integer(\"" + maxValue + "\"));\n");
                    continue;
                }
                valFormula = value.substring(index + 1);
                sb.append(indent);
                sb.append("\tvalFieldNameMap.put (\"" + valFormula + "\", \"" + fieldName + "\");\n");
            }
            sb.append(indent);
            sb.append("\tvalFieldNameMap_ = valFieldNameMap;\n");
            sb.append(indent);
            sb.append("}\n");
        }
        sb.append(indent);
        sb.append("System.arraycopy (initializedBuffer_, 0, buffer_, 0, bufferSize_);\n");
        return sb.toString();
    }

    public String getStaticInitializerBody() {
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        String initialSize = this.initializeRecordSize_;
        if (CodeGenUtils.isFormula((String)this.initializeRecordSize_)) {
            initialSize = Integer.toString(this.evaluateFormula(this.initializeRecordSize_));
        }
        sb.append(indent);
        sb.append("bufferSize_ = " + initialSize + ";\n");
        sb.append(indent);
        sb.append("initializedBuffer_ = new byte[bufferSize_];\n");
        if (this.initialValueBuffer_.length() != 0) {
            sb.append(this.initialValueBuffer_.toString());
        }
        return sb.toString();
    }

    protected void generateInitialValueCode(PropertyInfo info, String dataTypeName, String lowerCasePropertyName, String javaBeanPropertyName, String setterMethodName) {
        String initialValue = null;
        String kindAttribute = info.initialValueKind;
        String valueAttribute = info.initialValueVal;
        SimpleInstanceTD simpleTD = (SimpleInstanceTD)info.tdBase;
        String value = this.ODODependentMap_.get(javaBeanPropertyName);
        if (value != null) {
            int index = value.indexOf(58);
            if (index != -1) {
                initialValue = value.substring(0, index);
            } else if (kindAttribute == null) {
                return;
            }
        } else if (kindAttribute == null) {
            return;
        }
        if (initialValue == null) {
            String codePage;
            if (kindAttribute == null && valueAttribute == null) {
                return;
            }
            initialValue = "";
            int maxStringSize = CodeGenUtils.getMaximumStringSize((SimpleInstanceTD)simpleTD);
            boolean fixedLengthSpacePad = false;
            BaseTDType baseTD = simpleTD.getSharedType();
            boolean DBCSOnly = false;
            if (baseTD instanceof StringTD) {
                String padChar;
                StringTD stringTD = (StringTD)baseTD;
                if (MarshallParms.getDBCSOnly((StringTD)stringTD)) {
                    maxStringSize /= 2;
                    DBCSOnly = true;
                } else {
                    maxStringSize /= MarshallParms.getCharacterSize((StringTD)stringTD);
                }
                if (MarshallParms.getEncodingStyle((StringTD)stringTD) == 0 && (padChar = MarshallParms.getPaddingCharacter((StringTD)stringTD)) != null && padChar.equals(" ")) {
                    fixedLengthSpacePad = true;
                }
            }
            if (kindAttribute.equals("quotes")) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < maxStringSize) {
                    sb.append("\\\"");
                    ++i;
                }
                initialValue = sb.toString();
            } else if (kindAttribute.equals("SPACE")) {
                if (this.isCICSCharContainer_) {
                    return;
                }
                initialValue = DBCSOnly ? (baseTD instanceof StringTD ? (CodeGenStringUtils.isCodepageDBUnicode((String)(codePage = MarshallParms.getCodePage((StringTD)((StringTD)baseTD), (SimpleInstanceTD)simpleTD))) ? " " : (fixedLengthSpacePad ? "\\u3000" : this.createDBCSSpaceInitializeString(maxStringSize))) : this.createDBCSSpaceInitializeString(maxStringSize)) : (fixedLengthSpacePad ? " " : this.createStringFromPattern(" ", maxStringSize));
            } else if (kindAttribute.equals("ZERO")) {
                initialValue = this.createStringFromPattern("0", maxStringSize);
            } else if (kindAttribute.equals("ALL")) {
                if (valueAttribute == null) {
                    return;
                }
                if ((valueAttribute = valueAttribute.replaceAll("\"", "\\\\\"")).startsWith("\\u")) {
                    codePage = "UTF-8";
                    if (baseTD instanceof StringTD) {
                        codePage = MarshallParms.getCodePage((StringTD)((StringTD)baseTD), (SimpleInstanceTD)simpleTD);
                    }
                    initialValue = this.createHexStringFromPattern(valueAttribute, maxStringSize, codePage);
                } else {
                    initialValue = this.createStringFromPattern(valueAttribute, maxStringSize);
                }
            } else if (kindAttribute.equals("string_value")) {
                if (valueAttribute == null) {
                    return;
                }
                if ((valueAttribute = valueAttribute.replaceAll("\"", "\\\\\"")).startsWith("\\u")) {
                    codePage = "UTF-8";
                    if (baseTD instanceof StringTD) {
                        codePage = MarshallParms.getCodePage((StringTD)((StringTD)baseTD), (SimpleInstanceTD)simpleTD);
                    }
                    initialValue = this.createHexString(valueAttribute, maxStringSize, codePage);
                } else {
                    initialValue = valueAttribute;
                }
            } else {
                return;
            }
        }
        if (simpleTD.getSharedType() instanceof BinaryTD) {
            return;
        }
        String indent = "\t\t";
        String initValueVar = String.valueOf(lowerCasePropertyName) + "InitialValue";
        this.initialValueBuffer_.append(indent);
        this.initialValueBuffer_.append(String.valueOf(dataTypeName) + " " + initValueVar + " = ");
        if (dataTypeName.equals("String")) {
            this.initialValueBuffer_.append("\"" + initialValue + "\";\n");
        } else if (dataTypeName.startsWith("Big") || dataTypeName.startsWith("java.math.Big")) {
            this.initialValueBuffer_.append("new " + dataTypeName + "(\"" + initialValue + "\");\n");
        } else {
            this.initialValueBuffer_.append("(" + dataTypeName + ")" + initialValue + ";\n");
        }
        String baseOffset = Integer.toString(this.evaluateFormula(simpleTD.getOffset()) - this.evaluateFormula(this.recordBaseOffset_));
        EList list = simpleTD.getArrayDescr();
        if (list != null && list.size() != 0) {
            int numDimensions = list.size();
            ArrayList<String> strides = new ArrayList<String>(numDimensions);
            ArrayList<String> upperBounds = new ArrayList<String>(numDimensions);
            for (ArrayTD arrayTD : list) {
                String strideString = Integer.toString(this.evaluateFormula(arrayTD.getStride()));
                strides.add(strideString);
                String upperBoundString = Integer.toString(this.evaluateFormula(arrayTD.getUpperBound()));
                upperBounds.add(upperBoundString);
            }
            StringBuffer offsetBuf = new StringBuffer(baseOffset);
            int i = 0;
            while (i < numDimensions) {
                offsetBuf.append("+(");
                offsetBuf.append((String)strides.get(i));
                offsetBuf.append(" * index");
                offsetBuf.append(i + 1);
                offsetBuf.append(")");
                ++i;
            }
            String offsetString = offsetBuf.toString();
            String[] gendMethods = null;
            if (this.isCICSCharContainer_) {
                StringBuffer sb = new StringBuffer();
                sb.append(setterMethodName);
                sb.append(" (index, ");
                sb.append(initValueVar);
                sb.append(");");
                gendMethods = new String[]{sb.toString()};
            } else {
                gendMethods = CodeGenUtils.generateMarshallMethod((String)initValueVar, (String)"initializedBuffer_", (String)offsetString, (SimpleInstanceTD)simpleTD, (String)dataTypeName);
            }
            int i2 = 0;
            while (i2 < numDimensions) {
                this.initialValueBuffer_.append(indent);
                this.initialValueBuffer_.append("for (int index");
                this.initialValueBuffer_.append(i2 + 1);
                this.initialValueBuffer_.append(" = 0; index");
                this.initialValueBuffer_.append(i2 + 1);
                this.initialValueBuffer_.append(" < ");
                this.initialValueBuffer_.append((String)upperBounds.get(i2));
                this.initialValueBuffer_.append("; index");
                this.initialValueBuffer_.append(i2 + 1);
                this.initialValueBuffer_.append("++)\n");
                if (i2 + 1 < numDimensions) {
                    indent = String.valueOf(indent) + "\t";
                }
                ++i2;
            }
            if (gendMethods.length > 1) {
                this.initialValueBuffer_.append(indent);
                this.initialValueBuffer_.append("{\n");
            }
            i2 = 0;
            while (i2 < gendMethods.length) {
                this.initialValueBuffer_.append(indent);
                this.initialValueBuffer_.append("\t");
                this.initialValueBuffer_.append(gendMethods[i2]);
                this.initialValueBuffer_.append("\n");
                ++i2;
            }
            if (gendMethods.length > 1) {
                this.initialValueBuffer_.append(indent);
                this.initialValueBuffer_.append("}\n");
            }
        } else if (this.isCICSCharContainer_) {
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append(setterMethodName);
            this.initialValueBuffer_.append(" (");
            this.initialValueBuffer_.append(initValueVar);
            this.initialValueBuffer_.append(");\n");
        } else {
            String[] gendMethods = CodeGenUtils.generateMarshallMethod((String)initValueVar, (String)"initializedBuffer_", (String)baseOffset, (SimpleInstanceTD)simpleTD, (String)dataTypeName);
            int i = 0;
            while (i < gendMethods.length) {
                this.initialValueBuffer_.append(indent);
                this.initialValueBuffer_.append(gendMethods[i]);
                this.initialValueBuffer_.append("\n");
                ++i;
            }
        }
    }

    protected String createStringFromPattern(String pattern, int maxStringSize) {
        StringBuffer sb = new StringBuffer(maxStringSize);
        int patternLength = pattern.length();
        while (sb.length() + patternLength < maxStringSize) {
            sb.append(pattern);
        }
        if (sb.length() != maxStringSize) {
            char[] patternChars = pattern.toCharArray();
            sb.append(patternChars, 0, maxStringSize - sb.length());
        }
        return sb.toString();
    }

    protected String createHexString(String valueAttribute, int maxStringSize, String codepage) {
        ArrayList<String> unicodePatterns = this.getUnicodePatternsForCodepage(valueAttribute, codepage);
        StringBuffer buf = new StringBuffer();
        String[] unicodePatternArray = unicodePatterns.toArray(new String[unicodePatterns.size()]);
        int i = 0;
        while (i < unicodePatternArray.length && i < maxStringSize) {
            buf.append(unicodePatternArray[i]);
            ++i;
        }
        return buf.toString();
    }

    protected ArrayList<String> getUnicodePatternsForCodepage(String valueAttribute, String codepage) {
        String splitString = valueAttribute;
        ArrayList<String> numbers = new ArrayList<String>();
        while (splitString.length() > 0) {
            String s = splitString.substring(2, 6);
            numbers.add(s);
            splitString = splitString.substring(6);
        }
        ArrayList<String> unicodePatterns = new ArrayList<String>();
        for (String aNum : numbers) {
            StringBuffer sb = new StringBuffer();
            int hex = Integer.parseInt(aNum, 16);
            byte[] b = new byte[]{(byte)hex};
            String s = "";
            try {
                s = new String(b, codepage);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            int aChar = UTF16.charAt((String)s, (int)0);
            sb.append(Integer.toHexString(aChar));
            while (sb.length() < 2) {
                sb.insert(0, "0");
            }
            sb.insert(0, "\\u00");
            unicodePatterns.add(sb.toString());
        }
        return unicodePatterns;
    }

    protected String createHexStringFromPattern(String pattern, int maxStringSize, String codepage) {
        ArrayList<String> unicodePatterns = this.getUnicodePatternsForCodepage(pattern, codepage);
        StringBuffer buf = new StringBuffer();
        String[] unicodePatternArray = unicodePatterns.toArray(new String[unicodePatterns.size()]);
        int i = 0;
        while (i < maxStringSize) {
            buf.append(unicodePatternArray[i % unicodePatternArray.length]);
            ++i;
        }
        return buf.toString();
    }

    protected String createDBCSSpaceInitializeString(int maxStringSize) {
        StringBuffer sb = new StringBuffer(maxStringSize);
        String pattern = "\\u3000";
        int i = 0;
        while (i < maxStringSize) {
            sb.append(pattern);
            ++i;
        }
        return sb.toString();
    }

    protected void generateComplexArrayInitialValueCode(PropertyInfo info, String dataTypeName, String lowerCasePropertyName) {
        boolean notPaddedAtEnd;
        EList list = info.tdBase.getArrayDescr();
        int numDimensions = list.size();
        ArrayList<String> strides = new ArrayList<String>(numDimensions);
        ArrayList<String> upperBounds = new ArrayList<String>(numDimensions);
        for (ArrayTD arrayTD : list) {
            String strideString = Integer.toString(this.evaluateFormula(arrayTD.getStride()));
            strides.add(strideString);
            String upperBoundString = Integer.toString(this.evaluateFormula(arrayTD.getUpperBound()));
            upperBounds.add(upperBoundString);
        }
        int baseOffsetInt = this.evaluateFormula(info.tdBase.getOffset()) - this.evaluateFormula(this.recordBaseOffset_);
        if (this.isCICSCharContainer_) {
            baseOffsetInt /= this.charSize_;
        }
        StringBuffer offsetBuf = new StringBuffer(Integer.toString(baseOffsetInt));
        int i = 0;
        while (i < numDimensions) {
            offsetBuf.append("+(");
            int stride = Integer.parseInt((String)strides.get(i));
            if (this.isCICSCharContainer_) {
                stride /= this.charSize_;
            }
            offsetBuf.append(stride);
            offsetBuf.append(" * index");
            offsetBuf.append(i + 1);
            offsetBuf.append(")");
            ++i;
        }
        String offsetString = offsetBuf.toString();
        String initValueVarBytes = null;
        initValueVarBytes = this.isCICSCharContainer_ ? String.valueOf(lowerCasePropertyName) + "Chars" : String.valueOf(lowerCasePropertyName) + "Bytes";
        this.initialValueBuffer_.append("\t\t" + dataTypeName + " " + lowerCasePropertyName + " = new " + dataTypeName + "();\n");
        if (this.isCICSCharContainer_) {
            this.initialValueBuffer_.append("\t\tchar[] " + initValueVarBytes + " = " + lowerCasePropertyName + ".getString().toCharArray();\n");
        } else {
            this.initialValueBuffer_.append("\t\tbyte[] " + initValueVarBytes + " = " + lowerCasePropertyName + ".getBytes();\n");
        }
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        int stride = this.evaluateFormula((String)strides.get(0));
        boolean bl = notPaddedAtEnd = contentSize % stride != 0;
        if (this.isCICSCharContainer_) {
            contentSize /= this.charSize_;
        }
        String indent = "\t\t";
        int i2 = 0;
        while (i2 < numDimensions) {
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append("for (int index");
            this.initialValueBuffer_.append(i2 + 1);
            this.initialValueBuffer_.append(" = 0; index");
            this.initialValueBuffer_.append(i2 + 1);
            this.initialValueBuffer_.append(" < ");
            this.initialValueBuffer_.append((String)upperBounds.get(i2));
            this.initialValueBuffer_.append("; index");
            this.initialValueBuffer_.append(i2 + 1);
            this.initialValueBuffer_.append("++)\n");
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append("{\n");
            indent = String.valueOf(indent) + "\t";
            ++i2;
        }
        if (notPaddedAtEnd) {
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append("int bytesToCopy = ");
            this.initialValueBuffer_.append(initValueVarBytes);
            this.initialValueBuffer_.append(".length;\n");
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append("if ");
            if (numDimensions > 1) {
                this.initialValueBuffer_.append("(");
            }
            i2 = 0;
            while (i2 < numDimensions) {
                this.initialValueBuffer_.append("(index");
                this.initialValueBuffer_.append(i2 + 1);
                this.initialValueBuffer_.append(" == ");
                int upperBound = Integer.parseInt((String)upperBounds.get(i2));
                this.initialValueBuffer_.append(--upperBound);
                this.initialValueBuffer_.append(")");
                if (i2 + 1 < numDimensions) {
                    this.initialValueBuffer_.append(" && ");
                }
                ++i2;
            }
            if (numDimensions > 1) {
                this.initialValueBuffer_.append(")");
            }
            this.initialValueBuffer_.append("\n");
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append("\tbytesToCopy = ");
            this.initialValueBuffer_.append(contentSize);
            this.initialValueBuffer_.append(" - (");
            this.initialValueBuffer_.append((String)strides.get(0));
            this.initialValueBuffer_.append(" * ");
            this.initialValueBuffer_.append((String)upperBounds.get(0));
            this.initialValueBuffer_.append(") + ");
            this.initialValueBuffer_.append("bytesToCopy;\n");
        } else {
            this.initialValueBuffer_.append(indent);
            this.initialValueBuffer_.append("int bytesToCopy = ");
            this.initialValueBuffer_.append(initValueVarBytes);
            this.initialValueBuffer_.append(".length;\n");
        }
        this.initialValueBuffer_.append(indent);
        if (this.isCICSCharContainer_) {
            this.initialValueBuffer_.append("System.arraycopy (" + initValueVarBytes + ", 0, buffer_, " + offsetString + ", bytesToCopy);\n");
        } else {
            this.initialValueBuffer_.append("System.arraycopy (" + initValueVarBytes + ", 0, initializedBuffer_, " + offsetString + ", bytesToCopy);\n");
        }
        StringBuffer indentBuf = new StringBuffer(indent);
        int i3 = 0;
        while (i3 < numDimensions) {
            indentBuf.deleteCharAt(indentBuf.length() - 1);
            this.initialValueBuffer_.append(indentBuf);
            this.initialValueBuffer_.append("}\n");
            ++i3;
        }
    }

    public String getMatchMethodBody() {
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("if (obj == null)\n");
        sb.append(indent);
        sb.append("\treturn (false);\n");
        sb.append(indent);
        sb.append("if (obj.getClass().isArray())\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\tbyte[] currBytes = buffer_;\n");
        sb.append(indent);
        sb.append("\ttry\n");
        sb.append(indent);
        sb.append("\t{\n");
        sb.append(indent);
        sb.append("\t\tbyte[] objByteArray = (byte[])obj;\n");
        if (this.matchMethodBuffer_.length() == 0) {
            sb.append(indent);
            sb.append("\t\tif (objByteArray.length != buffer_.length)\n");
            sb.append(indent);
            sb.append("\t\t\treturn (false);\n");
        }
        sb.append(indent);
        sb.append("\t\tbuffer_ = objByteArray;\n");
        sb.append(this.matchMethodBuffer_.toString());
        sb.append(indent);
        sb.append("\t}\n");
        sb.append(indent);
        sb.append("\tcatch (ClassCastException exc)\n");
        sb.append(indent);
        sb.append("\t{\n");
        sb.append(indent);
        sb.append("\t\treturn (false);\n");
        sb.append(indent);
        sb.append("\t}\n");
        sb.append(indent);
        sb.append("\tfinally\n");
        sb.append(indent);
        sb.append("\t{\n");
        sb.append(indent);
        sb.append("\t\tbuffer_ = currBytes;\n");
        sb.append(indent);
        sb.append("\t}\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("else\n");
        sb.append(indent);
        sb.append("\treturn (false);\n");
        sb.append(indent);
        sb.append("\n");
        sb.append(indent);
        sb.append("return (true);\n");
        return sb.toString();
    }

    protected void generateMatchMethodCode(PropertyInfo info, String methodName, String dataTypeName, boolean isPrimitiveType) {
        String pattern = info.recognitonPattern;
        if (pattern == null) {
            return;
        }
        pattern = pattern.replaceAll("\"", "\\\\\"");
        String indent = "\t\t\t\t";
        this.matchMethodBuffer_.append(indent);
        this.matchMethodBuffer_.append("if (!(\"");
        this.matchMethodBuffer_.append(pattern);
        this.matchMethodBuffer_.append("\".equals(");
        if (!isPrimitiveType) {
            this.matchMethodBuffer_.append(methodName);
            this.matchMethodBuffer_.append("()");
        } else {
            this.matchMethodBuffer_.append("new ");
            this.matchMethodBuffer_.append(this.builtInJavaTypeToJavaClassMap_.get(dataTypeName));
            this.matchMethodBuffer_.append("(");
            this.matchMethodBuffer_.append(methodName);
            this.matchMethodBuffer_.append("())");
        }
        this.matchMethodBuffer_.append(".toString().trim())))\n");
        this.matchMethodBuffer_.append(indent);
        this.matchMethodBuffer_.append("\treturn (false);\n");
        this.matchMethodBuffer_.append("\n");
    }

    protected boolean isPrimitiveObjectClass(String typeName) {
        return "String".equals(typeName) || "java.lang.String".equals(typeName) || "BigDecimal".equals(typeName) || "BigInteger".equals(typeName) || "java.math.BigDecimal".equals(typeName) || "java.math.BigInteger".equals(typeName);
    }

    protected void generateMethodBodies(String dataTypeName, boolean isPrimitiveType, PropertyInfo info, String propertyName) {
        boolean isArrayAccessMethod = !info.tdBase.getArrayDescr().isEmpty();
        String lowerCasePropertyName = CodegenUtil.getParameterName(propertyName);
        String upperCasePropertyName = this.getUppercaseName(propertyName);
        String getterMethodName = "get" + upperCasePropertyName;
        String setterMethodName = "set" + upperCasePropertyName;
        String javaBeanPropertyName = Introspector.decapitalize(upperCasePropertyName);
        if (!isArrayAccessMethod) {
            if (isPrimitiveType || this.isPrimitiveObjectClass(dataTypeName)) {
                this.generateSimpleGetMethod(info, getterMethodName, dataTypeName, lowerCasePropertyName);
                this.generateSimpleSetMethod(info, setterMethodName, dataTypeName, lowerCasePropertyName, javaBeanPropertyName);
                this.generateInitialValueCode(info, dataTypeName, lowerCasePropertyName, javaBeanPropertyName, setterMethodName);
                this.generateMatchMethodCode(info, getterMethodName, dataTypeName, isPrimitiveType);
            } else {
                this.generateComplexSetCode(info, setterMethodName, dataTypeName, lowerCasePropertyName);
                this.generateComplexGetCode(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            }
        } else if (isPrimitiveType || this.isPrimitiveObjectClass(dataTypeName)) {
            this.generateSimpleArrayGetCode(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            this.generateSimpleArraySetCode(info, setterMethodName, dataTypeName, lowerCasePropertyName);
            this.generateInitialValueCode(info, dataTypeName, lowerCasePropertyName, javaBeanPropertyName, setterMethodName);
        } else {
            this.generateComplexArrayGetCode(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            this.generateComplexArraySetCode(info, setterMethodName, dataTypeName, lowerCasePropertyName);
            this.generateComplexArrayInitialValueCode(info, dataTypeName, lowerCasePropertyName);
        }
    }

    protected void generateComplexGetCode(PropertyInfo info, String methodName, String dataTypeName, String lowerCasePropertyName) {
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        sb.append("();\n");
        sb.append(indent);
        sb.append("if (");
        sb.append(lowerCasePropertyName);
        sb.append(".match(buffer_))\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\t");
        sb.append(lowerCasePropertyName);
        sb.append(".populate(buffer_);\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("else\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("return (null);\n");
        this.getterBodyMap_.put(methodName, sb.toString());
    }

    protected void generateComplexSetCode(PropertyInfo info, String methodName, String dataTypeName, String lowerCasePropertyName) {
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("if (");
        sb.append(lowerCasePropertyName);
        sb.append(" != null)\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("buffer_ = ");
        sb.append(lowerCasePropertyName);
        sb.append(".getBytes();\n");
        this.setterBodyMap_.put(methodName, sb.toString());
    }

    protected void generateSimpleGetMethod(PropertyInfo info, String methodName, String dataTypeName, String lowerCasePropertyName) {
        if (this.isCICSCharContainer_) {
            this.generateSimpleGetMethodForCharContianer(info, methodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        String defaultValue = this.builtInJavaTypeToDefaultValueMap_.get(dataTypeName);
        if (defaultValue == null) {
            defaultValue = "null";
        }
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = ");
        sb.append(defaultValue);
        sb.append(";\n");
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        String baseOffset = null;
        if (offsetFormula || recordBaseOffsetFormula) {
            String offsetString = null;
            offsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                offsetString = String.valueOf(offsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                offsetString = String.valueOf(offsetString) + " - " + this.recordBaseOffset_;
            }
            sb.append(String.valueOf(indent) + "int offset = " + offsetString + ";\n");
            baseOffset = "offset";
        } else {
            baseOffset = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        String[] gendMethods = CodeGenUtils.generateUnmarshallMethod((String)lowerCasePropertyName, (String)"buffer_", (String)baseOffset, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i = 0;
        while (i < gendMethods.length) {
            sb.append(indent);
            sb.append(gendMethods[i].toString());
            sb.append("\n");
            ++i;
        }
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        if (dataTypeName.equals("byte[]")) {
            methodName = String.valueOf(methodName) + "[]";
        }
        this.getterBodyMap_.put(methodName, sb.toString());
    }

    protected int getMaxChars(SimpleInstanceTD instanceTD) {
        int maxSize = 0;
        maxSize = MarshallParms.isArray((InstanceTDBase)instanceTD) ? MarshallParms.getStride((InstanceTDBase)instanceTD) : MarshallParms.getSize((SimpleInstanceTD)instanceTD);
        int maxChars = maxSize / this.charSize_;
        return maxChars;
    }

    protected void generateSimpleGetMethodForCharContianer(PropertyInfo info, String methodName, String dataTypeName, String lowerCasePropertyName) {
        SimpleInstanceTD td = (SimpleInstanceTD)info.tdBase;
        if (!(td.getSharedType() instanceof StringTD)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        String defaultValue = this.builtInJavaTypeToDefaultValueMap_.get(dataTypeName);
        if (defaultValue == null) {
            defaultValue = "null";
        }
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = ");
        sb.append(defaultValue);
        sb.append(";\n");
        String baseOffset = Integer.toString((ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_)) / this.charSize_);
        int maxChars = this.getMaxChars(td);
        sb.append(this.generateRetrieveStringAtMethod(lowerCasePropertyName, indent, baseOffset, maxChars));
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(methodName, sb.toString());
    }

    protected void generateSimpleSetMethod(PropertyInfo info, String methodName, String dataTypeName, String lowerCasePropertyName, String javaBeanPropertyName) {
        int index;
        String indent;
        if (this.isCICSCharContainer_) {
            this.generateSimpleSetMethodForCharContainer(info, methodName, dataTypeName, lowerCasePropertyName, javaBeanPropertyName);
            return;
        }
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        boolean isODOCtrl = false;
        String value = this.ODODependentMap_.get(javaBeanPropertyName);
        if (value != null && (index = value.indexOf(58)) != -1) {
            String maxValue;
            isODOCtrl = true;
            info.upperBound = maxValue = value.substring(0, index);
        }
        StringBuffer validationBuffer = new StringBuffer();
        boolean nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, true, null, null, info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        String baseOffset = null;
        if (offsetFormula || recordBaseOffsetFormula) {
            String offsetString = null;
            offsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                offsetString = String.valueOf(offsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                offsetString = String.valueOf(offsetString) + " - " + this.recordBaseOffset_;
            }
            sb.append(indent);
            sb.append("int offset = " + offsetString + ";\n");
            baseOffset = "offset";
        } else {
            baseOffset = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        String[] gendMethods = CodeGenUtils.generateMarshallMethod((String)lowerCasePropertyName, (String)"buffer_", (String)baseOffset, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i = 0;
        while (i < gendMethods.length) {
            sb.append(indent);
            sb.append(gendMethods[i].toString());
            sb.append("\n");
            ++i;
        }
        if (isODOCtrl) {
            sb.append(indent);
            sb.append("if (buffer_.length < bufferSize_)\n");
            sb.append(indent);
            sb.append("{\n");
            sb.append(indent);
            sb.append("\tbyte[] newBuffer = new byte[bufferSize_];\n");
            sb.append(indent);
            sb.append("\tSystem.arraycopy (buffer_, 0, newBuffer, 0, buffer_.length);\n");
            sb.append(indent);
            sb.append("\tbuffer_ = newBuffer;\n");
            sb.append(indent);
            sb.append("}\n");
        }
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        if (dataTypeName.equals("byte[]")) {
            methodName = String.valueOf(methodName) + "[]";
        }
        this.setterBodyMap_.put(methodName, sb.toString());
    }

    protected void generateSimpleSetMethodForCharContainer(PropertyInfo info, String methodName, String dataTypeName, String lowerCasePropertyName, String javaBeanPropertyName) {
        String indent;
        SimpleInstanceTD td = (SimpleInstanceTD)info.tdBase;
        if (!(td.getSharedType() instanceof StringTD)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        StringBuffer validationBuffer = new StringBuffer();
        boolean nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, true, null, null, info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        String baseOffset = Integer.toString((ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_)) / this.charSize_);
        int maxChars = this.getMaxChars(td);
        sb.append(this.generateInsertStringAtMethod(lowerCasePropertyName, indent, baseOffset, maxChars));
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(methodName, sb.toString());
    }

    protected String generateInsertStringAtMethod(String lowerCasePropertyName, String indent, String baseOffset, int maxChars) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append("insertStringAt (");
        sb.append(lowerCasePropertyName);
        sb.append(", ");
        sb.append(baseOffset);
        sb.append(", ");
        sb.append(maxChars);
        sb.append(");\n");
        return sb.toString();
    }

    protected void generateSimpleArrayGetCode(PropertyInfo info, String getterMethodName, String dataTypeName, String lowerCasePropertyName) {
        if (this.isCICSCharContainer_) {
            this.generateSimpleArrayGetCodeForCharContainer(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        EList list = info.tdBase.getArrayDescr();
        if (list.size() > 1) {
            this.generateSimpleArrayGetCodeForNDimensionalArray(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        ListIterator iterator = list.listIterator();
        ArrayTD arrayTD = (ArrayTD)iterator.next();
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)arrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)arrayTD.getUpperBound());
        String baseOffsetString = null;
        String strideString = null;
        String upperBoundString = null;
        strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
        upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append("[] ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        sb.append("[upperBound];\n");
        sb.append(indent);
        sb.append("for (int i = 0; i < upperBound; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\t" + dataTypeName + " value;\n");
        String offsetString = "baseOffset+(stride*i)";
        String[] gendMethods = CodeGenUtils.generateUnmarshallMethod((String)"value", (String)"buffer_", (String)offsetString, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i = 0;
        while (i < gendMethods.length) {
            sb.append(indent);
            sb.append("\t");
            sb.append(gendMethods[i].toString());
            sb.append("\n");
            ++i;
        }
        sb.append(indent);
        sb.append("\t");
        sb.append(lowerCasePropertyName);
        sb.append("[i] = value;\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(String.valueOf(getterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append("if ((index < 0) || (index > upperBound-1))\n");
        sb.append(indent);
        sb.append("\tthrow new ArrayIndexOutOfBoundsException(index);\n");
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        String defaultValue = this.builtInJavaTypeToDefaultValueMap_.get(dataTypeName);
        if (defaultValue == null) {
            defaultValue = "null";
        }
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = ");
        sb.append(defaultValue);
        sb.append(";\n");
        offsetString = "baseOffset+(stride*index)";
        gendMethods = CodeGenUtils.generateUnmarshallMethod((String)lowerCasePropertyName, (String)"buffer_", (String)offsetString, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i2 = 0;
        while (i2 < gendMethods.length) {
            sb.append(indent);
            sb.append(gendMethods[i2].toString());
            sb.append("\n");
            ++i2;
        }
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(getterMethodName, sb.toString());
    }

    protected void generateSimpleArrayGetCodeForNDimensionalArray(PropertyInfo info, String getterMethodName, String dataTypeName, String lowerCasePropertyName) {
        EList list = info.tdBase.getArrayDescr();
        ArrayTD baseArrayTD = (ArrayTD)list.get(0);
        int numDimensions = list.size();
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)baseArrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)baseArrayTD.getUpperBound());
        String baseOffsetString = null;
        ArrayList<String> strides = new ArrayList<String>(numDimensions);
        ArrayList<String> upperBounds = new ArrayList<String>(numDimensions);
        for (ArrayTD arrayTD : list) {
            String strideString = null;
            strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
            strides.add(strideString);
            String upperBoundString = null;
            upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
            upperBounds.add(upperBoundString);
        }
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = ");
        sb.append(baseOffsetString);
        sb.append(";\n");
        int i = 0;
        while (i < numDimensions) {
            sb.append(indent);
            sb.append("int stride");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append((String)strides.get(i));
            sb.append(";\n");
            sb.append(indent);
            sb.append("int upperBound");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append((String)upperBounds.get(i));
            sb.append(";\n");
            ++i;
        }
        sb.append(indent);
        sb.append(dataTypeName);
        i = 0;
        while (i < numDimensions) {
            sb.append("[]");
            ++i;
        }
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        i = 0;
        while (i < numDimensions) {
            sb.append("[upperBound");
            sb.append(i + 1);
            sb.append("]");
            ++i;
        }
        sb.append(";\n");
        String originalIndent = indent;
        int i2 = 0;
        while (i2 < numDimensions) {
            sb.append(indent);
            sb.append("for (int index");
            sb.append(i2 + 1);
            sb.append(" = 0; index");
            sb.append(i2 + 1);
            sb.append(" < upperBound");
            sb.append(i2 + 1);
            sb.append("; index");
            sb.append(i2 + 1);
            sb.append("++)\n");
            sb.append(indent);
            sb.append("{\n");
            indent = String.valueOf(indent) + "\t";
            ++i2;
        }
        sb.append(indent);
        sb.append(String.valueOf(dataTypeName) + " value;\n");
        StringBuffer offsetBuf = new StringBuffer("baseOffset");
        int i3 = 0;
        while (i3 < numDimensions) {
            offsetBuf.append(" + (stride");
            offsetBuf.append(i3 + 1);
            offsetBuf.append(" * index");
            offsetBuf.append(i3 + 1);
            offsetBuf.append(")");
            ++i3;
        }
        String offsetString = offsetBuf.toString();
        String[] gendMethods = CodeGenUtils.generateUnmarshallMethod((String)"value", (String)"buffer_", (String)offsetString, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i4 = 0;
        while (i4 < gendMethods.length) {
            sb.append(indent);
            sb.append(gendMethods[i4].toString());
            sb.append("\n");
            ++i4;
        }
        sb.append(indent);
        sb.append(lowerCasePropertyName);
        i4 = 0;
        while (i4 < numDimensions) {
            sb.append("[index");
            sb.append(i4 + 1);
            sb.append("]");
            ++i4;
        }
        sb.append(" = value;\n");
        StringBuffer indentBuf = new StringBuffer(indent);
        int i5 = 0;
        while (i5 < numDimensions) {
            indentBuf.deleteCharAt(indentBuf.length() - 1);
            sb.append(indentBuf);
            sb.append("}\n");
            ++i5;
        }
        sb.append(originalIndent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(String.valueOf(getterMethodName) + "[]", sb.toString());
    }

    protected void generateSimpleArrayGetCodeForCharContainer(PropertyInfo info, String getterMethodName, String dataTypeName, String lowerCasePropertyName) {
        SimpleInstanceTD td = (SimpleInstanceTD)info.tdBase;
        if (!(td.getSharedType() instanceof StringTD)) {
            return;
        }
        EList list = info.tdBase.getArrayDescr();
        ListIterator iterator = list.listIterator();
        ArrayTD arrayTD = (ArrayTD)iterator.next();
        String strideString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()) / this.charSize_);
        String upperBoundString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        String baseOffsetString = Integer.toString((ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_)) / this.charSize_);
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append("[] ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        sb.append("[upperBound];\n");
        sb.append(indent);
        sb.append("for (int i = 0; i < upperBound; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\t" + dataTypeName + " value;\n");
        String offsetString = "baseOffset+(stride*i)";
        int maxChars = this.getMaxChars(td);
        sb.append(this.generateRetrieveStringAtMethod("value", String.valueOf(indent) + "\t", offsetString, maxChars));
        sb.append(indent);
        sb.append("\t");
        sb.append(lowerCasePropertyName);
        sb.append("[i] = value;\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(String.valueOf(getterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append("if ((index < 0) || (index > upperBound-1))\n");
        sb.append(indent);
        sb.append("\tthrow new ArrayIndexOutOfBoundsException(index);\n");
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        String defaultValue = this.builtInJavaTypeToDefaultValueMap_.get(dataTypeName);
        if (defaultValue == null) {
            defaultValue = "null";
        }
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = ");
        sb.append(defaultValue);
        sb.append(";\n");
        offsetString = "baseOffset+(stride*index)";
        sb.append(this.generateRetrieveStringAtMethod(lowerCasePropertyName, indent, offsetString, maxChars));
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(getterMethodName, sb.toString());
    }

    protected String generateRetrieveStringAtMethod(String lowerCasePropertyName, String indent, String offsetString, int maxChars) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append(lowerCasePropertyName);
        sb.append(" = retrieveStringAt (");
        sb.append(offsetString);
        sb.append(", ");
        sb.append(maxChars);
        sb.append(");\n");
        return sb.toString();
    }

    protected void generateSimpleArraySetCode(PropertyInfo info, String setterMethodName, String dataTypeName, String lowerCasePropertyName) {
        String indent;
        if (this.isCICSCharContainer_) {
            this.generateSimpleArraySetCodeForCharContainer(info, setterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        EList list = info.tdBase.getArrayDescr();
        if (list.size() > 1) {
            this.generateSimpleArraySetCodeForNDimensionalArray(info, setterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        ListIterator iterator = list.listIterator();
        ArrayTD arrayTD = (ArrayTD)iterator.next();
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)arrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)arrayTD.getUpperBound());
        String baseOffsetString = null;
        String strideString = null;
        String upperBoundString = null;
        strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
        upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        StringBuffer validationBuffer = new StringBuffer();
        boolean nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, true, null, "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int numElems = Math.min (");
        sb.append(lowerCasePropertyName);
        sb.append(".length, upperBound);\n");
        sb.append(indent);
        sb.append("for (int i = 0; i < numElems; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        if (this.isPrimitiveObjectClass(dataTypeName)) {
            sb.append(indent);
            sb.append("\tif (");
            sb.append(lowerCasePropertyName);
            sb.append("[i] == null)\n");
            sb.append(indent);
            sb.append("\t\tcontinue;\n");
        }
        String offsetString = "baseOffset+(stride*i)";
        String[] gendMethods = CodeGenUtils.generateMarshallMethod((String)(String.valueOf(lowerCasePropertyName) + "[i]"), (String)"buffer_", (String)offsetString, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i = 0;
        while (i < gendMethods.length) {
            sb.append(indent);
            sb.append("\t");
            sb.append(gendMethods[i].toString());
            sb.append("\n");
            ++i;
        }
        sb.append(indent);
        sb.append("}\n");
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(String.valueOf(setterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        indent = originalIndent;
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        validationBuffer = new StringBuffer();
        nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, true, "index", "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        offsetString = "baseOffset+(stride*index)";
        gendMethods = CodeGenUtils.generateMarshallMethod((String)lowerCasePropertyName, (String)"buffer_", (String)offsetString, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        i = 0;
        while (i < gendMethods.length) {
            sb.append(indent);
            sb.append(gendMethods[i].toString());
            sb.append("\n");
            ++i;
        }
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(setterMethodName, sb.toString());
    }

    protected void generateSimpleArraySetCodeForNDimensionalArray(PropertyInfo info, String setterMethodName, String dataTypeName, String lowerCasePropertyName) {
        String indent;
        EList list = info.tdBase.getArrayDescr();
        ArrayTD baseArrayTD = (ArrayTD)list.get(0);
        int numDimensions = list.size();
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)baseArrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)baseArrayTD.getUpperBound());
        String baseOffsetString = null;
        ArrayList<String> strides = new ArrayList<String>(numDimensions);
        ArrayList<String> upperBounds = new ArrayList<String>(numDimensions);
        for (ArrayTD arrayTD : list) {
            String strideString = null;
            strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
            strides.add(strideString);
            String upperBoundString = null;
            upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
            upperBounds.add(upperBoundString);
        }
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        int i = 0;
        while (i < numDimensions) {
            sb.append(indent);
            sb.append("int stride");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append((String)strides.get(i));
            sb.append(";\n");
            sb.append(indent);
            sb.append("int upperBound");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append((String)upperBounds.get(i));
            sb.append(";\n");
            ++i;
        }
        sb.append(indent);
        sb.append("if (");
        sb.append(lowerCasePropertyName);
        sb.append(" == null)\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("return;\n\n");
        String propertyVariableName = lowerCasePropertyName;
        int i2 = 0;
        while (i2 < numDimensions) {
            sb.append(indent);
            ArrayTD arrayTD = (ArrayTD)list.get(i2);
            boolean isSetMaxOccurs = arrayTD.isSetUpperBound();
            boolean isSetMinOccurs = arrayTD.isSetLowerBound();
            if (isSetMinOccurs) {
                sb.append(indent);
                sb.append("if (");
                sb.append(propertyVariableName);
                sb.append(".length < ");
                sb.append(arrayTD.getLowerBound());
                sb.append(")\n");
                sb.append(indent);
                sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0122E, \"");
                sb.append(propertyVariableName);
                sb.append("\", \"");
                sb.append(arrayTD.getLowerBound());
                sb.append("\"));\n");
            }
            if (isSetMaxOccurs) {
                String upperBoundName = new StringBuffer("upperBound").append(i2 + 1).toString();
                sb.append(indent);
                sb.append("if (");
                sb.append(propertyVariableName);
                sb.append(".length > ");
                sb.append(upperBoundName);
                sb.append(")\n");
                sb.append(indent);
                sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0123E, \"");
                sb.append(propertyVariableName);
                sb.append("\", Integer.toString(");
                sb.append(upperBoundName);
                sb.append(")));\n");
            }
            sb.append(indent);
            sb.append("int numElems");
            sb.append(i2 + 1);
            sb.append(" = Math.min (");
            sb.append(propertyVariableName);
            sb.append(".length, upperBound");
            sb.append(i2 + 1);
            sb.append(");\n");
            sb.append(indent);
            sb.append("for (int index");
            sb.append(i2 + 1);
            sb.append(" = 0; index");
            sb.append(i2 + 1);
            sb.append(" < numElems");
            sb.append(i2 + 1);
            sb.append("; index");
            sb.append(i2 + 1);
            sb.append("++)\n");
            sb.append(indent);
            sb.append("{\n");
            indent = String.valueOf(indent) + "\t";
            propertyVariableName = new StringBuffer(propertyVariableName).append("[index").append(i2 + 1).append("]").toString();
            ++i2;
        }
        StringBuffer validationBuffer = new StringBuffer();
        this.generateTypeValidationCode(propertyVariableName, info, indent, sb, propertyVariableName, propertyVariableName, dataTypeName, true, true, originalIndent, validationBuffer);
        String validation = validationBuffer.toString();
        if (validation != null && !"".equals(validation)) {
            sb.append(validation);
        }
        if (this.isPrimitiveObjectClass(dataTypeName)) {
            sb.append(indent);
            sb.append("if (");
            sb.append(propertyVariableName);
            sb.append(" == null)\n");
            sb.append(indent);
            sb.append("\tcontinue;\n");
        }
        StringBuffer offsetBuf = new StringBuffer("baseOffset");
        int i3 = 0;
        while (i3 < numDimensions) {
            offsetBuf.append(" + (stride");
            offsetBuf.append(i3 + 1);
            offsetBuf.append(" * index");
            offsetBuf.append(i3 + 1);
            offsetBuf.append(")");
            ++i3;
        }
        String offsetString = offsetBuf.toString();
        String[] gendMethods = CodeGenUtils.generateMarshallMethod((String)propertyVariableName, (String)"buffer_", (String)offsetString, (SimpleInstanceTD)((SimpleInstanceTD)info.tdBase), (String)dataTypeName);
        int i4 = 0;
        while (i4 < gendMethods.length) {
            sb.append(indent);
            sb.append(gendMethods[i4].toString());
            sb.append("\n");
            ++i4;
        }
        StringBuffer indentBuf = new StringBuffer(indent);
        int i5 = 0;
        while (i5 < numDimensions) {
            indentBuf.deleteCharAt(indentBuf.length() - 1);
            sb.append(indentBuf);
            sb.append("}\n");
            ++i5;
        }
        this.setterBodyMap_.put(String.valueOf(setterMethodName) + "[]", sb.toString());
    }

    protected void generateSimpleArraySetCodeForCharContainer(PropertyInfo info, String setterMethodName, String dataTypeName, String lowerCasePropertyName) {
        String indent;
        SimpleInstanceTD td = (SimpleInstanceTD)info.tdBase;
        if (!(td.getSharedType() instanceof StringTD)) {
            return;
        }
        EList list = info.tdBase.getArrayDescr();
        ListIterator iterator = list.listIterator();
        ArrayTD arrayTD = (ArrayTD)iterator.next();
        String strideString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()) / this.charSize_);
        String upperBoundString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        String baseOffsetString = Integer.toString((ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_)) / this.charSize_);
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        StringBuffer validationBuffer = new StringBuffer();
        boolean nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, true, null, "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int numElems = Math.min (");
        sb.append(lowerCasePropertyName);
        sb.append(".length, upperBound);\n");
        sb.append(indent);
        sb.append("for (int i = 0; i < numElems; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        if (this.isPrimitiveObjectClass(dataTypeName)) {
            sb.append(indent);
            sb.append("\tif (");
            sb.append(lowerCasePropertyName);
            sb.append("[i] == null)\n");
            sb.append(indent);
            sb.append("\t\tcontinue;\n");
        }
        String offsetString = "baseOffset+(stride*i)";
        int maxChars = this.getMaxChars(td);
        sb.append(this.generateInsertStringAtMethod(String.valueOf(lowerCasePropertyName) + "[i]", String.valueOf(indent) + "\t", offsetString, maxChars));
        sb.append(indent);
        sb.append("}\n");
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(String.valueOf(setterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        indent = originalIndent;
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        validationBuffer = new StringBuffer();
        nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, true, "index", "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        offsetString = "baseOffset+(stride*index)";
        sb.append(this.generateInsertStringAtMethod(lowerCasePropertyName, indent, offsetString, maxChars));
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(setterMethodName, sb.toString());
    }

    protected boolean generateValidationCode(String propertyVariableName, String propertyTypeName, boolean isPrimitiveType, String indexName, String upperBoundName, PropertyInfo info, String indent, StringBuffer outputBuffer) {
        String parameterName = propertyVariableName;
        String valueName = propertyVariableName;
        String typeName = propertyTypeName;
        boolean generateForLoop = false;
        boolean nullCheckAdded = false;
        boolean contentAdded = false;
        String originalIndent = indent;
        EList arrayTDList = info.tdBase.getArrayDescr();
        if (arrayTDList != null && !arrayTDList.isEmpty()) {
            ArrayTD arrayTD = (ArrayTD)arrayTDList.get(0);
            boolean isSetMaxOccurs = arrayTD.isSetUpperBound();
            boolean isSetMinOccurs = arrayTD.isSetLowerBound();
            if (indexName != null) {
                contentAdded = true;
                outputBuffer.append(indent);
                outputBuffer.append("if ((" + indexName + " < 0) || (" + indexName + " > " + upperBoundName + "-1))\n");
                outputBuffer.append(indent);
                outputBuffer.append("\tthrow new ArrayIndexOutOfBoundsException(" + indexName + ");\n");
            } else {
                nullCheckAdded = true;
                outputBuffer.append(indent);
                outputBuffer.append("if (" + propertyVariableName + " != null) {\n");
                indent = String.valueOf(indent) + "\t";
                if (isSetMinOccurs) {
                    contentAdded = true;
                    outputBuffer.append(indent);
                    outputBuffer.append("if (" + propertyVariableName + ".length < " + arrayTD.getLowerBound() + ")\n");
                    outputBuffer.append(indent);
                    outputBuffer.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0122E, \"" + propertyVariableName + "\", \"" + arrayTD.getLowerBound() + "\"));\n");
                }
                if (isSetMaxOccurs) {
                    contentAdded = true;
                    outputBuffer.append(indent);
                    outputBuffer.append("if (" + propertyVariableName + ".length > " + upperBoundName + ")\n");
                    outputBuffer.append(indent);
                    outputBuffer.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0123E, \"" + propertyVariableName + "\", Integer.toString(" + upperBoundName + ")));\n");
                }
                parameterName = String.valueOf(propertyVariableName) + "[i]";
                valueName = String.valueOf(propertyVariableName) + "[\"+Integer.toString(i)+\"]";
                generateForLoop = true;
                indent = String.valueOf(indent) + "\t";
            }
        }
        if (!isPrimitiveType && !this.isPrimitiveObjectClass(propertyTypeName)) {
            if (!contentAdded) {
                return false;
            }
            return nullCheckAdded;
        }
        StringBuffer sb = new StringBuffer();
        nullCheckAdded = this.generateTypeValidationCode(propertyVariableName, info, indent, outputBuffer, parameterName, valueName, typeName, generateForLoop, nullCheckAdded, originalIndent, sb);
        String validation = sb.toString();
        if (validation != null && !validation.equals("")) {
            contentAdded = true;
            if (generateForLoop) {
                outputBuffer.append(String.valueOf(originalIndent) + "\t");
                outputBuffer.append("for (int i = 0; i < " + propertyVariableName + ".length; i++)\n");
            }
            outputBuffer.append(validation);
        }
        if (!contentAdded) {
            return false;
        }
        return nullCheckAdded;
    }

    protected boolean generateTypeValidationCode(String propertyVariableName, PropertyInfo info, String indent, StringBuffer outputBuffer, String parameterName, String valueName, String typeName, boolean generateForLoop, boolean nullCheckAdded, String originalIndent, StringBuffer sb) {
        boolean bothLengthFacetSet;
        boolean maxLengthFacetSet = info.maxLength != null;
        boolean minLengthFacetSet = info.minLength != null;
        boolean maxFacetSet = info.upperBound != null;
        boolean minFacetSet = info.lowerBound != null;
        boolean bothFacetSet = maxFacetSet && minFacetSet;
        boolean bl = bothLengthFacetSet = maxLengthFacetSet && minLengthFacetSet;
        if (typeName.equals("String")) {
            if (maxLengthFacetSet || minLengthFacetSet) {
                if (!nullCheckAdded) {
                    nullCheckAdded = true;
                    outputBuffer.append(indent);
                    outputBuffer.append("if (" + propertyVariableName + " != null) {\n");
                    indent = String.valueOf(indent) + "\t";
                }
                String maxLengthString = null;
                String minLengthString = null;
                if (maxLengthFacetSet) {
                    maxLengthString = info.maxLength;
                }
                if (minLengthFacetSet) {
                    minLengthString = info.minLength;
                }
                if (generateForLoop && bothLengthFacetSet) {
                    sb.append(originalIndent);
                    sb.append("\t{\n");
                }
                sb.append(indent);
                if (generateForLoop) {
                    sb.append("if ((");
                    sb.append(parameterName);
                    sb.append(" != null) && (");
                } else {
                    sb.append("if (");
                }
                if (minLengthFacetSet) {
                    sb.append(parameterName);
                    sb.append(".length() < ");
                    sb.append(minLengthString);
                    sb.append(")");
                    if (generateForLoop) {
                        sb.append(")");
                    }
                    sb.append("\n");
                    sb.append(indent);
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0126E, " + parameterName + ", \"" + minLengthString + "\", \"" + valueName + "\"));\n");
                }
                if (maxLengthString != null) {
                    if (bothLengthFacetSet) {
                        sb.append(indent);
                        if (generateForLoop) {
                            sb.append("if ((");
                            sb.append(parameterName);
                            sb.append(" != null) && (");
                        } else {
                            sb.append("if (");
                        }
                    }
                    sb.append(parameterName);
                    sb.append(".length() > ");
                    sb.append(maxLengthString);
                    sb.append(")");
                    if (generateForLoop) {
                        sb.append(")");
                    }
                    sb.append("\n");
                    sb.append(indent);
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0124E, " + parameterName + ", \"" + maxLengthString + "\", \"" + valueName + "\"));\n");
                }
                if (generateForLoop && bothLengthFacetSet) {
                    sb.append(originalIndent);
                    sb.append("\t}\n");
                }
            }
        } else if (typeName.equals("BigDecimal") || typeName.equals("BigInteger") || typeName.equals("java.math.BigDecimal") || typeName.equals("java.math.BigInteger")) {
            if (minFacetSet || maxFacetSet) {
                if (!nullCheckAdded) {
                    nullCheckAdded = true;
                    outputBuffer.append(indent);
                    outputBuffer.append("if (" + propertyVariableName + " != null) {\n");
                    indent = String.valueOf(indent) + "\t";
                }
                sb.append(indent);
                if (generateForLoop) {
                    sb.append("if ((");
                    sb.append(parameterName);
                    sb.append(" != null) && (");
                } else {
                    sb.append("if (");
                }
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(".compareTo(new ");
                    sb.append(typeName);
                    sb.append("(\"");
                    sb.append(info.lowerBound);
                    sb.append("\")) == -1)");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(".compareTo(new ");
                    sb.append(typeName);
                    sb.append("(\"");
                    sb.append(info.upperBound);
                    sb.append("\")) == 1)");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                if (generateForLoop) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, " + parameterName + ".toString(), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, " + parameterName + ".toString(), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, " + parameterName + ".toString(), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("byte")) {
            minFacetSet = minFacetSet && Byte.parseByte(info.lowerBound) != -128;
            maxFacetSet = maxFacetSet && Byte.parseByte(info.upperBound) != 127;
            boolean bl2 = bothFacetSet = maxFacetSet && minFacetSet;
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, Byte.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, Byte.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, Byte.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("short")) {
            minFacetSet = minFacetSet && Short.parseShort(info.lowerBound) != Short.MIN_VALUE;
            maxFacetSet = maxFacetSet && Short.parseShort(info.upperBound) != Short.MAX_VALUE;
            boolean bl3 = bothFacetSet = maxFacetSet && minFacetSet;
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, Short.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, Short.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, Short.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("int")) {
            minFacetSet = minFacetSet && Integer.parseInt(info.lowerBound) != Integer.MIN_VALUE;
            maxFacetSet = maxFacetSet && Integer.parseInt(info.upperBound) != Integer.MAX_VALUE;
            boolean bl4 = bothFacetSet = maxFacetSet && minFacetSet;
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, Integer.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, Integer.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, Integer.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("long")) {
            minFacetSet = minFacetSet && Long.parseLong(info.lowerBound) != Long.MIN_VALUE;
            maxFacetSet = maxFacetSet && Long.parseLong(info.upperBound) != Long.MAX_VALUE;
            boolean bl5 = bothFacetSet = maxFacetSet && minFacetSet;
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append("L)");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append("L)");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, Long.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, Long.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, Long.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("float")) {
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append("F)");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append("F)");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, Float.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, Float.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, Float.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("double")) {
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append("D)");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append("D)");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, Double.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, Double.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, Double.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("char")) {
            if (minFacetSet || maxFacetSet) {
                sb.append(indent);
                sb.append("if (");
                if (bothFacetSet) {
                    sb.append("(");
                }
                if (minFacetSet) {
                    sb.append(parameterName);
                    sb.append(" < ");
                    sb.append(info.lowerBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(" || (");
                }
                if (maxFacetSet) {
                    sb.append(parameterName);
                    sb.append(" > ");
                    sb.append(info.upperBound);
                    sb.append(")");
                }
                if (bothFacetSet) {
                    sb.append(")");
                }
                sb.append("\n");
                sb.append(indent);
                if (bothFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0127E, String.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\", \"" + info.upperBound + "\"));\n");
                } else if (minFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0128E, String.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.lowerBound + "\"));\n");
                } else if (maxFacetSet) {
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0129E, String.toString(" + parameterName + "), \"" + valueName + "\", \"" + info.upperBound + "\"));\n");
                }
            }
        } else if (typeName.equals("byte[]")) {
            if (maxLengthFacetSet || minLengthFacetSet) {
                if (!nullCheckAdded) {
                    nullCheckAdded = true;
                    outputBuffer.append(indent);
                    outputBuffer.append("if (" + propertyVariableName + " != null) {\n");
                    indent = String.valueOf(indent) + "\t";
                }
                String maxLengthString = null;
                String minLengthString = null;
                if (maxLengthFacetSet) {
                    maxLengthString = info.maxLength;
                }
                if (minLengthFacetSet) {
                    minLengthString = info.minLength;
                }
                if (generateForLoop && bothLengthFacetSet) {
                    sb.append(originalIndent);
                    sb.append("\t{\n");
                }
                sb.append(indent);
                if (generateForLoop) {
                    sb.append("if ((");
                    sb.append(parameterName);
                    sb.append(" != null) && (");
                } else {
                    sb.append("if (");
                }
                if (minLengthFacetSet) {
                    sb.append(parameterName);
                    sb.append(".length < ");
                    sb.append(minLengthString);
                    sb.append(")");
                    if (generateForLoop) {
                        sb.append(")");
                    }
                    sb.append("\n");
                    sb.append(indent);
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0122E, \"" + parameterName + "\", \"" + minLengthString + "\"));\n");
                }
                if (maxLengthString != null) {
                    if (bothLengthFacetSet) {
                        sb.append(indent);
                        if (generateForLoop) {
                            sb.append("if ((");
                            sb.append(parameterName);
                            sb.append(" != null) && (");
                        } else {
                            sb.append("if (");
                        }
                    }
                    sb.append(parameterName);
                    sb.append(".length > ");
                    sb.append(maxLengthString);
                    sb.append(")");
                    if (generateForLoop) {
                        sb.append(")");
                    }
                    sb.append("\n");
                    sb.append(indent);
                    sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0123E, \"" + parameterName + "\", \"" + maxLengthString + "\"));\n");
                }
                if (generateForLoop && bothLengthFacetSet) {
                    sb.append(originalIndent);
                    sb.append("\t}\n");
                }
            }
        } else {
            typeName.equals("boolean");
        }
        return nullCheckAdded;
    }

    protected void generateComplexArrayGetCode(PropertyInfo info, String getterMethodName, String dataTypeName, String lowerCasePropertyName) {
        if (this.isCICSCharContainer_) {
            this.generateComplexArrayGetCodeForCharContainer(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        EList list = info.tdBase.getArrayDescr();
        if (list.size() > 1) {
            this.generateComplexArrayGetCodeForNDimensionalArray(info, getterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        ArrayTD arrayTD = (ArrayTD)list.get(0);
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)arrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)arrayTD.getUpperBound());
        boolean contentSizeFormula = CodeGenUtils.isFormula((String)info.tdBase.getContentSize());
        String baseOffsetString = null;
        String strideString = null;
        String upperBoundString = null;
        String contentSizeString = null;
        strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
        upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        contentSizeString = contentSizeFormula ? "evaluateFormula (\"" + info.tdBase.getContentSize() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getContentSize()));
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        int stride = this.evaluateFormula(arrayTD.getStride());
        boolean notPaddedAtEnd = contentSize % stride != 0;
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append("[] ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        sb.append("[upperBound];\n");
        if (!this.generatingSubrecord_) {
            sb.append(indent);
            sb.append("java.util.HashMap evaluatedMap = evaluateMap (valFieldNameMap_);\n");
        }
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("for (int i = 0; i < upperBound; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\tint offset = baseOffset + (stride*i);\n");
        sb.append(indent);
        sb.append("\tint bytesToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("(i != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride;\n");
        } else {
            sb.append("stride;\n");
        }
        sb.append(indent);
        sb.append("\tbyte[] subBuffer = new byte[stride];\n");
        sb.append(indent);
        sb.append("\tSystem.arraycopy (buffer_, offset, subBuffer, 0, bytesToCopy);\n");
        sb.append(indent);
        if (!this.generatingSubrecord_) {
            sb.append("\t" + dataTypeName + " subRecord = new " + dataTypeName + "(evaluatedMap);\n");
        } else {
            sb.append("\t" + dataTypeName + " subRecord = new " + dataTypeName + "(valFieldNameMap_);\n");
        }
        sb.append(indent);
        sb.append("\tsubRecord.setBytes (subBuffer);\n");
        sb.append(indent);
        sb.append("\t");
        sb.append(lowerCasePropertyName);
        sb.append("[i] = subRecord;\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(String.valueOf(getterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append("if ((index < 0) || (index > upperBound-1))\n");
        sb.append(indent);
        sb.append("\tthrow new ArrayIndexOutOfBoundsException(index);\n");
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int offset = baseOffset + (stride*index);\n");
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("\tint bytesToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("(index != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride;\n");
        } else {
            sb.append("stride;\n");
        }
        sb.append(indent);
        sb.append("byte[] subBuffer = new byte[stride];\n");
        sb.append(indent);
        sb.append("System.arraycopy (buffer_, offset, subBuffer, 0, bytesToCopy);\n");
        sb.append(indent);
        if (!this.generatingSubrecord_) {
            sb.append(String.valueOf(dataTypeName) + " " + lowerCasePropertyName + " = new " + dataTypeName + "(evaluateMap(valFieldNameMap_));\n");
        } else {
            sb.append(String.valueOf(dataTypeName) + " " + lowerCasePropertyName + " = new " + dataTypeName + "(valFieldNameMap_);\n");
        }
        sb.append(indent);
        sb.append(lowerCasePropertyName);
        sb.append(".setBytes (subBuffer);\n");
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(getterMethodName, sb.toString());
    }

    protected void generateComplexArrayGetCodeForNDimensionalArray(PropertyInfo info, String getterMethodName, String dataTypeName, String lowerCasePropertyName) {
        int i;
        EList list = info.tdBase.getArrayDescr();
        ArrayTD baseArrayTD = (ArrayTD)list.get(0);
        int numDimensions = list.size();
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)baseArrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)baseArrayTD.getUpperBound());
        boolean contentSizeFormula = CodeGenUtils.isFormula((String)info.tdBase.getContentSize());
        String baseOffsetString = null;
        String contentSizeString = null;
        ArrayList<String> strides = new ArrayList<String>(numDimensions);
        ArrayList<String> upperBounds = new ArrayList<String>(numDimensions);
        for (ArrayTD arrayTD : list) {
            String strideString = null;
            strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
            strides.add(strideString);
            String upperBoundString = null;
            upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
            upperBounds.add(upperBoundString);
        }
        contentSizeString = contentSizeFormula ? "evaluateFormula (\"" + info.tdBase.getContentSize() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getContentSize()));
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        int stride = this.evaluateFormula(baseArrayTD.getStride());
        boolean notPaddedAtEnd = contentSize % stride != 0;
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = ");
        sb.append(baseOffsetString);
        sb.append(";\n");
        int i2 = 0;
        while (i2 < numDimensions) {
            sb.append(indent);
            sb.append("int stride");
            sb.append(i2 + 1);
            sb.append(" = ");
            sb.append((String)strides.get(i2));
            sb.append(";\n");
            sb.append(indent);
            sb.append("int upperBound");
            sb.append(i2 + 1);
            sb.append(" = ");
            sb.append((String)upperBounds.get(i2));
            sb.append(";\n");
            ++i2;
        }
        sb.append(indent);
        sb.append(dataTypeName);
        i2 = 0;
        while (i2 < numDimensions) {
            sb.append("[]");
            ++i2;
        }
        sb.append(" ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        i2 = 0;
        while (i2 < numDimensions) {
            sb.append("[upperBound");
            sb.append(i2 + 1);
            sb.append("]");
            ++i2;
        }
        sb.append(";\n");
        if (!this.generatingSubrecord_) {
            sb.append(indent);
            sb.append("java.util.HashMap evaluatedMap = evaluateMap (valFieldNameMap_);\n");
        }
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        String originalIndent = indent;
        int i3 = 0;
        while (i3 < numDimensions) {
            sb.append(indent);
            sb.append("for (int index");
            sb.append(i3 + 1);
            sb.append(" = 0; index");
            sb.append(i3 + 1);
            sb.append(" < upperBound");
            sb.append(i3 + 1);
            sb.append("; index");
            sb.append(i3 + 1);
            sb.append("++)\n");
            sb.append(indent);
            sb.append("{\n");
            if (i3 + 1 < numDimensions) {
                indent = String.valueOf(indent) + "\t";
            }
            ++i3;
        }
        sb.append(indent);
        sb.append("\tint offset = baseOffset");
        i3 = 0;
        while (i3 < numDimensions) {
            sb.append(" + (stride");
            sb.append(i3 + 1);
            sb.append(" * index");
            sb.append(i3 + 1);
            sb.append(")");
            ++i3;
        }
        sb.append(";\n");
        sb.append(indent);
        sb.append("\tint bytesToCopy = ");
        String strideVar = new StringBuffer("stride").append(numDimensions).toString();
        if (notPaddedAtEnd) {
            sb.append("(");
            i = 0;
            while (i < numDimensions) {
                sb.append("(index");
                sb.append(i + 1);
                sb.append(" != (upperBound");
                sb.append(i + 1);
                sb.append(" - 1))");
                if (i + 1 < numDimensions) {
                    sb.append(" || ");
                }
                ++i;
            }
            sb.append(") ? stride");
            sb.append(numDimensions);
            sb.append(" : contentSize - (stride1 * upperBound1) + stride");
            sb.append(numDimensions);
            sb.append(";\n");
        } else {
            sb.append(strideVar);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("\tbyte[] subBuffer = new byte[");
        sb.append(strideVar);
        sb.append("];\n");
        sb.append(indent);
        sb.append("\tSystem.arraycopy (buffer_, offset, subBuffer, 0, bytesToCopy);\n");
        sb.append(indent);
        if (!this.generatingSubrecord_) {
            sb.append("\t" + dataTypeName + " subRecord = new " + dataTypeName + "(evaluatedMap);\n");
        } else {
            sb.append("\t" + dataTypeName + " subRecord = new " + dataTypeName + "(valFieldNameMap_);\n");
        }
        sb.append(indent);
        sb.append("\tsubRecord.setBytes (subBuffer);\n");
        sb.append(indent);
        sb.append("\t");
        sb.append(lowerCasePropertyName);
        i = 0;
        while (i < numDimensions) {
            sb.append("[index");
            sb.append(i + 1);
            sb.append("]");
            ++i;
        }
        sb.append(" = subRecord;\n");
        StringBuffer indentBuf = new StringBuffer(indent);
        int i4 = 0;
        while (i4 < numDimensions) {
            indentBuf.deleteCharAt(indentBuf.length() - 1);
            sb.append(indentBuf);
            sb.append("}\n");
            ++i4;
        }
        sb.append(originalIndent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(String.valueOf(getterMethodName) + "[]", sb.toString());
    }

    protected void generateComplexArrayGetCodeForCharContainer(PropertyInfo info, String getterMethodName, String dataTypeName, String lowerCasePropertyName) {
        int stride;
        EList list = info.tdBase.getArrayDescr();
        ListIterator iterator = list.listIterator();
        ArrayTD arrayTD = (ArrayTD)iterator.next();
        String strideString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()) / this.charSize_);
        String upperBoundString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        String contentSizeString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getContentSize()) / this.charSize_);
        String baseOffsetString = Integer.toString((ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_)) / this.charSize_);
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        boolean notPaddedAtEnd = contentSize % (stride = this.evaluateFormula(arrayTD.getStride())) != 0;
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append(dataTypeName);
        sb.append("[] ");
        sb.append(lowerCasePropertyName);
        sb.append(" = new ");
        sb.append(dataTypeName);
        sb.append("[upperBound];\n");
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("for (int i = 0; i < upperBound; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\tint offset = baseOffset + (stride*i);\n");
        sb.append(indent);
        sb.append("\tint charsToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("(i != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride;\n");
        } else {
            sb.append("stride;\n");
        }
        sb.append(indent);
        sb.append("\tchar[] subBuffer = new char[stride];\n");
        sb.append(indent);
        sb.append("\tSystem.arraycopy (buffer_, offset, subBuffer, 0, charsToCopy);\n");
        sb.append(indent);
        sb.append("\t" + dataTypeName + " subRecord = new " + dataTypeName + "();\n");
        sb.append(indent);
        sb.append("\tsubRecord.setString (new String(subBuffer));\n");
        sb.append(indent);
        sb.append("\t");
        sb.append(lowerCasePropertyName);
        sb.append("[i] = subRecord;\n");
        sb.append(indent);
        sb.append("}\n");
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(String.valueOf(getterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        sb.append(indent);
        sb.append("if ((index < 0) || (index > upperBound-1))\n");
        sb.append(indent);
        sb.append("\tthrow new ArrayIndexOutOfBoundsException(index);\n");
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int offset = baseOffset + (stride*index);\n");
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("\tint charsToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("(index != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride;\n");
        } else {
            sb.append("stride;\n");
        }
        sb.append(indent);
        sb.append("char[] subBuffer = new char[stride];\n");
        sb.append(indent);
        sb.append("System.arraycopy (buffer_, offset, subBuffer, 0, charsToCopy);\n");
        sb.append(indent);
        sb.append(String.valueOf(dataTypeName) + " " + lowerCasePropertyName + " = new " + dataTypeName + "();\n");
        sb.append(indent);
        sb.append(lowerCasePropertyName);
        sb.append(".setString (new String(subBuffer));\n");
        sb.append(indent);
        sb.append("return (");
        sb.append(lowerCasePropertyName);
        sb.append(");\n");
        this.getterBodyMap_.put(getterMethodName, sb.toString());
    }

    protected void generateComplexArraySetCode(PropertyInfo info, String setterMethodName, String dataTypeName, String lowerCasePropertyName) {
        String indent;
        if (this.isCICSCharContainer_) {
            this.generateComplexArraySetCodeForCharContainer(info, setterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        EList list = info.tdBase.getArrayDescr();
        if (list.size() > 1) {
            this.generateComplexArraySetCodeForNDimensionalArray(info, setterMethodName, dataTypeName, lowerCasePropertyName);
            return;
        }
        ArrayTD arrayTD = (ArrayTD)list.get(0);
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)arrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)arrayTD.getUpperBound());
        boolean contentSizeFormula = CodeGenUtils.isFormula((String)info.tdBase.getContentSize());
        String baseOffsetString = null;
        String strideString = null;
        String upperBoundString = null;
        String contentSizeString = null;
        strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
        upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        contentSizeString = contentSizeFormula ? "evaluateFormula (\"" + info.tdBase.getContentSize() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getContentSize()));
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        int stride = this.evaluateFormula(arrayTD.getStride());
        boolean notPaddedAtEnd = contentSize % stride != 0;
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        StringBuffer validationBuffer = new StringBuffer();
        boolean nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, false, null, "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int numElems = Math.min (");
        sb.append(lowerCasePropertyName);
        sb.append(".length, upperBound);\n");
        sb.append(indent);
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append("for (int i = 0; i < numElems; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\tif (");
        sb.append(lowerCasePropertyName);
        sb.append("[i] == null)\n");
        sb.append(indent);
        sb.append("\t\tcontinue;\n");
        sb.append(indent);
        sb.append("\tint offset = baseOffset + (stride*i);\n");
        sb.append(indent);
        sb.append("\tbyte[] subBuffer = ");
        sb.append(lowerCasePropertyName);
        sb.append("[i].getBytes();\n");
        sb.append(indent);
        sb.append("\tint bytesToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("Math.min (subBuffer.length, (i != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride);\n");
        } else {
            sb.append("subBuffer.length;\n");
        }
        sb.append(indent);
        sb.append("\tSystem.arraycopy (subBuffer, 0, buffer_, offset, bytesToCopy);\n");
        sb.append(indent);
        sb.append("}\n");
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(String.valueOf(setterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        indent = originalIndent;
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        validationBuffer = new StringBuffer();
        nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, false, "index", "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int offset = baseOffset + (stride*index);\n");
        sb.append(indent);
        sb.append("\tbyte[] subBuffer = ");
        sb.append(lowerCasePropertyName);
        sb.append(".getBytes();\n");
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("\tint bytesToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("Math.min (subBuffer.length, (index != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride);\n");
        } else {
            sb.append("subBuffer.length;\n");
        }
        sb.append(indent);
        sb.append("System.arraycopy (subBuffer, 0, buffer_, offset, bytesToCopy);\n");
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(setterMethodName, sb.toString());
    }

    protected void generateComplexArraySetCodeForNDimensionalArray(PropertyInfo info, String setterMethodName, String dataTypeName, String lowerCasePropertyName) {
        EList list = info.tdBase.getArrayDescr();
        ArrayTD baseArrayTD = (ArrayTD)list.get(0);
        int numDimensions = list.size();
        boolean offsetFormula = CodeGenUtils.isFormula((String)info.tdBase.getOffset());
        boolean recordBaseOffsetFormula = CodeGenUtils.isFormula((String)this.recordBaseOffset_);
        boolean strideFormula = CodeGenUtils.isFormula((String)baseArrayTD.getStride());
        boolean upperBoundFormula = CodeGenUtils.isFormula((String)baseArrayTD.getUpperBound());
        boolean contentSizeFormula = CodeGenUtils.isFormula((String)info.tdBase.getContentSize());
        String baseOffsetString = null;
        String contentSizeString = null;
        ArrayList<String> strides = new ArrayList<String>(numDimensions);
        ArrayList<String> upperBounds = new ArrayList<String>(numDimensions);
        for (ArrayTD arrayTD : list) {
            String strideString = null;
            strideString = strideFormula ? "evaluateFormula (\"" + arrayTD.getStride() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()));
            strides.add(strideString);
            String upperBoundString = null;
            upperBoundString = upperBoundFormula ? "evaluateFormula (\"" + arrayTD.getUpperBound() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
            upperBounds.add(upperBoundString);
        }
        contentSizeString = contentSizeFormula ? "evaluateFormula (\"" + info.tdBase.getContentSize() + "\", valFieldNameMap_)" : Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getContentSize()));
        if (offsetFormula || recordBaseOffsetFormula) {
            baseOffsetString = offsetFormula ? "evaluateFormula (\"" + info.tdBase.getOffset() + "\", valFieldNameMap_)\n" : info.tdBase.getOffset();
            if (recordBaseOffsetFormula) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - evaluateFormula (\"" + this.recordBaseOffset_ + "\", valFieldNameMap_)";
            } else if (Integer.parseInt(this.recordBaseOffset_) != 0) {
                baseOffsetString = String.valueOf(baseOffsetString) + " - " + this.recordBaseOffset_;
            }
        } else {
            baseOffsetString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_));
        }
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        int stride = this.evaluateFormula(baseArrayTD.getStride());
        boolean notPaddedAtEnd = contentSize % stride != 0;
        StringBuffer sb = new StringBuffer();
        String indent = "\t\t";
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        int i = 0;
        while (i < numDimensions) {
            sb.append(indent);
            sb.append("int stride");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append((String)strides.get(i));
            sb.append(";\n");
            sb.append(indent);
            sb.append("int upperBound");
            sb.append(i + 1);
            sb.append(" = ");
            sb.append((String)upperBounds.get(i));
            sb.append(";\n");
            ++i;
        }
        sb.append(indent);
        sb.append("if (");
        sb.append(lowerCasePropertyName);
        sb.append(" == null)\n");
        sb.append(indent);
        sb.append("\t");
        sb.append("return;\n\n");
        String propertyVariableName = lowerCasePropertyName;
        int i2 = 0;
        while (i2 < numDimensions) {
            sb.append(indent);
            ArrayTD arrayTD = (ArrayTD)list.get(i2);
            boolean isSetMaxOccurs = arrayTD.isSetUpperBound();
            boolean isSetMinOccurs = arrayTD.isSetLowerBound();
            if (isSetMinOccurs) {
                sb.append(indent);
                sb.append("if (");
                sb.append(propertyVariableName);
                sb.append(".length < ");
                sb.append(arrayTD.getLowerBound());
                sb.append(")\n");
                sb.append(indent);
                sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0122E, \"");
                sb.append(propertyVariableName);
                sb.append("\", \"");
                sb.append(arrayTD.getLowerBound());
                sb.append("\"));\n");
            }
            if (isSetMaxOccurs) {
                String upperBoundName = new StringBuffer("upperBound").append(i2 + 1).toString();
                sb.append(indent);
                sb.append("if (");
                sb.append(propertyVariableName);
                sb.append(".length > ");
                sb.append(upperBoundName);
                sb.append(")\n");
                sb.append(indent);
                sb.append("\tthrow new IllegalArgumentException(MarshallResource.instance().getString(MarshallResource.IWAA0123E, \"");
                sb.append(propertyVariableName);
                sb.append("\", Integer.toString(");
                sb.append(upperBoundName);
                sb.append(")));\n");
            }
            sb.append(indent);
            sb.append("int numElems");
            sb.append(i2 + 1);
            sb.append(" = Math.min (");
            sb.append(propertyVariableName);
            sb.append(".length, upperBound");
            sb.append(i2 + 1);
            sb.append(");\n");
            sb.append(indent);
            sb.append("for (int index");
            sb.append(i2 + 1);
            sb.append(" = 0; index");
            sb.append(i2 + 1);
            sb.append(" < numElems");
            sb.append(i2 + 1);
            sb.append("; index");
            sb.append(i2 + 1);
            sb.append("++)\n");
            sb.append(indent);
            sb.append("{\n");
            indent = String.valueOf(indent) + "\t";
            propertyVariableName = new StringBuffer(propertyVariableName).append("[index").append(i2 + 1).append("]").toString();
            ++i2;
        }
        sb.append(indent);
        sb.append("if (");
        sb.append(propertyVariableName);
        sb.append(" == null)\n");
        sb.append(indent);
        sb.append("\tcontinue;\n");
        sb.append(indent);
        sb.append("\tint offset = baseOffset");
        i2 = 0;
        while (i2 < numDimensions) {
            sb.append(" + (stride");
            sb.append(i2 + 1);
            sb.append(" * index");
            sb.append(i2 + 1);
            sb.append(")");
            ++i2;
        }
        sb.append(";\n");
        sb.append(indent);
        sb.append("\tint bytesToCopy = ");
        String strideVar = new StringBuffer("stride").append(numDimensions).toString();
        if (notPaddedAtEnd) {
            sb.append("(");
            int i3 = 0;
            while (i3 < numDimensions) {
                sb.append("(index");
                sb.append(i3 + 1);
                sb.append(" != (upperBound");
                sb.append(i3 + 1);
                sb.append(" - 1))");
                if (i3 + 1 < numDimensions) {
                    sb.append(" || ");
                }
                ++i3;
            }
            sb.append(") ? stride");
            sb.append(numDimensions);
            sb.append(" : contentSize - (stride1 * upperBound1) + stride");
            sb.append(numDimensions);
            sb.append(";\n");
        } else {
            sb.append(strideVar);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("\tbyte[] subBuffer = ");
        sb.append(propertyVariableName);
        sb.append(".getBytes();\n");
        sb.append(indent);
        sb.append("\tSystem.arraycopy (subBuffer, 0, buffer_, offset, bytesToCopy);\n");
        sb.append(indent);
        StringBuffer indentBuf = new StringBuffer(indent);
        int i4 = 0;
        while (i4 < numDimensions) {
            indentBuf.deleteCharAt(indentBuf.length() - 1);
            sb.append(indentBuf);
            sb.append("}\n");
            ++i4;
        }
        this.setterBodyMap_.put(String.valueOf(setterMethodName) + "[]", sb.toString());
    }

    protected void generateComplexArraySetCodeForCharContainer(PropertyInfo info, String setterMethodName, String dataTypeName, String lowerCasePropertyName) {
        String indent;
        int stride;
        EList list = info.tdBase.getArrayDescr();
        ListIterator iterator = list.listIterator();
        ArrayTD arrayTD = (ArrayTD)iterator.next();
        String strideString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getStride()) / this.charSize_);
        String upperBoundString = Integer.toString(ConversionUtils.evaluateFormula((String)arrayTD.getUpperBound()));
        String contentSizeString = Integer.toString(ConversionUtils.evaluateFormula((String)info.tdBase.getContentSize()) / this.charSize_);
        String baseOffsetString = Integer.toString((ConversionUtils.evaluateFormula((String)info.tdBase.getOffset()) - Integer.parseInt(this.recordBaseOffset_)) / this.charSize_);
        int contentSize = this.evaluateFormula(info.tdBase.getContentSize());
        boolean notPaddedAtEnd = contentSize % (stride = this.evaluateFormula(arrayTD.getStride())) != 0;
        StringBuffer sb = new StringBuffer();
        String originalIndent = indent = "\t\t";
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        StringBuffer validationBuffer = new StringBuffer();
        boolean nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, false, null, "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int numElems = Math.min (");
        sb.append(lowerCasePropertyName);
        sb.append(".length, upperBound);\n");
        sb.append(indent);
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append("for (int i = 0; i < numElems; i++)\n");
        sb.append(indent);
        sb.append("{\n");
        sb.append(indent);
        sb.append("\tif (");
        sb.append(lowerCasePropertyName);
        sb.append("[i] == null)\n");
        sb.append(indent);
        sb.append("\t\tcontinue;\n");
        sb.append(indent);
        sb.append("\tint offset = baseOffset + (stride*i);\n");
        sb.append(indent);
        sb.append("\tchar[] subBuffer = ");
        sb.append(lowerCasePropertyName);
        sb.append("[i].getString().toCharArray();\n");
        sb.append(indent);
        sb.append("\tint charsToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("Math.min (subBuffer.length, (i != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride);\n");
        } else {
            sb.append("Math.min (subBuffer.length, stride);\n");
        }
        sb.append(indent);
        sb.append("\tSystem.arraycopy (subBuffer, 0, buffer_, offset, charsToCopy);\n");
        sb.append(indent);
        sb.append("}\n");
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(String.valueOf(setterMethodName) + "[]", sb.toString());
        sb = new StringBuffer();
        indent = originalIndent;
        sb.append(indent);
        sb.append("int upperBound = " + upperBoundString + ";\n");
        validationBuffer = new StringBuffer();
        nullCheckAdded = this.generateValidationCode(lowerCasePropertyName, dataTypeName, false, "index", "upperBound", info, indent, validationBuffer);
        sb.append(validationBuffer.toString());
        if (nullCheckAdded) {
            indent = String.valueOf(indent) + "\t";
        }
        sb.append(indent);
        sb.append("int baseOffset = " + baseOffsetString + ";\n");
        sb.append(indent);
        sb.append("int stride = " + strideString + ";\n");
        sb.append(indent);
        sb.append("int offset = baseOffset + (stride*index);\n");
        sb.append(indent);
        sb.append("\tchar[] subBuffer = ");
        sb.append(lowerCasePropertyName);
        sb.append(".getString().toCharArray();\n");
        if (notPaddedAtEnd) {
            sb.append(indent);
            sb.append("int contentSize = ");
            sb.append(contentSizeString);
            sb.append(";\n");
        }
        sb.append(indent);
        sb.append("\tint charsToCopy = ");
        if (notPaddedAtEnd) {
            sb.append("Math.min (subBuffer.length, (index != (upperBound - 1)) ? stride : contentSize - (stride * upperBound) + stride);\n");
        } else {
            sb.append("Math.min (subBuffer.length, stride);\n");
        }
        sb.append(indent);
        sb.append("System.arraycopy (subBuffer, 0, buffer_, offset, charsToCopy);\n");
        if (nullCheckAdded) {
            sb.append(originalIndent);
            sb.append("}\n");
        }
        this.setterBodyMap_.put(setterMethodName, sb.toString());
    }

    protected String getValueTypeWrapperString(String valueType, String value) {
        String startType = value;
        if (valueType.equals("String")) {
            value = value.replaceAll("\"", "\\\\\"");
            startType = "\"" + value + "\"";
        } else {
            startType = valueType.equals("BigDecimal") || valueType.equals("BigInteger") ? "(new " + valueType + "(\"" + value + "\"))" : (valueType.equals("short") ? "(" + valueType + ")" + value : (valueType.equals("long") ? String.valueOf(value) + "L" : (valueType.equals("float") ? String.valueOf(value) + "F" : (valueType.equals("double") ? String.valueOf(value) + "D" : value))));
        }
        return startType;
    }

    protected void generateLevel88Code(List<Level88> level88List) {
        for (Level88 level88 : level88List) {
            String dataType = level88.dataType;
            String level88Name = level88.level88Name;
            String level88Value = level88.level88Value;
            String valueType = "String";
            String rangeName = "String";
            String objectType = this.builtInJavaTypeToJavaClassMap_.get(dataType);
            if (this.isPrimitiveObjectClass(dataType)) {
                valueType = dataType;
                rangeName = dataType;
            } else if (objectType != null) {
                valueType = dataType;
                rangeName = objectType;
            }
            if (valueType.startsWith("java.lang.")) {
                valueType = valueType.substring(valueType.lastIndexOf(".") + 1);
            }
            if (rangeName.startsWith("java.lang.")) {
                rangeName = rangeName.substring(rangeName.lastIndexOf(".") + 1);
            }
            String unicodeSpaceStr = "\\u0020";
            boolean hasUnicodeSpace = false;
            if (level88Value.indexOf(unicodeSpaceStr) != -1) {
                hasUnicodeSpace = true;
            }
            ArrayList<String> level88Items = new ArrayList<String>();
            StringTokenizer valueTokenizer = new StringTokenizer(level88Value, ",");
            while (valueTokenizer.hasMoreTokens()) {
                String item = valueTokenizer.nextToken();
                if (hasUnicodeSpace) {
                    item = item.trim();
                    StringBuffer sb = new StringBuffer();
                    int index = item.indexOf(unicodeSpaceStr);
                    while (index != -1) {
                        String head = item.substring(0, index);
                        sb.append(head);
                        sb.append(" ");
                        item = item.substring(index + 6);
                        index = item.indexOf(unicodeSpaceStr);
                    }
                    sb.append(item);
                    item = sb.toString();
                }
                level88Items.add(item);
            }
            if (level88Items.size() > 1) {
                int j = 1;
                while (j < level88Items.size()) {
                    String value = (String)level88Items.get(j);
                    int char32 = UTF16.charAt((String)value, (int)0);
                    if (UCharacter.isWhitespace((int)char32) && value.length() > 1) {
                        value = value.substring(UTF16.getCharCount((int)char32));
                        level88Items.set(j, value);
                    }
                    ++j;
                }
            }
            String upperCaseName = CodegenUtil.getUppercaseName(level88Name);
            String lowerCaseName = CodegenUtil.getParameterName(level88Name);
            String getterMethodName = "get" + upperCaseName;
            String isMethodName = "is" + upperCaseName;
            String indent = "\t\t";
            StringBuffer getterBody = new StringBuffer("return (");
            StringBuffer testerBody = new StringBuffer("return (");
            int j = 0;
            while (j < level88Items.size()) {
                boolean isRangeItem;
                String thruStr;
                String startType = null;
                String endType = null;
                String item = (String)level88Items.get(j);
                int index = item.indexOf(thruStr = " THRU ");
                boolean bl = isRangeItem = index != -1;
                if (isRangeItem) {
                    String startStr = item.substring(0, index);
                    String endStr = item.substring(index + thruStr.length());
                    startType = this.getValueTypeWrapperString(valueType, startStr);
                    endType = this.getValueTypeWrapperString(valueType, endStr);
                } else {
                    startType = this.getValueTypeWrapperString(valueType, item);
                }
                if (j == 0) {
                    getterBody.append(startType);
                    getterBody.append(");\n");
                } else {
                    testerBody.append(" ||\n" + indent + "\t\t\t\t");
                }
                if (isRangeItem) {
                    testerBody.append("com.ibm.etools.marshall.util." + rangeName + "Range.isInRange(" + startType + ", " + endType + ", " + lowerCaseName + ")");
                } else if (valueType.equals("String")) {
                    testerBody.append(startType + ".equals(" + lowerCaseName + ")");
                } else if (valueType.equals("BigDecimal") || valueType.equals("BigInteger")) {
                    testerBody.append(String.valueOf(lowerCaseName) + ".compareTo" + startType + " == 0");
                } else {
                    testerBody.append(String.valueOf(lowerCaseName) + " == " + startType);
                }
                ++j;
            }
            testerBody.append(");\n");
            this.getterBodyMap_.put(getterMethodName, getterBody.toString());
            this.isBodyMap_.put(isMethodName, testerBody.toString());
        }
    }

    public String getRecordName() {
        return this.recordName_;
    }

    public String getRecordNameMethodBody() {
        if (this.recordName_ == null) {
            return "\treturn (this.getClass().getName());\n";
        }
        StringBuffer sb = new StringBuffer("\treturn (\"");
        sb.append(this.recordName_);
        sb.append("\");\n");
        return sb.toString();
    }

    public boolean isCICSChannel() {
        return this.isCICSChannel_;
    }

    public boolean isCICSCharContainer() {
        return this.isCICSCharContainer_;
    }
}

