/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsdt.dojo.ui.wizards;

import com.ibm.jsdt.dojo.ui.wizards.NewTypeWizardPage;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public class SuperInterfaceSelectionDialog
extends OpenTypeSelectionDialog {
    private static final int ADD_ID = 1025;
    private NewTypeWizardPage fTypeWizardPage;
    private List fOldContent;

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, NewTypeWizardPage page, IJavaScriptProject p) {
        super(parent, true, context, SuperInterfaceSelectionDialog.createSearchScope(p), 5);
        this.fTypeWizardPage = page;
        this.fOldContent = this.fTypeWizardPage.getSuperInterfaces();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "&Add", true);
        super.createButtonsForButtonBar(parent);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaScriptPlugin.getDefault().getDialogSettingsSection("DialogBounds_SuperInterfaceSelectionDialog");
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        Button addButton = this.getButton(1025);
        if (addButton != null && !addButton.isDisposed()) {
            addButton.setEnabled(!status.matches(4));
        }
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
    }

    protected void cancelPressed() {
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterfaces();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.addSelectedInterfaces();
        super.okPressed();
    }

    private void addSelectedInterfaces() {
        StructuredSelection selection = this.getSelectedItems();
        if (selection == null) {
            return;
        }
        for (Object obj : selection) {
            if (!(obj instanceof TypeNameMatch)) continue;
            this.accessedHistoryItem(obj);
            TypeNameMatch type = (TypeNameMatch)obj;
            String qualifiedName = JavaModelUtil.getFullyQualifiedName((IType)type.getType());
            String message = this.fTypeWizardPage.addSuperInterface(qualifiedName) ? Messages.format((String)"\"{0}\" added.", (Object)qualifiedName) : Messages.format((String)"\"{0}\" already in list.", (Object)qualifiedName);
            this.updateStatus((IStatus)new StatusInfo(1, message));
        }
    }

    private static IJavaScriptSearchScope createSearchScope(IJavaScriptProject p) {
        return SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptProject[]{p});
    }

    protected void handleDoubleClick() {
        this.buttonPressed(1025);
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        if (selection.size() == 0 && this.fTypeWizardPage.getSuperInterfaces().size() > this.fOldContent.size()) {
            this.updateStatus((IStatus)new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null));
            this.getButton(1025).setEnabled(false);
        } else {
            this.getButton(1025).setEnabled(this.getButton(0).isEnabled());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.wst.jsdt.ui.super_interface_selection_dialog_context");
    }
}

