/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsdt.dojo.refactor;

import com.ibm.jsdt.dojo.refactor.PullUpDojoMethodDialog;
import com.ibm.jsdt.dojo.refactor.SelectionDispatchAction;
import com.ibm.jsdt.dojo.refactor.Util;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class PullUpDojoAction
extends SelectionDispatchAction
implements IEditorActionDelegate,
IViewActionDelegate {
    protected ISelection selection;
    protected static final String DOJO_DECLARE = "dojo.declare";
    private static final String DIALOG_TITLE = "Pull Up Methods";
    private ISelection fSelection;
    private IViewPart fView;
    private CompilationUnitEditor fEditor;

    public PullUpDojoAction() {
        super(null);
    }

    public PullUpDojoAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public PullUpDojoAction(IWorkbenchSite site) {
        super(site);
        this.setText("Pull Up Functions");
        this.setDescription("Move functions from the type to it's super type");
        this.setToolTipText("Pull Up functions");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_unimplemented_methods_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getJavaScriptUnit() != null && !type.isInterface();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof IJavaScriptUnit;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn((JavaEditor)this.fEditor);
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaScriptModelException {
        IType type;
        Object[] elements = selection.toArray();
        if (elements == null) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getJavaScriptUnit() != null && !type2.isInterface()) {
                return type2;
            }
        } else if (elements[0] instanceof IJavaScriptUnit && (type = ((IJavaScriptUnit)elements[0]).findPrimaryType()) != null && !type.isInterface()) {
            return type;
        }
        return null;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IType type = null;
        try {
            type = this.getSelectedType(selection);
        }
        catch (Exception exception) {}
        if (type == null) {
            try {
                type = SelectionConverter.getTypeAtOffset((JavaEditor)this.fEditor);
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        try {
            if (type == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            if (!ElementValidator.check((IJavaScriptElement)type, (Shell)this.getShell(), (String)this.getDialogTitle(), (boolean)false) || !ActionUtil.isEditable((Shell)this.getShell(), (IJavaScriptElement)type)) {
                this.notifyResult(false);
                return;
            }
            this.run(this.getShell(), type);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle((CoreException)exception, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IType type = SelectionConverter.getTypeAtOffset((JavaEditor)this.fEditor);
            if (type != null) {
                if (!ElementValidator.check((IJavaScriptElement)type, (Shell)this.getShell(), (String)this.getDialogTitle(), (boolean)false) || !ActionUtil.isEditable((JavaEditor)this.fEditor, (Shell)this.getShell(), (IJavaScriptElement)type)) {
                    this.notifyResult(false);
                    return;
                }
                if (type.isAnnotation()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_annotation_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_interface_not_applicable);
                    this.notifyResult(false);
                    return;
                }
                this.run(this.getShell(), type);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_not_applicable);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), (Shell)this.getShell(), (String)this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_actionfailed);
        }
    }

    private void run(Shell shell, IType type) throws CoreException {
        PullUpDojoMethodDialog dialog = new PullUpDojoMethodDialog(shell, this.fEditor, type, false);
        if (!dialog.hasMethodsToOverride()) {
            MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.OverrideMethodsAction_error_nothing_found);
            this.notifyResult(false);
            return;
        }
        if (dialog.open() != 0) {
            this.notifyResult(false);
            return;
        }
        Object[] selected = dialog.getResult();
        if (selected == null) {
            this.notifyResult(false);
            return;
        }
        Hashtable<IJavaScriptUnit, Object[]> edits = new Hashtable<IJavaScriptUnit, Object[]>();
        ArrayList<Object> methods = new ArrayList<Object>();
        String methodText = new String();
        boolean needsComma = dialog.needsComma;
        if (dialog.overRideNull()) {
            methodText = "{";
        }
        int i = 0;
        while (i < selected.length) {
            Object elem = selected[i];
            if (elem instanceof IFunction) {
                IFunction method = (IFunction)elem;
                methods.add(elem);
                String methodSource = method.getSource();
                methodText = String.valueOf(methodText) + (needsComma ? ",\n\t" : "\n\t") + method.getElementName() + " : " + methodSource;
                needsComma = true;
            }
            ++i;
        }
        if (dialog.overRideNull()) {
            methodText = String.valueOf(methodText) + "}";
        }
        IFunction[] methodToOverride = methods.toArray(new IFunction[methods.size()]);
        IEditorPart editor = null;
        IRewriteTarget target = null;
        editor = JavaScriptUI.openInEditor((IJavaScriptElement)type.getJavaScriptUnit());
        IRewriteTarget iRewriteTarget = target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
        if (target != null) {
            target.beginCompoundChange();
        }
        Object[] tempObjectArray = new Object[2];
        tempObjectArray[0] = target;
        MultiTextEdit multiEdit = new MultiTextEdit();
        int insertPos = dialog.getInsertOffset();
        if (dialog.overRideNull()) {
            multiEdit.addChild((TextEdit)new ReplaceEdit(insertPos, 4, methodText));
        } else {
            multiEdit.addChild((TextEdit)new InsertEdit(insertPos, methodText));
        }
        tempObjectArray[1] = multiEdit;
        edits.put(type.getJavaScriptUnit(), tempObjectArray);
        int i2 = 0;
        while (i2 < methodToOverride.length) {
            IFunction method = methodToOverride[i2];
            tempObjectArray = (Object[])edits.get(type.getJavaScriptUnit());
            if (tempObjectArray != null) {
                multiEdit = (MultiTextEdit)tempObjectArray[1];
                target = (IRewriteTarget)tempObjectArray[0];
            } else {
                editor = JavaScriptUI.openInEditor((IJavaScriptElement)type.getJavaScriptUnit(), (boolean)false, (boolean)false);
                target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
                target.beginCompoundChange();
                tempObjectArray = new Object[]{target, new MultiTextEdit()};
                multiEdit = tempObjectArray[1];
                edits.put(type.getJavaScriptUnit(), tempObjectArray);
            }
            ISourceRange nameRange = method.getNameRange();
            insertPos = method.getSourceRange().getOffset();
            int methodEndOffset = insertPos + method.getSourceRange().getLength();
            IType declaringType = method.getDeclaringType();
            int declaringTypeOffset = declaringType.getSourceRange().getOffset();
            if (nameRange != null && nameRange.getOffset() < insertPos) {
                insertPos = nameRange.getOffset();
            }
            String documentText = target.getDocument().get();
            int q = insertPos;
            while (q > 0 && q > declaringTypeOffset) {
                if (documentText.charAt(q) == ',') {
                    insertPos = q;
                    break;
                }
                --q;
            }
            multiEdit.addChild((TextEdit)new DeleteEdit(insertPos, methodEndOffset - insertPos));
            ++i2;
        }
        Enumeration elements = edits.elements();
        while (elements.hasMoreElements()) {
            tempObjectArray = (Object[])elements.nextElement();
            target = (IRewriteTarget)tempObjectArray[0];
            multiEdit = (MultiTextEdit)tempObjectArray[1];
            try {
                multiEdit.apply(target.getDocument());
            }
            catch (MalformedTreeException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            target.endCompoundChange();
        }
        this.notifyResult(true);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaScriptModelException exception) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaScriptPlugin.log((Throwable)exception);
            }
            this.setEnabled(false);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor == null) {
            return;
        }
        this.fEditor = (CompilationUnitEditor)targetEditor;
        super.setSite((IWorkbenchSite)targetEditor.getSite());
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)this.fSelection);
        }
        if (this.fSelection instanceof ITextSelection) {
            this.run((ITextSelection)this.fSelection);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (this.fSelection instanceof TextSelection) {
            TextSelection textSelect = (TextSelection)this.fSelection;
            int offset = textSelect.getOffset();
            IJavaScriptUnit cu = null;
            if (this.fEditor != null) {
                cu = Util.getCompilationUnit((JavaEditor)this.fEditor);
            }
            IJavaScriptElement element = null;
            if (cu != null) {
                try {
                    element = cu.getElementAt(offset);
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            if (element != null && element instanceof SourceType) {
                SourceType type = (SourceType)element;
                String typeSource = null;
                try {
                    typeSource = type.getSource();
                    if (typeSource.indexOf(DOJO_DECLARE) < 0) {
                        action.setEnabled(false);
                    } else {
                        action.setEnabled(true);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
        }
    }

    public void init(IViewPart view) {
        this.fView = view;
        super.setSite((IWorkbenchSite)view.getSite());
    }
}

