/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.plugin;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.cic.licensing.common.LicenseCheck;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class J2CUIPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.ibm.j2c.ui";
    private static J2CUIPlugin Instance_;
    private ResourceBundle ResourceBundle_;
    private boolean dialogSettingsChecked_ = false;

    public J2CUIPlugin() {
        if (Instance_ == null) {
            Instance_ = this;
        }
    }

    public static J2CUIPlugin getInstance() {
        return Instance_;
    }

    public ResourceBundle getResourceBundle() {
        if (this.ResourceBundle_ == null) {
            this.ResourceBundle_ = Platform.getResourceBundle((Bundle)this.getBundle());
        }
        return this.ResourceBundle_;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LicenseCheck.requestLicense((Plugin)this, (String)ID, (String)"7.0.0");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        try {
            URL installURL = Instance_.getBundle().getEntry("/");
            URL imageURL = new URL(installURL, name);
            return ImageDescriptor.createFromURL((URL)imageURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettingsChecked_) {
            return super.getDialogSettings();
        }
        IDialogSettings settings = super.getDialogSettings();
        IDialogSettings[] sections = settings.getSections();
        boolean versionFound = false;
        int i = 0;
        while (i < sections.length) {
            int version;
            if ("version".equals(sections[i].getName()) && (version = sections[i].getInt("versionNumber")) == 7004) {
                versionFound = true;
                break;
            }
            ++i;
        }
        if (!versionFound) {
            IPath path = this.getStateLocation();
            File settingsFile = (path = path.append("dialog_settings.xml")).toFile();
            if (settingsFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(settingsFile));
                    StringBuffer sb = new StringBuffer();
                    String line = reader.readLine();
                    while (line != null) {
                        sb.append(line);
                        line = reader.readLine();
                    }
                    reader.close();
                    String content = sb.toString();
                    content = this.migrateDialogSettings(content);
                    FileWriter writer = new FileWriter(settingsFile);
                    writer.write(content);
                    writer.close();
                    this.loadDialogSettings();
                    settings = super.getDialogSettings();
                }
                catch (Exception exception) {}
            }
            IDialogSettings versionSection = settings.addNewSection("version");
            versionSection.put("versionNumber", 7004);
        }
        this.dialogSettingsChecked_ = true;
        return settings;
    }

    private String migrateDialogSettings(String content) {
        content = content.replaceAll("Managed connection property group", "MANAGED_CONNECTION_FACTORY_PG:MANAGED_CONNECTION_FACTORY_CLASS_PROPERTIES");
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        IResourceAdapterRegistry registry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
        try {
            IResourceAdapterDescriptor[] descriptors = registry.getAllResourceAdapters();
            int i = 0;
            while (i < descriptors.length) {
                String project = descriptors[i].getConnectorProject().getName();
                Connector con = descriptors[i].getConnector();
                StringBuffer oldBuffer = new StringBuffer(con.getDisplayName());
                oldBuffer.append(" \\(");
                oldBuffer.append(con.getVendorName());
                oldBuffer.append(" : ");
                oldBuffer.append(con.getVersion());
                oldBuffer.append("\\)");
                String oldKey = oldBuffer.toString();
                StringBuffer newBuffer = new StringBuffer(con.getDisplayName());
                newBuffer.append(" (");
                newBuffer.append(con.getVendorName());
                newBuffer.append(" : ");
                newBuffer.append(con.getVersion());
                newBuffer.append(")::");
                newBuffer.append(project);
                String newKey = newBuffer.toString();
                replacementMap.put(oldKey, newKey);
                ++i;
            }
        }
        catch (BaseException baseException) {}
        for (Map.Entry entry : replacementMap.entrySet()) {
            String oldKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            if (content.indexOf(newKey) != -1) continue;
            content = content.replaceAll(oldKey, newKey);
        }
        return content;
    }
}

