/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.wizards;

import com.ibm.adapter.j2c.edit.J2CJavaBeanEdit;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.model.J2CRAExtensionPointInfo;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.j2c.ui.internal.wizards.J2CDeploymentWizard;
import com.ibm.j2c.ui.internal.wizards.J2CDeploymentWizard_SelectFilePage;
import com.ibm.j2c.ui.internal.wizards.J2CWizard_BeanDeploymentPage;
import com.ibm.j2c.ui.internal.wizards.J2CWizard_BindingDetailsPage;
import com.ibm.j2c.ui.internal.wizards.NewOperationWizard;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class RASelectionPage
extends MessageBundleWizardDynamicPage
implements ISelectionChangedListener {
    protected TreeViewer listViewer_;
    protected RAInfoLabelProvider RALabelProvider_;
    protected RAInfoContentProvider RAContentProvider_;
    private MCF_RAR_Indentifier currentSelection = null;
    protected J2CJavaBeanEdit modelEdit = null;
    protected Vector multipleRars = null;
    protected IPropertyUIWidgetFactory factory = null;
    final IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();

    public RASelectionPage(String name) {
        super(name);
    }

    public RASelectionPage(String name, J2CUIMessageBundle newBundle) {
        super(name, (PropertyUIMessageBundle)newBundle);
    }

    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        this.factory = factory;
        this.setTitle(J2CUIMessages.J2C_UI_RASELECTION_PAGE_TITLE);
        this.setDescription(J2CUIMessages.J2C_UI_RASELECTION_PAGE_DESCRIPTION);
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_J2C_WIZARD_PAGE")));
        return this.displayPage(parent);
    }

    public Composite displayPage(Composite origParent) {
        ScrolledComposite parent = (ScrolledComposite)origParent;
        Composite mainComp = this.factory.createComposite((Composite)parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 6;
        mainComp.setLayout((Layout)layout);
        GridData data1 = new GridData(1808);
        data1.grabExcessHorizontalSpace = true;
        mainComp.setLayoutData((Object)data1);
        Tree tree = this.factory.createTree(mainComp, 4 | this.factory.getBorderStyle());
        this.listViewer_ = this.factory.createTreeViewer(tree);
        GridData data = new GridData(1808);
        this.listViewer_.getTree().setLayoutData((Object)data);
        this.listViewer_.addSelectionChangedListener((ISelectionChangedListener)this);
        this.RALabelProvider_ = new RAInfoLabelProvider();
        this.RAContentProvider_ = new RAInfoContentProvider();
        this.listViewer_.setLabelProvider((IBaseLabelProvider)this.RALabelProvider_);
        this.listViewer_.setContentProvider((IContentProvider)this.RAContentProvider_);
        Vector vec = null;
        if (this.getWizard() instanceof NewOperationWizard) {
            vec = ((NewOperationWizard)this.getWizard()).multipleRAsOnClassPath;
            ((NewOperationWizard)this.getWizard()).OperationPage_.setPageComplete(false);
        } else {
            vec = this.multipleRars;
        }
        if (vec != null) {
            this.listViewer_.setInput((Object)vec);
        }
        if (this.currentSelection != null) {
            this.listViewer_.setSelection((ISelection)new StructuredSelection((Object)this.currentSelection), true);
        }
        parent.setContent((Control)mainComp);
        Point p = mainComp.computeSize(-1, -1);
        mainComp.setSize(p.x, p.y);
        parent.setMinSize(p);
        parent.update();
        this.validatePage();
        return mainComp;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selected = ((StructuredSelection)this.listViewer_.getSelection()).getFirstElement();
        this.currentSelection = (MCF_RAR_Indentifier)selected;
        this.validatePage();
    }

    protected void validatePage() {
        if (this.currentSelection == null) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    public IWizardPage getNextPage() {
        IResourceAdapterDescriptor aresD = null;
        try {
            IResourceAdapterDescriptor[] ras;
            if (this.currentSelection != null && (ras = this.raRegistry.getResourceAdapters(this.currentSelection.getRarType(), this.currentSelection.getRarVersion(), this.currentSelection.getRarVendor())).length > 0) {
                aresD = ras[0];
                if (this.getWizard() instanceof NewOperationWizard) {
                    J2CJavaBeanEdit edit = ((NewOperationWizard)this.getWizard()).edit;
                    if (edit != null) {
                        edit.setResourceAdapter(aresD);
                        edit.setManagedConnectionFactoryName(this.currentSelection.getMcfClassName());
                        ((NewOperationWizard)this.getWizard()).UIInfo_.JavaInterface_ = edit.getOutboundServiceDescriptionModel();
                        ((NewOperationWizard)this.getWizard()).initWizard(((NewOperationWizard)this.getWizard()).UIInfo_.JavaInterface_);
                        J2CWizard_BindingDetailsPage page = (J2CWizard_BindingDetailsPage)super.getNextPage();
                        page.initPage(((NewOperationWizard)this.getWizard()).UIInfo_.JavaInterface_);
                        return page;
                    }
                } else if (this.getWizard() instanceof J2CDeploymentWizard && this.modelEdit != null) {
                    this.modelEdit.setResourceAdapter(aresD);
                    this.modelEdit.setManagedConnectionFactoryName(new String());
                    ((J2CDeploymentWizard)this.getWizard()).osd = this.modelEdit.getOutboundServiceDescriptionModel();
                    J2CWizard_BeanDeploymentPage selectionPage = (J2CWizard_BeanDeploymentPage)super.getNextPage();
                    J2CDeploymentWizard_SelectFilePage selP = (J2CDeploymentWizard_SelectFilePage)this.getWizard().getPreviousPage((IWizardPage)this);
                    selectionPage.genProj = selP.file.getProject();
                    selectionPage.displayPage();
                    return selectionPage;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public MCF_RAR_Indentifier getSelectedRAR() {
        return this.currentSelection;
    }

    protected class RAInfoContentProvider
    implements ITreeContentProvider {
        protected RAInfoContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            MCF_RAR_Indentifier[] res = new MCF_RAR_Indentifier[]{};
            if (parentElement instanceof Vector) {
                Vector vec = (Vector)parentElement;
                return vec.toArray(res);
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (this.getChildren(element) == null) {
                return false;
            }
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class RAInfoLabelProvider
    implements ILabelProvider {
        Hashtable allocatedImages_ = new Hashtable();

        protected RAInfoLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof MCF_RAR_Indentifier) {
                MCF_RAR_Indentifier mcfInfo = (MCF_RAR_Indentifier)element;
                J2CRAExtensionPointInfo info = J2CUIHelper.instance().getRAExtensionPointInfo(mcfInfo.getRarType(), mcfInfo.getRarVendor(), mcfInfo.getRarVersion());
                if (info != null) {
                    String iPath = ((MessageBundleWizardPage)RASelectionPage.this).messageBundle_.getMessage(info.getIconPath());
                    return this.getImage(iPath);
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof MCF_RAR_Indentifier) {
                MCF_RAR_Indentifier raIn = (MCF_RAR_Indentifier)element;
                return String.valueOf(raIn.getRarType()) + " (" + raIn.getRarVendor() + " : " + raIn.getRarVersion() + ")";
            }
            return null;
        }

        public Image getImage(String iconPath) {
            if (iconPath != null) {
                Image im = (Image)this.allocatedImages_.get(iconPath);
                if (im != null) {
                    return im;
                }
                im = ((MessageBundleWizardPage)RASelectionPage.this).messageBundle_.getImageDescriptor(iconPath).createImage();
                this.allocatedImages_.put(iconPath, im);
                return im;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            Enumeration ims = this.allocatedImages_.elements();
            while (ims.hasMoreElements()) {
                Image i = (Image)ims.nextElement();
                if (i.isDisposed()) continue;
                i.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

