/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.wizards;

import com.ibm.j2c.rar.operations.jmx.internal.ServerRAROperations;
import com.ibm.j2c.rar.operations.jmx.internal.utils.NewServerDetectionListener;
import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.J2CInfoPopHelper;
import com.ibm.j2c.ui.internal.wizards.J2CWizardPage;
import com.ibm.j2c.ui.internal.wizards.JNDIResourceLookupWizard;
import com.ibm.j2c.ui.internal.wizards.JNDIResourceLookupWizard_NameSelectionPage;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.wizard.NewServerWizard;

public class JNDIResourceLookupWizard_ServerSelectionPage
extends J2CWizardPage
implements Listener {
    private Combo serversC;
    private Button newServerButt;
    private Vector jndiNames;
    private boolean firstTouched = true;
    private int serverType = 60;

    public JNDIResourceLookupWizard_ServerSelectionPage(String name, J2CUIMessageBundle newBundle) {
        super(name, newBundle);
    }

    public Composite createContents(IPropertyUIWidgetFactory factory, Composite parent) {
        Composite composite = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 6;
        composite.setLayout((Layout)layout);
        GridData gd1 = new GridData(768);
        composite.setLayoutData((Object)gd1);
        factory.createLabel(composite, this.messageBundle_.getMessage("J2C_UI_WIZARDS_DEPLOY_TARGET_SERVER"), 64);
        this.serversC = factory.createNormalCombo(composite, factory.getBorderStyle() | 8);
        this.serversC.setToolTipText(this.messageBundle_.getMessage("J2C_UI_WIZARDS_DEPLOY_TIP_TARGET_SERVER"));
        this.serversC.setLayout((Layout)new GridLayout());
        gd1 = new GridData(768);
        gd1.horizontalSpan = 1;
        this.serversC.setLayoutData((Object)gd1);
        this.getAvailableServers(true);
        this.newServerButt = factory.createButton(composite, 0);
        gd1 = new GridData();
        gd1.horizontalSpan = 1;
        gd1.horizontalAlignment = 4;
        this.newServerButt.setLayoutData((Object)gd1);
        this.newServerButt.setText(this.messageBundle_.getMessage("J2C_UI_WIZARDS_BUTTON_NEW"));
        this.newServerButt.addListener(13, (Listener)this);
        this.serversC.select(0);
        String pageName = this.getName();
        if (parent != null) {
            J2CInfoPopHelper.instance().setInfoHelp(parent, pageName, "Composite", J2CInfoPopHelper.J2CUI_WIZARD_PACKAGE);
        }
        if (this.serversC != null) {
            J2CInfoPopHelper.instance().setInfoHelp(this.serversC, pageName, "serversC", J2CInfoPopHelper.J2CUI_WIZARD_PACKAGE);
        }
        if (this.newServerButt != null) {
            J2CInfoPopHelper.instance().setInfoHelp(this.newServerButt, pageName, "newServerButt", J2CInfoPopHelper.J2CUI_WIZARD_PACKAGE);
        }
        this.setPageComplete(this.validatePage());
        return composite;
    }

    public void handleEvent(Event event) {
        if (event.type == 13 && event.widget == this.newServerButt) {
            this.getAvailableServers(true);
            NewServerWizard serverWizard = new NewServerWizard();
            Shell shell = Display.getCurrent().getActiveShell();
            NewServerDetectionListener servDecLis = new NewServerDetectionListener();
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)servDecLis);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)serverWizard);
            wizardDialog.create();
            int resDial = wizardDialog.open();
            if (resDial == 0) {
                IServer serverN = servDecLis.getNewServer();
                this.getAvailableServers(true);
                if (serverN != null) {
                    this.serversC.setText(serverN.getName());
                } else {
                    this.serversC.select(0);
                }
                ServerCore.removeServerLifecycleListener((IServerLifecycleListener)servDecLis);
            } else {
                this.serversC.select(0);
            }
        }
        this.setPageComplete(this.validatePage());
    }

    public Hashtable getAvailableServers(boolean updateCombo) {
        if (updateCombo) {
            this.serversC.removeAll();
        }
        Hashtable<String, IServer> availableServers = new Hashtable<String, IServer>();
        String specStr = ((JNDIResourceLookupWizard)this.getWizard()).connector.getSpecVersion();
        IServer[] servers = ServerCore.getServers();
        int k = 0;
        while (k < servers.length) {
            IServer server = servers[k];
            int serverVersion = DeploymentHelper.instance().getWASServerVersion(server);
            if (!((double)new Float(specStr).floatValue() > 1.0) || serverVersion >= 60) {
                availableServers.put(server.getName(), server);
                if (updateCombo) {
                    this.serversC.add(server.getName());
                }
            }
            ++k;
        }
        return availableServers;
    }

    private Vector getExistingJNDINames(IServer server, IProject connectorProject, Connector connector, List connectionProperties) {
        this.jndiNames = new Vector();
        this.serverType = DeploymentHelper.instance().getWASServerVersion(server);
        try {
            ServerRAROperations ops = new ServerRAROperations();
            ops.setEisType(connector.getEisType());
            ops.setVendorName(connector.getVendorName());
            ops.setConnectorVersion(connector.getVersion());
            ops.setDisplayName(connector.getDisplayName());
            if (((JNDIResourceLookupWizard)this.getWizard()).properties.getName().equals("ActivationSpecProperties")) {
                ops.setMode(5);
            } else {
                ops.setMode(2);
            }
            Vector resVec = ops.getExistingJNDINames(this.getContainer(), server, connectorProject, connectionProperties);
            return resVec;
        }
        catch (Exception e) {
            this.jndiNames = null;
            e.printStackTrace();
            return this.jndiNames;
        }
    }

    public IWizardPage getNextPage() {
        JNDIResourceLookupWizard_NameSelectionPage nextPage = (JNDIResourceLookupWizard_NameSelectionPage)super.getNextPage();
        String serverName = this.serversC.getText();
        IServer server = (IServer)this.getAvailableServers(false).get(serverName);
        if (server == null) {
            return nextPage;
        }
        ((JNDIResourceLookupWizard)this.getWizard()).setServerId(server.getId());
        IProject proj = ((JNDIResourceLookupWizard)this.getWizard()).connectorProject;
        Connector conn = ((JNDIResourceLookupWizard)this.getWizard()).connector;
        if (this.firstTouched) {
            this.firstTouched = false;
        } else if (((JNDIResourceLookupWizard)this.getWizard()).mode == 1) {
            Vector jndiNs = this.getExistingJNDINames(server, proj, conn, null);
            nextPage.JNDINames = jndiNs != null ? jndiNs : new Vector();
            nextPage.displayPage(null, null);
        } else {
            try {
                IPropertyGroup properties = (IPropertyGroup)((JNDIResourceLookupWizard)this.getWizard()).getProperties().clone();
                String[] names = ((JNDIResourceLookupWizard)this.getWizard()).getClassName();
                nextPage.displayPage(properties, names);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nextPage;
    }

    public IServer getSelectedServer() {
        String serverName = this.serversC.getText();
        IServer server = (IServer)this.getAvailableServers(false).get(serverName);
        return server;
    }

    public boolean validatePage() {
        boolean result = true;
        if (this.serversC.getItemCount() == 0) {
            this.setErrorMessage(this.messageBundle_.getMessage("J2C_UI_JNDIWIZARD_SERVER_SELECTION_PAGE_ERROR1"));
            return false;
        }
        if (result) {
            this.setErrorMessage(null);
        }
        ((JNDIResourceLookupWizard)this.getWizard()).setCanFinish(false);
        return result;
    }

    @Override
    public void setPageComplete(boolean complete) {
        ((JNDIResourceLookupWizard)this.getWizard()).setCanFinish(false);
        super.setPageComplete(complete);
    }
}

