/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.wizards;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.j2ca.IResourceAdapterListener;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.internal.utilities.DiscUIHelper;
import com.ibm.ccl.discpub.ui.core.internal.environment.UICoreImportEnvironment;
import com.ibm.j2c.ui.internal.listeners.ResourceAdapterListener;
import com.ibm.j2c.ui.internal.properties.ConnectorImportPropertyGroup;
import com.ibm.j2c.ui.internal.threads.WaitingThread;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.j2c.ui.wizards.J2CWizard;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardDynamicPage_PropertyGroup;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentImportDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class J2CWizard_ImportRARPage
extends MessageBundleWizardDynamicPage_PropertyGroup {
    private IProject connProject = null;

    public IProject getConnProject() {
        return this.connProject;
    }

    public void setConnProject(IProject project) {
        this.connProject = project;
    }

    public J2CWizard_ImportRARPage(String name, DiscUIMessageBundle newBundle) {
        super(name, (PropertyUIMessageBundle)newBundle);
        this.initPageTitle();
    }

    protected void initPageTitle() {
        this.setTitle(this.messageBundle_.getMessage("J2C_UI_WIZARDS_IMPORT_RAR_PAGE_TITLE"));
        this.setDescription(this.messageBundle_.getMessage("J2C_UI_WIZARDS_IMPORT_RAR_PAGE_DESC"));
        this.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_J2C_WIZARD_IMPORT_RAR_PAGE")));
    }

    public void initPage(ConnectorImportPropertyGroup pg) {
        this.isModified(true);
        this.displayPage((IPropertyGroup)pg);
    }

    public boolean performPageFinish() {
        final ResourceAdapterListener listener = new ResourceAdapterListener(null);
        final J2CWizard wizard = (J2CWizard)this.getWizard();
        try {
            RegistryFactory.getFactory().getAPIResourceAdapterRegistry().addResourceAdapterListener((IResourceAdapterListener)listener);
            wizard.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WaitingThread wThread;
                    monitor.beginTask(((MessageBundleWizardPage)J2CWizard_ImportRARPage.this).messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_IMPORTING_RAR_FILE"), 100);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
                    ConnectorImportPropertyGroup pg = (ConnectorImportPropertyGroup)J2CWizard_ImportRARPage.this.getPropertyGroup();
                    String projectName = pg.getConnectorProjectNameProperty().getValueAsString();
                    final IDataModel importDataModel = J2CWizard_ImportRARPage.this.importRarFile(pg.getConnectorFileProperty().getValueAsString(), projectName, pg.getTargetServerProperty().getRuntime(), (IProgressMonitor)subMonitor);
                    String rarFile = (String)importDataModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
                    IProject createdProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (createdProject != null) {
                        J2CUIHelper.checkServerRuntime(createdProject, rarFile);
                        J2CWizard_ImportRARPage.this.setConnProject(createdProject);
                    }
                    UICoreImportEnvironment env = wizard.getImportEnvironment();
                    env.setProgressMonitor(monitor);
                    listener.setConnectorProject(createdProject);
                    WaitingThread waitingThread = wThread = new WaitingThread((IEnvironment)env, null, createdProject, listener);
                    synchronized (waitingThread) {
                        wThread.start();
                        while (!wThread.isFinished()) {
                            ((Object)((Object)wThread)).wait(2000L);
                            if (!monitor.isCanceled()) continue;
                            wThread.setCanceled(true);
                            break;
                        }
                    }
                    monitor.done();
                    if (wThread.isCanceled()) {
                        importDataModel.dispose();
                        throw new InterruptedException();
                    }
                    J2CWizard_ImportRARPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            wizard.getJ2CCategoryPage().updateResourceAdapterViewer(importDataModel);
                            wizard.getJ2CCategoryPage().isModified(false);
                        }
                    });
                    importDataModel.dispose();
                }
            });
            return true;
        }
        catch (InvocationTargetException itc) {
            if (itc.getCause() instanceof BaseException) {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(itc.getCause(), this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), DiscUIHelper.getDiscUIHelper().getMessageFromCoreException((CoreException)((Object)((BaseException)itc.getCause()))));
            } else {
                DiscUIHelper.getDiscUIHelper().showExceptionMessage(itc.getCause(), this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), itc.getCause().getMessage());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            DiscUIHelper.getDiscUIHelper().showExceptionMessage((Throwable)e, this.getShell(), this.messageBundle_.getMessage("WIZARD_WIN_ERRTITLE"), e.getMessage());
        }
        finally {
            RegistryFactory.getFactory().getAPIResourceAdapterRegistry().removeResourceAdapterListener((IResourceAdapterListener)listener);
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IDataModel importRarFile(String rarPath, String projectName, IRuntime targetRuntime, IProgressMonitor monitor) {
        IDataModel importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentImportDataModelProvider());
        importDataModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", false);
        importDataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)rarPath);
        importDataModel.setStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", projectName);
        importDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)targetRuntime);
        try {
            List versionList = JavaFacetUtils.JAVA_FACET.getSortedVersions(true);
            IProjectFacetVersion versionToInstall = null;
            int i = versionList.size() - 1;
            while (i >= 0) {
                IProjectFacetVersion element = (IProjectFacetVersion)versionList.get(i);
                if (targetRuntime.supports(element)) {
                    versionToInstall = element;
                    break;
                }
                --i;
            }
            if (versionToInstall != null) {
                IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)importDataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                IDataModel model = (IDataModel)map.get((Object)"jst.java");
                model.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)versionToInstall.getVersionString());
            }
        }
        catch (Exception exception) {}
        IDataModelOperation runnable = importDataModel.getDefaultOperation();
        try {
            runnable.execute(monitor, null);
            return importDataModel;
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }
}

