/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.wizards;

import com.ibm.adapter.emd.internal.discovery.EMDDescriptor;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IDiscoveryAgent;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.build.registry.IBuildConfiguration;
import com.ibm.adapter.framework.registry.Configuration;
import com.ibm.adapter.framework.registry.IConfiguration;
import com.ibm.adapter.framework.registry.IRegistry;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.ccl.discovery.ui.internal.messages.DiscUIMessageBundle;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard;
import com.ibm.ccl.discovery.ui.wizards.DiscWizard_CategoryPage;
import com.ibm.ccl.discpub.ui.core.internal.environment.UICoreImportEnvironment;
import com.ibm.j2c.ui.core.internal.rar.RARImportManager;
import com.ibm.j2c.ui.core.internal.rar.RARInfo;
import com.ibm.j2c.ui.internal.actions.DropDownBaseAction;
import com.ibm.j2c.ui.internal.actions.DropDownMenuAction;
import com.ibm.j2c.ui.internal.datastore.ConnectionStore;
import com.ibm.j2c.ui.internal.datastore.GenerateResourceAdapter;
import com.ibm.j2c.ui.internal.menus.DropDownMenuCreator;
import com.ibm.j2c.ui.internal.messages.J2CUIMessageBundle;
import com.ibm.j2c.ui.internal.model.J2CRAExtensionPointInfo;
import com.ibm.j2c.ui.internal.model.RAConnectionElement;
import com.ibm.j2c.ui.internal.model.RAConnectorProjectElement;
import com.ibm.j2c.ui.internal.model.ResourceAdapterElement;
import com.ibm.j2c.ui.internal.model.ResourceAdapterViewElement;
import com.ibm.j2c.ui.internal.providers.RAElementContentProvider;
import com.ibm.j2c.ui.internal.providers.RAElementLabelProvider;
import com.ibm.j2c.ui.internal.utilities.J2CInfoPopHelper;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.j2c.ui.plugin.J2CUIPlugin;
import com.ibm.j2c.ui.plugin.J2CUIPluginConstants;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.wizards.MessageBundleWizardPage;
import commonj.connector.metadata.MetadataConfigurationType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.jst.j2ee.jca.ui.internal.wizard.ConnectorComponentImportWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.ui.internal.wizard.page.WorkspaceRunnableAdapter;

public class J2CWizard_CategoryPage
extends DiscWizard_CategoryPage {
    protected Label descText_;
    protected Hyperlink helpLink_;
    protected ArrayList raNames_;
    protected Hashtable raGroups_ = new Hashtable();
    protected IAction importAction_;
    protected DropDownBaseAction viewbyAction_;
    protected DropDownBaseAction filterAction_;
    protected DropDownMenuAction filterShowAll_;
    protected DropDownMenuAction filterShowRA_;
    protected DropDownMenuAction filterShowDA_;
    protected DropDownMenuAction viewbyEIS_;
    protected DropDownMenuAction viewbyJ2C_;
    protected DropDownMenuAction viewbyVendor_;
    protected DropDownMenuAction viewbyName_;
    protected boolean showViewBy_ = true;
    protected String VIEWBY_EISTYPE_;
    protected String VIEWBY_JCAVERSION_;
    protected String VIEWBY_NAME_;
    protected String VIEWBY_VENDOR_;
    protected String VIEWBY_OTHERS_FOLDER_;
    protected String viewBy_;
    protected ResourceAdapterElement selectedRAElement_ = null;
    protected IResourceAdapterDescriptor selectedRA_;
    protected RAElementLabelProvider raLabelProvider_;
    protected RAElementContentProvider raContentProvider_;
    protected String treeViewerTitle_ = this.messageBundle_.getMessage("J2C_UI_WIDGETS_LABEL_RACHOOSE");
    protected boolean isRAImported_ = false;
    protected boolean needIMSSelection_ = false;
    protected IBuildAgent bAgent_;
    protected boolean showHelpLink_ = true;
    protected InitRACustomizationJob initRACustomizationJob_;

    public J2CWizard_CategoryPage(String name, J2CUIMessageBundle newBundle) {
        super(name, (DiscUIMessageBundle)newBundle);
    }

    protected void initPageTitle() {
        super.initPageTitle();
        this.VIEWBY_EISTYPE_ = this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_VIEWBY_EISTYPE");
        this.VIEWBY_JCAVERSION_ = this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_VIEWBY_JCAVERSION");
        this.VIEWBY_NAME_ = this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_VIEWBY_NAME");
        this.VIEWBY_VENDOR_ = this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_VIEWBY_VENDOR");
        this.VIEWBY_OTHERS_FOLDER_ = "Others";
        this.initRACustomizationJob_ = new InitRACustomizationJob(this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_INIT_RA_CUSTOMIZATION"));
        this.initRACustomizationJob_.setSystem(true);
        this.initRACustomizationJob_.schedule();
    }

    protected Label createTreeViewerTitle(IPropertyUIWidgetFactory factory, Composite parent) {
        if (this.treeViewerTitle_ != null && this.treeViewerTitle_.length() > 0) {
            return factory.createLabel(parent, this.treeViewerTitle_, 0);
        }
        return null;
    }

    protected TreeViewer createTreeViewer(IPropertyUIWidgetFactory factory, SashForm parent) {
        this.toolBarItems_ = this.createContributionItems();
        TreeViewer viewer = super.createTreeViewer(factory, parent);
        this.createDescriptionText(factory, parent.getParent());
        if (this.showHelpLink_) {
            this.createHelpLink(factory, parent.getParent());
        }
        return viewer;
    }

    protected ViewerSorter getViewerStorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ResourceAdapterViewElement && e2 instanceof ResourceAdapterViewElement) {
                    String name1 = ((ResourceAdapterViewElement)e1).getName();
                    String name2 = ((ResourceAdapterViewElement)e2).getName();
                    if (name1.equals(J2CWizard_CategoryPage.this.VIEWBY_OTHERS_FOLDER_)) {
                        return 1;
                    }
                    if (name2.equals(J2CWizard_CategoryPage.this.VIEWBY_OTHERS_FOLDER_)) {
                        return -1;
                    }
                    return name1.compareTo(name2);
                }
                if (e1 instanceof ResourceAdapterElement && e2 instanceof ResourceAdapterElement) {
                    return ((ResourceAdapterElement)e1).getName().compareTo(((ResourceAdapterElement)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }

    protected IContributionItem[] createContributionItems() {
        this.importAction_ = new Action("Import"){

            public void run() {
                J2CWizard_CategoryPage.this.performRAImport();
            }
        };
        this.importAction_.setToolTipText(this.messageBundle_.getMessage("J2C_UI_WIDGETS_BUTTON_IMPORT_RAR_TIP"));
        this.importAction_.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_J2C_WIZARD_ACTION_IMPORT")));
        if (this.showViewBy_) {
            IPreferenceStore store = J2CUIPlugin.getInstance().getPreferenceStore();
            this.viewbyEIS_ = new CategoryViewByMenuAction(this.VIEWBY_EISTYPE_, 8, store);
            this.viewbyJ2C_ = new CategoryViewByMenuAction(this.VIEWBY_JCAVERSION_, 8, store);
            this.viewbyName_ = new CategoryViewByMenuAction(this.VIEWBY_NAME_, 8, store);
            this.viewbyVendor_ = new CategoryViewByMenuAction(this.VIEWBY_VENDOR_, 8, store);
            this.viewbyAction_ = new DropDownBaseAction("ViewBy", new DropDownMenuCreator(new DropDownMenuAction[]{this.viewbyEIS_, this.viewbyJ2C_, this.viewbyName_, this.viewbyVendor_}));
            this.viewbyAction_.setToolTipText(this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_VIEWBY"));
            this.viewbyAction_.setImageDescriptor(this.messageBundle_.getImageDescriptor(this.messageBundle_.getMessage("ICON_J2C_WIZARD_ACTION_VIEWBY")));
        }
        if (this.viewbyAction_ != null) {
            return new IContributionItem[]{new ActionContributionItem(this.importAction_), new Separator(), new ActionContributionItem((IAction)this.viewbyAction_)};
        }
        return new IContributionItem[]{new ActionContributionItem(this.importAction_), new Separator()};
    }

    protected void performRAImport() {
        ConnectorComponentImportWizard wizard = new ConnectorComponentImportWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        IDataModel importModel = wizard.getDataModel();
        importModel.setBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", false);
        if (dialog.open() == 0) {
            this.updateResourceAdapterViewer(importModel);
        }
    }

    protected ArrayList initTreeInput() {
        if (this.raNames_ == null) {
            this.setTreeViewInput(this.populateRAList());
        }
        this.viewByOptionChanged(this.viewBy_, false);
        return null;
    }

    protected void initPageContents() {
        super.initPageContents();
        String[] stringArray = new String[2];
        stringArray[0] = "Choose_the_resource_adapter";
        this.setInfoHelp(new Control[]{this.treeViewer_.getControl().getParent(), this.treeViewer_.getControl()}, stringArray);
    }

    protected void initTreeViewer(TreeViewer treeViewer) {
        super.initTreeViewer(treeViewer);
        this.raLabelProvider_ = new RAElementLabelProvider((J2CUIMessageBundle)this.messageBundle_);
        treeViewer.setLabelProvider((IBaseLabelProvider)this.raLabelProvider_);
        this.raContentProvider_ = new RAElementContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.raContentProvider_);
        if (this.viewBy_ == null || this.viewBy_.length() < 1) {
            if (this.viewbyAction_ != null) {
                this.viewbyEIS_.setChecked(true);
                this.viewBy_ = this.VIEWBY_EISTYPE_;
            } else {
                this.viewBy_ = this.VIEWBY_NAME_;
            }
        }
    }

    protected void setInfoHelp(Control[] controls, String[] keys) {
        String pageName = this.getName();
        int i = 0;
        while (i < controls.length) {
            if (keys[i] != null) {
                J2CInfoPopHelper.instance().setInfoHelp(controls[i], pageName, keys[i], J2CInfoPopHelper.J2CUI_WIZARD_PACKAGE);
            } else {
                J2CInfoPopHelper.instance().setInfoHelp(controls[i], pageName, J2CInfoPopHelper.J2CUI_WIZARD_PACKAGE);
            }
            ++i;
        }
    }

    public ArrayList<ResourceAdapterElement> populateRAList() {
        ArrayList<ResourceAdapterElement> raList = new ArrayList<ResourceAdapterElement>();
        ConnectionStore connectionStore = this.getConnectionStore();
        List rarInfos = RARImportManager.getInstance().getRARInfos();
        int i = 0;
        while (i < rarInfos.size()) {
            RARInfo rarInfo = (RARInfo)rarInfos.get(i);
            String rarURI = rarInfo.getRARURI();
            Connector connector = rarInfo.getConnector();
            if (!this.isSupportedResourceAdapter(connector)) {
                rarInfo.dispose();
            } else {
                ResourceAdapterElement element = this.createResourceAdapterElement(raList, connector, rarURI);
                this.setToRAElementList(raList, element, rarInfo.getRARFile(), rarInfo.isInWorkspace(), rarURI, connectionStore);
                rarInfo.dispose();
            }
            ++i;
        }
        return raList;
    }

    protected ResourceAdapterElement setToRAElementList(ArrayList<ResourceAdapterElement> list, ResourceAdapterElement element, RARFile rarFile, boolean isInWorkspace, String uri, ConnectionStore connectionStore) {
        ResourceAdapterElement retElement;
        if (rarFile != null) {
            element.setSubElement(this.getEMDDescriptor(rarFile));
        }
        if ((retElement = this.addRAElement(list, element)) != null && isInWorkspace) {
            String rarURI = rarFile == null ? uri : rarFile.getOriginalURI();
            rarURI = rarURI.substring(rarURI.lastIndexOf(58) + 1);
            RAConnectorProjectElement connProj = new RAConnectorProjectElement(retElement, rarURI);
            retElement.addChild(connProj);
            connectionStore.loadConnectionNames(retElement.getRAElementID(rarURI));
            if (connectionStore.connectionNames_ != null) {
                int j = 0;
                while (j < connectionStore.connectionNames_.size()) {
                    RAConnectionElement con1 = new RAConnectionElement(connProj, (String)connectionStore.connectionNames_.get(j));
                    connProj.addConnection(con1);
                    ++j;
                }
            }
        }
        return retElement;
    }

    protected EMDDescriptor getEMDDescriptor(RARFile rarFile) {
        File file = null;
        try {
            file = rarFile.getFile("META-INF/discovery-service.xml");
        }
        catch (Exception exception) {}
        if (file == null) {
            return null;
        }
        EMDDescriptor descriptor = null;
        return descriptor;
    }

    protected ResourceAdapterElement createResourceAdapterElement(ArrayList<ResourceAdapterElement> list, Object obj, String rarURI) {
        Connector conn;
        ResourceAdapterElement element = null;
        if (obj instanceof Connector) {
            conn = (Connector)obj;
        } else if (obj instanceof IResourceAdapterDescriptor) {
            conn = ((IResourceAdapterDescriptor)obj).getConnector();
        } else {
            return null;
        }
        int i1 = 0;
        while (i1 < list.size()) {
            ResourceAdapterElement ra = list.get(i1);
            if (ra.getElement() instanceof Connector && RARImportManager.isEqual((Connector)((Connector)ra.getElement()), (Connector)conn)) {
                return ra;
            }
            ++i1;
        }
        J2CRAExtensionPointInfo info = J2CUIHelper.instance().getRAExtensionPointInfo(conn.getDisplayName(), conn.getVendorName(), conn.getVersion());
        element = info != null ? new ResourceAdapterElement(obj, this.messageBundle_.getMessage(info.getIconPath()), this.messageBundle_.getMessage(info.getTopologyImagePath()), rarURI, info.getContextHelp()) : new ResourceAdapterElement(obj, this.messageBundle_.getMessage("ICON_NEW_OTHERADAPTER"), this.messageBundle_.getMessage("ICON_OTHERADAPTER_TOPOLOGY"), rarURI, null);
        return element;
    }

    public void dispose() {
        super.dispose();
        if (this.raContentProvider_ != null) {
            this.raContentProvider_.dispose();
        }
        if (this.raLabelProvider_ != null) {
            this.raLabelProvider_.dispose();
        }
    }

    protected void processSelectedObject() {
        if (this.descText_ != null) {
            this.descText_.setText("");
        }
        if (this.selectedObject_ != null) {
            if (this.selectedObject_ instanceof ResourceAdapterElement) {
                ResourceAdapterElement ra = (ResourceAdapterElement)this.selectedObject_;
                if (!ra.equals(this.selectedRAElement_)) {
                    this.selectedRAElement_ = ra;
                }
                this.treeViewer_.expandToLevel((Object)ra, 1);
                if (this.descText_ != null) {
                    this.descText_.setText(((ResourceAdapterElement)this.selectedObject_).getDetailsDescription());
                }
            } else if (this.selectedObject_ instanceof RAConnectorProjectElement) {
                ResourceAdapterElement ra = ((RAConnectorProjectElement)this.selectedObject_).getRA();
                if (!ra.equals(this.selectedRAElement_)) {
                    this.selectedRAElement_ = ra;
                }
                this.treeViewer_.expandToLevel(this.selectedObject_, 1);
            } else if (this.selectedObject_ instanceof RAConnectionElement) {
                ResourceAdapterElement ra = ((RAConnectionElement)this.selectedObject_).getRA();
                if (!ra.equals(this.selectedRAElement_)) {
                    this.selectedRAElement_ = ra;
                }
            } else if (this.selectedObject_ instanceof ResourceAdapterViewElement) {
                this.selectedRAElement_ = null;
            }
        } else {
            this.selectedRAElement_ = null;
        }
    }

    public ResourceAdapterElement getSelectedRAElement() {
        return this.selectedRAElement_;
    }

    public String getConnectionName() {
        if (this.selectedObject_ != null && this.selectedObject_ instanceof RAConnectionElement) {
            return ((RAConnectionElement)this.selectedObject_).getName();
        }
        return null;
    }

    public String getConnectionClassName() {
        if (this.selectedObject_ != null && this.selectedObject_ instanceof RAConnectionElement) {
            return ((RAConnectionElement)this.selectedObject_).getClassName();
        }
        return null;
    }

    public String getJNDIName() {
        if (this.selectedObject_ != null && this.selectedObject_ instanceof RAConnectionElement) {
            return ((RAConnectionElement)this.selectedObject_).getJNDIName();
        }
        return this.getDefaultJNDIName();
    }

    public String getDefaultJNDIName() {
        return "MyDefaultJNDIName";
    }

    protected IResourceAdapterDescriptor getResourceAdapter(final ResourceAdapterElement rae, boolean needImport, String projectName) {
        Object element = rae.getElement();
        if (element instanceof IResourceAdapterDescriptor) {
            return (IResourceAdapterDescriptor)element;
        }
        IResourceAdapterDescriptor[] ras = null;
        try {
            if (this.initRACustomizationJob_ != null) {
                this.initRACustomizationJob_.cancel();
            }
            final IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
            raRegistry.waitForRegistryProcessing();
            com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getRegistry().waitForRegistryProcessing();
            ras = raRegistry.getResourceAdapters(rae.getName(), rae.getVersion(), rae.getVendor());
            IResourceAdapterDescriptor matchedRA = this.getMatchedResourceAdapter(ras, projectName);
            if (matchedRA != null) {
                return matchedRA;
            }
            final int raNoBefore = raRegistry.getAllResourceAdapters().length;
            if (needImport) {
                this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceRunnableAdapter(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) {
                        RARImportManager rarMan = RARImportManager.getInstance();
                        rarMan.importIfNeeded(rae.getRALocation(), progressMonitor);
                        GenerateResourceAdapter.setRAfile(rae.getRALocation());
                        J2CWizard_CategoryPage.this.isRAImported_ = true;
                    }
                }));
            }
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor progressMonitor) {
                    boolean loop = true;
                    int interval = 1000;
                    int totalTime = 0;
                    int units = 60;
                    progressMonitor.beginTask(((MessageBundleWizardPage)J2CWizard_CategoryPage.this).messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_UPDATE_RA_REGISTRY"), units);
                    try {
                        try {
                            while (loop) {
                                int raNoAfter = raRegistry.getAllResourceAdapters().length;
                                if (raNoAfter != raNoBefore) {
                                    loop = false;
                                } else {
                                    Thread.sleep(interval);
                                    if ((totalTime += interval) >= interval * units) {
                                        loop = false;
                                    }
                                }
                                progressMonitor.worked(1);
                                if (!progressMonitor.isCanceled()) continue;
                                break;
                            }
                        }
                        catch (Exception exception) {
                            progressMonitor.worked(units);
                        }
                    }
                    finally {
                        progressMonitor.worked(units);
                    }
                }
            });
            ras = raRegistry.getResourceAdapters(rae.getName(), rae.getVersion(), rae.getVendor());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Exception e) {
            J2CUIPluginConstants.debug("exception getting  ra:" + e.getMessage());
            e.printStackTrace();
        }
        return this.getMatchedResourceAdapter(ras, projectName);
    }

    protected IResourceAdapterDescriptor getMatchedResourceAdapter(IResourceAdapterDescriptor[] ras, String name) {
        if (ras == null || ras.length < 1) {
            return null;
        }
        if (name == null) {
            return ras[0];
        }
        int i = 0;
        while (i < ras.length) {
            if (ras[i].getConnectorProject().getName().equals(name)) {
                return ras[i];
            }
            ++i;
        }
        return null;
    }

    public void viewByOptionChanged(String viewBy, boolean selectItem) {
        if (viewBy == null || viewBy.length() < 1 || this.raNames_ == null || this.raNames_.size() < 1) {
            return;
        }
        this.viewBy_ = viewBy;
        Object treeInput = this.raGroups_.get(viewBy);
        if (treeInput == null) {
            if (viewBy.equals(this.VIEWBY_NAME_)) {
                treeInput = this.raNames_;
            } else {
                Hashtable<String, ResourceAdapterViewElement> input = new Hashtable<String, ResourceAdapterViewElement>();
                ResourceAdapterViewElement viewElement = null;
                int i = 0;
                while (i < this.raNames_.size()) {
                    ResourceAdapterElement ra = (ResourceAdapterElement)this.raNames_.get(i);
                    Connector connector = ra.getConnector();
                    String key = this.VIEWBY_OTHERS_FOLDER_;
                    if (connector != null) {
                        if (viewBy.equals(this.VIEWBY_VENDOR_)) {
                            key = connector.getVendorName().trim();
                        } else if (viewBy.equals(this.VIEWBY_JCAVERSION_)) {
                            key = connector.getSpecVersion().trim();
                        } else if (viewBy.equals(this.VIEWBY_EISTYPE_)) {
                            key = connector.getEisType();
                        }
                    }
                    if ((viewElement = (ResourceAdapterViewElement)input.get(key.toUpperCase())) == null) {
                        viewElement = new ResourceAdapterViewElement(key);
                        input.put(key.toUpperCase(), viewElement);
                    }
                    viewElement.getContents().add(ra);
                    ++i;
                }
                treeInput = input.values();
            }
        }
        if (treeInput != null) {
            Object selectedItem = this.selectedObject_;
            this.raGroups_.put(viewBy, treeInput);
            this.treeViewer_.setInput(treeInput);
            this.treeViewer_.refresh();
            if (selectItem) {
                this.selectTreeItem(selectedItem);
            }
        }
    }

    public boolean validatePage() {
        String errMsg = null;
        if (this.selectedRAElement_ == null) {
            errMsg = this.messageBundle_.getMessage("ERROR_WIZARDS_SELECT_RA");
        }
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.raNames_.size() > 0 && this.selectedRAElement_ == null && visible) {
            this.selectTreeItem(this.raNames_.get(0));
        }
    }

    public boolean hasDiscoveryAgent() {
        return this.agent_ != null;
    }

    public boolean hasBuildAgent() {
        return this.bAgent_ != null;
    }

    public IProject getConnectorProject() {
        if (this.selectedRA_ != null) {
            return this.selectedRA_.getConnectorProject();
        }
        return null;
    }

    public IResourceAdapterDescriptor getSelectedResourceAdapter() {
        return this.selectedRA_;
    }

    public String getResourceAdapterID() {
        if (this.selectedRAElement_ != null) {
            String projectName = null;
            if (this.selectedRA_ != null) {
                projectName = this.selectedRA_.getConnectorProject().getName();
            }
            return this.selectedRAElement_.getRAElementID(projectName);
        }
        return null;
    }

    protected ResourceAdapterElement addRAElement(ArrayList<ResourceAdapterElement> list, ResourceAdapterElement element) {
        if (list.contains(element)) {
            return element;
        }
        list.add(element);
        return element;
    }

    protected void updateResourceAdapterViewer(IDataModel importModel) {
        block12: {
            this.setPageComplete(false);
            String projectName = importModel.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            ConnectorArtifactEdit artifactEdit = ConnectorArtifactEdit.getConnectorArtifactEditForRead((IVirtualComponent)component);
            GenerateResourceAdapter.setRAfile((String)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME"));
            RARFile rarFile = null;
            try {
                try {
                    rarFile = (RARFile)artifactEdit.asArchive(false);
                    Connector conn = rarFile.getDeploymentDescriptor();
                    ResourceAdapterElement raElement = this.createResourceAdapterElement(this.raNames_, conn, rarFile.getOriginalURI());
                    Object ra = null;
                    if (this.isSupportedResourceAdapter(conn)) {
                        ra = this.setToRAElementList(this.raNames_, raElement, null, true, projectName, this.getConnectionStore());
                    }
                    if (ra != null) {
                        if (ra.equals(raElement)) {
                            this.raGroups_.clear();
                            this.viewByOptionChanged(this.viewBy_, false);
                        }
                        this.selectTreeItem(ra);
                        this.setConfigurableProject(project);
                        break block12;
                    }
                    MessageDialog.openError((Shell)this.getShell(), (String)this.messageBundle_.getMessage("J2C_UI_WIZARDS_ERRTITLE_UI_"), (String)this.messageBundle_.getMessage("ERROR_WIZARDS_UNSUPPORTED_RA"));
                }
                catch (Exception ofe) {
                    ofe.printStackTrace();
                    if (rarFile != null) {
                        rarFile.close();
                    }
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (rarFile != null) {
                    rarFile.close();
                }
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
    }

    protected void createDescriptionText(IPropertyUIWidgetFactory factory, Composite parent) {
        this.descText_ = factory.createLabel(parent, 64);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.descText_.setLayoutData((Object)gd);
    }

    protected void createHelpLink(IPropertyUIWidgetFactory factory, Composite parent) {
        this.helpLink_ = factory.createUnderlinedHyperlink(parent, this.messageBundle_.getMessage("J2C_UI_WIZARDS_LABEL_J2C_BEAN_HELP_LINK"), 64);
        this.helpLink_.setForeground(parent.getDisplay().getSystemColor(10));
        this.helpLink_.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String helpId = "/com.ibm.etools.j2c.doc/topics/cj2cbeaninout.html";
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
            }
        });
        GridData gd = new GridData(128);
        gd.horizontalSpan = 1;
        this.helpLink_.setLayoutData((Object)gd);
    }

    public void showHelpLink(boolean show) {
        this.showHelpLink_ = show;
    }

    protected void selectTreeItem(Object selectedItem) {
        this.treeViewer_.getTree().setFocus();
        if (selectedItem == null) {
            this.treeViewer_.setSelection(null);
        } else {
            ResourceAdapterElement raElement = null;
            if (selectedItem instanceof ResourceAdapterElement) {
                raElement = (ResourceAdapterElement)selectedItem;
            } else if (selectedItem instanceof RAConnectionElement) {
                raElement = ((RAConnectionElement)selectedItem).getRA();
            } else if (selectedItem instanceof RAConnectorProjectElement) {
                raElement = ((RAConnectorProjectElement)selectedItem).getRA();
            }
            if (raElement != null) {
                Connector connector = raElement.getConnector();
                String key = this.VIEWBY_OTHERS_FOLDER_;
                TreeItem[] items = this.treeViewer_.getTree().getItems();
                if (connector != null) {
                    if (this.viewBy_.equals(this.VIEWBY_VENDOR_)) {
                        key = connector.getVendorName().trim();
                    } else if (this.viewBy_.equals(this.VIEWBY_JCAVERSION_)) {
                        key = connector.getSpecVersion().trim();
                    } else if (this.viewBy_.equals(this.VIEWBY_EISTYPE_)) {
                        key = connector.getEisType();
                    }
                }
                TreeItem[] children = items;
                int i = 0;
                while (i < items.length) {
                    String label = items[i].getText();
                    if (label == null || label.length() < 1) break;
                    if (key.equals(label)) {
                        this.treeViewer_.expandToLevel(items[i].getData(), 2);
                        children = items[i].getItems();
                        break;
                    }
                    ++i;
                }
                if (!raElement.equals(selectedItem) && children != null) {
                    int j = 0;
                    while (j < children.length) {
                        if (children[j].getData().equals(raElement)) {
                            this.treeViewer_.expandToLevel(children[j].getData(), 1);
                            break;
                        }
                        ++j;
                    }
                }
                StructuredSelection sel = new StructuredSelection(selectedItem);
                this.treeViewer_.setSelection((ISelection)sel, true);
            }
        }
    }

    protected boolean checkServerRuntime(IProject project) {
        if (project != null) {
            GenerateResourceAdapter.setRAProject(project.getName());
            Set<IRuntime> runtimes = J2CUIHelper.instance().getProjectTargetedRuntimes(project);
            if (runtimes != null && !runtimes.isEmpty() && runtimes.iterator().next() != null) {
                GenerateResourceAdapter.setRAruntime(runtimes.iterator().next().getLocalizedName());
                return true;
            }
        }
        return false;
    }

    public void setTreeViewInput(ArrayList newList) {
        this.raNames_ = newList;
    }

    public void showViewBy(boolean show) {
        this.showViewBy_ = show;
    }

    public Object performPageFinish() throws BaseException {
        IResourceAdapterDescriptor ra = null;
        this.needIMSSelection_ = false;
        Object element = this.selectedRAElement_.getElement();
        if (element instanceof IResourceAdapterDescriptor) {
            ra = (IResourceAdapterDescriptor)element;
        } else if (element instanceof Connector) {
            if (this.selectedObject_ instanceof ResourceAdapterElement) {
                return null;
            }
            this.isRAImported_ = false;
            String projectName = null;
            if (this.selectedObject_ != null) {
                if (this.selectedObject_ instanceof RAConnectorProjectElement) {
                    projectName = ((RAConnectorProjectElement)this.selectedObject_).getDisplayName();
                } else if (this.selectedObject_ instanceof RAConnectionElement) {
                    projectName = ((RAConnectionElement)this.selectedObject_).getConnectorProjectName();
                }
            }
            if ((ra = this.getResourceAdapter(this.selectedRAElement_, false, projectName)) != null) {
                ArrayList children = this.selectedRAElement_.getChildren();
                if (this.isRAImported_ && (children == null || children.isEmpty())) {
                    this.setToRAElementList(this.raNames_, this.selectedRAElement_, null, true, ra.getConnectorProject().getName(), this.getConnectionStore());
                    this.treeViewer_.refresh((Object)this.selectedRAElement_, true);
                }
            }
        }
        if (ra != null) {
            Connector connector;
            String eisType;
            IProject connProject = ra.getConnectorProject();
            if (!this.checkServerRuntime(connProject)) {
                MessageDialog.openError((Shell)this.getShell(), (String)this.messageBundle_.getMessage("J2C_UI_WIZARDS_ERRTITLE_UI_"), (String)this.messageBundle_.getMessage("ERROR_WIZARDS_CANNOT_FIND_SERVER_RUNTIME", (Object[])J2CUIHelper.instance().getDisplayString(connProject.getName())));
                return null;
            }
            List alist = RARImportManager.getInstance().getRARURIs();
            String raloc = this.selectedRAElement_.getRALocation();
            if (raloc != null) {
                int ralocindex = raloc.indexOf("]:");
                String raloc1 = raloc.substring(ralocindex + 2);
                int i = 0;
                while (i < alist.size()) {
                    String raURI = (String)alist.get(i);
                    if (raURI.indexOf(raloc1) != -1) {
                        GenerateResourceAdapter.setRAfile(raURI);
                        break;
                    }
                    ++i;
                }
            }
            if (!ra.hasDiscoveryAgent()) {
                if (this.agent_ != null) {
                    try {
                        this.agent_.close();
                    }
                    catch (BaseException baseException) {}
                    this.agent_ = null;
                }
                return this.setupBuildModel(ra);
            }
            if (this.bAgent_ != null) {
                try {
                    this.bAgent_.close();
                }
                catch (BaseException baseException) {}
                this.bAgent_ = null;
            }
            if (this.isRAImported_) {
                this.setConfigurableProject(connProject);
            }
            if ((eisType = (connector = ra.getConnector()).getEisType()).equals("IMS") || eisType.equals("IMS TM")) {
                this.needIMSSelection_ = true;
                return ra;
            }
            return this.setupDiscoveryModel(ra);
        }
        if (element instanceof IConfiguration) {
            return this.setupDiscoveryModel(element);
        }
        return null;
    }

    public IBuildAgent setupBuildModel(IResourceAdapterDescriptor ra) throws BaseException {
        this.selectedRA_ = ra;
        IBuildAgent ba = ra.getBuildAgent();
        if (ba != null && !ba.equals(this.bAgent_)) {
            if (this.bAgent_ != null) {
                try {
                    this.bAgent_.close();
                }
                catch (BaseException baseException) {}
            }
            this.bAgent_ = ba;
            this.setWizardCanFinish(false);
            this.configuration_ = null;
        }
        if (this.bAgent_ != null) {
            return this.bAgent_;
        }
        MessageDialog.openError((Shell)this.getShell(), (String)this.messageBundle_.getMessage("J2C_UI_WIZARDS_ERRTITLE_UI_"), (String)this.messageBundle_.getMessage("ERROR_WIZARDS_UNSUPPORTED_RA"));
        return null;
    }

    public IDiscoveryAgent setupDiscoveryModel(Object obj) throws BaseException {
        if (obj != null) {
            IDiscoveryAgent da = null;
            this.selectedRA_ = null;
            this.configuration_ = null;
            if (obj instanceof IResourceAdapterDescriptor) {
                this.selectedRA_ = (IResourceAdapterDescriptor)obj;
                da = this.selectedRA_.getDiscoveryAgent();
            } else if (obj instanceof IConfiguration) {
                this.configuration_ = (IConfiguration)obj;
                da = this.configuration_.createDiscoveryAgent();
            }
            if (da != null && !da.equals(this.agent_)) {
                if (this.agent_ != null) {
                    try {
                        this.agent_.close();
                    }
                    catch (BaseException baseException) {}
                }
                this.agent_ = da;
                this.setWizardCanFinish(false);
            }
            if (this.agent_ != null) {
                return this.agent_;
            }
        }
        MessageDialog.openError((Shell)this.getShell(), (String)this.messageBundle_.getMessage("J2C_UI_WIZARDS_ERRTITLE_UI_"), (String)this.messageBundle_.getMessage("ERROR_WIZARDS_UNSUPPORTED_RA"));
        return null;
    }

    public IConfiguration getConfiguration() {
        block17: {
            if (this.configuration_ == null) {
                IWizard wizard = this.getWizard();
                DiscWizard discWizard = wizard instanceof DiscWizard ? (DiscWizard)wizard : null;
                ArrayList<Configuration> confs = new ArrayList<Configuration>(3);
                if (discWizard != null) {
                    try {
                        int i;
                        IRegistry registry = com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getRegistry();
                        registry.waitForRegistryProcessing();
                        Configuration[] importConfigs = registry.getAllConfigurations(discWizard.getClassifications(), false);
                        if (this.agent_ != null) {
                            i = 0;
                            while (i < importConfigs.length) {
                                if (!(importConfigs[i] instanceof IBuildConfiguration) && importConfigs[i].createDiscoveryAgent().equals(this.agent_)) {
                                    confs.add(importConfigs[i]);
                                }
                                ++i;
                            }
                        } else if (this.bAgent_ != null) {
                            i = 0;
                            while (i < importConfigs.length) {
                                if (importConfigs[i] instanceof IBuildConfiguration && ((IBuildConfiguration)importConfigs[i]).createBuildAgent().equals(this.bAgent_)) {
                                    confs.add(importConfigs[i]);
                                }
                                ++i;
                            }
                        }
                        if (confs.isEmpty()) break block17;
                        if (confs.size() == 1) {
                            this.configuration_ = (IConfiguration)confs.get(0);
                            break block17;
                        }
                        int style = this.getAgentStyle();
                        this.configuration_ = (IConfiguration)confs.get(0);
                        if (style == 0) break block17;
                        int i2 = 1;
                        while (i2 < confs.size()) {
                            IConfiguration iConfiguration = (IConfiguration)confs.get(i2);
                            String[] configs = iConfiguration.createResourceWriter().getConfiguration();
                            boolean found = false;
                            if (configs != null && configs.length > 0) {
                                int j = 0;
                                while (j < configs.length) {
                                    if ("INBOUND_ADAPTER".equals(configs[j]) && style == 1 || "OUTBOUND_ADAPTER".equals(configs[j]) && style == 2) {
                                        this.configuration_ = iConfiguration;
                                        found = true;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            if (!found) {
                                ++i2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.configuration_;
    }

    protected int getAgentStyle() {
        int style = 0;
        String outboundString = MetadataConfigurationType.OUTBOUND_SERVICE.toString();
        String inboundString = MetadataConfigurationType.INBOUND_SERVICE.toString();
        String[] configs = null;
        if (this.agent_ != null) {
            configs = this.agent_.getConfiguration();
        } else if (this.bAgent_ != null) {
            configs = this.bAgent_.getConfiguration();
        }
        if (configs != null) {
            int i = 0;
            while (i < configs.length) {
                if (inboundString.equals(configs[i])) {
                    style = 1;
                    break;
                }
                if (outboundString.equals(configs[i])) {
                    style = 2;
                    break;
                }
                ++i;
            }
        }
        return style == 0 ? 2 : style;
    }

    protected ConnectionStore getConnectionStore() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof DiscWizard) {
            return new ConnectionStore(((DiscWizard)wizard).getDataPersistPlugin());
        }
        return new ConnectionStore();
    }

    public boolean isRAImported() {
        return this.isRAImported_;
    }

    public boolean needIMSSelection() {
        return this.needIMSSelection_;
    }

    public void setTreeViewerTitle(String newTitle) {
        this.treeViewerTitle_ = newTitle;
    }

    public IBuildAgent getBuildAgent() {
        return this.bAgent_;
    }

    protected boolean isRADPath() {
        IPath[] classifications = null;
        IWizard wizard = this.getWizard();
        if (wizard instanceof DiscWizard) {
            classifications = ((DiscWizard)wizard).getClassifications();
        }
        return classifications == null || classifications.equals(J2CUIHelper.instance().RAD_PATH);
    }

    protected boolean isSupportedResourceAdapter(Connector connector) {
        if (this.isRADPath()) {
            String eisType = connector.getEisType();
            if ("JMS Provider".equals(eisType)) {
                return false;
            }
            String vendor = connector.getVendorName();
            if ("IBM".equals(vendor) && this.isRADPath() && ("Remote File System".equals(eisType) || "Local File System".equals(eisType) || "Email Server".equals(eisType))) {
                return false;
            }
        }
        return true;
    }

    public ArrayList getRaNames() {
        if (this.raNames_ == null) {
            this.setTreeViewInput(this.populateRAList());
        }
        return this.raNames_;
    }

    protected class CategoryViewByMenuAction
    extends DropDownMenuAction {
        public CategoryViewByMenuAction(String name, int style, IPreferenceStore store) {
            super(name, style, store);
            if (this.isChecked()) {
                J2CWizard_CategoryPage.this.viewBy_ = this.name_;
            }
        }

        @Override
        public void run() {
            super.run();
            if (this.isChecked()) {
                J2CWizard_CategoryPage.this.viewByOptionChanged(this.name_, true);
            }
        }
    }

    protected class InitRACustomizationJob
    extends Job {
        public InitRACustomizationJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
            raRegistry.waitForRegistryProcessing();
            com.ibm.adapter.framework.registry.RegistryFactory.getFactory().getRegistry().waitForRegistryProcessing();
            try {
                IResourceAdapterDescriptor ra;
                IResourceAdapterDescriptor[] adapters = raRegistry.getAllNonImportAdapters();
                IResourceAdapterDescriptor iResourceAdapterDescriptor = ra = adapters != null && adapters.length > 0 ? adapters[0] : null;
                if (ra != null && ra.hasBuildAgent()) {
                    IBuildAgent agent = ra.getBuildAgent();
                    agent.initializeContext(null);
                    agent.initialize((IEnvironment)new UICoreImportEnvironment(), agent.getInitializeProperties());
                    agent.close();
                }
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    }
}

