/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class TypedElementSelectionValidator
implements ISelectionStatusValidator {
    private IStatus fgErrorStatus = new Status(4, "com.ibm.j2c.ui", 0, "", null);
    private IStatus fgOKStatus = new Status(0, "com.ibm.j2c.ui", 0, "", null);
    private Class[] fAcceptedTypes;
    private boolean fAllowMultipleSelection;

    public TypedElementSelectionValidator(Class[] acceptedTypes, boolean allowMultipleSelection) {
        if (acceptedTypes != null) {
            this.fAcceptedTypes = acceptedTypes;
            this.fAllowMultipleSelection = allowMultipleSelection;
        }
    }

    public IStatus validate(Object[] elements) {
        if (this.isValid(elements)) {
            return this.fgOKStatus;
        }
        return this.fgErrorStatus;
    }

    private boolean isOfAcceptedType(Object o) {
        int i = 0;
        while (i < this.fAcceptedTypes.length) {
            if (this.fAcceptedTypes[i].isInstance(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValid(Object[] selection) {
        if (selection.length == 0) {
            return false;
        }
        if (!this.fAllowMultipleSelection && selection.length != 1) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            Object o = selection[i];
            if (!this.isOfAcceptedType(o)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

