/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.internal.properties.JNDITargetProperty;
import com.ibm.adapter.emd.util.EMDUtil;
import com.ibm.adapter.j2c.codegen.writer.properties.ConnectionPropertyGroup;
import com.ibm.adapter.j2c.codegen.writer.properties.InboundConnectionPropertyGroup;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.j2c.ui.internal.properties.JNDINameProperty;
import com.ibm.j2c.ui.internal.utilities.J2CEMDHelper;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import commonj.connector.metadata.description.InboundServiceDescription;
import commonj.connector.metadata.description.OutboundServiceDescription;
import commonj.connector.metadata.description.ServiceDescription;
import commonj.connector.metadata.discovery.connection.InboundConnectionConfiguration;
import commonj.connector.metadata.discovery.connection.OutboundConnectionConfiguration;
import commonj.connector.metadata.discovery.properties.PropertyGroup;
import java.util.ArrayList;

public class JndiPropertyUtils {
    public static IPropertyGroup getOriginalPropertyGroup(IPropertyDescriptor property) {
        InboundConnectionPropertyGroup parent;
        J2CServiceDescription inDef;
        IPropertyDescriptor ipd;
        if (property instanceof JNDINameProperty) {
            return ((JNDINameProperty)property).getOriginalPropertyGroup();
        }
        if (property instanceof JNDITargetProperty) {
            J2CServiceDescription outDef = JndiPropertyUtils.getJ2CServiceDescription(property);
            if (outDef != null) {
                try {
                    ServiceDescription sd = outDef.getServiceDescription();
                    OutboundServiceDescription osd = (OutboundServiceDescription)sd;
                    if (osd != null) {
                        OutboundConnectionConfiguration occ = osd.getOutboundConnectionAdvancedConfiguration();
                        PropertyGroup pg = occ.createManagedConnectionFactoryProperties();
                        occ.applyManagedConnectionFactoryProperties(pg);
                        return J2CEMDHelper.emdPG2ibmPG(pg, EMDUtil.getEMDSpecVersion((IResourceAdapterDescriptor)outDef.getResourceAdapterDescriptor()));
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
        } else if (property instanceof BaseSingleValuedProperty && (ipd = property.getParent()) instanceof InboundConnectionPropertyGroup && (inDef = (parent = (InboundConnectionPropertyGroup)property.getParent()).getServiceDescriptionWrapper()) != null) {
            try {
                InboundServiceDescription isd = (InboundServiceDescription)inDef.getServiceDescription();
                if (isd != null) {
                    InboundConnectionConfiguration occ = isd.getInboundConnectionAdvancedConfiguration();
                    PropertyGroup pg = occ.createActivationSpecProperties();
                    occ.applyActivationSpecProperties(pg);
                    return J2CEMDHelper.emdPG2ibmPG(pg, EMDUtil.getEMDSpecVersion((IResourceAdapterDescriptor)inDef.getResourceAdapterDescriptor()));
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static IResourceAdapterDescriptor getResourceAdapter(IPropertyDescriptor property) {
        J2CServiceDescription servDef;
        if (property instanceof JNDINameProperty) {
            return ((JNDINameProperty)property).getResourceAdapter();
        }
        if (property instanceof BaseSingleValuedProperty && (servDef = JndiPropertyUtils.getJ2CServiceDescription(property)) != null) {
            return servDef.getResourceAdapterDescriptor();
        }
        return null;
    }

    public static String[] getMCFClassNames(IPropertyDescriptor property) {
        IResourceAdapterDescriptor ra;
        if (property instanceof JNDINameProperty) {
            return ((JNDINameProperty)property).getMCFClassNames();
        }
        if (property instanceof BaseSingleValuedProperty && (ra = JndiPropertyUtils.getResourceAdapter(property)) != null) {
            return ra.getManagedConnectionFactoryNames();
        }
        return null;
    }

    public static String[] getASClassNames(IPropertyDescriptor property) {
        IResourceAdapterDescriptor.IMessageListenerDescriptor[] mls;
        IResourceAdapterDescriptor ra = JndiPropertyUtils.getResourceAdapter(property);
        ArrayList<String> found = new ArrayList<String>();
        IResourceAdapterDescriptor.IMessageListenerDescriptor[] iMessageListenerDescriptorArray = mls = ra.getMessageListeners();
        int n = mls.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceAdapterDescriptor.IMessageListenerDescriptor m = iMessageListenerDescriptorArray[n2];
            found.add(m.getActivationSpecName());
            ++n2;
        }
        return found.toArray(new String[0]);
    }

    public static IPropertyGroup getInitializePropertyGroup(IPropertyDescriptor property) {
        if (property instanceof JNDINameProperty) {
            return ((JNDINameProperty)property).getInitializePropertyGroup();
        }
        if (property instanceof BaseSingleValuedProperty) {
            try {
                return JndiPropertyUtils.getOriginalPropertyGroup(property);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static J2CServiceDescription getJ2CServiceDescription(IPropertyDescriptor property) {
        if (property instanceof JNDINameProperty) {
            return ((JNDINameProperty)property).getOutboundServiceDescription();
        }
        if (property instanceof BaseSingleValuedProperty) {
            IPropertyDescriptor parent = property.getParent();
            if (parent instanceof ConnectionPropertyGroup) {
                return ((ConnectionPropertyGroup)parent).getJ2CServiceDescription();
            }
            if (parent instanceof InboundConnectionPropertyGroup) {
                return ((InboundConnectionPropertyGroup)parent).getServiceDescriptionWrapper();
            }
        }
        return null;
    }

    public static void setServerId(IPropertyDescriptor property, String serverId) {
        if (property instanceof JNDINameProperty) {
            ((JNDINameProperty)property).setServerId(serverId);
        }
    }

    public static int getNumberOfColumn(IPropertyDescriptor property) {
        if (property instanceof JNDINameProperty && ((JNDINameProperty)property).canEditJNDI()) {
            return 4;
        }
        if (property instanceof BaseSingleValuedProperty) {
            return 4;
        }
        return -1;
    }
}

