/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.internal.build.IBuildAgent;
import com.ibm.adapter.framework.internal.build.IServiceBuilder;
import com.ibm.adapter.framework.registry.IRegistry;
import com.ibm.adapter.framework.registry.RegistryFactory;
import com.ibm.adapter.framework.registry.ResourceWriter;
import com.ibm.adapter.framework.util.QNameHelper;
import com.ibm.adapter.j2c.codegen.writer.J2CCodegenConstants;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.j2c.ui.core.internal.utilities.J2CImplTypeSearchScope;
import com.ibm.j2c.ui.core.internal.utilities.J2CUICoreHelper;
import com.ibm.j2c.ui.core.internal.utilities.J2CUIPropertyUtil;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.datastore.GenerateResourceAdapter;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.model.J2CRAExtensionPointInfo;
import com.ibm.j2c.ui.internal.model.J2CUIInfo;
import com.ibm.propertygroup.IPropertyGroup;
import commonj.connector.metadata.MetadataConfigurationType;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class J2CUIHelper
extends J2CUICoreHelper {
    private static J2CUIHelper uiHelper_;
    public final String IBM_WS_PLATFORM_WORKSPACE_PREFIX = "platform:/resource";
    public final String IBM_WS_PLATFORM_FILESYSTEM_PREFIX = "file:";
    public final IPath[] UNCLASSIFIED_PATH = new IPath[]{new Path("UNCLASSIFIED")};
    public final IPath[] RAD_PATH = new IPath[]{new Path("RAD")};

    public static J2CUIHelper instance() {
        if (uiHelper_ == null) {
            uiHelper_ = new J2CUIHelper();
        }
        return uiHelper_;
    }

    public J2CRAExtensionPointInfo getRAExtensionPointInfo(String dName, String vendor, String version) {
        ArrayList<J2CRAExtensionPointInfo> j2cRAEPInfoList = null;
        if (j2cRAEPInfoList == null) {
            j2cRAEPInfoList = this.initRAExtensionPointInfoList();
        }
        J2CRAExtensionPointInfo closestInfo = null;
        int closestDiff = -1;
        int i = 0;
        while (i < j2cRAEPInfoList.size()) {
            boolean sameResourceAdapter;
            J2CRAExtensionPointInfo info = j2cRAEPInfoList.get(i);
            boolean bl = sameResourceAdapter = dName.equals(info.getDisplayName()) && vendor.equals(info.getVendor());
            if (sameResourceAdapter) {
                if (version.equals(info.getVersion())) {
                    return info;
                }
                if (closestInfo == null) {
                    closestInfo = info;
                    closestDiff = this.diffVersionNo(info.getVersion(), version);
                    if (closestDiff < 0) {
                        closestDiff = -closestDiff;
                    }
                } else {
                    int diff = this.diffVersionNo(info.getVersion(), version);
                    if (diff < 0) {
                        diff = -diff;
                    }
                    if (diff < closestDiff) {
                        closestDiff = diff;
                        closestInfo = info;
                    }
                }
            }
            ++i;
        }
        return closestInfo;
    }

    public ArrayList<J2CRAExtensionPointInfo> initRAExtensionPointInfoList() {
        ArrayList<J2CRAExtensionPointInfo> j2cRAEPInfoList = new ArrayList<J2CRAExtensionPointInfo>(6);
        ArrayList<String> j2cSpecEPList = new ArrayList<String>();
        ArrayList<String> j2cContextHelpList = new ArrayList<String>();
        IConfigurationElement[] raExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.j2c.ui.J2CResourceAdapterInfo");
        int i = 0;
        while (i < raExtensionPoints.length) {
            if (raExtensionPoints[i].getName().equals("InfoPopContextHelp")) {
                String help = raExtensionPoints[i].getAttribute("interactionspeccontext");
                if (help != null && help.length() > 0) {
                    j2cSpecEPList.add("interactionspeccontext");
                    j2cContextHelpList.add(help);
                }
                if ((help = raExtensionPoints[i].getAttribute("connectionspeccontext")) != null && help.length() > 0) {
                    j2cSpecEPList.add("connectionspeccontext");
                    j2cContextHelpList.add(help);
                }
                if ((help = raExtensionPoints[i].getAttribute("mfccontext")) != null && help.length() > 0) {
                    j2cSpecEPList.add("mfccontext");
                    j2cContextHelpList.add(help);
                }
                if ((help = raExtensionPoints[i].getAttribute("DAInitializationContextId")) != null && help.length() > 0) {
                    j2cSpecEPList.add("DAInitializationContextId");
                    j2cContextHelpList.add(help);
                }
                if ((help = raExtensionPoints[i].getAttribute("DASearchQueryContextId")) != null && help.length() > 0) {
                    j2cSpecEPList.add("DASearchQueryContextId");
                    j2cContextHelpList.add(help);
                }
                if ((help = raExtensionPoints[i].getAttribute("DAImportParamContextId")) != null && help.length() > 0) {
                    j2cSpecEPList.add("DAImportParamContextId");
                    j2cContextHelpList.add(help);
                }
                if ((help = raExtensionPoints[i].getAttribute("ConfigParamContextId")) != null && help.length() > 0) {
                    j2cSpecEPList.add("ConfigParamContextId");
                    j2cContextHelpList.add(help);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < raExtensionPoints.length) {
            if (raExtensionPoints[i2].getName().equals("ResourceAdapter")) {
                String dName = raExtensionPoints[i2].getAttribute("displayName");
                String vendor = raExtensionPoints[i2].getAttribute("vendor");
                String icon = raExtensionPoints[i2].getAttribute("icon");
                String timage = raExtensionPoints[i2].getAttribute("topologyImage");
                String version = raExtensionPoints[i2].getAttribute("version");
                if (dName != null && vendor != null && version != null && dName.length() >= 1 && vendor.length() >= 1 && version.length() >= 1) {
                    IConfigurationElement[] helpExtensionPoints = raExtensionPoints[i2].getChildren("InfoPopContextHelp");
                    int m = 0;
                    while (m < helpExtensionPoints.length) {
                        String specclass = helpExtensionPoints[m].getAttribute("class");
                        String context = helpExtensionPoints[m].getAttribute("context");
                        if (specclass != null && specclass.length() > 0 && context != null && context.length() > 0) {
                            j2cSpecEPList.add(specclass);
                            j2cContextHelpList.add(context);
                        }
                        ++m;
                    }
                    J2CRAExtensionPointInfo info = null;
                    int j = 0;
                    while (j < j2cRAEPInfoList.size()) {
                        J2CRAExtensionPointInfo tmpInfo = j2cRAEPInfoList.get(j);
                        if (dName.equals(tmpInfo.getDisplayName()) && vendor.equals(tmpInfo.getVendor()) && version.equals(tmpInfo.getVersion())) {
                            info = tmpInfo;
                            break;
                        }
                        ++j;
                    }
                    if (info == null) {
                        info = new J2CRAExtensionPointInfo();
                        j2cRAEPInfoList.add(info);
                        info.setDisplayName(dName);
                        info.setVendor(vendor);
                        info.setIconPath(icon);
                        info.setTopologyImagePath(timage);
                        info.setVersion(version);
                        int k = 0;
                        while (k < j2cSpecEPList.size()) {
                            info.setContextHelp((String)j2cSpecEPList.get(k), (String)j2cContextHelpList.get(k));
                            ++k;
                        }
                    }
                }
            }
            ++i2;
        }
        return j2cRAEPInfoList;
    }

    public int diffVersionNo(String version1, String version2) {
        int idxBig;
        int idxSmall;
        if (version1.equals(version2)) {
            return 0;
        }
        ArrayList[] elements = new ArrayList[]{new ArrayList(4), new ArrayList(4)};
        StringTokenizer st = new StringTokenizer(version1, ".");
        while (st.hasMoreTokens()) {
            elements[0].add(st.nextToken());
        }
        st = new StringTokenizer(version2, ".");
        while (st.hasMoreTokens()) {
            elements[1].add(st.nextToken());
        }
        int size = Math.min(elements[0].size(), elements[1].size());
        int index = 0;
        int i = 0;
        while (i < size) {
            index = i;
            if (!elements[0].get(i).equals(elements[1].get(i))) break;
            ++i;
        }
        size = Math.max(elements[0].size(), elements[1].size());
        if (elements[1].size() == size) {
            idxSmall = 0;
            idxBig = 1;
        } else {
            idxSmall = 1;
            idxBig = 0;
        }
        int i2 = elements[idxSmall].size();
        while (i2 < size) {
            StringBuffer newStr = new StringBuffer();
            int j = 0;
            while (j < ((String)elements[idxBig].get(i2)).length()) {
                newStr.append(0);
                ++j;
            }
            elements[idxSmall].add(newStr.toString());
            ++i2;
        }
        StringBuffer ver1 = new StringBuffer();
        StringBuffer ver2 = new StringBuffer();
        int i3 = index;
        while (i3 < size) {
            ver1.append(this.getVersionString(elements[0], i3, ((String)elements[1].get(i3)).length()));
            ver2.append(this.getVersionString(elements[1], i3, ((String)elements[0].get(i3)).length()));
            ++i3;
        }
        return this.parseVersion(ver1.toString()) - this.parseVersion(ver2.toString());
    }

    private String getVersionString(ArrayList elements, int index, int length) {
        StringBuffer newStr = new StringBuffer();
        if (index >= elements.size()) {
            int i = 0;
            while (i < length) {
                newStr.append(0);
                ++i;
            }
        } else {
            newStr = new StringBuffer((String)elements.get(index));
            int size = newStr.length();
            int i = 0;
            while (i < length - size) {
                newStr.append(0);
                ++i;
            }
        }
        return newStr.toString();
    }

    public Integer parseVersion(String version) {
        StringCharacterIterator iterator = new StringCharacterIterator(version);
        char[] digits = new char[version.length()];
        int i = 0;
        char c = iterator.first();
        while (c != '\uffff') {
            if (Character.isDigit(c)) {
                digits[i++] = c;
            }
            c = iterator.next();
        }
        return new Integer(new String(digits).trim());
    }

    public boolean codeGeneration(J2CUIInfo uiInfo, IServiceBuilder serviceBuilder) throws Exception {
        if (serviceBuilder != null) {
            serviceBuilder.completeBuildProcess(uiInfo.Environment_);
        }
        if (uiInfo.writerInfo_ != null && uiInfo.writerInfo_.getPublishingSet() != null && uiInfo.writerInfo_.getWriteProperties() != null) {
            this.checkAnnotationBuilder(uiInfo.writerInfo_.getWriteProperties());
            uiInfo.writerInfo_.getResourceWriter().performWrite(uiInfo.Environment_, uiInfo.writerInfo_.getPublishingSet());
        }
        return true;
    }

    public boolean codeGeneration(J2CUIInfo uiInfo) throws Exception {
        if (uiInfo.writerInfo_ != null && uiInfo.writerInfo_.getPublishingSet() != null && uiInfo.writerInfo_.getWriteProperties() != null) {
            this.checkAnnotationBuilder(uiInfo.writerInfo_.getWriteProperties());
            uiInfo.writerInfo_.getResourceWriter().performWrite(uiInfo.Environment_, uiInfo.writerInfo_.getPublishingSet());
        }
        return true;
    }

    public void checkAnnotationBuilder(IPropertyGroup writeProperties) {
        String[] names = J2CUIPropertyUtil.getJavaClassPathNames((IPropertyGroup)writeProperties);
        if (names != null && names[0] != null && names[0].length() > 0) {
            ResourceUtils.checkAnnotationBuilder((String)names[0]);
        }
    }

    public void enableComposite(Composite comp, boolean enable) {
        if (comp == null) {
            return;
        }
        Control[] controls = comp.getChildren();
        comp.setEnabled(enable);
        int i = 0;
        while (i < controls.length) {
            if (!(controls[i] instanceof Composite)) {
                controls[i].setEnabled(enable);
            } else {
                this.enableComposite((Composite)controls[i], enable);
            }
            ++i;
        }
    }

    public IType browseJ2CJavaBeanFromWorkspace(Shell shell) {
        return this.browseJ2CJavaBeanFromWorkspace(shell, (IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    public IType browseJ2CJavaBeanFromWorkspace(Shell shell, IResource[] resources) {
        ArrayList<IJavaProject> searchTypes = new ArrayList<IJavaProject>();
        Object type = null;
        int i = 0;
        while (i < resources.length) {
            IJavaElement javaElement = JavaCore.create((IResource)resources[i]);
            if (javaElement != null) {
                if (javaElement instanceof IJavaProject) {
                    IJavaProject project = (IJavaProject)javaElement;
                    IProject projct = ((IJavaProject)javaElement).getProject();
                    if (ResourceUtils.getJ2EEProjectType((IProject)projct).length() != 0) {
                        if (ResourceUtils.isTrueJavaProject((IProject)project.getProject()) || ResourceUtils.isDynamicWebProject((IProject)project.getProject()) || ResourceUtils.isEJBProject((IProject)project.getProject())) {
                            searchTypes.add(project);
                        }
                    } else if (ResourceUtils.isJavaProject((IProject)projct)) {
                        searchTypes.add(project);
                    }
                }
                if (type != null && searchTypes.indexOf(type) == -1) {
                    searchTypes.add((IJavaProject)type);
                }
            }
            ++i;
        }
        try {
            J2CImplTypeSearchScope scope = new J2CImplTypeSearchScope(searchTypes, resources);
            SelectionDialog selDialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)scope, (int)256, (boolean)false);
            selDialog.setTitle(J2CUIMessages.J2C_JNDIWIZARD_BEANSELECTION_FINDJ2CBEAN);
            if (selDialog.open() == 0) {
                return (IType)selDialog.getResult()[0];
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    public QName getJ2CJavaBeanResourceWriterQName() {
        return J2CCodegenConstants.J2C_OUTBOUND_ADAPTER_RESOURCE_WRITER_QNAME;
    }

    public IResourceWriter getResourceWriter(QName name) {
        try {
            IRegistry registry = RegistryFactory.getFactory().getRegistry();
            ResourceWriter writer = registry.getResourceWriter(name);
            return writer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public QName convertStringToQName(String fullName) {
        if (fullName != null) {
            int indx = fullName.lastIndexOf(46);
            String packName = "";
            if (indx >= 0) {
                packName = fullName.substring(0, indx);
            }
            String simpleName = fullName;
            if (indx >= 0) {
                simpleName = fullName.substring(indx + 1, fullName.length());
            }
            return QNameHelper.createQName((String)packName, (String)simpleName);
        }
        return null;
    }

    public String encodeURLString(String urlStr) throws Exception {
        return URLEncoder.encode(urlStr, "UTF-8");
    }

    public String decodeURLString(String urlStr) throws Exception {
        return URLDecoder.decode(urlStr, "UTF-8");
    }

    public Set<IRuntime> getProjectTargetedRuntimes(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project).getTargetedRuntimes();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean checkServerRuntime(IProject project, String rarFile) {
        if (project != null) {
            Set<IRuntime> runtimes;
            GenerateResourceAdapter.setRAProject(project.getName());
            if (rarFile != null) {
                GenerateResourceAdapter.setRAfile(rarFile);
            }
            if ((runtimes = J2CUIHelper.instance().getProjectTargetedRuntimes(project)) != null && !runtimes.isEmpty() && runtimes.iterator().next() != null) {
                GenerateResourceAdapter.setRAruntime(runtimes.iterator().next().getLocalizedName());
                return true;
            }
        }
        return false;
    }

    public ArrayList<ArrayList> getJ2CWritePropertyInfo(IPropertyGroup propertyGroup) {
        IPropertyGroup pg;
        String name = propertyGroup.getName();
        if (("J2C Java Bean Writer Properties".equals(name) || "J2C MessageDriven EJB Writer Properties".equals(name)) && (pg = (IPropertyGroup)propertyGroup.getProperty("SAVE_LOCATION_PG_NAME")) != null) {
            return J2CUIPropertyUtil.getProperties((IPropertyGroup)pg);
        }
        return J2CUIPropertyUtil.getProperties((IPropertyGroup)propertyGroup);
    }

    public boolean isOutboundScenario(IBuildAgent agent) {
        String[] configurations = agent.getConfiguration();
        if (configurations != null) {
            int i = 0;
            while (i < configurations.length) {
                if (MetadataConfigurationType.INBOUND_SERVICE.toString().equals(configurations[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

