/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.text.edits.MalformedTreeException;

public class J2CDeltaUtil {
    private static HashMap delta4AllMethods;

    public static void dump(String str) {
    }

    public static HashMap getDelta4AllMethods() {
        return delta4AllMethods;
    }

    public static void setDelta4AllMethods(HashMap map) {
        delta4AllMethods = map;
    }

    public static List deltaTransferProcess(SimpleName na, Javadoc jd) {
        List tagList = jd.tags();
        ArrayList<TagElement> transferList = new ArrayList<TagElement>();
        if (tagList != null) {
            int r = 0;
            while (r < tagList.size()) {
                TagElement tE = (TagElement)tagList.get(r);
                String tEName = tE.getTagName();
                if (tEName.equals("@j2c.connectionSpec-property") || tEName.equals("@j2c.interactionSpec-property") || tEName.equals("@j2c.interactionSpec-returnProperty") || tEName.equals("@generated") || tEName.equals("@j2c.interactionSpec")) {
                    String fragment = "";
                    if (tE.fragments() != null && tE.fragments().size() > 0) {
                        fragment = ((TextElement)tE.fragments().get(0)).getText().trim();
                        String name = "";
                        if (fragment.indexOf("value") >= 0) {
                            name = fragment.substring("name=\"".length(), fragment.indexOf("value") - 1);
                        } else if (fragment.indexOf("argumentBinding") >= 0) {
                            name = fragment.substring("name=\"".length(), fragment.indexOf("argumentBinding") - 1);
                        } else if (fragment.indexOf("outputBinding") >= 0) {
                            name = fragment.substring("name=\"".length(), fragment.indexOf("outputBinding") - 1);
                        }
                        if (name.endsWith("\"")) {
                            name = name.substring(0, name.length() - 1);
                        }
                    }
                } else {
                    transferList.add(tE);
                }
                ++r;
            }
        }
        return transferList;
    }

    public static void transferDeltaAnnotationsForAll(ICompilationUnit cu) {
        HashMap methodsDelta = J2CDeltaUtil.getDelta4AllMethods();
        if (methodsDelta == null || methodsDelta.isEmpty()) {
            return;
        }
        try {
            cu.getSource();
            cu.reconcile(0, true, null, (IProgressMonitor)new NullProgressMonitor());
            cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
            J2CDeltaUtil.transferDeltaAnnotations(cu, methodsDelta, true);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public static void transferDeltaAnnotations(ICompilationUnit cu, HashMap methodsDelta, boolean commit) {
        String[] pTypeSignatures = new String[1];
        Set methodsKey = methodsDelta.keySet();
        if (methodsKey != null) {
            for (String methodNameKey : methodsKey) {
                int index = methodNameKey.indexOf(":");
                if (index == -1) {
                    index = methodNameKey.length();
                }
                String methodName = methodNameKey.substring(0, index);
                methodNameKey.substring(index + 1);
                ArrayList parameters = null;
                List tagList = (List)methodsDelta.get(methodNameKey);
                if (tagList != null && tagList.size() > 0) {
                    int k = 0;
                    while (k < tagList.size()) {
                        int plength;
                        if (tagList.get(k) instanceof AnnotationInfo) {
                            AnnotationInfo cfr_ignored_0 = (AnnotationInfo)tagList.get(k);
                        } else if (!(tagList.get(k) instanceof TagElement) && tagList.get(k) instanceof ArrayList && (plength = (parameters = (ArrayList)tagList.get(k)).size()) > 0) {
                            pTypeSignatures = new String[plength];
                            int j = 0;
                            while (j < plength) {
                                pTypeSignatures[j] = (String)parameters.get(j);
                                ++j;
                            }
                        }
                        ++k;
                    }
                }
                try {
                    String[] parameterTypeSignatures = new String[pTypeSignatures.length];
                    if (pTypeSignatures == null) continue;
                    int i = 0;
                    while (i < pTypeSignatures.length) {
                        parameterTypeSignatures[i] = Signature.createTypeSignature((String)pTypeSignatures[i], (boolean)false);
                        ++i;
                    }
                    IMethod meth = cu.findPrimaryType().getMethod(methodName, parameterTypeSignatures);
                    if (meth == null) continue;
                    meth.getPrimaryElement();
                    if (tagList == null) continue;
                    int t = 0;
                    while (t < tagList.size()) {
                        if (tagList.get(t) instanceof AnnotationInfo) {
                            AnnotationInfo aInfo = (AnnotationInfo)tagList.get(t);
                            try {
                                InternalUtils.addAnnotationToCUafterJavaDoc((ICompilationUnit)cu, (String)aInfo.getPackageName(), (String)aInfo.annotToString(), (IJavaElement)meth, (boolean)commit);
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                        ++t;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return;
                }
            }
        }
    }

    public static List findAnnotations4Method(List<AnnotationInfo> alist, String methodName) {
        ArrayList<AnnotationInfo> AnnotationMap = new ArrayList<AnnotationInfo>();
        if (alist != null && alist.size() > 0) {
            int aa = 0;
            while (aa < alist.size()) {
                String thisJeName;
                AnnotationInfo ainfo = alist.get(aa);
                if (ainfo != null && ainfo.getAnnotation() != null && (thisJeName = ainfo.getParentJavaElementInfo().getJavaElement().getElementName()).equals(methodName)) {
                    try {
                        AnnotationMap.add(ainfo);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
                ++aa;
            }
        }
        return AnnotationMap;
    }
}

