/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.framework.IEnvironment;
import com.ibm.adapter.framework.IImportResult;
import com.ibm.adapter.framework.IPublishingObject;
import com.ibm.adapter.framework.IPublishingSet;
import com.ibm.adapter.framework.IResourceWriter;
import com.ibm.adapter.framework.spi.BasePublishingObject;
import com.ibm.adapter.framework.spi.BasePublishingSet;
import com.ibm.adapter.framework.spi.BaseResourceWriter;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.FolderProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class EMDWorkspaceResourceTestWriter
extends BaseResourceWriter {
    private static QName writerQname = null;
    private static String DISPLAY_NAME = "EIS Discovery Writer For Testing";
    private static String DESCRIPTION = "Enterprise MetaData Discovery Service workspace resource testing writer.";

    static {
        writerQname = new QName("com/ibm/adapter/emdwriter", "EISImportExportWriter");
    }

    public EMDWorkspaceResourceTestWriter() {
        super(writerQname, DISPLAY_NAME, DESCRIPTION);
        this.setInitializeProperties(null);
    }

    public IPropertyGroup initialize(IEnvironment importEnvironment, IImportResult importResult) throws BaseException {
        this.initialize(importEnvironment, (IPropertyGroup)null);
        IPublishingSet publishingSet = this.createPublishingSet(importResult);
        IPropertyGroup writeProps = publishingSet.createPublishingProperties();
        publishingSet.applyPublishingProperties(writeProps);
        return writeProps;
    }

    public void initialize(IEnvironment environment, IPropertyGroup initializeProperties) throws BaseException {
        super.initialize(environment, initializeProperties);
    }

    public IResourceWriter newInstance() {
        return new EMDWorkspaceResourceTestWriter();
    }

    public URI writeToWorkspace(IPropertyGroup writeProperties, IEnvironment environment) throws BaseException {
        return null;
    }

    public URI performWrite(IEnvironment environment, IPublishingSet publishingSet) throws BaseException {
        if (!(publishingSet instanceof TestPublishingSet)) {
            BaseException be = BaseException.createException((String)"Invalid publishing set!", null);
            throw be;
        }
        URI uri = null;
        IPublishingObject[] pobjs = publishingSet.getPublishingObjects();
        if (pobjs != null && pobjs.length > 0 && publishingSet instanceof TestPublishingSet) {
            TestPublishingObject[] tpobjs = new TestPublishingObject[pobjs.length];
            int i = 0;
            while (i < pobjs.length) {
                tpobjs[i] = (TestPublishingObject)pobjs[i];
                ++i;
            }
            try {
                uri = this.generateFile(environment, tpobjs, (EMDTestWriterPropertyGroup)((TestPublishingSet)publishingSet).getPublishingProperties());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        return uri;
    }

    public IPublishingSet createPublishingSet(IImportResult result) throws BaseException {
        try {
            return new TestPublishingSet(result);
        }
        catch (CoreException exc) {
            throw new BaseException(exc.getStatus());
        }
    }

    protected URI generateFile(IEnvironment environment, TestPublishingObject[] objs, EMDTestWriterPropertyGroup properties) throws BaseException, FileNotFoundException, IOException {
        String path = properties.getFullPath();
        FileOutputStream f = new FileOutputStream(path);
        if (environment == null) {
            new NullProgressMonitor();
        } else {
            environment.getProgressMonitor();
        }
        ((OutputStream)f).close();
        return null;
    }

    protected class EMDTestWriterPropertyGroup
    extends BasePropertyGroup {
        protected FolderProperty path_;
        protected BaseSingleValuedProperty name_;
        protected BaseSingleValuedProperty overwrite_;
        public static final String PATH_KEY = "File path";
        public static final String NAME_KEY = "File name";
        public static final String OVERWRITE_KEY = "Overwrite";

        public EMDTestWriterPropertyGroup() throws CoreException {
            super("EMD_Test_Writer", "EMD Test Writer", "EMD Test Writer");
            this.initializePropertyGroup();
        }

        private void initializePropertyGroup() throws CoreException {
            this.path_ = new FolderProperty(PATH_KEY, PATH_KEY, "Path of output file.", (BasePropertyGroup)this);
            this.path_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
            this.path_.setRequired(true);
            this.name_ = new BaseSingleValuedProperty(NAME_KEY, NAME_KEY, "Name of output file.", String.class, (BasePropertyGroup)this);
            this.name_.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
            this.name_.setRequired(true);
            this.overwrite_ = new BaseSingleValuedProperty(OVERWRITE_KEY, OVERWRITE_KEY, OVERWRITE_KEY, Boolean.class, (BasePropertyGroup)this);
            this.overwrite_.setValue((Object)Boolean.TRUE);
            this.overwrite_.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public FolderProperty getPathProperty() {
            return this.path_;
        }

        public BaseSingleValuedProperty getNameProperty() {
            return this.name_;
        }

        public String getFullPath() {
            if (this.path_.getValue() != null && this.name_.getValue() != null) {
                StringBuffer path = new StringBuffer(this.path_.getValueAsString().trim());
                if (path.length() > 0) {
                    String name = this.name_.getValueAsString().trim();
                    if (name.length() > 0) {
                        path.append(File.separator);
                        int index = name.indexOf(".");
                        if (index != -1) {
                            path.append(name);
                            if (index == name.length() - 1) {
                                path.append("txt");
                            }
                        } else {
                            path.append(name).append(".txt");
                        }
                    } else {
                        path = null;
                    }
                } else {
                    path = null;
                }
                if (path != null) {
                    return path.toString();
                }
            }
            return null;
        }

        public Object clone() throws CloneNotSupportedException {
            EMDTestWriterPropertyGroup group = (EMDTestWriterPropertyGroup)((Object)super.clone());
            FolderProperty path = (FolderProperty)group.getProperty(PATH_KEY);
            BaseSingleValuedProperty name = (BaseSingleValuedProperty)group.getProperty(NAME_KEY);
            BaseSingleValuedProperty overwrite = (BaseSingleValuedProperty)group.getProperty(OVERWRITE_KEY);
            group.path_ = path;
            group.name_ = name;
            group.overwrite_ = overwrite;
            path.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
            name.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
            overwrite.addVetoablePropertyChangeListener((IVetoableChangeListener)group);
            return group;
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            String path = null;
            String name = null;
            boolean overwrite = true;
            if (evt.getSource() == this.path_) {
                path = ((URI)evt.getNewValue()).toFileString();
                name = this.name_.getValueAsString();
                overwrite = (Boolean)this.overwrite_.getValue();
            } else if (evt.getSource() == this.name_) {
                path = this.path_.getValueAsString();
                name = (String)evt.getNewValue();
                overwrite = (Boolean)this.overwrite_.getValue();
            } else if (evt.getSource() == this.overwrite_) {
                path = this.path_.getValueAsString();
                name = this.name_.getValueAsString();
                overwrite = (Boolean)evt.getNewValue();
            }
            this.validFile(path, name, overwrite, evt);
        }

        protected void validFile(String path, String name, boolean overwrite, PropertyChangeEvent evt) throws PropertyVetoException {
            File file;
            int index;
            if (path == null || name == null || path.trim().length() < 1 || name.trim().length() < 1) {
                return;
            }
            StringBuffer loc = new StringBuffer(path);
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                loc.append(File.separator);
            }
            if ((index = name.indexOf(".")) != -1) {
                loc.append(name);
                if (index == name.length() - 1) {
                    loc.append("txt");
                }
            } else {
                loc.append(name).append(".txt");
            }
            if ((file = new File(loc.toString())).exists() && !overwrite) {
                throw new PropertyVetoException("The file already exists.", (java.beans.PropertyChangeEvent)evt);
            }
        }
    }

    public class TestPublishingObject
    extends BasePublishingObject {
    }

    protected class TestPublishingSet
    extends BasePublishingSet {
        private IImportResult importResult_ = null;

        public TestPublishingSet() {
        }

        public TestPublishingSet(IImportResult importResult) throws CoreException {
            this.importResult_ = importResult;
            this.publishingProperties = new EMDTestWriterPropertyGroup();
        }

        public IPublishingObject[] getPublishingObjects() {
            IPublishingObject[] objs = null;
            return objs;
        }

        public boolean publishCheck() throws BaseException {
            return true;
        }

        public IPropertyGroup getPublishingProperties() {
            return this.currentPublishingProperties;
        }
    }
}

