/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.adapter.emd.extension.description.J2CParameterDescription;
import com.ibm.adapter.emd.extension.description.ParameterDescription;
import com.ibm.adapter.emd.extension.description.spi.DataDescription;
import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.emd.extension.description.spi.OutboundFunctionDescription;
import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.j2c.edit.J2CJavaBeanEdit;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.adapter.j2ca.IResourceAdapterRegistry;
import com.ibm.adapter.j2ca.RegistryFactory;
import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.rar.operations.jmx.internal.utils.JmxUtils;
import com.ibm.j2c.ui.core.CoreConstants;
import com.ibm.j2c.ui.core.internal.utilities.J2CLogUtil;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.model.DeploymentOptionInfo;
import com.ibm.j2c.ui.internal.model.IDeploymentMethod;
import com.ibm.j2c.ui.internal.model.IWasCommonUtils;
import com.ibm.j2c.ui.internal.properties.CommonDeploymentPropertyGroup;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.j2c.ui.internal.utilities.J2CCodeParsingUtil;
import com.ibm.j2c.ui.internal.utilities.J2CDeltaUtil;
import com.ibm.j2c.ui.internal.utilities.J2CUIHelper;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import commonj.connector.metadata.description.DataFile;
import commonj.connector.metadata.description.FunctionDescription;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.jca.ConnectionDefinition;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationOperation;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class DeploymentUtils {
    public static void addUtilityProjectToModule(String utilityProjectName, String moduleName, IVirtualComponent componentParent) {
        if (componentParent == null) {
            return;
        }
        IProject dataProj = ResourceUtils.getWorkspaceRoot().getProject(utilityProjectName);
        IVirtualComponent component1 = ComponentCore.createComponent((IProject)dataProj);
        IVirtualComponent childComponent = ComponentCore.createComponent((IProject)dataProj);
        ArrayList<IVirtualComponent> vList = new ArrayList<IVirtualComponent>();
        vList.add(childComponent);
        if (ResourceUtils.isTrueJavaProject((IProject)dataProj)) {
            IVirtualReference ref;
            JavaProjectMigrationOperation op = J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)dataProj);
            if (op != null && op.canExecute()) {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            if (ResourceUtils.isDynamicWebProject((IProject)componentParent.getProject())) {
                try {
                    CreateReferenceComponentsOp opp = ComponentUtilities.createWLPReferenceComponentOperation((IVirtualComponent)componentParent, vList);
                    if (opp != null && opp.canExecute()) {
                        opp.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (J2EEProjectUtilities.isEARProject((IProject)componentParent.getProject()) && !(ref = ComponentCore.createReference((IVirtualComponent)componentParent, (IVirtualComponent)component1)).exists()) {
                DeploymentUtils.waitForBuildJobs(3);
                ref.create(0, null);
            }
        } else {
            AddComponentToEnterpriseApplicationDataModelProvider addProv = new AddComponentToEnterpriseApplicationDataModelProvider();
            IDataModel addModel = DataModelFactory.createDataModel((IDataModelProvider)addProv);
            addModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)componentParent);
            addModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", vList);
            try {
                addModel.getDefaultOperation().execute(null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Vector getEARModules() {
        Vector<IVirtualComponent> moduleEARs = new Vector<IVirtualComponent>();
        IProject[] projs = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ear");
        int i = 0;
        while (i < projs.length) {
            IVirtualComponent comp = ComponentCore.createComponent((IProject)projs[i]);
            moduleEARs.add(comp);
            ++i;
        }
        return moduleEARs;
    }

    public static boolean checkForV6Server(Connector conn) {
        boolean b2;
        boolean result = true;
        if (conn == null) {
            return result;
        }
        boolean b1 = conn.getVendorName().toLowerCase().indexOf("ibm") >= 0 && conn.getEisType().toLowerCase().indexOf("cics") >= 0 && !conn.getSpecVersion().equals("1.0");
        boolean bl = b2 = conn.getVendorName().toLowerCase().indexOf("ibm") >= 0 && conn.getEisType().toLowerCase().indexOf("ims") >= 0 && !conn.getSpecVersion().equals("1.0");
        if (b1 || b2) {
            boolean serverFound = false;
            IServer[] servers = ServerCore.getServers();
            int u = 0;
            while (u < servers.length) {
                IServer server = servers[u];
                int serverVersion = DeploymentHelper.instance().getWASServerVersion(server);
                if (serverVersion >= 60) {
                    serverFound = true;
                    break;
                }
                ++u;
            }
            result = serverFound;
        }
        return result;
    }

    public static void waitForBuildJobs(int periods) {
        DeploymentUtils.waitForBuildJobs(periods, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void waitForBuildJobs(int periods, IProgressMonitor monitor) {
        int j = 0;
        while (j < periods) {
            IJobManager jobManager = Job.getJobManager();
            try {
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            }
            catch (Exception exception) {}
            try {
                jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                jobManager.join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
    }

    public static Hashtable getAllDataTypeProjectNames(FunctionDescription[] ofd, boolean notusedfonow) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (ofd == null) {
            return result;
        }
        int g = 0;
        while (g < ofd.length) {
            String name;
            DataFile[] files;
            String sURI;
            FunctionDescription methDef = ofd[g];
            if (methDef.getInputDataDescription() != null) {
                sURI = null;
                files = methDef.getInputDataDescription().getDataFiles();
                if (files != null && files.length > 0) {
                    try {
                        sURI = J2CUIHelper.instance().decodeURLString(files[0].getLocation().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    name = ResourceUtils.extractNameFromURI(sURI);
                    if (name != null) {
                        result.put(name, name);
                    }
                }
            }
            if (methDef.getOutputDataDescription() != null) {
                sURI = null;
                files = methDef.getOutputDataDescription().getDataFiles();
                if (files != null && files.length > 0) {
                    try {
                        sURI = J2CUIHelper.instance().decodeURLString(files[0].getLocation().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    name = ResourceUtils.extractNameFromURI((String)sURI);
                    if (name != null) {
                        result.put(name, name);
                    }
                }
            }
            ++g;
        }
        return result;
    }

    public static void updateReference(IProject proj, String reName) {
        if (proj != null && ResourceUtils.isDynamicWebProject((IProject)proj)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)proj);
            WebArtifactEdit editWeb = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
            new Float(J2EEProjectUtilities.getJ2EEProjectVersion((IProject)component.getProject())).floatValue();
            WebApp webApp = editWeb.getWebApp();
            if (DeploymentUtils.resourceReferenceDefined(webApp.getResourceRefs().iterator(), reName)) {
                return;
            }
        }
    }

    public static boolean resourceReferenceDefined(Iterator iter, String refName) {
        boolean result = false;
        while (iter.hasNext()) {
            ResourceRef tempRR = (ResourceRef)iter.next();
            if (!tempRR.getName().equals(refName)) continue;
            result = true;
        }
        return result;
    }

    public static Hashtable getAllDependentProjects(IType type1) {
        IJavaProject parentPr = type1.getJavaProject();
        Hashtable<String, String> allTypesToCopy = new Hashtable<String, String>();
        Vector dependentTypesV = new Vector();
        Hashtable<String, String> dependentTypesH = new Hashtable<String, String>();
        while (true) {
            J2CCodeParsingUtil codeParse = new J2CCodeParsingUtil();
            codeParse.initialize(type1, parentPr);
            codeParse.lookupAllDependecies();
            dependentTypesV = codeParse.typesToCopy;
            int j = 0;
            while (j < dependentTypesV.size()) {
                String dType = (String)dependentTypesV.get(j);
                if (allTypesToCopy.get(dType) == null) {
                    dependentTypesH.put(dType, dType);
                }
                ++j;
            }
            if (!dependentTypesH.keys().hasMoreElements()) break;
            String newtypeName = (String)dependentTypesH.keys().nextElement();
            allTypesToCopy.put(newtypeName, newtypeName);
            dependentTypesH.remove(newtypeName);
            type1 = DeploymentUtils.getType(newtypeName, parentPr);
        }
        return allTypesToCopy;
    }

    public static IType getType(String typeName, IJavaProject project) {
        IType type = null;
        String packageName = null;
        int indx = typeName.lastIndexOf(".");
        if (indx > 0) {
            packageName = typeName.substring(0, indx);
            typeName = typeName.substring(indx + 1);
        }
        try {
            IPackageFragment fragment;
            int i;
            IPackageFragmentRoot srcPackage = J2CUIHelper.getDefault().getSourcePackage(project);
            IJavaElement[] elements = srcPackage.getChildren();
            if (packageName != null) {
                i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IPackageFragment) {
                        fragment = (IPackageFragment)elements[i];
                        if (fragment.getElementName().equals(packageName)) {
                            type = project.findType(String.valueOf(fragment.getElementName()) + "." + typeName);
                        }
                        if (type != null) {
                            return type;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < elements.length) {
                if (!(elements[i] instanceof IPackageFragment) || (type = project.findType(String.valueOf((fragment = (IPackageFragment)elements[i]).getElementName()) + "." + typeName)) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            J2CLogUtil.log((String)e.getMessage(), (short)60);
        }
        return type;
    }

    public static boolean isAnyServerExtensionDefined() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.RARServerDeploymentInfo");
        IExtension[] extensions = extensionPoint.getExtensions();
        return extensions.length > 0;
    }

    public static Vector hasEARSforJ2EEProj(IProject j2eeProj) {
        Vector res = new Vector();
        if (j2eeProj == null) {
            return res;
        }
        if (j2eeProj.getName() == null) {
            return res;
        }
        if (ResourceUtils.isEJBProject((IProject)j2eeProj) || ResourceUtils.isDynamicWebProject((IProject)j2eeProj)) {
            Vector allEars = DeploymentUtils.getEARModules();
            int u = 0;
            while (u < allEars.size()) {
                IVirtualReference ref = null;
                IVirtualReference[] refs = ((IVirtualComponent)allEars.get(u)).getReferences();
                int i = 0;
                while (i < refs.length) {
                    String rName;
                    IVirtualReference reference = refs[i];
                    if (reference.getReferencedComponent() != null && (rName = reference.getReferencedComponent().getName()) != null && rName.equals(j2eeProj.getName())) {
                        ref = reference;
                        break;
                    }
                    ++i;
                }
                if (ref != null) {
                    res.add(allEars.get(u));
                }
                ++u;
            }
        }
        return res;
    }

    public static String findServerForRarDeploy(IVirtualComponent comp) {
        String sServerId = null;
        IServer serv = null;
        if (comp == null) {
            return null;
        }
        IProject pr = comp.getProject();
        if (pr != null) {
            Vector ears;
            IFacetedProject fProj = null;
            try {
                fProj = ProjectFacetsManager.create((IProject)pr);
            }
            catch (Exception exception) {}
            if (fProj == null) {
                return null;
            }
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runT = fProj.getPrimaryRuntime();
            IRuntime rT = null;
            if (runT != null) {
                rT = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runT);
            }
            if (rT != null) {
                String targetServerTypeId = rT.getRuntimeType().getId();
                IServer[] configuredServers = ServerCore.getServers();
                int i = 0;
                while (i < configuredServers.length) {
                    String serverRuntimeType = configuredServers[i].getRuntime().getRuntimeType().getId();
                    if (serverRuntimeType.equals(targetServerTypeId)) {
                        serv = configuredServers[i];
                        return serv.getId();
                    }
                    ++i;
                }
            }
            if (serv == null && (ears = DeploymentUtils.hasEARSforJ2EEProj(comp.getProject())) != null) {
                int i = 0;
                while (i < ears.size()) {
                    IServer se;
                    Enumeration en;
                    String key;
                    IVirtualComponent ear = (IVirtualComponent)ears.get(i);
                    Hashtable hashServ = DeploymentUtils.getAvailableServers(ear, false, null);
                    if (hashServ != null && !hashServ.isEmpty() && (key = (String)(en = hashServ.keys()).nextElement()) != null && (se = (IServer)hashServ.get(key)) != null) {
                        return se.getId();
                    }
                    ++i;
                }
            }
        }
        if (serv != null) {
            sServerId = serv.getId();
        }
        return sServerId;
    }

    public static synchronized Vector getDeploymentMethodsIds(String wizardId) {
        Vector<String> res = new Vector<String>();
        if (wizardId == null) {
            return res;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.DeploymentOptionsConfig");
        IExtension[] extensions = extensionPoint.getExtensions();
        int r = 0;
        while (r < extensions.length) {
            IExtension currentEx = extensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                String wizId = currentConEl.getAttribute("wizardId");
                if (wizId.equals(wizardId)) {
                    String deploymentMethodIds = currentConEl.getAttribute("deploymentMethodIds");
                    StringTokenizer tokenizer = new StringTokenizer(deploymentMethodIds, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String methodId = tokenizer.nextToken();
                        CoreConstants.dump((String)("Method ID : - " + methodId));
                        res.add(methodId);
                    }
                }
                ++y;
            }
            ++r;
        }
        return res;
    }

    public static synchronized Vector getDeploymentMethods(String wizardId) {
        Vector<DeploymentOptionInfo> res = new Vector<DeploymentOptionInfo>();
        Vector deploymentMethods = DeploymentUtils.getDeploymentMethodsIds(wizardId);
        if (deploymentMethods.isEmpty()) {
            return res;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.DeploymentMethods");
        IExtension[] extensions = extensionPoint.getExtensions();
        int r = 0;
        while (r < extensions.length) {
            IExtension currentEx = extensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                String deployMethodId = currentConEl.getAttribute("id");
                boolean defaultSelection = false;
                String defaultSelectionSt = currentConEl.getAttribute("defaultSelection");
                if (defaultSelectionSt != null && defaultSelectionSt.equals("true")) {
                    defaultSelection = true;
                }
                if (deploymentMethods.contains(deployMethodId)) {
                    String name = currentConEl.getAttribute("name");
                    try {
                        IDeploymentMethod ops = (IDeploymentMethod)currentConEl.createExecutableExtension("class");
                        DeploymentOptionInfo deployOptionInfo = new DeploymentOptionInfo(ops, name, deployMethodId, defaultSelection);
                        CoreConstants.dump((String)("DeploymentOptionInfo name : - " + name));
                        res.add(deployOptionInfo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++y;
            }
            ++r;
        }
        return res;
    }

    public static void updateJNDIName(ICompilationUnit cu1, String jndiName) {
        try {
            ICompilationUnit cu = cu1.getWorkingCopy(null);
            String source = cu.getSource();
            Document doc = new Document(source);
            ASTParser parser1 = ASTParser.newParser((int)3);
            parser1.setSource(doc.get().toCharArray());
            CompilationUnit astCU1 = (CompilationUnit)parser1.createAST(null);
            List l1 = astCU1.types();
            TypeDeclaration td1 = (TypeDeclaration)l1.get(0);
            Javadoc jd1 = td1.getJavadoc();
            ASTRewrite rewrite1 = ASTRewrite.create((AST)jd1.getAST());
            AST ast1 = jd1.getAST();
            TagElement te1 = ast1.newTagElement();
            ListRewrite lrw1 = rewrite1.getListRewrite((ASTNode)jd1, Javadoc.TAGS_PROPERTY);
            List origLst = lrw1.getOriginalList();
            Iterator tagIter = origLst.iterator();
            boolean jndiNameTagFound = false;
            while (tagIter.hasNext()) {
                TagElement tag = (TagElement)tagIter.next();
                if (!tag.getTagName().equals("@j2c.connectionFactory")) continue;
                List fragmentList = tag.fragments();
                for (Object obj : fragmentList) {
                    TextElement tEl;
                    String oldText;
                    if (!(obj instanceof TextElement) || (oldText = (tEl = (TextElement)obj).getText()).indexOf("jndi-name") < 0) continue;
                    jndiNameTagFound = true;
                    String newText = "jndi-name=\"" + jndiName + "\"";
                    tEl.setText(newText);
                    te1 = tag;
                    lrw1.remove((ASTNode)tag, null);
                    lrw1.insertFirst((ASTNode)te1, null);
                    TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                    edits1.apply((IDocument)doc);
                    cu.getBuffer().setContents(doc.get());
                    cu.commitWorkingCopy(true, null);
                    return;
                }
            }
            if (!jndiNameTagFound) {
                te1.setTagName("@j2c.connectionFactory jndi-name=\"" + jndiName + "\"");
                lrw1.insertFirst((ASTNode)te1, null);
                TextEdit edits1 = rewrite1.rewriteAST((IDocument)doc, null);
                edits1.apply((IDocument)doc);
                cu.getBuffer().setContents(doc.get());
                cu.commitWorkingCopy(true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getNewMethodSignature(MethodDeclaration foundMethod, Object[] inputPars) {
        ArrayList<String> signatureList = new ArrayList<String>();
        int z = 0;
        while (z < inputPars.length) {
            com.ibm.adapter.emd.extension.description.DataDescription dD;
            foundMethod.getAST().newSingleVariableDeclaration();
            if (inputPars[z] instanceof J2CParameterDescription) {
                J2CParameterDescription j2cp = (J2CParameterDescription)inputPars[z];
                if (j2cp.getStyle() != 2) {
                    signatureList.add(j2cp.getPropertyType().getName());
                }
            } else if (inputPars[z] instanceof com.ibm.adapter.emd.extension.description.DataDescription && (dD = (com.ibm.adapter.emd.extension.description.DataDescription)inputPars[z]).getStyle() != 2) {
                String sN = DeploymentUtils.getDataType(dD).getFullyQualifiedName();
                signatureList.add(sN);
            }
            ++z;
        }
        int q = signatureList.size() - 1;
        while (q > -1) {
            --q;
        }
        return signatureList;
    }

    public static List modifyMethod(ICompilationUnit cu, OutboundFunctionDescription oldOfd, OutboundFunctionDescription newOfd, boolean isInterface) {
        return DeploymentUtils.modifyMethod(cu, oldOfd.getName(), oldOfd.getParameterDescriptions(), newOfd.getName(), newOfd.getParameterDescriptions(), isInterface);
    }

    /*
     * Unable to fully structure code
     */
    public static void modifyMethodOld(J2CJavaBeanEdit edit1, ICompilationUnit cu, String oldName, ParameterDescription[] oldPds, String newName, ParameterDescription[] newPds, boolean isInterface) {
        try {
            if (cu == null) {
                return;
            }
            if (!cu.isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            source = cu.getSource();
            doc = new Document(source);
            parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            astCU = (CompilationUnit)parser.createAST(null);
            l = astCU.types();
            td = (TypeDeclaration)l.get(0);
            msA = td.getMethods();
            interFaces = td.superInterfaceTypes();
            if (interFaces.size() > 0) {
                interType = (Type)interFaces.get(0);
                typeName = null;
                if (interType.isSimpleType()) {
                    typeName = ((SimpleType)interType).getName().getFullyQualifiedName();
                } else if (interType.isQualifiedType()) {
                    typeName = ((QualifiedType)interType).getName().getFullyQualifiedName();
                }
                if (typeName != null) {
                    interIType = J2CCodeParsingUtil.getType(typeName, cu.getJavaProject());
                    DeploymentUtils.modifyMethod(interIType.getCompilationUnit(), oldName, oldPds, newName, newPds, true);
                }
            }
            methodFound = false;
            foundMethod = null;
            methodName = oldName;
            i = 0;
            while (i < msA.length) {
                block71: {
                    tempsS = msA[i].getName().getIdentifier();
                    if (!tempsS.equals(methodName)) break block71;
                    argumentsAreMatching = true;
                    params = msA[i].parameters();
                    pds = oldPds;
                    arL = new ArrayList<ParameterDescription>(5);
                    y = 0;
                    while (y < pds.length) {
                        if (pds[y].getStyle() != 2) {
                            arL.add(pds[y]);
                        }
                        ++y;
                    }
                    inputPars = arL.toArray();
                    if (params.size() != inputPars.length) break block71;
                    y = 0;
                    while (y < params.size()) {
                        svd = (SingleVariableDeclaration)params.get(y);
                        tDec = svd.getType();
                        if (!tDec.isPrimitiveType()) ** GOTO lbl66
                        if (!(inputPars[y] instanceof J2CParameterDescription)) ** GOTO lbl64
                        j2cP1 = (J2CParameterDescription)inputPars[y];
                        propType = j2cP1.getPropertyType();
                        if (propType.isPrimitive()) {
                            pt1 = (PrimitiveType)tDec;
                            sPrimName = propType.getName();
                            if (sPrimName == null || !sPrimName.equals(pt1.getPrimitiveTypeCode().toString())) {
                                argumentsAreMatching = false;
                                break;
                            }
                        } else {
                            argumentsAreMatching = false;
                            break;
lbl64:
                            // 1 sources

                            argumentsAreMatching = false;
                            break;
lbl66:
                            // 1 sources

                            if (inputPars[y] instanceof J2CParameterDescription) {
                                j2cP1 = (J2CParameterDescription)inputPars[y];
                                propType = j2cP1.getPropertyType();
                                name = null;
                                if (tDec instanceof SimpleType) {
                                    name = ((SimpleType)tDec).getName().getFullyQualifiedName();
                                }
                                if (name == null || name != null && !propType.getName().equals(name)) {
                                    argumentsAreMatching = false;
                                    break;
                                }
                            }
                        }
                        ++y;
                    }
                    if (argumentsAreMatching) {
                        foundMethod = msA[i];
                    }
                }
                if (foundMethod != null) {
                    astCU.recordModifications();
                    methodFound = true;
                    sNa = foundMethod.getAST().newSimpleName(newName);
                    foundMethod.setName(sNa);
                    totalN = foundMethod.parameters().size();
                    jd = foundMethod.getJavadoc();
                    while (totalN - 1 != -1) {
                        foundMethod.parameters().remove(totalN - 1);
                        --totalN;
                    }
                    pds = newPds;
                    arL = new ArrayList<ParameterDescription>(5);
                    arLO = new ArrayList<ParameterDescription>();
                    y = 0;
                    while (y < pds.length) {
                        if (pds[y].getStyle() == 2 && pds[y] instanceof J2CParameterDescription) {
                            arLO.add(pds[y]);
                        }
                        ++y;
                    }
                    y = 0;
                    while (y < pds.length) {
                        if (pds[y].getStyle() != 2) {
                            arL.add(pds[y]);
                        } else if (pds[y] instanceof com.ibm.adapter.emd.extension.description.DataDescription) {
                            dD = (com.ibm.adapter.emd.extension.description.DataDescription)pds[y];
                            sN = DeploymentUtils.getDataType(dD).getFullyQualifiedName();
                            tn = foundMethod.getAST().newName(sN);
                            st = foundMethod.getAST().newSimpleType(tn);
                            returnType = foundMethod.getReturnType2();
                            if (returnType != null) {
                                returnType.resolveBinding();
                                returnType.isPrimitiveType();
                                foundMethod.setReturnType2((Type)st);
                            }
                        }
                        ++y;
                    }
                    inputPars = arL.toArray();
                    exposedParams = new ArrayList<J2CParameterDescription>(3);
                    signatureList = new ArrayList<SingleVariableDeclaration>(3);
                    dataBinding = null;
                    arLO.toArray();
                    z = 0;
                    while (z < inputPars.length) {
                        svd = foundMethod.getAST().newSingleVariableDeclaration();
                        if (inputPars[z] instanceof J2CParameterDescription) {
                            j2cp = (J2CParameterDescription)inputPars[z];
                            exposedParams.add(j2cp);
                            if (j2cp.getPropertyType().isPrimitive()) {
                                codeString = j2cp.getPropertyType().getName();
                                if (PrimitiveType.toCode((String)codeString) != null) {
                                    pt = foundMethod.getAST().newPrimitiveType(PrimitiveType.toCode((String)codeString));
                                    svd.setType((Type)pt);
                                    sn = foundMethod.getAST().newSimpleName(j2cp.getParameterName());
                                    svd.setName(sn);
                                    signatureList.add(svd);
                                }
                            } else {
                                if (j2cp.getPropertyType().isPrimitive()) {
                                    cNam = PrimitiveType.toCode((String)j2cp.getPropertyType().getName());
                                    pt = foundMethod.getAST().newPrimitiveType(cNam);
                                    svd.setType((Type)pt);
                                    sn = foundMethod.getAST().newSimpleName(j2cp.getParameterName());
                                    svd.setName(sn);
                                } else {
                                    tn = foundMethod.getAST().newName(j2cp.getPropertyType().getName());
                                    st = foundMethod.getAST().newSimpleType(tn);
                                    sn = foundMethod.getAST().newSimpleName(j2cp.getParameterName());
                                    svd.setName(sn);
                                    svd.setType((Type)st);
                                }
                                signatureList.add(svd);
                            }
                        } else if (inputPars[z] instanceof com.ibm.adapter.emd.extension.description.DataDescription) {
                            dD = (com.ibm.adapter.emd.extension.description.DataDescription)inputPars[z];
                            sN = DeploymentUtils.getDataType(dD).getFullyQualifiedName();
                            tn = foundMethod.getAST().newName(sN);
                            st = foundMethod.getAST().newSimpleType(tn);
                            sn = foundMethod.getAST().newSimpleName("arg");
                            svd.setName(sn);
                            svd.setType((Type)st);
                            dataBinding = svd;
                        }
                        ++z;
                    }
                    q = signatureList.size() - 1;
                    while (q > -1) {
                        foundMethod.parameters().add(0, signatureList.get(q));
                        --q;
                    }
                    if (dataBinding != null) {
                        foundMethod.parameters().add(0, dataBinding);
                    }
                    if (!isInterface) {
                        tagList = null;
                        if (jd != null) {
                            tagList = jd.tags();
                        }
                        nonUsedOldBindings = new ArrayList<TagElement>(1);
                        if (tagList != null) {
                            r = 0;
                            while (r < tagList.size()) {
                                tE = (TagElement)tagList.get(r);
                                tEName = tE.getTagName();
                                if (tEName.equals("@j2c.connectionSpec-property") || tEName.equals("@j2c.interactionSpec-property")) {
                                    fragment = ((TextElement)tE.fragments().get(0)).getText().trim();
                                    name = "";
                                    if (fragment.indexOf("value") >= 0) {
                                        name = fragment.substring("name=\"".length(), fragment.indexOf("value") - 1);
                                    } else if (fragment.indexOf("argumentBinding") >= 0) {
                                        name = fragment.substring("name=\"".length(), fragment.indexOf("argumentBinding") - 1);
                                    }
                                    if (name.endsWith("\"")) {
                                        name = name.substring(0, name.length() - 1);
                                    }
                                    parameterF = false;
                                    j2cP = null;
                                    e = 0;
                                    while (e < exposedParams.size()) {
                                        j2cP = (J2CParameterDescription)exposedParams.get(e);
                                        if (j2cP.getPropertyName().equals(name)) {
                                            newTextEl = "     name=\"" + name + "\" " + "argumentBinding=\"" + j2cP.getParameterName() + "\"";
                                            rr = foundMethod.getAST().newTextElement();
                                            rr.setText(newTextEl);
                                            tE.fragments().remove(0);
                                            tE.fragments().add(rr);
                                            tE.setTagName(String.valueOf(tEName) + " ");
                                            parameterF = true;
                                            break;
                                        }
                                        ++e;
                                    }
                                    if (!parameterF) {
                                        nonUsedOldBindings.add(tE);
                                    } else if (j2cP != null) {
                                        exposedParams.remove(j2cP);
                                    }
                                }
                                ++r;
                            }
                        }
                        if (!isInterface && tagList != null) {
                            r = 0;
                            while (r < tagList.size()) {
                                tE = (TagElement)tagList.get(r);
                                tEName = tE.getTagName();
                                if (tEName.equals("@j2c.interactionSpec-returnProperty")) {
                                    fragment = ((TextElement)tE.fragments().get(0)).getText().trim();
                                    name = "";
                                    if (fragment.indexOf("outputBinding") >= 0) {
                                        name = fragment.substring("name=\"".length(), fragment.indexOf("outputBinding") - 1);
                                    }
                                    if (name.endsWith("\"")) {
                                        name = name.substring(0, name.length() - 1);
                                    }
                                    parameterF = false;
                                    j2cP = null;
                                    e = 0;
                                    while (e < exposedParams.size()) {
                                        j2cP = (J2CParameterDescription)exposedParams.get(e);
                                        if (j2cP.getPropertyName().equals(name)) {
                                            newTextEl = "     name=\"" + name + "\" " + "outputBinding=\"" + j2cP.getParameterName() + "\"";
                                            rr = foundMethod.getAST().newTextElement();
                                            rr.setText(newTextEl);
                                            tE.fragments().remove(0);
                                            tE.fragments().add(rr);
                                            tE.setTagName(String.valueOf(tEName) + " ");
                                            parameterF = true;
                                            break;
                                        }
                                        ++e;
                                    }
                                    if (!parameterF) {
                                        nonUsedOldBindings.add(tE);
                                    }
                                }
                                ++r;
                            }
                        }
                        t = 0;
                        while (t < nonUsedOldBindings.size()) {
                            ((TagElement)nonUsedOldBindings.get(t)).delete();
                            ++t;
                        }
                        addBeforeLast = false;
                        if (jd.tags() != null && (sZ = jd.tags().size()) > 0 && (geTagEl = (TagElement)jd.tags().get(sZ - 1)).getTagName() != null && geTagEl.getTagName().equals("@generated")) {
                            addBeforeLast = true;
                        }
                        h = 0;
                        while (h < exposedParams.size()) {
                            j2cP = (J2CParameterDescription)exposedParams.get(h);
                            rr = foundMethod.getAST().newTextElement();
                            newTextEl = "name=\"" + j2cP.getPropertyName() + "\" " + "argumentBinding=\"" + j2cP.getParameterName() + "\"";
                            if (j2cP.getStyle() == 2) {
                                newTextEl = "name=\"" + j2cP.getPropertyName() + "\" " + "outputBinding=\"" + j2cP.getParameterName() + "\"";
                                rr.setText(newTextEl);
                            }
                            if (j2cP.getStyle() == 1) {
                                newTextEl = "name=\"" + j2cP.getPropertyName() + "\" " + "argumentBinding=\"" + j2cP.getParameterName() + "\"";
                                rr.setText(newTextEl);
                            }
                            tagName = "@j2c.connectionSpec-property";
                            if (j2cP.getParameterType() == 1) {
                                tagName = "@j2c.interactionSpec-property";
                            }
                            tagE = foundMethod.getAST().newTagElement();
                            tagE.setTagName(tagName);
                            tagE.fragments().add(rr);
                            if (!addBeforeLast) {
                                jd.tags().add(tagE);
                            } else {
                                iTagLenth = jd.tags().size();
                                jd.tags().add(iTagLenth - 1, tagE);
                            }
                            ++h;
                        }
                        if (!methodFound) break;
                        astCU.rewrite((IDocument)doc, null).apply((IDocument)doc);
                        break;
                    }
                    if (!methodFound) break;
                    astCU.rewrite((IDocument)doc, null).apply((IDocument)doc);
                    break;
                }
                ++i;
            }
            if (methodFound) {
                cu.getBuffer().setContents(doc.get());
                cu.commitWorkingCopy(true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List modifyMethod(ICompilationUnit cu, String oldName, ParameterDescription[] oldPds, String newName, ParameterDescription[] newPds, boolean isInterface) {
        List<ArrayList> transferList = new ArrayList();
        try {
            if (cu == null) {
                return null;
            }
            if (!cu.isWorkingCopy()) {
                cu = cu.getWorkingCopy(null);
            }
            String source = cu.getSource();
            Document doc = new Document(source);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(cu);
            AnnotatedClassInfo info = AnnotationUtils.getAnnotatedClassInfo((IJavaElement)cu);
            List alist = AnnotationUtils.getAllAnnotationInfosUtilMethod((AnnotatedClassInfo)info);
            CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
            List l = astCU.types();
            TypeDeclaration td = (TypeDeclaration)l.get(0);
            MethodDeclaration[] msA = td.getMethods();
            List interFaces = td.superInterfaceTypes();
            if (interFaces.size() > 0) {
                Type interType = (Type)interFaces.get(0);
                String typeName = null;
                if (interType.isSimpleType()) {
                    typeName = ((SimpleType)interType).getName().getFullyQualifiedName();
                } else if (interType.isQualifiedType()) {
                    typeName = ((QualifiedType)interType).getName().getFullyQualifiedName();
                }
                if (typeName != null) {
                    IType interIType = J2CCodeParsingUtil.getType(typeName, cu.getJavaProject());
                    DeploymentUtils.modifyMethod(interIType.getCompilationUnit(), oldName, oldPds, newName, newPds, true);
                }
            }
            boolean methodFound = false;
            MethodDeclaration foundMethod = null;
            String methodName = oldName;
            int i = 0;
            while (i < msA.length) {
                Object[] pds;
                String tempsS = msA[i].getName().getIdentifier();
                if (tempsS.equals(methodName)) {
                    boolean argumentsAreMatching = true;
                    List params = msA[i].parameters();
                    pds = oldPds;
                    ArrayList<Object> arL = new ArrayList<Object>(5);
                    int y = 0;
                    while (y < pds.length) {
                        if (pds[y].getStyle() != 2) {
                            arL.add(pds[y]);
                        }
                        ++y;
                    }
                    Object[] inputPars = arL.toArray();
                    if (params.size() == inputPars.length) {
                        int y2 = 0;
                        while (y2 < params.size()) {
                            block27: {
                                Class propType;
                                J2CParameterDescription j2cP1;
                                SingleVariableDeclaration svd = (SingleVariableDeclaration)params.get(y2);
                                Type tDec = svd.getType();
                                if (tDec.isPrimitiveType()) {
                                    if (inputPars[y2] instanceof J2CParameterDescription) {
                                        j2cP1 = (J2CParameterDescription)inputPars[y2];
                                        propType = j2cP1.getPropertyType();
                                        if (propType.isPrimitive()) {
                                            PrimitiveType pt1 = (PrimitiveType)tDec;
                                            String sPrimName = propType.getName();
                                            if (sPrimName == null || !sPrimName.equals(pt1.getPrimitiveTypeCode().toString())) {
                                                argumentsAreMatching = false;
                                                break;
                                            }
                                            break block27;
                                        } else {
                                            argumentsAreMatching = false;
                                            break;
                                        }
                                    }
                                    argumentsAreMatching = false;
                                    break;
                                }
                                if (inputPars[y2] instanceof J2CParameterDescription) {
                                    j2cP1 = (J2CParameterDescription)inputPars[y2];
                                    propType = j2cP1.getPropertyType();
                                    String name = null;
                                    if (tDec instanceof SimpleType) {
                                        name = ((SimpleType)tDec).getName().getFullyQualifiedName();
                                    }
                                    if (name == null || name != null && !propType.getName().equals(name)) {
                                        argumentsAreMatching = false;
                                        break;
                                    }
                                }
                            }
                            ++y2;
                        }
                        if (argumentsAreMatching) {
                            foundMethod = msA[i];
                        }
                    }
                }
                if (foundMethod != null) {
                    astCU.recordModifications();
                    methodFound = true;
                    SimpleName sNa = foundMethod.getAST().newSimpleName(newName);
                    foundMethod.setName(sNa);
                    foundMethod.parameters().size();
                    Javadoc jd = foundMethod.getJavadoc();
                    pds = newPds;
                    ArrayList signatureList = null;
                    if (!isInterface) {
                        signatureList = DeploymentUtils.getNewMethodSignature(foundMethod, pds);
                        transferList = J2CDeltaUtil.findAnnotations4Method(alist, methodName);
                        List tempList = J2CDeltaUtil.deltaTransferProcess(sNa, jd);
                        if (tempList != null) {
                            transferList.addAll(tempList);
                        }
                        transferList.add(signatureList);
                    }
                    foundMethod.delete();
                    astCU.rewrite((IDocument)doc, null).apply((IDocument)doc);
                    break;
                }
                ++i;
            }
            if (!methodFound) return null;
            cu.getBuffer().setContents(doc.get());
            cu.commitWorkingCopy(true, null);
            return transferList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getLocalName(DataDescription dd) {
        QName qn = dd.getName();
        return qn.getLocalPart();
    }

    public static J2CServiceDescription getOSDfromServer(J2CJavaBeanEdit edit, IProject project) {
        IResourceAdapterDescriptor aresD;
        J2CServiceDescription oid = null;
        String lookupName = edit.getJNDILookupName();
        String resRefBinding = null;
        IWasCommonUtils utils = DeploymentHelper.instance().getWASCommonUtils();
        if (utils != null) {
            resRefBinding = utils.getBindingForResReference(project, project.getName(), lookupName);
        }
        if (resRefBinding != null) {
            lookupName = resRefBinding;
        }
        if ((aresD = JmxUtils.getProperResourceAdapterDescriptorFromServer((String)lookupName, (IProject)project, null)) != null) {
            edit.setResourceAdapter(aresD);
            edit.setManagedConnectionFactoryName(new String());
            oid = edit.getOutboundServiceDescriptionModel();
        }
        return oid;
    }

    public static J2CServiceDescription getOSDfromRARInfo(J2CJavaBeanEdit ide, MCF_RAR_Indentifier mcfRar) {
        J2CServiceDescription oid;
        block4: {
            oid = null;
            IResourceAdapterRegistry raRegistry = RegistryFactory.getFactory().getAPIResourceAdapterRegistry();
            try {
                IResourceAdapterDescriptor[] ras = raRegistry.getResourceAdapters(mcfRar.getRarType().trim(), mcfRar.getRarVersion(), mcfRar.getRarVendor());
                if (ras == null || ras.length <= 0) break block4;
                ide.setResourceAdapter(ras[0]);
                String factoryClassName = "";
                try {
                    factoryClassName = DeploymentUtils.getManagedConnectionFactoryNameFromConnector(ras[0].getConnector());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ide.setManagedConnectionFactoryName(factoryClassName);
                oid = ide.getOutboundServiceDescriptionModel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return oid;
    }

    public static Hashtable getAvailableServers(IVirtualComponent earComp, boolean updateCombo, Combo serversC) {
        Hashtable<String, IServer> availableServers;
        block19: {
            block18: {
                availableServers = new Hashtable<String, IServer>();
                if (earComp == null) break block18;
                IProject pr = earComp.getProject();
                IModule earMod = ServerUtil.getModule((IProject)pr);
                if (updateCombo) {
                    serversC.removeAll();
                }
                if (earMod == null) break block19;
                IFacetedProject fProj = null;
                try {
                    fProj = ProjectFacetsManager.create((IProject)pr);
                }
                catch (Exception exception) {}
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime runT = fProj.getPrimaryRuntime();
                IRuntime rT = null;
                if (runT != null) {
                    rT = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runT);
                }
                if (rT != null) {
                    String serverRuntimeTypeId;
                    IServer[] availableNonUsedServers = ServerUtil.getAvailableServersForModule((IModule)earMod, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                    IServer[] availableUsedServers = ServerUtil.getServersByModule((IModule)earMod, (IProgressMonitor)new NullProgressMonitor());
                    IServer[] configuredServers = new IServer[availableNonUsedServers.length + availableUsedServers.length];
                    int u = 0;
                    u = 0;
                    while (u < availableNonUsedServers.length) {
                        configuredServers[u] = availableNonUsedServers[u];
                        ++u;
                    }
                    int m = 0;
                    while (m < availableUsedServers.length) {
                        configuredServers[u + m] = availableUsedServers[m];
                        ++m;
                    }
                    String targetServerTypeId = rT.getRuntimeType().getId();
                    int i = 0;
                    while (i < configuredServers.length) {
                        serverRuntimeTypeId = configuredServers[i].getRuntime().getRuntimeType().getId();
                        if (serverRuntimeTypeId.equals(targetServerTypeId)) {
                            availableServers.put(configuredServers[i].getName(), configuredServers[i]);
                            if (updateCombo) {
                                serversC.add(configuredServers[i].getName());
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < configuredServers.length) {
                        serverRuntimeTypeId = configuredServers[i].getRuntime().getRuntimeType().getId();
                        if (!serverRuntimeTypeId.equals(targetServerTypeId)) {
                            availableServers.put(configuredServers[i].getName(), configuredServers[i]);
                            if (updateCombo) {
                                serversC.add(configuredServers[i].getName());
                            }
                        }
                        ++i;
                    }
                } else {
                    IServer[] servers = ServerCore.getServers();
                    int u = 0;
                    while (u < servers.length) {
                        IServer server = servers[u];
                        availableServers.put(server.getName(), server);
                        if (updateCombo) {
                            serversC.add(server.getName());
                        }
                        ++u;
                    }
                }
                break block19;
            }
            IServer[] servers = ServerCore.getServers();
            int u = 0;
            while (u < servers.length) {
                IServer server = servers[u];
                availableServers.put(server.getName(), server);
                if (updateCombo) {
                    serversC.add(server.getName());
                }
                ++u;
            }
        }
        return availableServers;
    }

    private static IType getDataType(com.ibm.adapter.emd.extension.description.DataDescription dataDefinition) {
        IFile javaFile;
        DataFile[] dataFiles = dataDefinition.getDataFiles();
        URI dataURI = dataFiles[0].getLocation();
        if (dataURI != null && (javaFile = DeploymentUtils.resolve(dataURI)) != null && javaFile.exists()) {
            IJavaElement javaElement = JavaCore.create((IFile)javaFile);
            switch (javaElement.getElementType()) {
                case 5: {
                    return ((ICompilationUnit)javaElement).findPrimaryType();
                }
                case 6: {
                    try {
                        return ((IClassFile)javaElement).getType();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }
        return null;
    }

    private static IFile resolve(URI uri) {
        try {
            IFile ifile;
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            String path = URLDecoder.decode(uri.toString(), "UTF-8");
            if (path.startsWith("platform:/resource/")) {
                if ((path = path.substring("platform:/resource/".length())).startsWith("platform:/resource/")) {
                    path = path.substring("platform:/resource/".length());
                }
            } else if (path.startsWith("file:/")) {
                path = path.substring("file:/".length());
            }
            if ((ifile = workspace.getFile((IPath)new Path(path))) != null && ifile.exists()) {
                return ifile;
            }
            File file = new File(path);
            if (file != null && file.exists()) {
                return workspace.getFileForLocation((IPath)new Path(path));
            }
        }
        catch (Exception e) {
            BaseException.createException((String)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static void initializeCommonDeploymentPropretyGroupValues(String projectName, BasePropertyGroup cdPGO) {
        try {
            String rR;
            IWasCommonUtils utils;
            IProject wPr;
            CommonDeploymentPropertyGroup cdPG = (CommonDeploymentPropertyGroup)cdPGO;
            if (projectName != null && (wPr = ResourceUtils.getWorkspace().getRoot().getProject(projectName)) != null && wPr.exists() && (utils = DeploymentHelper.instance().getWASCommonUtils()) != null && (rR = utils.getBindingForResReference(wPr, wPr.getName(), cdPG.getOutboundServiceDescription().getJNDILookupName())) != null) {
                cdPG.setResourceReference(new String(cdPG.getOutboundServiceDescription().getJNDILookupName()));
                cdPG.getJNDINameProperty().setValueAsString(rR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getManagedConnectionFactoryNameFromConnector(Connector connector) {
        Iterator iter;
        EList connectionDefinitions;
        OutboundResourceAdapter outboundAdapter;
        String res = "";
        String specVersion = connector.getSpecVersion();
        if ("1.0".equals(specVersion)) {
            res = connector.getResourceAdapter().getManagedConnectionFactoryClass();
        } else if ("1.5".equals(specVersion) && (outboundAdapter = connector.getResourceAdapter().getOutboundResourceAdapter()) != null && (connectionDefinitions = outboundAdapter.getConnectionDefinitions()) != null && (iter = connectionDefinitions.iterator()).hasNext()) {
            ConnectionDefinition def = (ConnectionDefinition)iter.next();
            res = def.getManagedConnectionFactoryClass();
        }
        return res;
    }

    public static void exportRarFile(IProject connectorProject, String path, IProgressMonitor monitor) {
        ConnectorComponentExportDataModelProvider conExp = new ConnectorComponentExportDataModelProvider();
        IDataModel exportDM = DataModelFactory.createDataModel((IDataModelProvider)conExp);
        exportDM.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)path);
        exportDM.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)connectorProject.getName());
        IVirtualComponent comps = ComponentCore.createComponent((IProject)connectorProject);
        exportDM.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)comps);
        try {
            exportDM.getDefaultOperation().execute(monitor, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

