/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.utilities;

import com.ibm.j2c.rar.operations.ear.EnhancedEARUtils;
import com.ibm.j2c.rar.operations.jmx.internal.model.MCF_RAR_Indentifier;
import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.model.IWasCommonUtils;
import com.ibm.j2c.ui.internal.utilities.DeploymentUtils;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class DeploymentHelper {
    private static DeploymentHelper helper;
    private String projectType = "";

    public static DeploymentHelper instance() {
        if (helper == null) {
            helper = new DeploymentHelper();
        }
        return helper;
    }

    public void deployRARinEAR(IModule earMod, IProject connectorProject) {
        IProject EARproj = earMod.getProject();
        IVirtualComponent moduleEAR = null;
        if (EARproj != null) {
            moduleEAR = ComponentCore.createComponent((IProject)EARproj);
        }
        if (moduleEAR != null) {
            EnhancedEARUtils.addClasspathToLibrary((IProject)connectorProject, (IVirtualComponent)moduleEAR);
        }
        DeploymentUtils.addUtilityProjectToModule(connectorProject.getName(), connectorProject.getName(), moduleEAR);
    }

    public void updateDeploymentInfo(IProject origProj, String moduleName, IVirtualComponent webProj, IVirtualComponent earMod, Hashtable externalProjNames, boolean addToEAR, boolean forWSCreation) {
        boolean isJavaProject = ResourceUtils.isTrueJavaProject((IProject)origProj);
        String javaProjName = "";
        if (isJavaProject) {
            javaProjName = origProj.getName();
            DeploymentUtils.addUtilityProjectToModule(javaProjName, javaProjName, webProj);
        } else {
            ResourceUtils.updateClassPath((String)origProj.getName(), (IProject)webProj.getProject());
            DeploymentUtils.addUtilityProjectToModule(origProj.getName(), origProj.getName(), earMod);
        }
        Enumeration keys = externalProjNames.keys();
        while (keys.hasMoreElements()) {
            String typeProjectName = (String)keys.nextElement();
            if (typeProjectName.equals(webProj.getName()) || typeProjectName.equals(javaProjName)) continue;
            IProject dataProj = ResourceUtils.getWorkspaceRoot().getProject(typeProjectName);
            if (ResourceUtils.isTrueJavaProject((IProject)dataProj)) {
                DeploymentUtils.addUtilityProjectToModule(typeProjectName, typeProjectName, webProj);
                continue;
            }
            DeploymentUtils.addUtilityProjectToModule(typeProjectName, typeProjectName, earMod);
            ResourceUtils.updateClassPath((String)typeProjectName, (IProject)webProj.getProject());
            if (javaProjName.equals("")) continue;
            ResourceUtils.updateClassPath((String)typeProjectName, (IProject)origProj);
        }
        if (addToEAR) {
            DeploymentUtils.addUtilityProjectToModule(webProj.getName(), webProj.getName(), earMod);
        }
    }

    public String getMCFClassName(IProject project) {
        String res = null;
        IClasspathEntry[] classPathEntries = ResourceUtils.getJavaClasspath((IProject)project);
        Vector<IProject> dependentProjects = new Vector<IProject>();
        int i = 0;
        while (classPathEntries.length > i) {
            if (classPathEntries[i].getEntryKind() == 2) {
                IProject depProj;
                String sPath = classPathEntries[i].getPath().toString();
                int indx = sPath.lastIndexOf("/");
                String projectName = sPath;
                if (indx != -1) {
                    projectName = projectName.substring(indx + 1);
                }
                if (!(depProj = ResourceUtils.getWorkspace().getRoot().getProject(projectName)).exists() || ResourceUtils.isJCAProject((IProject)depProj)) {
                    // empty if block
                }
                dependentProjects.add(depProj);
            }
            ++i;
        }
        if (!dependentProjects.isEmpty()) {
            Hashtable<String, MCF_RAR_Indentifier> rarInfos = new Hashtable<String, MCF_RAR_Indentifier>();
            int q = 0;
            while (q < dependentProjects.size()) {
                try {
                    IProject proj = (IProject)dependentProjects.get(q);
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                    IPath compPath = comp.getRootFolder().getUnderlyingFolder().getLocation();
                    IPath raXMLpath = compPath.append("/META-INF/ra.xml");
                    File f = raXMLpath.toFile();
                    if (f.exists()) {
                        FileInputStream fis = new FileInputStream(f);
                        int buffersize = (int)f.length();
                        byte[] contents = new byte[buffersize];
                        fis.read(contents, 0, buffersize);
                        fis.close();
                        fis = null;
                        String version = this.parseTagValue(new String(contents), "<resourceadapter-version>", "</resourceadapter-version>");
                        if (version == null) {
                            version = this.parseTagValue(new String(contents), "<version>", "</version>");
                        }
                        String vendorName = this.parseTagValue(new String(contents), "<vendor-name>", "</vendor-name>");
                        String displayName = this.parseTagValue(new String(contents), "<display-name>", "</display-name>");
                        String className = this.parseTagValue(new String(contents), "<managedconnectionfactory-class>", "</managedconnectionfactory-class>");
                        this.parseTagValue(new String(contents), "<eis-type>", "</eis-type>");
                        MCF_RAR_Indentifier rarInf = new MCF_RAR_Indentifier(className, vendorName, version, displayName);
                        rarInfos.put(proj.getName(), rarInf);
                        res = className;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++q;
            }
        }
        return res;
    }

    public Vector getConnectorProjectsOnClassPath(IProject project) {
        IClasspathEntry[] classPathEntries = ResourceUtils.getJavaClasspath((IProject)project);
        Vector<IProject> dependentProjects = new Vector<IProject>();
        int i = 0;
        while (classPathEntries.length > i) {
            if (classPathEntries[i].getEntryKind() == 2) {
                IProject depProj;
                String sPath = classPathEntries[i].getPath().toString();
                int indx = sPath.lastIndexOf("/");
                String projectName = sPath;
                if (indx != -1) {
                    projectName = projectName.substring(indx + 1);
                }
                if (!(depProj = ResourceUtils.getWorkspace().getRoot().getProject(projectName)).exists() || ResourceUtils.isJCAProject((IProject)depProj)) {
                    // empty if block
                }
                dependentProjects.add(depProj);
            }
            ++i;
        }
        return dependentProjects;
    }

    public Vector getMCFRarInfosForProject(IProject project) {
        Vector<MCF_RAR_Indentifier> res = null;
        Vector dependentProjects = this.getConnectorProjectsOnClassPath(project);
        if (!dependentProjects.isEmpty()) {
            Vector<MCF_RAR_Indentifier> rarInfos = new Vector<MCF_RAR_Indentifier>();
            int q = 0;
            while (q < dependentProjects.size()) {
                try {
                    IProject proj = (IProject)dependentProjects.get(q);
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                    IPath compPath = comp.getRootFolder().getUnderlyingFolder().getLocation();
                    IPath raXMLpath = compPath.append("/META-INF/ra.xml");
                    File f = raXMLpath.toFile();
                    if (f.exists()) {
                        FileInputStream fis = new FileInputStream(f);
                        int buffersize = (int)f.length();
                        byte[] contents = new byte[buffersize];
                        fis.read(contents, 0, buffersize);
                        fis.close();
                        fis = null;
                        String version = this.parseTagValue(new String(contents), "<resourceadapter-version>", "</resourceadapter-version>");
                        if (version == null) {
                            version = this.parseTagValue(new String(contents), "<version>", "</version>");
                        }
                        String vendorName = this.parseTagValue(new String(contents), "<vendor-name>", "</vendor-name>");
                        String displayName = this.parseTagValue(new String(contents), "<display-name>", "</display-name>");
                        String className = this.parseTagValue(new String(contents), "<managedconnectionfactory-class>", "</managedconnectionfactory-class>");
                        this.parseTagValue(new String(contents), "<eis-type>", "</eis-type>");
                        MCF_RAR_Indentifier rarInf = new MCF_RAR_Indentifier(className, vendorName, version, displayName);
                        rarInfos.add(rarInf);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++q;
            }
            res = rarInfos;
        }
        return res;
    }

    public synchronized int getWASServerVersion(IServer server) {
        int res = 0;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.WasCommonUtils");
        IExtension[] extensions = extensionPoint.getExtensions();
        int r = 0;
        while (r < extensions.length) {
            IExtension currentEx = extensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                try {
                    IWasCommonUtils util = (IWasCommonUtils)currentConEl.createExecutableExtension("utilClass");
                    res = util.getWasServerVersion(server);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++y;
            }
            ++r;
        }
        return res;
    }

    public synchronized int getWASRuntimeVersion(IRuntime runt) {
        int res = 0;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.WasCommonUtils");
        IExtension[] extensions = extensionPoint.getExtensions();
        int r = 0;
        while (r < extensions.length) {
            IExtension currentEx = extensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                try {
                    IWasCommonUtils util = (IWasCommonUtils)currentConEl.createExecutableExtension("utilClass");
                    res = util.getWasRuntimeVersion(runt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++y;
            }
            ++r;
        }
        return res;
    }

    public synchronized IWasCommonUtils getWASCommonUtils() {
        IWasCommonUtils res = null;
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.j2c.ui.WasCommonUtils");
        IExtension[] extensions = extensionPoint.getExtensions();
        int r = 0;
        while (r < extensions.length) {
            IExtension currentEx = extensions[r];
            IConfigurationElement[] configEls = currentEx.getConfigurationElements();
            int y = 0;
            while (y < configEls.length) {
                IConfigurationElement currentConEl = configEls[y];
                try {
                    res = (IWasCommonUtils)currentConEl.createExecutableExtension("utilClass");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++y;
            }
            ++r;
        }
        return res;
    }

    public IModule componentToModule(IVirtualComponent iComp) {
        IModule mod = null;
        if (iComp != null) {
            IProject pr = iComp.getProject();
            mod = ServerUtil.getModule((IProject)pr);
        }
        return mod;
    }

    public ElementTreeSelectionDialog getSourceFolderSelectionDialog(Shell shell, IResource rootResource, String projectKind) {
        this.projectType = projectKind;
        Object provider = new StandardJavaElementContentProvider();
        if (this.projectType.equals(ResourceUtils.ENTERPRISE_APPLICATION)) {
            ITreeContentProvider earProjectProvider = new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof IWorkspaceRoot) {
                        ArrayList<IProject> al = new ArrayList<IProject>(5);
                        IProject[] projs = ((IWorkspaceRoot)parentElement).getProjects();
                        int r = 0;
                        while (r < projs.length) {
                            if (ResourceUtils.isEARProject((IProject)projs[r])) {
                                al.add(projs[r]);
                            }
                            ++r;
                        }
                        return al.toArray();
                    }
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    Object[] obs = this.getChildren(element);
                    return obs != null && (obs == null || obs.length != 0);
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
            provider = earProjectProvider;
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(PropertyUIMessages.PROPERTY_UI_WIZARDS_TITLE_FSELECTION);
        dialog.setMessage(PropertyUIMessages.PROPERTY_UI_WIZARDS_LABEL_SFOLDER);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    return jproject.exists() && ResourceUtils.isProjectOfKind((IProject)jproject.getProject(), (String)DeploymentHelper.this.projectType);
                }
                if (element instanceof IProject) {
                    IProject proj = (IProject)element;
                    return proj.exists() && ResourceUtils.isProjectOfKind((IProject)proj, (String)DeploymentHelper.this.projectType);
                }
                return false;
            }
        });
        if (this.projectType.equals(ResourceUtils.ENTERPRISE_APPLICATION)) {
            dialog.setInput((Object)ResourceUtils.getWorkspace().getRoot());
        } else if (rootResource == null) {
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourceUtils.getWorkspace().getRoot()));
        } else {
            dialog.setInput((Object)JavaCore.create((IResource)rootResource));
        }
        return dialog;
    }

    private String parseTagValue(String content, String tag1, String tag2) {
        String temp1;
        int indx2;
        String res = null;
        int indx1 = content.indexOf(tag1);
        if (indx1 != -1 && (indx2 = (temp1 = content.substring(indx1 + tag1.length())).indexOf(tag2)) > 0) {
            res = temp1.substring(0, indx2);
        }
        return res;
    }
}

