/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.uiextensions;

import com.ibm.j2c.ui.core.internal.utilities.ResourceUtils;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.utilities.DeploymentHelper;
import com.ibm.propertygroup.IProperty;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetProperty;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTextContentAssist;
import com.ibm.propertygroup.ui.utilities.PropertyUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.ejb.ui.project.facet.EjbProjectWizard;
import org.eclipse.jst.j2ee.ui.project.facet.EarProjectWizard;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class J2EEProjectWidget
extends PropertyUIWidgetProperty
implements PaintListener {
    private Label Label_;
    private Button Button_;
    private Button Button2_;
    private PropertyUIWidgetTextContentAssist TextContentAssist_;
    private Text Text_;
    private int ColumnNo_ = 1;
    private String projectType = ResourceUtils.DYNAMIC_WEB;
    private String ButtonLabel_ = null;
    private String Button2Label_ = null;

    public J2EEProjectWidget(IProperty property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public J2EEProjectWidget(IProperty property, IPropertyUIWidgetFactory factory, int columnNo) {
        super(property, factory);
        this.ColumnNo_ = columnNo;
    }

    public void createControl(Composite parent) {
        this.Label_ = this.factory_.createLabel(parent, this.getWidgetLabel(false), 64);
        GridData gd = new GridData();
        if (this.widgetIndent_ > 0) {
            gd.horizontalIndent = this.widgetIndent_;
        }
        this.Label_.setLayoutData((Object)gd);
        if (PropertyUtil.isRequired((IPropertyDescriptor)this.property_)) {
            this.Label_.addPaintListener((PaintListener)this);
            GC gc = new GC((Drawable)this.Label_);
            gd.widthHint = gc.stringExtent((String)this.Label_.getText()).x + gc.stringExtent((String)"*").x;
            gc.dispose();
        }
        this.TextContentAssist_ = this.widgetStyle_ == -1 ? this.factory_.createTextWithContentAssist(parent, this.factory_.getBorderStyle(), null) : this.factory_.createTextWithContentAssist(parent, this.widgetStyle_, null);
        this.Text_ = this.TextContentAssist_.getTextField();
        this.addHoverManager((Control)this.Text_, this.property_.getDescription());
        gd = new GridData(768);
        this.Text_.setLayoutData((Object)gd);
        if (this.ButtonLabel_ != null && this.ButtonLabel_.length() > 1) {
            this.Button_ = this.factory_.createButton(parent, this.ButtonLabel_, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this.Button_.setLayoutData((Object)gd);
            this.Button_.addListener(13, (Listener)this);
        }
        if (this.Button2Label_ != null && this.Button2Label_.length() > 1) {
            this.Button2_ = this.factory_.createButton(parent, this.Button2Label_, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            this.Button2_.setLayoutData((Object)gd);
            this.Button2_.addListener(13, (Listener)this);
        }
        if (PropertyUtil.isSensitive((IPropertyDescriptor)this.property_)) {
            this.Text_.setEchoChar('*');
        }
        this.initDefaultValue();
        if (PropertyUtil.isReadOnly((IPropertyDescriptor)this.property_) || !this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void initDefaultValue() {
        this.removeModificationListner((Control)this.Text_, 24);
        this.Text_.setText("");
        Object defaultValue = this.getDefaultValue();
        Object value = this.getValue();
        if (value != null) {
            this.Text_.setText(this.getValueAsString());
        } else if (defaultValue != null) {
            if (PropertyUtil.isRequired((IPropertyDescriptor)this.property_)) {
                this.setValue(defaultValue.toString());
                value = this.getValue();
                if (value != null) {
                    this.Text_.setText(this.getValueAsString());
                } else if (this.status_ != 0) {
                    this.errorMessage_ = null;
                    this.status_ = 0;
                }
            } else {
                this.Text_.setText(defaultValue.toString());
            }
        }
        this.addModificationListner((Control)this.Text_, 24);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.Button_) {
            String value = this.Text_.getText();
            ElementTreeSelectionDialog dialog = DeploymentHelper.instance().getSourceFolderSelectionDialog(this.shell_, null, this.projectType);
            if (dialog != null && dialog.open() == 0) {
                Object element = dialog.getFirstResult();
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    IPackageFragmentRoot root = jproject.getPackageFragmentRoot((IResource)jproject.getProject());
                    value = root.getPath().toString();
                } else if (element instanceof IProject) {
                    IProject proj = (IProject)element;
                    value = proj.getName();
                } else if (element instanceof IPackageFragmentRoot) {
                    value = ((IPackageFragmentRoot)element).getPath().toString();
                }
            }
            if (value != null && value.length() > 0) {
                this.Text_.setText(value);
            }
        } else if (event.widget == this.Button2_) {
            if (this.projectType.equals(ResourceUtils.DYNAMIC_WEB)) {
                WebProjectWizard webWiz = new WebProjectWizard();
                webWiz.getDataModel().setStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", this.Text_.getText().trim());
                StructuredSelection selection = new StructuredSelection();
                webWiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                PrivateWizardDialog dialog = new PrivateWizardDialog(this.getShell(), (IWizard)webWiz);
                dialog.create();
                if (dialog.open() == 0) {
                    String name = webWiz.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    this.Text_.setText(name);
                }
            } else if (this.projectType.equals(ResourceUtils.ENTERPRISE_APPLICATION)) {
                EarProjectWizard earWiz = new EarProjectWizard();
                earWiz.getDataModel().setStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", this.Text_.getText().trim());
                StructuredSelection selection = new StructuredSelection();
                earWiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                PrivateWizardDialog dialog = new PrivateWizardDialog(this.getShell(), (IWizard)earWiz);
                dialog.create();
                if (dialog.open() == 0) {
                    String name = earWiz.getDataModel().getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    this.Text_.setText(name);
                }
            } else if (this.projectType.equals(ResourceUtils.EJB)) {
                EjbProjectWizard ejbWiz = new EjbProjectWizard();
                StructuredSelection selection = new StructuredSelection();
                ejbWiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                PrivateWizardDialog dialog = new PrivateWizardDialog(this.getShell(), (IWizard)ejbWiz);
                dialog.create();
                if (dialog.open() == 0) {
                    IDataModel model = ejbWiz.getDataModel();
                    String name = model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    this.Text_.setText(name);
                    IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                    IDataModel model1 = (IDataModel)map.get((Object)"jst.ejb");
                    String version = ((IProjectFacetVersion)model1.getProperty("IFacetDataModelPropeties.FACET_VERSION")).getVersionString();
                    if (version.equals("1.1")) {
                        MessageDialog.openWarning((Shell)this.shell_, (String)J2CUIMessages.WARNING_NEW_EJB_PROJECT_VER_11_HEADER, (String)J2CUIMessages.WARNING_NEW_EJB_PROJECT_VER_11_MESSAGE);
                    }
                }
            }
        } else if (event.widget == this.Text_) {
            super.handleEvent(event);
        }
    }

    public String getWidgetValue() {
        return this.Text_.getText();
    }

    public void setWidgetValue(String newValue) {
        this.Text_.setText(newValue);
    }

    public void update() {
        this.update(0);
    }

    public void update(int propertyChangeType) {
        switch (propertyChangeType) {
            case 0: {
                if (this.isValueSynch()) break;
                String newValue = this.getValueAsString();
                this.removeModificationListner((Control)this.Text_, 24);
                if (newValue == null) {
                    this.Text_.setText("");
                } else {
                    this.Text_.setText(newValue);
                }
                this.addModificationListner((Control)this.Text_, 24);
                break;
            }
            case 1: 
            case 2: {
                if (PropertyUtil.isReadOnly((IPropertyDescriptor)this.property_) || !this.isEnabled()) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
            }
        }
    }

    public Text getText() {
        return this.Text_;
    }

    public Button getButton() {
        return this.Button_;
    }

    public void setColumnNo(int newValue) {
        this.ColumnNo_ = newValue;
    }

    public void setButtonLabel(String newValue) {
        this.ButtonLabel_ = newValue;
    }

    public void setButton2Label(String newValue) {
        this.Button2Label_ = newValue;
    }

    public void setValue(String newValue) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            if (newValue == null || newValue.length() < 1) {
                if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
                    ((ISingleValuedProperty)this.property_).setValue(null);
                } else {
                    ((IProperty)this.property_).unSet();
                }
            } else if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)this.property_)) {
                ((ISingleValuedProperty)this.property_).setValueAsString(newValue);
            }
            this.errorMessage_ = null;
            this.status_ = 0;
        }
        catch (CoreException ie) {
            IStatus status = ie.getStatus();
            this.errorMessage_ = status.getMessage();
            this.status_ = status.getSeverity();
        }
        catch (Exception e) {
            this.errorMessage_ = e.getMessage();
            if (this.errorMessage_ == null || this.errorMessage_.length() < 1) {
                this.errorMessage_ = e.toString();
            }
            this.status_ = 4;
        }
    }

    public void addSuggestion(String suggestion) {
        if (suggestion != null && suggestion.length() > 0) {
            this.TextContentAssist_.addSuggestion(suggestion);
        }
    }

    public void setSuggestions(List suggestions) {
        this.TextContentAssist_.setSuggestions(suggestions);
    }

    public void sortSuggestions() {
        this.TextContentAssist_.sortSuggestions();
    }

    public Control[] getUIControls() {
        ArrayList<Object> controls = new ArrayList<Object>(3);
        controls.add(this.Label_);
        controls.add(this.Text_);
        if (this.Button_ != null) {
            controls.add(this.Button_);
        }
        if (this.Button2_ != null) {
            controls.add(this.Button2_);
        }
        Control[] newArray = new Control[controls.size()];
        int i = 0;
        while (i < controls.size()) {
            newArray[i] = (Control)controls.get(i);
            ++i;
        }
        return newArray;
    }

    public Control getDefaultFocusControl() {
        return this.Text_;
    }

    public void changeColumnNumber(int newNumber) {
        if (newNumber - 1 != this.ColumnNo_) {
            this.ColumnNo_ = newNumber - 1;
        }
    }

    public void paintControl(PaintEvent e) {
        int width;
        GridData gd = (GridData)this.Label_.getLayoutData();
        if (gd == null) {
            return;
        }
        Rectangle lBounds = this.Label_.getBounds();
        Point tLoc = this.Text_.getLocation();
        GridLayout layout = (GridLayout)this.Label_.getParent().getLayout();
        int hSpace = 5;
        if (layout != null) {
            hSpace = layout.horizontalSpacing;
        }
        if (gd.widthHint < (width = tLoc.x - lBounds.x - hSpace)) {
            this.Label_.setBounds(lBounds.x, lBounds.y, width, lBounds.height);
            gd.widthHint = width;
        } else if (PropertyUtil.isRequired((IPropertyDescriptor)this.property_) && this.isEnabled()) {
            GC gc = e.gc;
            String requiredLabel = "*";
            gc.drawString(requiredLabel, width - gc.stringExtent((String)requiredLabel).x, 0);
        }
    }

    boolean isValueSynch() {
        String newValue = this.getValueAsString();
        String widgetValue = this.getWidgetValue();
        if (newValue == null && widgetValue == null) {
            return true;
        }
        if (widgetValue.length() < 1 && newValue == null) {
            return true;
        }
        return newValue != null && newValue.equalsIgnoreCase(widgetValue) || widgetValue != null && widgetValue.equalsIgnoreCase(newValue);
    }

    public String getProjectType() {
        return this.projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    private class PrivateWizardDialog
    extends WizardDialog {
        public PrivateWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        public void updateButtons() {
            if (this.getCurrentPage() != null) {
                super.updateButtons();
            }
        }
    }
}

