/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.properties;

import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.properties.TargetServerPropertyType;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import com.ibm.propertygroup.ui.plugin.PropertyUIMessageBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.project.facet.ProductManager;

public class TargetServerProperty
extends BaseSingleValuedProperty {
    public static final String TARGET_SERVER_PROPERTY_NAME = "TARGET_SERVER";

    public TargetServerProperty() throws CoreException {
        this(null);
    }

    public TargetServerProperty(BasePropertyGroup parentGroup) throws CoreException {
        super(TARGET_SERVER_PROPERTY_NAME, J2CUIMessages.TARGET_SERVER_PROPERTY_DISPLAY_NAME, J2CUIMessages.TARGET_SERVER_PROPERTY_DESCRIPTION, IRuntime.class, parentGroup);
        this.propertyType = new TargetServerPropertyType(IRuntime.class);
        this.loadDefaultValues();
    }

    public TargetServerProperty(BasePropertyGroup parentGroup, PropertyUIMessageBundle msgBundle) throws CoreException {
        super(TARGET_SERVER_PROPERTY_NAME, msgBundle.getMessage("TARGET_SERVER_PROPERTY_DISPLAY_NAME"), msgBundle.getMessage("TARGET_SERVER_PROPERTY_DESCRIPTION"), IRuntime.class, parentGroup);
        this.propertyType = new TargetServerPropertyType(IRuntime.class);
        this.loadDefaultValues();
    }

    public String getValueAsString() {
        if (this.value != null) {
            return ((IRuntime)this.value).getLocalizedName();
        }
        return null;
    }

    public void setValueAsString(String aValue) throws CoreException {
        Object[] validValues = this.getPropertyType().getValidValues();
        IRuntime runtimeToSet = null;
        int i = 0;
        while (i < validValues.length) {
            IRuntime runtime = (IRuntime)validValues[i];
            if (runtime.getLocalizedName().equals(aValue)) {
                runtimeToSet = runtime;
                break;
            }
            ++i;
        }
        if (runtimeToSet == null) {
            try {
                runtimeToSet = RuntimeManager.getRuntime((String)aValue);
            }
            catch (IllegalArgumentException exc) {
                Status status = new Status(4, "com.ibm.j2c.ui", 0, exc.getLocalizedMessage(), (Throwable)exc);
                throw new CoreException((IStatus)status);
            }
        }
        this.setValue(runtimeToSet);
    }

    public IRuntime getRuntime() {
        return (IRuntime)this.getValue();
    }

    public void loadDefaultValues() throws CoreException {
        Set runtimeSet = RuntimeManager.getRuntimes();
        HashSet<IRuntime> supportedRuntimes = new HashSet<IRuntime>();
        IProjectFacet connectorFacet = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
        for (IRuntime runtime : runtimeSet) {
            if (!runtime.supports(connectorFacet)) continue;
            supportedRuntimes.add(runtime);
        }
        ArrayList<IRuntime> preferredList = new ArrayList<IRuntime>();
        if (!supportedRuntimes.isEmpty()) {
            List defaultRuntimes = ProductManager.getDefaultRuntimes();
            if (defaultRuntimes != null && !defaultRuntimes.isEmpty()) {
                this.setDefaultValue(defaultRuntimes.get(0));
                for (IRuntime rt : defaultRuntimes) {
                    if (!supportedRuntimes.contains(rt)) continue;
                    preferredList.add(rt);
                }
            }
            for (IRuntime aRuntime : supportedRuntimes) {
                if (preferredList.contains(aRuntime)) continue;
                preferredList.add(aRuntime);
            }
        }
        Object[] runtimes = preferredList.toArray(new IRuntime[preferredList.size()]);
        this.setValidValues(runtimes);
    }
}

