/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j2c.ui.internal.properties;

import com.ibm.adapter.emd.extension.description.spi.J2CServiceDescription;
import com.ibm.adapter.j2ca.IResourceAdapterDescriptor;
import com.ibm.j2c.ui.internal.messages.J2CUIMessages;
import com.ibm.j2c.ui.internal.utilities.J2CEMDHelper;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.BaseSingleValuedProperty;
import org.eclipse.core.runtime.CoreException;

public class JNDINameProperty
extends BaseSingleValuedProperty {
    private J2CServiceDescription outDef;
    private String serverId = null;
    private IPropertyGroup pG = null;
    private IPropertyGroup initializePG_ = null;
    private IResourceAdapterDescriptor ra_;
    private String aliasName_ = null;
    private boolean canEditJNDI_ = true;

    public JNDINameProperty(BasePropertyGroup parentGroup) throws CoreException {
        super("JNDILookupName", J2CUIMessages.J2C_UI_WIZARDS_LABEL_JNDI_NAME, J2CUIMessages.J2C_UI_WIZARDS_LABEL_JNDI_NAME, String.class, parentGroup);
    }

    public JNDINameProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, displayName, propertyDescription, String.class, parentGroup);
    }

    public J2CServiceDescription getOutboundServiceDescription() {
        return this.outDef;
    }

    public void setOutboundServieDescription(J2CServiceDescription outDef) {
        this.outDef = outDef;
        if (outDef != null) {
            String jndiName = outDef.getJNDILookupName();
            boolean isEnabled = this.isEnabled();
            if (!isEnabled) {
                this.setEnabled(true);
            }
            try {
                this.setValueAsString(jndiName);
            }
            catch (Exception exception) {}
            this.setEnabled(isEnabled);
        }
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setValueAsString(String newValue) throws CoreException {
        super.setValueAsString(newValue);
        this.updateModel();
    }

    public void setOriginalPropertyGroup(IPropertyGroup pg1) {
        this.pG = pg1;
    }

    public IPropertyGroup getOriginalPropertyGroup() {
        if (this.pG == null && this.outDef != null) {
            if (this.outDef != null) {
                try {
                    return J2CEMDHelper.getMCFProperties(this.outDef, true);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this.initializePG_ != null && this.initializePG_ != null) {
                return (IPropertyGroup)this.initializePG_.getProperty("MANAGED_CONNECTION_FACTORY_CLASS_PROPERTIES");
            }
        }
        return this.pG;
    }

    public String[] getMCFClassNames() {
        ISingleValuedProperty classNameProperty;
        IResourceAdapterDescriptor ra = this.getResourceAdapter();
        if (ra != null) {
            return ra.getManagedConnectionFactoryNames();
        }
        if (this.initializePG_ != null && (classNameProperty = (ISingleValuedProperty)this.initializePG_.getProperty("MANAGED_CONNECTION_FACTORY_CLASS_PROPERTY")) != null) {
            return classNameProperty.getPropertyType().getValidValuesAsStrings();
        }
        return null;
    }

    public void setInitializePropertyGroup(IPropertyGroup pg1) {
        this.initializePG_ = pg1;
    }

    public IPropertyGroup getInitializePropertyGroup() {
        return this.initializePG_;
    }

    public void setResourceAdapter(IResourceAdapterDescriptor ra) {
        this.ra_ = ra;
    }

    public IResourceAdapterDescriptor getResourceAdapter() {
        if (this.ra_ == null && this.outDef != null) {
            return this.outDef.getResourceAdapterDescriptor();
        }
        return this.ra_;
    }

    public void setAliasName(String newName) throws CoreException {
        this.aliasName_ = newName;
        this.updateModel();
    }

    public String getAliasName() throws CoreException {
        return this.aliasName_;
    }

    public void canEditJNDI(boolean can) {
        this.canEditJNDI_ = can;
    }

    public boolean canEditJNDI() {
        return this.canEditJNDI_ && (this.outDef != null || this.initializePG_ != null && this.ra_ != null);
    }

    protected void updateModel() throws CoreException {
        String jndiValue = this.getValueAsString();
        J2CServiceDescription sd = this.getOutboundServiceDescription();
        if (sd != null) {
            if (jndiValue != null) {
                J2CEMDHelper.setJNDIName(sd, jndiValue.trim());
            }
            if (this.aliasName_ != null) {
                J2CEMDHelper.setJAASAlias(sd, this.aliasName_.trim());
            }
        }
    }
}

